/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.view;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.AbstractDependencyData;
import com.intellij.openapi.externalSystem.model.project.DependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryData;
import com.intellij.openapi.externalSystem.model.project.LibraryDependencyData;
import com.intellij.openapi.externalSystem.model.project.LibraryPathType;
import com.intellij.openapi.externalSystem.model.project.ModuleData;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.Named;
import com.intellij.openapi.externalSystem.model.project.OrderAware;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.model.task.TaskData;
import com.intellij.openapi.externalSystem.service.project.IdeModelsProviderImpl;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.externalSystem.view.ExternalProjectsStructure;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalSystemNode;
import com.intellij.openapi.externalSystem.view.ExternalSystemViewContributor;
import com.intellij.openapi.externalSystem.view.ModuleNode;
import com.intellij.openapi.externalSystem.view.TasksNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemViewDefaultContributor
extends ExternalSystemViewContributor {
    private static final Key<?>[] KEYS = new Key[]{ProjectKeys.MODULE, ProjectKeys.MODULE_DEPENDENCY, ProjectKeys.LIBRARY_DEPENDENCY, ProjectKeys.TASK};

    @Override
    @NotNull
    public ProjectSystemId getSystemId() {
        ProjectSystemId projectSystemId = ProjectSystemId.IDE;
        if (projectSystemId == null) {
            ExternalSystemViewDefaultContributor.$$$reportNull$$$0(0);
        }
        return projectSystemId;
    }

    @Override
    @NotNull
    public List<Key<?>> getKeys() {
        List<Key<?>> list = Arrays.asList(KEYS);
        if (list == null) {
            ExternalSystemViewDefaultContributor.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    public List<ExternalSystemNode<?>> createNodes(ExternalProjectsView externalProjectsView, MultiMap<Key<?>, DataNode<?>> dataNodes) {
        SmartList result = new SmartList();
        ExternalSystemViewDefaultContributor.addModuleNodes(externalProjectsView, dataNodes, result);
        Collection tasksNodes = dataNodes.get((Object)ProjectKeys.TASK);
        if (!tasksNodes.isEmpty()) {
            TasksNode tasksNode = new TasksNode(externalProjectsView, tasksNodes);
            if (externalProjectsView.useTasksNode()) {
                result.add(tasksNode);
            } else {
                ContainerUtil.addAll((Collection)result, (Object[])tasksNode.getChildren());
            }
        }
        ExternalSystemViewDefaultContributor.addDependenciesNode(externalProjectsView, dataNodes, result);
        SmartList smartList = result;
        if (smartList == null) {
            ExternalSystemViewDefaultContributor.$$$reportNull$$$0(2);
        }
        return smartList;
    }

    @Override
    @Nullable
    public String getDisplayName(@NotNull DataNode node) {
        if (node == null) {
            ExternalSystemViewDefaultContributor.$$$reportNull$$$0(3);
        }
        return ExternalSystemViewDefaultContributor.getNodeDisplayName(node);
    }

    private static void addDependenciesNode(@NotNull ExternalProjectsView externalProjectsView, @NotNull MultiMap<Key<?>, DataNode<?>> dataNodes, @NotNull List<? super ExternalSystemNode<?>> result) {
        if (externalProjectsView == null) {
            ExternalSystemViewDefaultContributor.$$$reportNull$$$0(4);
        }
        if (dataNodes == null) {
            ExternalSystemViewDefaultContributor.$$$reportNull$$$0(5);
        }
        if (result == null) {
            ExternalSystemViewDefaultContributor.$$$reportNull$$$0(6);
        }
        Collection moduleDeps = dataNodes.get((Object)ProjectKeys.MODULE_DEPENDENCY);
        Collection libDeps = dataNodes.get((Object)ProjectKeys.LIBRARY_DEPENDENCY);
        if (!moduleDeps.isEmpty() || !libDeps.isEmpty()) {
            MyDependenciesNode depNode = new MyDependenciesNode(externalProjectsView);
            for (DataNode dataNode : moduleDeps) {
                if (!(dataNode.getData() instanceof ModuleDependencyData)) continue;
                ModuleDependencyDataExternalSystemNode moduleDependencyDataExternalSystemNode = new ModuleDependencyDataExternalSystemNode(externalProjectsView, (DataNode<ModuleDependencyData>)dataNode);
                if (dataNode.getParent() != null && dataNode.getParent().getData() instanceof AbstractDependencyData) {
                    result.add(moduleDependencyDataExternalSystemNode);
                    continue;
                }
                depNode.add(moduleDependencyDataExternalSystemNode);
            }
            for (DataNode dataNode : libDeps) {
                if (!(dataNode.getData() instanceof LibraryDependencyData)) continue;
                LibraryDependencyDataExternalSystemNode libraryDependencyDataExternalSystemNode = new LibraryDependencyDataExternalSystemNode(externalProjectsView, (DataNode<LibraryDependencyData>)dataNode);
                if (((LibraryData)((LibraryDependencyData)dataNode.getData()).getTarget()).isUnresolved()) {
                    libraryDependencyDataExternalSystemNode.setErrorLevel(ExternalProjectsStructure.ErrorLevel.ERROR, "Unable to resolve " + ((LibraryData)((LibraryDependencyData)dataNode.getData()).getTarget()).getExternalName());
                } else {
                    libraryDependencyDataExternalSystemNode.setErrorLevel(ExternalProjectsStructure.ErrorLevel.NONE, new String[0]);
                }
                if (dataNode.getParent() != null && dataNode.getParent().getData() instanceof ModuleData) {
                    depNode.add(libraryDependencyDataExternalSystemNode);
                    continue;
                }
                result.add(libraryDependencyDataExternalSystemNode);
            }
            if (depNode.hasChildren()) {
                result.add(depNode);
            }
        }
    }

    private static void addModuleNodes(@NotNull ExternalProjectsView externalProjectsView, @NotNull MultiMap<Key<?>, DataNode<?>> dataNodes, @NotNull List<? super ExternalSystemNode<?>> result) {
        Collection moduleDataNodes;
        if (externalProjectsView == null) {
            ExternalSystemViewDefaultContributor.$$$reportNull$$$0(7);
        }
        if (dataNodes == null) {
            ExternalSystemViewDefaultContributor.$$$reportNull$$$0(8);
        }
        if (result == null) {
            ExternalSystemViewDefaultContributor.$$$reportNull$$$0(9);
        }
        if (!(moduleDataNodes = dataNodes.get((Object)ProjectKeys.MODULE)).isEmpty()) {
            AbstractExternalSystemSettings systemSettings = ExternalSystemApiUtil.getSettings((Project)externalProjectsView.getProject(), (ProjectSystemId)externalProjectsView.getSystemId());
            Map groupToModule = ContainerUtil.newHashMap((int)moduleDataNodes.size());
            ArrayList moduleNodes = ContainerUtil.newArrayList();
            for (DataNode dataNode : moduleDataNodes) {
                ModuleData data = (ModuleData)dataNode.getData();
                ExternalProjectSettings projectSettings = systemSettings.getLinkedProjectSettings(data.getLinkedExternalProjectPath());
                DataNode projectDataNode = ExternalSystemApiUtil.findParent((DataNode)dataNode, (Key)ProjectKeys.PROJECT);
                boolean isRoot = projectSettings != null && data.getLinkedExternalProjectPath().equals(projectSettings.getExternalProjectPath()) && projectDataNode != null && ((ProjectData)projectDataNode.getData()).getInternalName().equals(data.getInternalName());
                ModuleNode moduleNode = new ModuleNode(externalProjectsView, (DataNode<ModuleData>)dataNode, null, isRoot);
                moduleNodes.add(moduleNode);
                String group = moduleNode.getIdeGrouping();
                if (group == null) continue;
                groupToModule.put(group, moduleNode);
            }
            for (ModuleNode moduleNode : moduleNodes) {
                ModuleNode parent;
                moduleNode.setAllModules(moduleNodes);
                String parentGroup = moduleNode.getIdeParentGrouping();
                ModuleNode moduleNode2 = parent = parentGroup != null ? (ModuleNode)groupToModule.get(parentGroup) : null;
                if (parent == null) continue;
                moduleNode.setParent(parent);
            }
            result.addAll(moduleNodes);
        }
    }

    @NotNull
    private static String getNodeDisplayName(@NotNull DataNode node) {
        Object data;
        if (node == null) {
            ExternalSystemViewDefaultContributor.$$$reportNull$$$0(10);
        }
        if ((data = node.getData()) instanceof LibraryDependencyData) {
            LibraryDependencyData libraryDependencyData = (LibraryDependencyData)data;
            String externalName = libraryDependencyData.getExternalName();
            if (StringUtil.isEmpty((String)externalName)) {
                Set paths = ((LibraryData)libraryDependencyData.getTarget()).getPaths(LibraryPathType.BINARY);
                if (paths.size() == 1) {
                    String relativePathToRoot = null;
                    String path = ExternalSystemApiUtil.toCanonicalPath((String)((String)paths.iterator().next()));
                    DataNode projectDataDataNode = ExternalSystemApiUtil.findParent((DataNode)node, (Key)ProjectKeys.PROJECT);
                    if (projectDataDataNode != null) {
                        relativePathToRoot = FileUtil.getRelativePath((String)((ProjectData)projectDataDataNode.getData()).getLinkedExternalProjectPath(), (String)path, (char)'/');
                        relativePathToRoot = relativePathToRoot != null && StringUtil.startsWith((CharSequence)relativePathToRoot, (CharSequence)"../../") ? new File(relativePathToRoot).getName() : relativePathToRoot;
                    }
                    String string = (String)ObjectUtils.notNull(relativePathToRoot, (Object)path);
                    if (string == null) {
                        ExternalSystemViewDefaultContributor.$$$reportNull$$$0(11);
                    }
                    return string;
                }
                if ("<file set>" == null) {
                    ExternalSystemViewDefaultContributor.$$$reportNull$$$0(12);
                }
                return "<file set>";
            }
            String string = externalName;
            if (string == null) {
                ExternalSystemViewDefaultContributor.$$$reportNull$$$0(13);
            }
            return string;
        }
        if (data instanceof Named) {
            String string = ((Named)data).getExternalName();
            if (string == null) {
                ExternalSystemViewDefaultContributor.$$$reportNull$$$0(14);
            }
            return string;
        }
        if (data instanceof TaskData) {
            String string = ((TaskData)data).getName();
            if (string == null) {
                ExternalSystemViewDefaultContributor.$$$reportNull$$$0(15);
            }
            return string;
        }
        String string = StringUtil.notNullize((String)node.toString());
        if (string == null) {
            ExternalSystemViewDefaultContributor.$$$reportNull$$$0(16);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalProjectsView";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataNodes";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeys";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createNodes";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayName";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addDependenciesNode";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addModuleNodes";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getNodeDisplayName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LibraryDependencyDataExternalSystemNode
    extends DependencyDataExternalSystemNode<LibraryDependencyData> {
        LibraryDependencyDataExternalSystemNode(ExternalProjectsView externalProjectsView, DataNode<LibraryDependencyData> dataNode) {
            super(externalProjectsView, null, dataNode);
        }

        protected void update(@NotNull PresentationData presentation) {
            if (presentation == null) {
                LibraryDependencyDataExternalSystemNode.$$$reportNull$$$0(0);
            }
            super.update(presentation);
            presentation.setIcon(AllIcons.Nodes.PpLib);
            LibraryDependencyData data = (LibraryDependencyData)this.getData();
            if (data != null) {
                this.setNameAndTooltip(this.getName(), null, data.getScope().getDisplayName());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor$LibraryDependencyDataExternalSystemNode", "update"));
        }
    }

    private static class ModuleDependencyDataExternalSystemNode
    extends DependencyDataExternalSystemNode<ModuleDependencyData> {
        ModuleDependencyDataExternalSystemNode(ExternalProjectsView externalProjectsView, DataNode<ModuleDependencyData> dataNode) {
            super(externalProjectsView, null, dataNode);
        }

        protected void update(@NotNull PresentationData presentation) {
            if (presentation == null) {
                ModuleDependencyDataExternalSystemNode.$$$reportNull$$$0(0);
            }
            super.update(presentation);
            presentation.setIcon(this.getUiAware().getProjectIcon());
            ModuleDependencyData data = (ModuleDependencyData)this.getData();
            if (data != null) {
                this.setNameAndTooltip(this.getName(), null, data.getScope().getDisplayName());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor$ModuleDependencyDataExternalSystemNode", "update"));
        }
    }

    private static abstract class DependencyDataExternalSystemNode<T extends DependencyData>
    extends ExternalSystemNode<T> {
        DependencyDataExternalSystemNode(@NotNull ExternalProjectsView externalProjectsView, @Nullable ExternalSystemNode parent, @Nullable DataNode<T> dataNode) {
            if (externalProjectsView == null) {
                DependencyDataExternalSystemNode.$$$reportNull$$$0(0);
            }
            super(externalProjectsView, parent, dataNode);
        }

        @Override
        @Nullable
        public Navigatable getNavigatable() {
            return new Navigatable(){
                @Nullable
                private OrderEntry myOrderEntry;

                public void navigate(boolean requestFocus) {
                    if (this.myOrderEntry != null) {
                        ProjectSettingsService.getInstance((Project)myProject).openModuleDependenciesSettings(this.myOrderEntry.getOwnerModule(), this.myOrderEntry);
                    }
                }

                public boolean canNavigate() {
                    this.myOrderEntry = this.getOrderEntry();
                    return this.myOrderEntry != null;
                }

                public boolean canNavigateToSource() {
                    return true;
                }
            };
        }

        @Nullable
        private OrderEntry getOrderEntry() {
            DependencyData data = (DependencyData)this.getData();
            if (data == null) {
                return null;
            }
            Project project = this.getProject();
            if (project == null) {
                return null;
            }
            return new IdeModelsProviderImpl(project).findIdeModuleOrderEntry(data);
        }

        @Override
        public int compareTo(@NotNull ExternalSystemNode node) {
            int order2;
            int order1;
            if (node == null) {
                DependencyDataExternalSystemNode.$$$reportNull$$$0(1);
            }
            DependencyData myData = (DependencyData)this.getData();
            Object thatData = node.getData();
            if (myData instanceof OrderAware && thatData instanceof OrderAware && (order1 = ((OrderAware)myData).getOrder()) != (order2 = ((OrderAware)thatData).getOrder())) {
                return order1 < order2 ? -1 : 1;
            }
            String dependencyName = DependencyDataExternalSystemNode.getDependencySimpleName(this);
            String thatDependencyName = DependencyDataExternalSystemNode.getDependencySimpleName(node);
            return StringUtil.compare((String)dependencyName, (String)thatDependencyName, (boolean)true);
        }

        @NotNull
        private static String getDependencySimpleName(@NotNull ExternalSystemNode node) {
            Set paths;
            LibraryDependencyData dependencyData;
            String externalName;
            Object thatData;
            if (node == null) {
                DependencyDataExternalSystemNode.$$$reportNull$$$0(2);
            }
            if ((thatData = node.getData()) instanceof LibraryDependencyData && StringUtil.isEmpty((String)(externalName = (dependencyData = (LibraryDependencyData)thatData).getExternalName())) && (paths = ((LibraryData)dependencyData.getTarget()).getPaths(LibraryPathType.BINARY)).size() == 1) {
                String string = new File((String)paths.iterator().next()).getName();
                if (string == null) {
                    DependencyDataExternalSystemNode.$$$reportNull$$$0(3);
                }
                return string;
            }
            String string = node.getName();
            if (string == null) {
                DependencyDataExternalSystemNode.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "externalProjectsView";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor$DependencyDataExternalSystemNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor$DependencyDataExternalSystemNode";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDependencySimpleName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "getDependencySimpleName";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @Order(value=20)
    private static class MyDependenciesNode
    extends ExternalSystemNode {
        MyDependenciesNode(ExternalProjectsView externalProjectsView) {
            super(externalProjectsView, null, null);
        }

        protected void update(@NotNull PresentationData presentation) {
            if (presentation == null) {
                MyDependenciesNode.$$$reportNull$$$0(0);
            }
            super.update(presentation);
            presentation.setIcon(AllIcons.Nodes.PpLibFolder);
        }

        @Override
        public String getName() {
            return "Dependencies";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/openapi/externalSystem/view/ExternalSystemViewDefaultContributor$MyDependenciesNode", "update"));
        }
    }
}

