/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.eclipse;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Processor;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.eclipse.EclipseXml;

public class EclipseProjectFinder
implements EclipseXml {
    public static void findModuleRoots(List<? super String> paths, String rootPath, @Nullable Processor<? super String> progressUpdater) {
        File[] files;
        File root;
        String project;
        if (progressUpdater != null) {
            progressUpdater.process((Object)rootPath);
        }
        if ((project = EclipseProjectFinder.findProjectName(rootPath)) != null) {
            paths.add(rootPath);
        }
        if ((root = new File(rootPath)).isDirectory() && (files = root.listFiles()) != null) {
            for (File file : files) {
                EclipseProjectFinder.findModuleRoots(paths, file.getPath(), progressUpdater);
            }
        }
    }

    @Nullable
    public static String findProjectName(String rootPath) {
        String name = null;
        File file = new File(rootPath, ".project");
        if (file.isFile()) {
            try {
                name = JDOMUtil.load((File)file).getChildText("name");
                if (StringUtil.isEmptyOrSpaces((String)name)) {
                    return null;
                }
                name = name.replace("\n", " ").trim();
            }
            catch (IOException | JDOMException e) {
                return null;
            }
        }
        return name;
    }

    @Nullable
    public static LinkedResource findLinkedResource(@NotNull String projectPath, @NotNull String relativePath) {
        File file;
        String independentPath;
        if (projectPath == null) {
            EclipseProjectFinder.$$$reportNull$$$0(0);
        }
        if (relativePath == null) {
            EclipseProjectFinder.$$$reportNull$$$0(1);
        }
        String resourceName = independentPath = FileUtil.toSystemIndependentName((String)relativePath);
        int idx = independentPath.indexOf(47);
        if (idx != -1) {
            resourceName = independentPath.substring(0, idx);
        }
        if ((file = new File(projectPath, ".project")).isFile()) {
            try {
                for (Element o : JDOMUtil.load((File)file).getChildren("linkedResources")) {
                    for (Element l : o.getChildren("link")) {
                        Element location;
                        if (!Comparing.strEqual((String)l.getChildText("name"), (String)resourceName)) continue;
                        LinkedResource linkedResource = new LinkedResource();
                        String relativeToLinkedResourcePath = independentPath.length() > resourceName.length() ? independentPath.substring(resourceName.length()) : "";
                        Element locationURI = l.getChild("locationURI");
                        if (locationURI != null) {
                            linkedResource.setURI(FileUtil.toSystemIndependentName((String)locationURI.getText()) + relativeToLinkedResourcePath);
                        }
                        if ((location = l.getChild("location")) != null) {
                            linkedResource.setLocation(FileUtil.toSystemIndependentName((String)location.getText()) + relativeToLinkedResourcePath);
                        }
                        return linkedResource;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "projectPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "relativePath";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/idea/eclipse/EclipseProjectFinder";
        objectArray[2] = "findLinkedResource";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class LinkedResource {
        private String myURI;
        private String myLocation;

        public String getVariableName() {
            int idx = this.myURI.indexOf(47);
            return idx > -1 ? this.myURI.substring(0, idx) : this.myURI;
        }

        @Nullable
        public String getRelativeToVariablePath() {
            int idx = this.myURI.indexOf(47);
            return idx > -1 && idx + 1 < this.myURI.length() ? this.myURI.substring(idx + 1) : null;
        }

        public boolean containsPathVariable() {
            return this.myURI != null;
        }

        public void setURI(String URI2) {
            this.myURI = URI2;
        }

        public String getLocation() {
            return this.myLocation;
        }

        public void setLocation(String location) {
            this.myLocation = location;
        }
    }
}

