/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.vfs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.reference.SoftReference;
import com.intellij.util.LogicalRoot;
import com.intellij.util.LogicalRootsManager;
import com.intellij.util.SVGLoader;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.lang.ref.Reference;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.common.bytesource.ByteSource;
import org.apache.commons.imaging.common.bytesource.ByteSourceArray;
import org.apache.commons.imaging.formats.ico.IcoImageParser;
import org.intellij.images.editor.ImageDocument;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class IfsUtil {
    private static final Logger LOG = Logger.getInstance((String)"#org.intellij.images.vfs.IfsUtil");
    public static final String ICO_FORMAT = "ico";
    public static final String SVG_FORMAT = "svg";
    private static final Key<Long> TIMESTAMP_KEY = Key.create((String)"Image.timeStamp");
    private static final Key<String> FORMAT_KEY = Key.create((String)"Image.format");
    private static final Key<SoftReference<ImageDocument.ScaledImageProvider>> IMAGE_PROVIDER_REF_KEY = Key.create((String)"Image.bufferedImageProvider");
    private static final IcoImageParser ICO_IMAGE_PARSER = new IcoImageParser();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private static boolean refresh(@NotNull VirtualFile file) throws IOException {
        block33: {
            if (file == null) {
                IfsUtil.$$$reportNull$$$0(0);
            }
            loadedTimeStamp = (Long)file.getUserData(IfsUtil.TIMESTAMP_KEY);
            imageProviderRef = (SoftReference)file.getUserData(IfsUtil.IMAGE_PROVIDER_REF_KEY);
            if (loadedTimeStamp != null && loadedTimeStamp.longValue() == file.getTimeStamp() && SoftReference.dereference((Reference)imageProviderRef) != null) break block33;
            try {
                block32: {
                    content = file.contentsToByteArray();
                    file.putUserData(IfsUtil.IMAGE_PROVIDER_REF_KEY, null);
                    if (!"ico".equalsIgnoreCase(file.getExtension())) ** GOTO lbl-1000
                    try {
                        image = IfsUtil.ICO_IMAGE_PARSER.getBufferedImage((ByteSource)new ByteSourceArray(content), null);
                        file.putUserData(IfsUtil.FORMAT_KEY, (Object)"ico");
                        file.putUserData(IfsUtil.IMAGE_PROVIDER_REF_KEY, (Object)new SoftReference((Object)(ImageDocument.ScaledImageProvider)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$refresh$0(java.awt.image.BufferedImage java.lang.Double java.awt.Component ), (Ljava/lang/Double;Ljava/awt/Component;)Ljava/awt/image/BufferedImage;)((BufferedImage)image)));
                        var5_8 = true;
                        return var5_8;
                    }
                    catch (ImageReadException image) {
                        if (!IfsUtil.isSVG(file)) break block32;
                        url = Ref.create();
                        try {
                            url.set((Object)new File(file.getPath()).toURI().toURL());
                        }
                        catch (MalformedURLException ex) {
                            IfsUtil.LOG.warn(ex.getMessage());
                        }
                        try {
                            SVGLoader.load((URL)((URL)url.get()), (InputStream)new ByteArrayInputStream(content), (double)1.0);
                        }
                        catch (Throwable t) {
                            IfsUtil.LOG.warn(url.get() + " " + t.getMessage());
                            var6_13 = false;
                            file.putUserData(IfsUtil.TIMESTAMP_KEY, (Object)file.getTimeStamp());
                            return var6_13;
                        }
                    }
                    file.putUserData(IfsUtil.FORMAT_KEY, (Object)"svg");
                    file.putUserData(IfsUtil.IMAGE_PROVIDER_REF_KEY, (Object)new SoftReference((Object)new ImageDocument.CachedScaledImageProvider(){
                        final JBUI.ScaleContext.Cache<BufferedImage> cache = new JBUI.ScaleContext.Cache(ctx -> {
                            try {
                                return SVGLoader.loadHiDPI((URL)((URL)url.get()), (InputStream)new ByteArrayInputStream(content), (JBUI.ScaleContext)ctx);
                            }
                            catch (Throwable t) {
                                LOG.warn(url.get() + " " + t.getMessage());
                                return null;
                            }
                        });

                        @Override
                        public void clearCache() {
                            this.cache.clear();
                        }

                        @Override
                        public BufferedImage apply(Double zoom, Component ancestor) {
                            JBUI.ScaleContext ctx = JBUI.ScaleContext.create((Component)ancestor);
                            ctx.update(JBUI.ScaleType.OBJ_SCALE.of(zoom.doubleValue()));
                            return (BufferedImage)this.cache.getOrProvide((JBUI.BaseScaleContext)ctx);
                        }
                    }));
                    t = true;
                    return t;
                }
                inputStream = new ByteArrayInputStream(content, 0, content.length);
                imageInputStream = ImageIO.createImageInputStream(inputStream);
                var6_14 = null;
                try {
                    imageReaders = ImageIO.getImageReaders(imageInputStream);
                    if (imageReaders.hasNext()) {
                        imageReader = imageReaders.next();
                        try {
                            file.putUserData(IfsUtil.FORMAT_KEY, (Object)imageReader.getFormatName());
                            param = imageReader.getDefaultReadParam();
                            imageReader.setInput(imageInputStream, true, true);
                            minIndex = imageReader.getMinIndex();
                            image = imageReader.read(minIndex, param);
                            file.putUserData(IfsUtil.IMAGE_PROVIDER_REF_KEY, (Object)new SoftReference((Object)(ImageDocument.ScaledImageProvider)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, lambda$refresh$1(java.awt.image.BufferedImage java.lang.Double java.awt.Component ), (Ljava/lang/Double;Ljava/awt/Component;)Ljava/awt/image/BufferedImage;)((BufferedImage)image)));
                            var12_22 = true;
                            imageReader.dispose();
                            return var12_22;
                        }
                        catch (Throwable var14_24) {
                            imageReader.dispose();
                            throw var14_24;
                        }
                    }
                    {
                        catch (Throwable var7_17) {
                            var6_14 = var7_17;
                            throw var7_17;
                        }
                        catch (Throwable var15_25) {
                            throw var15_25;
                        }
                    }
                }
                finally {
                    if (imageInputStream != null) {
                        if (var6_14 != null) {
                            try {
                                imageInputStream.close();
                            }
                            catch (Throwable var13_23) {
                                var6_14.addSuppressed(var13_23);
                            }
                        } else {
                            imageInputStream.close();
                        }
                    }
                }
                {
                    catch (Throwable var17_27) {
                        throw var17_27;
                    }
                }
            }
            finally {
                file.putUserData(IfsUtil.TIMESTAMP_KEY, (Object)file.getTimeStamp());
            }
        }
        return false;
    }

    @Nullable
    public static BufferedImage getImage(@NotNull VirtualFile file2) throws IOException {
        if (file2 == null) {
            IfsUtil.$$$reportNull$$$0(1);
        }
        return IfsUtil.getImage(file2, null);
    }

    @Nullable
    public static BufferedImage getImage(@NotNull VirtualFile file2, @Nullable Component ancestor) throws IOException {
        ImageDocument.ScaledImageProvider imageProvider;
        if (file2 == null) {
            IfsUtil.$$$reportNull$$$0(2);
        }
        if ((imageProvider = IfsUtil.getImageProvider(file2)) == null) {
            return null;
        }
        return (BufferedImage)imageProvider.apply(1.0, ancestor);
    }

    @Nullable
    public static ImageDocument.ScaledImageProvider getImageProvider(@NotNull VirtualFile file2) throws IOException {
        if (file2 == null) {
            IfsUtil.$$$reportNull$$$0(3);
        }
        IfsUtil.refresh(file2);
        SoftReference imageProviderRef = (SoftReference)file2.getUserData(IMAGE_PROVIDER_REF_KEY);
        return (ImageDocument.ScaledImageProvider)SoftReference.dereference((Reference)imageProviderRef);
    }

    public static boolean isSVG(@Nullable VirtualFile file2) {
        return file2 != null && SVG_FORMAT.equalsIgnoreCase(file2.getExtension());
    }

    @Nullable
    public static String getFormat(@NotNull VirtualFile file2) throws IOException {
        if (file2 == null) {
            IfsUtil.$$$reportNull$$$0(4);
        }
        IfsUtil.refresh(file2);
        return (String)file2.getUserData(FORMAT_KEY);
    }

    public static String getReferencePath(Project project, VirtualFile file2) {
        LogicalRoot logicalRoot = LogicalRootsManager.getLogicalRootsManager((Project)project).findLogicalRoot(file2);
        if (logicalRoot != null) {
            return IfsUtil.getRelativePath(file2, logicalRoot.getVirtualFile());
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile sourceRoot = fileIndex.getSourceRootForFile(file2);
        if (sourceRoot != null) {
            return IfsUtil.getRelativePath(file2, sourceRoot);
        }
        VirtualFile root = fileIndex.getContentRootForFile(file2);
        if (root != null) {
            return IfsUtil.getRelativePath(file2, root);
        }
        return file2.getPath();
    }

    private static String getRelativePath(VirtualFile file2, VirtualFile root) {
        if (root.equals(file2)) {
            return file2.getPath();
        }
        return "/" + VfsUtilCore.getRelativePath((VirtualFile)file2, (VirtualFile)root, (char)'/');
    }

    private static /* synthetic */ BufferedImage lambda$refresh$1(BufferedImage image, Double zoom, Component ancestor) {
        return image;
    }

    private static /* synthetic */ BufferedImage lambda$refresh$0(BufferedImage image, Double scale, Component ancestor) {
        return image;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "file";
        objectArray2[1] = "org/intellij/images/vfs/IfsUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "refresh";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getImage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getImageProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getFormat";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

