/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.AstLoadingFilter;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.adapters.JsonArrayValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.EnumArrayValueWrapper;
import com.jetbrains.jsonSchema.impl.EnumObjectValueWrapper;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaReader {
    private static final int MAX_SCHEMA_LENGTH = 0x100000;
    public static final Logger LOG = Logger.getInstance(JsonSchemaReader.class);
    public static final NotificationGroup ERRORS_NOTIFICATION = NotificationGroup.logOnlyGroup((String)"JSON Schema");
    private final Map<String, JsonSchemaObject> myIds = new HashMap<String, JsonSchemaObject>();
    private final ArrayDeque<Pair<JsonSchemaObject, JsonValueAdapter>> myQueue;
    private static final Map<String, MyReader> READERS_MAP = new HashMap<String, MyReader>();
    @Nullable
    private final VirtualFile myFile;

    public JsonSchemaReader(@Nullable VirtualFile file2) {
        this.myFile = file2;
        this.myQueue = new ArrayDeque();
    }

    @NotNull
    public static JsonSchemaObject readFromFile(@NotNull Project project, @NotNull VirtualFile file2) throws Exception {
        JsonSchemaObject object;
        if (project == null) {
            JsonSchemaReader.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            JsonSchemaReader.$$$reportNull$$$0(1);
        }
        if (!file2.isValid()) {
            throw new Exception(String.format("Can not load JSON Schema file '%s'", file2.getName()));
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file2);
        JsonSchemaObject jsonSchemaObject = object = psiFile == null ? null : new JsonSchemaReader(file2).read(psiFile);
        if (object == null) {
            throw new Exception(String.format("Can not load code model for JSON Schema file '%s'", file2.getName()));
        }
        JsonSchemaObject jsonSchemaObject2 = object;
        if (jsonSchemaObject2 == null) {
            JsonSchemaReader.$$$reportNull$$$0(2);
        }
        return jsonSchemaObject2;
    }

    @Nullable
    public static String checkIfValidJsonSchema(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            JsonSchemaReader.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            JsonSchemaReader.$$$reportNull$$$0(4);
        }
        long length = file2.getLength();
        String fileName2 = file2.getName();
        if (length > 0x100000L) {
            return String.format("JSON schema was not loaded from '%s' because it's too large (file size is %d bytes).", fileName2, length);
        }
        if (length == 0L) {
            return String.format("JSON schema was not loaded from '%s'. File is empty.", fileName2);
        }
        try {
            JsonSchemaReader.readFromFile(project, file2);
        }
        catch (Exception e) {
            String message = String.format("JSON Schema not found or contain error in '%s': %s", fileName2, e.getMessage());
            LOG.info(message);
            return message;
        }
        return null;
    }

    private static JsonSchemaObject enqueue(@NotNull Collection<Pair<JsonSchemaObject, JsonValueAdapter>> queue2, @NotNull JsonSchemaObject schemaObject, @NotNull JsonValueAdapter container) {
        if (queue2 == null) {
            JsonSchemaReader.$$$reportNull$$$0(5);
        }
        if (schemaObject == null) {
            JsonSchemaReader.$$$reportNull$$$0(6);
        }
        if (container == null) {
            JsonSchemaReader.$$$reportNull$$$0(7);
        }
        queue2.add((Pair<JsonSchemaObject, JsonValueAdapter>)Pair.create((Object)schemaObject, (Object)container));
        return schemaObject;
    }

    @Nullable
    public JsonSchemaObject read(@NotNull PsiFile file2) {
        JsonLikePsiWalker walker;
        if (file2 == null) {
            JsonSchemaReader.$$$reportNull$$$0(8);
        }
        if ((walker = JsonLikePsiWalker.getWalker((PsiElement)file2, JsonSchemaObject.NULL_OBJ)) == null) {
            return null;
        }
        PsiElement root = (PsiElement)AstLoadingFilter.forceAllowTreeLoading((PsiFile)file2, () -> walker.getRoot(file2));
        return root == null ? null : this.read(root, walker);
    }

    @Nullable
    private JsonSchemaObject read(@NotNull PsiElement object, @NotNull JsonLikePsiWalker walker) {
        if (object == null) {
            JsonSchemaReader.$$$reportNull$$$0(9);
        }
        if (walker == null) {
            JsonSchemaReader.$$$reportNull$$$0(10);
        }
        JsonSchemaObject root = new JsonSchemaObject(this.myFile, "/");
        JsonValueAdapter rootAdapter = walker.createValueAdapter(object);
        if (rootAdapter == null) {
            return null;
        }
        JsonSchemaReader.enqueue(this.myQueue, root, rootAdapter);
        while (!this.myQueue.isEmpty()) {
            Pair<JsonSchemaObject, JsonValueAdapter> currentItem = this.myQueue.removeFirst();
            JsonSchemaObject currentSchema = (JsonSchemaObject)currentItem.first;
            String pointer = currentSchema.getPointer();
            JsonValueAdapter adapter = (JsonValueAdapter)currentItem.second;
            if (adapter instanceof JsonObjectValueAdapter) {
                List<JsonPropertyAdapter> list2 = ((JsonObjectValueAdapter)adapter).getPropertyList();
                for (JsonPropertyAdapter property : list2) {
                    String name;
                    Collection<JsonValueAdapter> values = property.getValues();
                    if (values.size() != 1 || (name = property.getName()) == null) continue;
                    MyReader reader = READERS_MAP.get(name);
                    JsonValueAdapter value = values.iterator().next();
                    if (reader != null) {
                        reader.read(value, currentSchema, this.myQueue, this.myFile);
                        continue;
                    }
                    this.readSingleDefinition(name, value, currentSchema, pointer);
                }
            } else if (adapter instanceof JsonArrayValueAdapter) {
                List<JsonValueAdapter> values = ((JsonArrayValueAdapter)adapter).getElements();
                for (int i = 0; i < values.size(); ++i) {
                    this.readSingleDefinition(String.valueOf(i), values.get(i), currentSchema, pointer);
                }
            }
            if (currentSchema.getId() != null) {
                this.myIds.put(currentSchema.getId(), currentSchema);
            }
            currentSchema.completeInitialization(adapter);
        }
        return root;
    }

    public Map<String, JsonSchemaObject> getIds() {
        return this.myIds;
    }

    private void readSingleDefinition(@NotNull String name, @NotNull JsonValueAdapter value, @NotNull JsonSchemaObject schema, String pointer) {
        if (name == null) {
            JsonSchemaReader.$$$reportNull$$$0(11);
        }
        if (value == null) {
            JsonSchemaReader.$$$reportNull$$$0(12);
        }
        if (schema == null) {
            JsonSchemaReader.$$$reportNull$$$0(13);
        }
        String nextPointer = JsonSchemaReader.getNewPointer(name, pointer);
        JsonSchemaObject defined = JsonSchemaReader.enqueue(this.myQueue, new JsonSchemaObject(this.myFile, nextPointer), value);
        Map<String, JsonSchemaObject> definitions = schema.getDefinitionsMap();
        if (definitions == null) {
            definitions = new HashMap<String, JsonSchemaObject>();
            schema.setDefinitionsMap(definitions);
        }
        definitions.put(name, defined);
    }

    @NotNull
    private static String getNewPointer(@NotNull String name, String oldPointer) {
        if (name == null) {
            JsonSchemaReader.$$$reportNull$$$0(14);
        }
        String string = oldPointer.equals("/") ? oldPointer + name : oldPointer + "/" + name;
        if (string == null) {
            JsonSchemaReader.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static void fillMap() {
        READERS_MAP.put("$id", JsonSchemaReader.createFromStringValue((PairConsumer<JsonSchemaObject, String>)((PairConsumer)(object, s) -> object.setId((String)s))));
        READERS_MAP.put("id", JsonSchemaReader.createFromStringValue((PairConsumer<JsonSchemaObject, String>)((PairConsumer)(object, s) -> object.setId((String)s))));
        READERS_MAP.put("$schema", JsonSchemaReader.createFromStringValue((PairConsumer<JsonSchemaObject, String>)((PairConsumer)(object, s) -> object.setSchema((String)s))));
        READERS_MAP.put("description", JsonSchemaReader.createFromStringValue((PairConsumer<JsonSchemaObject, String>)((PairConsumer)(object, s) -> object.setDescription((String)s))));
        READERS_MAP.put("deprecationMessage", JsonSchemaReader.createFromStringValue((PairConsumer<JsonSchemaObject, String>)((PairConsumer)(object, s) -> object.setDeprecationMessage((String)s))));
        READERS_MAP.put("x-intellij-html-description", JsonSchemaReader.createFromStringValue((PairConsumer<JsonSchemaObject, String>)((PairConsumer)(object, s) -> object.setHtmlDescription((String)s))));
        READERS_MAP.put("x-intellij-language-injection", JsonSchemaReader.createFromStringValue((PairConsumer<JsonSchemaObject, String>)((PairConsumer)(object, s) -> object.setLanguageInjection((String)s))));
        READERS_MAP.put("title", JsonSchemaReader.createFromStringValue((PairConsumer<JsonSchemaObject, String>)((PairConsumer)(object, s) -> object.setTitle((String)s))));
        READERS_MAP.put("$ref", JsonSchemaReader.createFromStringValue((PairConsumer<JsonSchemaObject, String>)((PairConsumer)(object, s) -> object.setRef((String)s))));
        READERS_MAP.put("default", JsonSchemaReader.createDefault());
        READERS_MAP.put("format", JsonSchemaReader.createFromStringValue((PairConsumer<JsonSchemaObject, String>)((PairConsumer)(object, s) -> object.setFormat((String)s))));
        READERS_MAP.put("definitions", JsonSchemaReader.createDefinitionsConsumer());
        READERS_MAP.put("properties", JsonSchemaReader.createPropertiesConsumer());
        READERS_MAP.put("multipleOf", JsonSchemaReader.createFromNumber((PairConsumer<JsonSchemaObject, Number>)((PairConsumer)(object, i) -> object.setMultipleOf((Number)i))));
        READERS_MAP.put("maximum", JsonSchemaReader.createFromNumber((PairConsumer<JsonSchemaObject, Number>)((PairConsumer)(object, i) -> object.setMaximum((Number)i))));
        READERS_MAP.put("minimum", JsonSchemaReader.createFromNumber((PairConsumer<JsonSchemaObject, Number>)((PairConsumer)(object, i) -> object.setMinimum((Number)i))));
        READERS_MAP.put("exclusiveMaximum", (element, object, queue2, virtualFile) -> {
            if (element.isBooleanLiteral()) {
                object.setExclusiveMaximum(JsonSchemaReader.getBoolean(element));
            } else if (element.isNumberLiteral()) {
                object.setExclusiveMaximumNumber(JsonSchemaReader.getNumber(element));
            }
        });
        READERS_MAP.put("exclusiveMinimum", (element, object, queue2, virtualFile) -> {
            if (element.isBooleanLiteral()) {
                object.setExclusiveMinimum(JsonSchemaReader.getBoolean(element));
            } else if (element.isNumberLiteral()) {
                object.setExclusiveMinimumNumber(JsonSchemaReader.getNumber(element));
            }
        });
        READERS_MAP.put("maxLength", JsonSchemaReader.createFromInteger((PairConsumer<JsonSchemaObject, Integer>)((PairConsumer)(object, i) -> object.setMaxLength((Integer)i))));
        READERS_MAP.put("minLength", JsonSchemaReader.createFromInteger((PairConsumer<JsonSchemaObject, Integer>)((PairConsumer)(object, i) -> object.setMinLength((Integer)i))));
        READERS_MAP.put("pattern", JsonSchemaReader.createFromStringValue((PairConsumer<JsonSchemaObject, String>)((PairConsumer)(object, s) -> object.setPattern((String)s))));
        READERS_MAP.put("additionalItems", JsonSchemaReader.createAdditionalItems());
        READERS_MAP.put("items", JsonSchemaReader.createItems());
        READERS_MAP.put("contains", JsonSchemaReader.createContains());
        READERS_MAP.put("maxItems", JsonSchemaReader.createFromInteger((PairConsumer<JsonSchemaObject, Integer>)((PairConsumer)(object, i) -> object.setMaxItems((Integer)i))));
        READERS_MAP.put("minItems", JsonSchemaReader.createFromInteger((PairConsumer<JsonSchemaObject, Integer>)((PairConsumer)(object, i) -> object.setMinItems((Integer)i))));
        READERS_MAP.put("uniqueItems", (element, object, queue2, virtualFile) -> {
            if (element.isBooleanLiteral()) {
                object.setUniqueItems(JsonSchemaReader.getBoolean(element));
            }
        });
        READERS_MAP.put("maxProperties", JsonSchemaReader.createFromInteger((PairConsumer<JsonSchemaObject, Integer>)((PairConsumer)(object, i) -> object.setMaxProperties((Integer)i))));
        READERS_MAP.put("minProperties", JsonSchemaReader.createFromInteger((PairConsumer<JsonSchemaObject, Integer>)((PairConsumer)(object, i) -> object.setMinProperties((Integer)i))));
        READERS_MAP.put("required", JsonSchemaReader.createRequired());
        READERS_MAP.put("additionalProperties", JsonSchemaReader.createAdditionalProperties());
        READERS_MAP.put("propertyNames", JsonSchemaReader.createFromObject("propertyNames", (PairConsumer<JsonSchemaObject, JsonSchemaObject>)((PairConsumer)(object, schema) -> object.setPropertyNamesSchema((JsonSchemaObject)schema))));
        READERS_MAP.put("patternProperties", JsonSchemaReader.createPatternProperties());
        READERS_MAP.put("dependencies", JsonSchemaReader.createDependencies());
        READERS_MAP.put("enum", JsonSchemaReader.createEnum());
        READERS_MAP.put("const", (element, object, queue2, virtualFile) -> object.setEnum(ContainerUtil.createMaybeSingletonList((Object)JsonSchemaReader.readEnumValue(element))));
        READERS_MAP.put("type", JsonSchemaReader.createType());
        READERS_MAP.put("allOf", JsonSchemaReader.createContainer((PairConsumer<JsonSchemaObject, List<JsonSchemaObject>>)((PairConsumer)(object, members) -> object.setAllOf((List<JsonSchemaObject>)members))));
        READERS_MAP.put("anyOf", JsonSchemaReader.createContainer((PairConsumer<JsonSchemaObject, List<JsonSchemaObject>>)((PairConsumer)(object, members) -> object.setAnyOf((List<JsonSchemaObject>)members))));
        READERS_MAP.put("oneOf", JsonSchemaReader.createContainer((PairConsumer<JsonSchemaObject, List<JsonSchemaObject>>)((PairConsumer)(object, members) -> object.setOneOf((List<JsonSchemaObject>)members))));
        READERS_MAP.put("not", JsonSchemaReader.createFromObject("not", (PairConsumer<JsonSchemaObject, JsonSchemaObject>)((PairConsumer)(object, schema1) -> object.setNot((JsonSchemaObject)schema1))));
        READERS_MAP.put("if", JsonSchemaReader.createFromObject("if", (PairConsumer<JsonSchemaObject, JsonSchemaObject>)((PairConsumer)(object, schema) -> object.setIf((JsonSchemaObject)schema))));
        READERS_MAP.put("then", JsonSchemaReader.createFromObject("then", (PairConsumer<JsonSchemaObject, JsonSchemaObject>)((PairConsumer)(object, schema) -> object.setThen((JsonSchemaObject)schema))));
        READERS_MAP.put("else", JsonSchemaReader.createFromObject("else", (PairConsumer<JsonSchemaObject, JsonSchemaObject>)((PairConsumer)(object, schema) -> object.setElse((JsonSchemaObject)schema))));
        READERS_MAP.put("instanceof", (element, object, queue2, virtualFile) -> object.setShouldValidateAgainstJSType());
        READERS_MAP.put("typeof", (element, object, queue2, virtualFile) -> object.setShouldValidateAgainstJSType());
    }

    private static MyReader createFromStringValue(PairConsumer<JsonSchemaObject, String> propertySetter) {
        return (element, object, queue2, virtualFile) -> {
            if (element.isStringLiteral()) {
                propertySetter.consume((Object)object, (Object)StringUtil.unquoteString((String)element.getDelegate().getText()));
            }
        };
    }

    private static MyReader createFromInteger(PairConsumer<JsonSchemaObject, Integer> propertySetter) {
        return (element, object, queue2, virtualFile) -> {
            if (element.isNumberLiteral()) {
                propertySetter.consume((Object)object, (Object)((Integer)JsonSchemaReader.getNumber(element)));
            }
        };
    }

    private static MyReader createFromNumber(PairConsumer<JsonSchemaObject, Number> propertySetter) {
        return (element, object, queue2, virtualFile) -> {
            if (element.isNumberLiteral()) {
                propertySetter.consume((Object)object, (Object)JsonSchemaReader.getNumber(element));
            }
        };
    }

    private static MyReader createFromObject(String prop, PairConsumer<JsonSchemaObject, JsonSchemaObject> propertySetter) {
        return (element, object, queue2, virtualFile) -> {
            if (element.isObject()) {
                propertySetter.consume((Object)object, (Object)JsonSchemaReader.enqueue(queue2, new JsonSchemaObject(virtualFile, JsonSchemaReader.getNewPointer(prop, object.getPointer())), element));
            }
        };
    }

    private static MyReader createContainer(@NotNull PairConsumer<JsonSchemaObject, List<JsonSchemaObject>> delegate) {
        if (delegate == null) {
            JsonSchemaReader.$$$reportNull$$$0(16);
        }
        return (element, object, queue2, virtualFile) -> {
            if (element instanceof JsonArrayValueAdapter) {
                List<JsonValueAdapter> list2 = ((JsonArrayValueAdapter)element).getElements();
                ArrayList members = ContainerUtil.newArrayListWithCapacity((int)list2.size());
                for (int i = 0; i < list2.size(); ++i) {
                    JsonValueAdapter value = list2.get(i);
                    if (!value.isObject()) continue;
                    members.add(JsonSchemaReader.enqueue(queue2, new JsonSchemaObject(virtualFile, JsonSchemaReader.getNewPointer(String.valueOf(i), object.getPointer())), value));
                }
                delegate.consume((Object)object, (Object)members);
            }
        };
    }

    private static MyReader createType() {
        return (element, object, queue2, virtualFile) -> {
            Set<JsonSchemaType> typeList;
            if (element.isStringLiteral()) {
                JsonSchemaType type = JsonSchemaReader.parseType(StringUtil.unquoteString((String)element.getDelegate().getText()));
                if (type != null) {
                    object.setType(type);
                }
            } else if (element instanceof JsonArrayValueAdapter && !(typeList = ((JsonArrayValueAdapter)element).getElements().stream().filter(JsonSchemaReader.notEmptyString()).map(el -> JsonSchemaReader.parseType(StringUtil.unquoteString((String)el.getDelegate().getText()))).filter(el -> el != null).collect(Collectors.toSet())).isEmpty()) {
                object.setTypeVariants(typeList);
            }
        };
    }

    @Nullable
    private static JsonSchemaType parseType(@NotNull String typeString) {
        if (typeString == null) {
            JsonSchemaReader.$$$reportNull$$$0(17);
        }
        try {
            return JsonSchemaType.valueOf("_" + typeString);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Nullable
    private static Object readEnumValue(JsonValueAdapter value) {
        if (value.isStringLiteral()) {
            return "\"" + StringUtil.unquoteString((String)value.getDelegate().getText()) + "\"";
        }
        if (value.isNumberLiteral()) {
            return JsonSchemaReader.getNumber(value);
        }
        if (value.isBooleanLiteral()) {
            return JsonSchemaReader.getBoolean(value);
        }
        if (value.isNull()) {
            return "null";
        }
        if (value instanceof JsonArrayValueAdapter) {
            return new EnumArrayValueWrapper(((JsonArrayValueAdapter)value).getElements().stream().map(v -> JsonSchemaReader.readEnumValue(v)).filter(v -> v != null).toArray());
        }
        if (value instanceof JsonObjectValueAdapter) {
            return new EnumObjectValueWrapper(((JsonObjectValueAdapter)value).getPropertyList().stream().filter(p -> p.getValues().size() == 1).map(p -> Pair.create((Object)p.getName(), (Object)JsonSchemaReader.readEnumValue(p.getValues().iterator().next()))).filter(p -> p.second != null).collect(Collectors.toMap(p -> (String)p.first, p -> p.second)));
        }
        return null;
    }

    private static MyReader createEnum() {
        return (element, object, queue2, virtualFile) -> {
            if (element instanceof JsonArrayValueAdapter) {
                ArrayList<Object> objects = new ArrayList<Object>();
                List<JsonValueAdapter> list2 = ((JsonArrayValueAdapter)element).getElements();
                for (JsonValueAdapter value : list2) {
                    Object enumValue = JsonSchemaReader.readEnumValue(value);
                    if (enumValue == null) {
                        return;
                    }
                    objects.add(enumValue);
                }
                object.setEnum(objects);
            }
        };
    }

    private static boolean getBoolean(@NotNull JsonValueAdapter value) {
        if (value == null) {
            JsonSchemaReader.$$$reportNull$$$0(18);
        }
        return Boolean.parseBoolean(value.getDelegate().getText());
    }

    @NotNull
    private static Number getNumber(@NotNull JsonValueAdapter value) {
        Number numberValue;
        if (value == null) {
            JsonSchemaReader.$$$reportNull$$$0(19);
        }
        try {
            numberValue = Integer.parseInt(value.getDelegate().getText());
        }
        catch (NumberFormatException e) {
            try {
                numberValue = Double.parseDouble(value.getDelegate().getText());
            }
            catch (NumberFormatException e2) {
                Integer n = -1;
                if (n == null) {
                    JsonSchemaReader.$$$reportNull$$$0(20);
                }
                return n;
            }
        }
        Integer n = numberValue;
        if (n == null) {
            JsonSchemaReader.$$$reportNull$$$0(21);
        }
        return n;
    }

    private static MyReader createDependencies() {
        return (element, object, queue2, virtualFile) -> {
            if (element instanceof JsonObjectValueAdapter) {
                HashMap<String, List<String>> propertyDependencies = new HashMap<String, List<String>>();
                HashMap<String, JsonSchemaObject> schemaDependencies = new HashMap<String, JsonSchemaObject>();
                List<JsonPropertyAdapter> list2 = ((JsonObjectValueAdapter)element).getPropertyList();
                for (JsonPropertyAdapter property : list2) {
                    JsonValueAdapter value;
                    Collection<JsonValueAdapter> values = property.getValues();
                    if (values.size() != 1 || (value = values.iterator().next()) == null) continue;
                    if (value instanceof JsonArrayValueAdapter) {
                        List dependencies = ((JsonArrayValueAdapter)value).getElements().stream().filter(JsonSchemaReader.notEmptyString()).map(el -> StringUtil.unquoteString((String)el.getDelegate().getText())).collect(Collectors.toList());
                        if (dependencies.isEmpty()) continue;
                        propertyDependencies.put(property.getName(), dependencies);
                        continue;
                    }
                    if (!value.isObject()) continue;
                    String newPointer = JsonSchemaReader.getNewPointer("dependencies/" + property.getName(), object.getPointer());
                    schemaDependencies.put(property.getName(), JsonSchemaReader.enqueue(queue2, new JsonSchemaObject(virtualFile, newPointer), value));
                }
                object.setPropertyDependencies(propertyDependencies);
                object.setSchemaDependencies(schemaDependencies);
            }
        };
    }

    @NotNull
    private static Predicate<JsonValueAdapter> notEmptyString() {
        Predicate<JsonValueAdapter> predicate = el -> el.isStringLiteral() && !StringUtil.isEmptyOrSpaces((String)el.getDelegate().getText());
        if (predicate == null) {
            JsonSchemaReader.$$$reportNull$$$0(22);
        }
        return predicate;
    }

    private static MyReader createPatternProperties() {
        return (element, object, queue2, virtualFile) -> {
            if (element.isObject()) {
                object.setPatternProperties(JsonSchemaReader.readInnerObject(JsonSchemaReader.getNewPointer("patternProperties", object.getPointer()), element, queue2, virtualFile));
            }
        };
    }

    private static MyReader createAdditionalProperties() {
        return (element, object, queue2, virtualFile) -> {
            if (element.isBooleanLiteral()) {
                object.setAdditionalPropertiesAllowed(JsonSchemaReader.getBoolean(element));
            } else if (element.isObject()) {
                object.setAdditionalPropertiesSchema(JsonSchemaReader.enqueue(queue2, new JsonSchemaObject(virtualFile, JsonSchemaReader.getNewPointer("additionalProperties", object.getPointer())), element));
            }
        };
    }

    private static MyReader createRequired() {
        return (element, object, queue2, virtualFile) -> {
            if (element instanceof JsonArrayValueAdapter) {
                object.setRequired(ContainerUtil.newLinkedHashSet((Iterable)((JsonArrayValueAdapter)element).getElements().stream().filter(JsonSchemaReader.notEmptyString()).map(el -> StringUtil.unquoteString((String)el.getDelegate().getText())).collect(Collectors.toList())));
            }
        };
    }

    private static MyReader createItems() {
        return (element, object, queue2, virtualFile) -> {
            if (element.isObject()) {
                object.setItemsSchema(JsonSchemaReader.enqueue(queue2, new JsonSchemaObject(virtualFile, JsonSchemaReader.getNewPointer("items", object.getPointer())), element));
            } else if (element instanceof JsonArrayValueAdapter) {
                ArrayList<JsonSchemaObject> list2 = new ArrayList<JsonSchemaObject>();
                List<JsonValueAdapter> values = ((JsonArrayValueAdapter)element).getElements();
                for (int i = 0; i < values.size(); ++i) {
                    JsonValueAdapter value = values.get(i);
                    if (!value.isObject()) continue;
                    list2.add(JsonSchemaReader.enqueue(queue2, new JsonSchemaObject(virtualFile, JsonSchemaReader.getNewPointer("items/" + i, object.getPointer())), value));
                }
                object.setItemsSchemaList(list2);
            }
        };
    }

    private static MyReader createDefinitionsConsumer() {
        return (element, object, queue2, virtualFile) -> {
            if (element.isObject()) {
                object.setDefinitionsMap(JsonSchemaReader.readInnerObject(JsonSchemaReader.getNewPointer("definitions", object.getPointer()), element, queue2, virtualFile));
            }
        };
    }

    private static MyReader createContains() {
        return (element, object, queue2, virtualFile) -> {
            if (element.isObject()) {
                object.setContainsSchema(JsonSchemaReader.enqueue(queue2, new JsonSchemaObject(virtualFile, JsonSchemaReader.getNewPointer("contains", object.getPointer())), element));
            }
        };
    }

    private static MyReader createAdditionalItems() {
        return (element, object, queue2, virtualFile) -> {
            if (element.isBooleanLiteral()) {
                object.setAdditionalItemsAllowed(JsonSchemaReader.getBoolean(element));
            } else if (element.isObject()) {
                object.setAdditionalItemsSchema(JsonSchemaReader.enqueue(queue2, new JsonSchemaObject(virtualFile, JsonSchemaReader.getNewPointer("additionalItems", object.getPointer())), element));
            }
        };
    }

    private static MyReader createPropertiesConsumer() {
        return (element, object, queue2, virtualFile) -> {
            if (element.isObject()) {
                object.setProperties(JsonSchemaReader.readInnerObject(JsonSchemaReader.getNewPointer("properties", object.getPointer()), element, queue2, virtualFile));
            }
        };
    }

    @NotNull
    private static Map<String, JsonSchemaObject> readInnerObject(String parentPointer, @NotNull JsonValueAdapter element, @NotNull Collection<Pair<JsonSchemaObject, JsonValueAdapter>> queue2, VirtualFile virtualFile) {
        if (element == null) {
            JsonSchemaReader.$$$reportNull$$$0(23);
        }
        if (queue2 == null) {
            JsonSchemaReader.$$$reportNull$$$0(24);
        }
        HashMap<String, JsonSchemaObject> map2 = new HashMap<String, JsonSchemaObject>();
        if (!(element instanceof JsonObjectValueAdapter)) {
            HashMap<String, JsonSchemaObject> hashMap = map2;
            if (hashMap == null) {
                JsonSchemaReader.$$$reportNull$$$0(25);
            }
            return hashMap;
        }
        List<JsonPropertyAdapter> properties = ((JsonObjectValueAdapter)element).getPropertyList();
        for (JsonPropertyAdapter property : properties) {
            Collection<JsonValueAdapter> values = property.getValues();
            if (values.size() != 1) continue;
            JsonValueAdapter value = values.iterator().next();
            String propertyName = property.getName();
            if (propertyName == null) continue;
            if (value.isBooleanLiteral()) {
                map2.put(propertyName, new JsonSchemaObject(virtualFile, JsonSchemaReader.getNewPointer(propertyName, parentPointer)));
                continue;
            }
            if (!value.isObject()) continue;
            map2.put(propertyName, JsonSchemaReader.enqueue(queue2, new JsonSchemaObject(virtualFile, JsonSchemaReader.getNewPointer(propertyName, parentPointer)), value));
        }
        HashMap<String, JsonSchemaObject> hashMap = map2;
        if (hashMap == null) {
            JsonSchemaReader.$$$reportNull$$$0(26);
        }
        return hashMap;
    }

    private static MyReader createDefault() {
        return (element, object, queue2, virtualFile) -> {
            if (element.isObject()) {
                object.setDefault(JsonSchemaReader.enqueue(queue2, new JsonSchemaObject(virtualFile, JsonSchemaReader.getNewPointer("default", object.getPointer())), element));
            } else if (element.isStringLiteral()) {
                object.setDefault(StringUtil.unquoteString((String)element.getDelegate().getText()));
            } else if (element.isNumberLiteral()) {
                object.setDefault(JsonSchemaReader.getNumber(element));
            } else if (element.isBooleanLiteral()) {
                object.setDefault(JsonSchemaReader.getBoolean(element));
            }
        };
    }

    static {
        JsonSchemaReader.fillMap();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaReader";
                break;
            }
            case 5: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queue";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaObject";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "walker";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeString";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaReader";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "readFromFile";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getNewPointer";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getNumber";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "notEmptyString";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "readInnerObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readFromFile";
                break;
            }
            case 2: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkIfValidJsonSchema";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "enqueue";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "read";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "readSingleDefinition";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getNewPointer";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createContainer";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "parseType";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getBoolean";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getNumber";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "readInnerObject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 15: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static interface MyReader {
        public void read(@NotNull JsonValueAdapter var1, @NotNull JsonSchemaObject var2, @NotNull Collection<Pair<JsonSchemaObject, JsonValueAdapter>> var3, @Nullable VirtualFile var4);
    }
}

