/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.extension;

import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ThreeState;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalkerFactory;
import com.jetbrains.jsonSchema.extension.JsonLikeSyntaxAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.JsonOriginalPsiWalker;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JsonLikePsiWalker {
    public ThreeState isName(PsiElement var1);

    public boolean isPropertyWithValue(@NotNull PsiElement var1);

    public PsiElement findElementToCheck(@NotNull PsiElement var1);

    @Nullable
    public JsonPointerPosition findPosition(@NotNull PsiElement var1, boolean var2);

    public boolean requiresNameQuotes();

    default public boolean requiresValueQuotes() {
        return true;
    }

    public boolean allowsSingleQuotes();

    public boolean hasMissingCommaAfter(@NotNull PsiElement var1);

    public Set<String> getPropertyNamesOfParentObject(@NotNull PsiElement var1, PsiElement var2);

    @Nullable
    public JsonPropertyAdapter getParentPropertyAdapter(@NotNull PsiElement var1);

    public boolean isTopJsonElement(@NotNull PsiElement var1);

    @Nullable
    public JsonValueAdapter createValueAdapter(@NotNull PsiElement var1);

    default public TextRange adjustErrorHighlightingRange(@NotNull PsiElement element) {
        if (element == null) {
            JsonLikePsiWalker.$$$reportNull$$$0(0);
        }
        return element.getTextRange();
    }

    default public boolean acceptsEmptyRoot() {
        return false;
    }

    @Nullable
    public PsiElement getRoot(@NotNull PsiFile var1);

    @Nullable
    public static JsonLikePsiWalker getWalker(@NotNull PsiElement element, JsonSchemaObject schemaObject) {
        if (element == null) {
            JsonLikePsiWalker.$$$reportNull$$$0(1);
        }
        if (JsonOriginalPsiWalker.INSTANCE.handles(element)) {
            return JsonOriginalPsiWalker.INSTANCE;
        }
        return JsonLikePsiWalkerFactory.EXTENSION_POINT_NAME.getExtensionList().stream().filter(extension -> extension.handles(element)).findFirst().map(extension -> extension.create(schemaObject)).orElse(null);
    }

    default public String getDefaultObjectValue() {
        return "{}";
    }

    default public String getDefaultArrayValue() {
        return "[]";
    }

    default public boolean hasWhitespaceDelimitedCodeBlocks() {
        return false;
    }

    default public String getNodeTextForValidation(PsiElement element) {
        return element.getText();
    }

    default public JsonLikeSyntaxAdapter getSyntaxAdapter(Project project) {
        return null;
    }

    @Nullable
    default public PsiElement getParentContainer(PsiElement element) {
        return null;
    }

    @Nullable
    public PsiElement getPropertyNameElement(@Nullable PsiElement var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "element";
        objectArray2[1] = "com/jetbrains/jsonSchema/extension/JsonLikePsiWalker";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "adjustErrorHighlightingRange";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getWalker";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

