/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.index;

import com.intellij.ide.highlighter.DTDFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.NullableFunction;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.IOUtil;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xml.index.IndexedRelevantResource;
import com.intellij.xml.index.XmlIndex;
import com.intellij.xml.index.XsdNamespaceBuilder;
import com.intellij.xml.util.XmlUtil;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlNamespaceIndex
extends XmlIndex<XsdNamespaceBuilder> {
    public static final ID<String, XsdNamespaceBuilder> NAME = ID.create((String)"XmlNamespaces");
    private static final String NULL_STRING = "\"\"";

    @Nullable
    public static String getNamespace(@NotNull VirtualFile file2, Project project, PsiFile context) {
        if (file2 == null) {
            XmlNamespaceIndex.$$$reportNull$$$0(0);
        }
        if (DumbService.isDumb((Project)project) || context != null && XmlUtil.isStubBuilding()) {
            return XmlNamespaceIndex.computeNamespace(file2);
        }
        List list2 = FileBasedIndex.getInstance().getValues(NAME, (Object)file2.getUrl(), XmlNamespaceIndex.createFilter(project));
        return list2.size() == 0 ? null : ((XsdNamespaceBuilder)list2.get(0)).getNamespace();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String computeNamespace(@NotNull VirtualFile file2) {
        if (file2 == null) {
            XmlNamespaceIndex.$$$reportNull$$$0(1);
        }
        InputStream stream = null;
        try {
            stream = file2.getInputStream();
            String string = XsdNamespaceBuilder.computeNamespace(stream);
            return string;
        }
        catch (IOException e) {
            String string = null;
            return string;
        }
        finally {
            StreamUtil.closeStream((Closeable)stream);
        }
    }

    public static List<IndexedRelevantResource<String, XsdNamespaceBuilder>> getResourcesByNamespace(String namespace, @NotNull Project project, @Nullable Module module) {
        if (project == null) {
            XmlNamespaceIndex.$$$reportNull$$$0(2);
        }
        List<IndexedRelevantResource<String, XsdNamespaceBuilder>> resources = IndexedRelevantResource.getResources(NAME, namespace, module, project, null);
        Collections.sort(resources);
        return resources;
    }

    public static List<IndexedRelevantResource<String, XsdNamespaceBuilder>> getAllResources(@Nullable Module module, @NotNull Project project, @Nullable NullableFunction<List<IndexedRelevantResource<String, XsdNamespaceBuilder>>, ? extends IndexedRelevantResource<String, XsdNamespaceBuilder>> chooser) {
        if (project == null) {
            XmlNamespaceIndex.$$$reportNull$$$0(3);
        }
        return IndexedRelevantResource.getAllResources(NAME, module, project, chooser);
    }

    @NotNull
    public ID<String, XsdNamespaceBuilder> getName() {
        ID<String, XsdNamespaceBuilder> iD = NAME;
        if (iD == null) {
            XmlNamespaceIndex.$$$reportNull$$$0(4);
        }
        return iD;
    }

    @Override
    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DefaultFileTypeSpecificInputFilter defaultFileTypeSpecificInputFilter = new DefaultFileTypeSpecificInputFilter(new FileType[]{XmlFileType.INSTANCE, DTDFileType.INSTANCE}){

            public boolean acceptInput(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                FileType fileType = file2.getFileType();
                String extension = file2.getExtension();
                return XmlFileType.INSTANCE.equals(fileType) && "xsd".equals(extension) || ((Object)((Object)DTDFileType.INSTANCE)).equals(fileType) && "dtd".equals(extension);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/xml/index/XmlNamespaceIndex$1", "acceptInput"));
            }
        };
        if (defaultFileTypeSpecificInputFilter == null) {
            XmlNamespaceIndex.$$$reportNull$$$0(5);
        }
        return defaultFileTypeSpecificInputFilter;
    }

    @NotNull
    public DataIndexer<String, XsdNamespaceBuilder, FileContent> getIndexer() {
        DataIndexer<String, XsdNamespaceBuilder, FileContent> dataIndexer = new DataIndexer<String, XsdNamespaceBuilder, FileContent>(){

            @NotNull
            public Map<String, XsdNamespaceBuilder> map(@NotNull FileContent inputData) {
                if (inputData == null) {
                    2.$$$reportNull$$$0(0);
                }
                XsdNamespaceBuilder builder2 = "dtd".equals(inputData.getFile().getExtension()) ? new XsdNamespaceBuilder(inputData.getFileName(), "", Collections.emptyList(), Collections.emptyList()) : XsdNamespaceBuilder.computeNamespace(CharArrayUtil.readerFromCharSequence((CharSequence)inputData.getContentAsText()));
                HashMap<String, XsdNamespaceBuilder> map2 = new HashMap<String, XsdNamespaceBuilder>(2);
                String namespace = builder2.getNamespace();
                if (namespace != null) {
                    map2.put(namespace, builder2);
                }
                map2.put(inputData.getFile().getUrl(), builder2);
                HashMap<String, XsdNamespaceBuilder> hashMap = map2;
                if (hashMap == null) {
                    2.$$$reportNull$$$0(1);
                }
                return hashMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "inputData";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/xml/index/XmlNamespaceIndex$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/xml/index/XmlNamespaceIndex$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "map";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "map";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (dataIndexer == null) {
            XmlNamespaceIndex.$$$reportNull$$$0(6);
        }
        return dataIndexer;
    }

    @NotNull
    public DataExternalizer<XsdNamespaceBuilder> getValueExternalizer() {
        DataExternalizer<XsdNamespaceBuilder> dataExternalizer = new DataExternalizer<XsdNamespaceBuilder>(){

            public void save(@NotNull DataOutput out, XsdNamespaceBuilder value) throws IOException {
                if (out == null) {
                    3.$$$reportNull$$$0(0);
                }
                IOUtil.writeUTF((DataOutput)out, (String)(value.getNamespace() != null ? value.getNamespace() : XmlNamespaceIndex.NULL_STRING));
                IOUtil.writeUTF((DataOutput)out, (String)(value.getVersion() != null ? value.getVersion() : XmlNamespaceIndex.NULL_STRING));
                IOUtil.writeStringList((DataOutput)out, value.getTags());
                IOUtil.writeStringList((DataOutput)out, value.getRootTags());
            }

            public XsdNamespaceBuilder read(@NotNull DataInput in) throws IOException {
                String version2;
                String namespace;
                if (in == null) {
                    3.$$$reportNull$$$0(1);
                }
                if (XmlNamespaceIndex.NULL_STRING.equals(namespace = IOUtil.readUTF((DataInput)in))) {
                    namespace = null;
                }
                if (XmlNamespaceIndex.NULL_STRING.equals(version2 = IOUtil.readUTF((DataInput)in))) {
                    version2 = null;
                }
                return new XsdNamespaceBuilder(namespace, version2, IOUtil.readStringList((DataInput)in), IOUtil.readStringList((DataInput)in));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/xml/index/XmlNamespaceIndex$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "save";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "read";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        if (dataExternalizer == null) {
            XmlNamespaceIndex.$$$reportNull$$$0(7);
        }
        return dataExternalizer;
    }

    @Override
    public int getVersion() {
        return 6;
    }

    @Nullable
    public static IndexedRelevantResource<String, XsdNamespaceBuilder> guessSchema(String namespace, @Nullable String tagName, @Nullable String version2, @Nullable String schemaLocation, @Nullable Module module, @NotNull Project project) {
        List<IndexedRelevantResource<String, XsdNamespaceBuilder>> resources;
        if (project == null) {
            XmlNamespaceIndex.$$$reportNull$$$0(8);
        }
        if ((resources = XmlNamespaceIndex.getResourcesByNamespace(namespace, project, module)).isEmpty()) {
            return null;
        }
        if (resources.size() == 1) {
            return resources.get(0);
        }
        String fileName2 = schemaLocation == null ? null : new File(schemaLocation).getName();
        IndexedRelevantResource<String, XsdNamespaceBuilder> resource = Collections.max(resources, (o1, o2) -> {
            int i;
            if (fileName2 != null && (i = Comparing.compare((boolean)fileName2.equals(o1.getFile().getName()), (boolean)fileName2.equals(o2.getFile().getName()))) != 0) {
                return i;
            }
            if (tagName != null && (i = Comparing.compare((boolean)((XsdNamespaceBuilder)o1.getValue()).hasTag(tagName), (boolean)((XsdNamespaceBuilder)o2.getValue()).hasTag(tagName))) != 0) {
                return i;
            }
            i = o1.compareTo(o2);
            if (i != 0) {
                return i;
            }
            return ((XsdNamespaceBuilder)o1.getValue()).getRating(tagName, version2) - ((XsdNamespaceBuilder)o2.getValue()).getRating(tagName, version2);
        });
        if (tagName != null && !resource.getValue().hasTag(tagName)) {
            return null;
        }
        return resource;
    }

    @Nullable
    public static XmlFile guessSchema(String namespace, @Nullable String tagName, @Nullable String version2, @Nullable String schemaLocation, @NotNull PsiFile file2) {
        if (file2 == null) {
            XmlNamespaceIndex.$$$reportNull$$$0(9);
        }
        if (DumbService.isDumb((Project)file2.getProject()) || XmlUtil.isStubBuilding()) {
            return null;
        }
        IndexedRelevantResource<String, XsdNamespaceBuilder> resource = XmlNamespaceIndex.guessSchema(namespace, tagName, version2, schemaLocation, ModuleUtilCore.findModuleForPsiElement((PsiElement)file2), file2.getProject());
        if (resource == null) {
            return null;
        }
        return XmlNamespaceIndex.findSchemaFile(resource.getFile(), file2);
    }

    @Nullable
    private static XmlFile findSchemaFile(VirtualFile resourceFile, PsiFile baseFile) {
        PsiFile psiFile = baseFile.getManager().findFile(resourceFile);
        return psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
    }

    @Nullable
    public static XmlFile guessDtd(String dtdUri, @NotNull PsiFile baseFile) {
        IndexedRelevantResource<String, XsdNamespaceBuilder> resource;
        if (baseFile == null) {
            XmlNamespaceIndex.$$$reportNull$$$0(10);
        }
        if (!dtdUri.endsWith(".dtd") || DumbService.isDumb((Project)baseFile.getProject()) || XmlUtil.isStubBuilding()) {
            return null;
        }
        String dtdFileName = new File(dtdUri).getName();
        List<IndexedRelevantResource<String, XsdNamespaceBuilder>> list2 = XmlNamespaceIndex.getResourcesByNamespace(dtdFileName, baseFile.getProject(), ModuleUtilCore.findModuleForPsiElement((PsiElement)baseFile));
        if (list2.isEmpty()) {
            return null;
        }
        if (list2.size() > 1) {
            final String[] split = dtdUri.split("/");
            resource = Collections.max(list2, new Comparator<IndexedRelevantResource<String, XsdNamespaceBuilder>>(){

                @Override
                public int compare(IndexedRelevantResource<String, XsdNamespaceBuilder> o1, IndexedRelevantResource<String, XsdNamespaceBuilder> o2) {
                    return this.weight(o1) - this.weight(o2);
                }

                int weight(IndexedRelevantResource<String, XsdNamespaceBuilder> o1) {
                    VirtualFile file2 = o1.getFile();
                    for (int i = split.length - 1; i >= 0 && file2 != null; file2 = file2.getParent(), --i) {
                        String s = split[i];
                        if (s.equals(file2.getName())) continue;
                        return split.length - i;
                    }
                    return 0;
                }
            });
        } else {
            resource = list2.get(0);
        }
        return XmlNamespaceIndex.findSchemaFile(resource.getFile(), baseFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/index/XmlNamespaceIndex";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/index/XmlNamespaceIndex";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNamespace";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "computeNamespace";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getResourcesByNamespace";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAllResources";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "guessSchema";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "guessDtd";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

