/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiElement;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.xml.breadcrumbs.CrumbPresentation;
import com.intellij.xml.breadcrumbs.NavigatableCrumb;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PsiCrumb
extends Crumb.Impl
implements NavigatableCrumb {
    private final PsiAnchor anchor;
    private BreadcrumbsProvider provider;
    private String tooltip;
    final CrumbPresentation presentation;

    PsiCrumb(PsiElement element, BreadcrumbsProvider provider, CrumbPresentation presentation) {
        super(provider.getElementIcon(element), provider.getElementInfo(element), null, provider.getContextActions(element));
        this.anchor = PsiAnchor.create(element);
        this.provider = provider;
        this.presentation = presentation;
    }

    public String getTooltip() {
        if (this.tooltip == null && this.provider != null) {
            PsiElement element = PsiCrumb.getElement(this);
            if (element != null) {
                this.tooltip = this.provider.getElementTooltip(element);
            }
            this.provider = null;
        }
        return this.tooltip;
    }

    @Override
    public TextRange getHighlightRange() {
        PsiElement element = this.anchor.retrieve();
        return element != null ? element.getTextRange() : null;
    }

    @Override
    public void navigate(@NotNull Editor editor, boolean withSelection) {
        TextRange range2;
        PsiElement element;
        if (editor == null) {
            PsiCrumb.$$$reportNull$$$0(0);
        }
        if ((element = this.anchor.retrieve()) == null) {
            return;
        }
        PsiCrumb.moveEditorCaretTo(editor, element.getTextOffset());
        if (withSelection && (range2 = this.getHighlightRange()) != null) {
            editor.getSelectionModel().setSelection(range2.getStartOffset(), range2.getEndOffset());
        }
    }

    private static void moveEditorCaretTo(Editor editor, int offset) {
        if (offset >= 0) {
            editor.getCaretModel().moveToOffset(offset);
            editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        }
    }

    @Nullable
    static PsiElement getElement(Crumb crumb) {
        return crumb instanceof PsiCrumb ? ((PsiCrumb)crumb).anchor.retrieve() : null;
    }

    @Nullable
    static CrumbPresentation getPresentation(Crumb crumb) {
        return crumb instanceof PsiCrumb ? ((PsiCrumb)crumb).presentation : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/xml/breadcrumbs/PsiCrumb", "navigate"));
    }
}

