/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.frame;

import com.intellij.ide.OccurenceNavigator;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.components.JBList;
import com.intellij.xdebugger.XDebuggerBundle;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Position;
import org.jetbrains.annotations.NotNull;

public abstract class DebuggerFramesList
extends JBList
implements OccurenceNavigator {
    public DebuggerFramesList() {
        super((ListModel)new CollectionListModel(new Object[0]));
    }

    protected void doInit() {
        this.getSelectionModel().setSelectionMode(0);
        this.setCellRenderer(this.createListRenderer());
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    DebuggerFramesList.this.onFrameChanged(DebuggerFramesList.this.getSelectedValue());
                }
            }
        });
        this.getEmptyText().setText(XDebuggerBundle.message((String)"debugger.frames.not.available", (Object[])new Object[0]));
    }

    public void setModel(ListModel model) {
    }

    public CollectionListModel getModel() {
        return (CollectionListModel)super.getModel();
    }

    public void clear() {
        this.getModel().removeAll();
    }

    public int getElementCount() {
        return this.getModel().getSize();
    }

    @NotNull
    public String getNextOccurenceActionName() {
        String string = XDebuggerBundle.message((String)"action.next.frame.text", (Object[])new Object[0]);
        if (string == null) {
            DebuggerFramesList.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getPreviousOccurenceActionName() {
        String string = XDebuggerBundle.message((String)"action.previous.frame.text", (Object[])new Object[0]);
        if (string == null) {
            DebuggerFramesList.$$$reportNull$$$0(1);
        }
        return string;
    }

    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        this.setSelectedIndex(this.getSelectedIndex() + 1);
        return this.createInfo();
    }

    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        this.setSelectedIndex(this.getSelectedIndex() - 1);
        return this.createInfo();
    }

    private OccurenceNavigator.OccurenceInfo createInfo() {
        return OccurenceNavigator.OccurenceInfo.position((int)this.getSelectedIndex(), (int)this.getElementCount());
    }

    public boolean hasNextOccurence() {
        return this.getSelectedIndex() < this.getElementCount() - 1;
    }

    public boolean hasPreviousOccurence() {
        return this.getSelectedIndex() > 0;
    }

    protected abstract ListCellRenderer createListRenderer();

    protected abstract void onFrameChanged(Object var1);

    public int getNextMatch(String prefix, int startIndex, Position.Bias bias) {
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/xdebugger/impl/frame/DebuggerFramesList";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextOccurenceActionName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviousOccurenceActionName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

