/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.lang.Language;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultsSerializationFilter;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="debuggerHistoryManager", storages={@Storage(value="$WORKSPACE_FILE$")})
public class XDebuggerHistoryManager
implements PersistentStateComponent<Element> {
    public static final int MAX_RECENT_EXPRESSIONS = 10;
    private static final SerializationFilter SERIALIZATION_FILTER = new SkipDefaultsSerializationFilter();
    private static final String STATE_TAG = "root";
    private static final String ID_ATTRIBUTE = "id";
    private static final String EXPRESSIONS_TAG = "expressions";
    private static final String EXPRESSION_TAG = "expression";
    private final Map<String, LinkedList<XExpression>> myRecentExpressions = new HashMap<String, LinkedList<XExpression>>();

    public static XDebuggerHistoryManager getInstance(@NotNull Project project) {
        if (project == null) {
            XDebuggerHistoryManager.$$$reportNull$$$0(0);
        }
        return (XDebuggerHistoryManager)ServiceManager.getService((Project)project, XDebuggerHistoryManager.class);
    }

    public boolean addRecentExpression(@NotNull @NonNls String id, @Nullable XExpression expression) {
        if (id == null) {
            XDebuggerHistoryManager.$$$reportNull$$$0(1);
        }
        if (XDebuggerUtilImpl.isEmptyExpression(expression) || expression.getExpression().length() > 100000) {
            return false;
        }
        LinkedList list2 = this.myRecentExpressions.computeIfAbsent(id, k -> new LinkedList());
        if (list2.size() == 10) {
            list2.removeLast();
        }
        XExpressionImpl trimmedExpression = new XExpressionImpl(expression.getExpression().trim(), expression.getLanguage(), expression.getCustomInfo(), expression.getMode());
        list2.remove(trimmedExpression);
        list2.addFirst(trimmedExpression);
        return true;
    }

    public List<XExpression> getRecentExpressions(@NonNls String id) {
        return ContainerUtil.notNullize((List)this.myRecentExpressions.get(id));
    }

    @Nullable
    public Element getState() {
        Element state = new Element(STATE_TAG);
        for (String id : this.myRecentExpressions.keySet()) {
            LinkedList<XExpression> expressions = this.myRecentExpressions.get(id);
            List states = ContainerUtil.map(expressions, ExpressionState::new);
            Element entryElement = new Element(EXPRESSIONS_TAG);
            entryElement.setAttribute(ID_ATTRIBUTE, id);
            for (ExpressionState expressionState : states) {
                entryElement.addContent(XmlSerializer.serialize((Object)expressionState, (SerializationFilter)SERIALIZATION_FILTER));
            }
            state.addContent(entryElement);
        }
        return state;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            XDebuggerHistoryManager.$$$reportNull$$$0(2);
        }
        this.myRecentExpressions.clear();
        for (Element expression : state.getChildren(EXPRESSIONS_TAG)) {
            String id = expression.getAttributeValue(ID_ATTRIBUTE);
            LinkedList<XExpression> expressions = new LinkedList<XExpression>();
            for (Element expressionElement : expression.getChildren(EXPRESSION_TAG)) {
                expressions.add(((ExpressionState)XmlSerializer.deserialize((Element)expressionElement, ExpressionState.class)).toXExpression());
            }
            this.myRecentExpressions.put(id, expressions);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = ID_ATTRIBUTE;
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "com/intellij/xdebugger/impl/XDebuggerHistoryManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "addRecentExpression";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @Tag(value="expression")
    private static class ExpressionState {
        @Tag(value="expression-string")
        String myExpression;
        @Tag(value="language-id")
        String myLanguageId;
        @Tag(value="custom-info")
        String myCustomInfo;
        @Tag(value="evaluation-mode")
        EvaluationMode myEvaluationMode;

        ExpressionState() {
        }

        ExpressionState(@NotNull XExpression expression) {
            if (expression == null) {
                ExpressionState.$$$reportNull$$$0(0);
            }
            this.myExpression = expression.getExpression();
            Language language = expression.getLanguage();
            this.myLanguageId = language == null ? null : language.getID();
            this.myCustomInfo = expression.getCustomInfo();
            this.myEvaluationMode = expression.getMode();
        }

        @NotNull
        XExpression toXExpression() {
            if (this.myEvaluationMode == null) {
                this.myEvaluationMode = EvaluationMode.EXPRESSION;
            }
            XExpressionImpl xExpressionImpl = new XExpressionImpl(this.myExpression, Language.findLanguageByID((String)this.myLanguageId), this.myCustomInfo, this.myEvaluationMode);
            if (xExpressionImpl == null) {
                ExpressionState.$$$reportNull$$$0(1);
            }
            return xExpressionImpl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = XDebuggerHistoryManager.EXPRESSION_TAG;
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xdebugger/impl/XDebuggerHistoryManager$ExpressionState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xdebugger/impl/XDebuggerHistoryManager$ExpressionState";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toXExpression";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

