/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.attach.osHandlers;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.EnvironmentUtil;
import com.intellij.xdebugger.attach.EnvironmentAwareHost;
import com.intellij.xdebugger.attach.LocalAttachHost;
import com.intellij.xdebugger.attach.osHandlers.GenericAttachOSHandler;
import com.intellij.xdebugger.attach.osHandlers.LinuxAttachOSHandler;
import com.intellij.xdebugger.attach.osHandlers.MacAttachOSHandler;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AttachOSHandler {
    private static final Logger LOGGER = Logger.getInstance(AttachOSHandler.class);
    private static final GeneralCommandLine ENV_COMMAND_LINE = new GeneralCommandLine(new String[]{"env"});
    private Map<String, String> myEnvironment;
    @NotNull
    private final OSType myOSType;
    @NotNull
    protected final EnvironmentAwareHost myHost;

    public AttachOSHandler(@NotNull EnvironmentAwareHost host, @NotNull OSType osType) {
        if (host == null) {
            AttachOSHandler.$$$reportNull$$$0(0);
        }
        if (osType == null) {
            AttachOSHandler.$$$reportNull$$$0(1);
        }
        this.myHost = host;
        this.myOSType = osType;
    }

    @NotNull
    public OSType getOSType() {
        OSType oSType = this.myOSType;
        if (oSType == null) {
            AttachOSHandler.$$$reportNull$$$0(2);
        }
        return oSType;
    }

    @Nullable
    protected String getenv(String name) throws Exception {
        if (this.myHost instanceof LocalAttachHost) {
            return EnvironmentUtil.getValue((String)name);
        }
        if (this.myEnvironment == null) {
            this.myEnvironment = EnvironmentUtil.parseEnv((String[])this.myHost.getProcessOutput(ENV_COMMAND_LINE).getStdout().split("\n"));
        }
        return this.myEnvironment.get(name);
    }

    @NotNull
    public static AttachOSHandler getAttachOsHandler(@NotNull EnvironmentAwareHost host) {
        block7: {
            MacAttachOSHandler macAttachOSHandler;
            block8: {
                OSType osType;
                block5: {
                    LinuxAttachOSHandler linuxAttachOSHandler;
                    block6: {
                        if (host == null) {
                            AttachOSHandler.$$$reportNull$$$0(3);
                        }
                        osType = AttachOSHandler.computeOsType(host);
                        if (osType != OSType.LINUX) break block5;
                        linuxAttachOSHandler = new LinuxAttachOSHandler(host);
                        if (linuxAttachOSHandler != null) break block6;
                        AttachOSHandler.$$$reportNull$$$0(4);
                    }
                    return linuxAttachOSHandler;
                }
                try {
                    if (osType != OSType.MACOSX) break block7;
                    macAttachOSHandler = new MacAttachOSHandler(host);
                    if (macAttachOSHandler != null) break block8;
                }
                catch (ExecutionException e) {
                    LOGGER.warn("Error while obtaining host operating system", (Throwable)e);
                }
                AttachOSHandler.$$$reportNull$$$0(5);
            }
            return macAttachOSHandler;
        }
        GenericAttachOSHandler genericAttachOSHandler = new GenericAttachOSHandler(host);
        if (genericAttachOSHandler == null) {
            AttachOSHandler.$$$reportNull$$$0(6);
        }
        return genericAttachOSHandler;
    }

    @NotNull
    private static OSType localComputeOsType() {
        if (SystemInfo.isLinux) {
            OSType oSType = OSType.LINUX;
            if (oSType == null) {
                AttachOSHandler.$$$reportNull$$$0(7);
            }
            return oSType;
        }
        if (SystemInfo.isMac) {
            OSType oSType = OSType.MACOSX;
            if (oSType == null) {
                AttachOSHandler.$$$reportNull$$$0(8);
            }
            return oSType;
        }
        OSType oSType = OSType.UNKNOWN;
        if (oSType == null) {
            AttachOSHandler.$$$reportNull$$$0(9);
        }
        return oSType;
    }

    @NotNull
    private static OSType computeOsType(@NotNull EnvironmentAwareHost host) throws ExecutionException {
        OSType osType;
        String osString;
        block16: {
            OSType oSType;
            if (host == null) {
                AttachOSHandler.$$$reportNull$$$0(10);
            }
            if (host instanceof LocalAttachHost) {
                OSType oSType2 = AttachOSHandler.localComputeOsType();
                if (oSType2 == null) {
                    AttachOSHandler.$$$reportNull$$$0(11);
                }
                return oSType2;
            }
            try {
                GeneralCommandLine getOsCommandLine = new GeneralCommandLine(new String[]{"uname", "-s"});
                osString = host.getProcessOutput(getOsCommandLine).getStdout().trim();
                if (!osString.startsWith("MSYS")) break block16;
                oSType = OSType.WINDOWS;
            }
            catch (ExecutionException ex) {
                throw new ExecutionException("Error while calculating the remote operating system", (Throwable)ex);
            }
            if (oSType == null) {
                AttachOSHandler.$$$reportNull$$$0(12);
            }
            return oSType;
        }
        switch (osString) {
            case "Linux": {
                osType = OSType.LINUX;
                break;
            }
            case "Darwin": {
                osType = OSType.MACOSX;
                break;
            }
            default: {
                osType = OSType.UNKNOWN;
            }
        }
        OSType oSType = osType;
        if (oSType == null) {
            AttachOSHandler.$$$reportNull$$$0(13);
        }
        return oSType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "osType";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/attach/osHandlers/AttachOSHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/attach/osHandlers/AttachOSHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOSType";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttachOsHandler";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "localComputeOsType";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "computeOsType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAttachOsHandler";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "computeOsType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum OSType {
        LINUX,
        MACOSX,
        WINDOWS,
        UNKNOWN;

    }
}

