/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.attach.fs;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xdebugger.attach.EnvironmentAwareHost;
import com.intellij.xdebugger.attach.fs.LazyAttachVirtualFile;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LazyAttachVirtualFS
extends VirtualFileSystem {
    private static final Logger LOG = Logger.getInstance(LazyAttachVirtualFS.class);
    @NonNls
    private static final String PROTOCOL = "lazyAttachVfs";
    private final Map<String, LazyAttachVirtualFile> myFileCache = new HashMap<String, LazyAttachVirtualFile>();

    public static LazyAttachVirtualFS getInstance() {
        return (LazyAttachVirtualFS)VirtualFileManager.getInstance().getFileSystem(PROTOCOL);
    }

    @NotNull
    public String getProtocol() {
        if (PROTOCOL == null) {
            LazyAttachVirtualFS.$$$reportNull$$$0(0);
        }
        return PROTOCOL;
    }

    @Nullable
    public VirtualFile findFileByPath(@NotNull String path, @NotNull EnvironmentAwareHost hostInfo) {
        if (path == null) {
            LazyAttachVirtualFS.$$$reportNull$$$0(1);
        }
        if (hostInfo == null) {
            LazyAttachVirtualFS.$$$reportNull$$$0(2);
        }
        String fullFilePath = hostInfo.getFileSystemHostId() + path;
        return (VirtualFile)this.myFileCache.computeIfAbsent(fullFilePath, s -> {
            String content;
            try {
                content = LazyAttachVirtualFS.getFileContent(hostInfo, path);
            }
            catch (IOException e) {
                LOG.warn("can't read file", (Throwable)e);
                return null;
            }
            if (content == null) {
                return null;
            }
            return new LazyAttachVirtualFile(fullFilePath, content);
        });
    }

    public VirtualFile findFileByPath(@NotNull String path) {
        if (path == null) {
            LazyAttachVirtualFS.$$$reportNull$$$0(3);
        }
        return (VirtualFile)this.myFileCache.get(path);
    }

    public void refresh(boolean asynchronous) {
        throw new IncorrectOperationException();
    }

    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        if (path == null) {
            LazyAttachVirtualFS.$$$reportNull$$$0(4);
        }
        return null;
    }

    public void addVirtualFileListener(@NotNull VirtualFileListener listener2) {
        if (listener2 == null) {
            LazyAttachVirtualFS.$$$reportNull$$$0(5);
        }
    }

    public void removeVirtualFileListener(@NotNull VirtualFileListener listener2) {
        if (listener2 == null) {
            LazyAttachVirtualFS.$$$reportNull$$$0(6);
        }
    }

    protected void deleteFile(Object requestor, @NotNull VirtualFile vFile) {
        if (vFile == null) {
            LazyAttachVirtualFS.$$$reportNull$$$0(7);
        }
        throw new IncorrectOperationException();
    }

    protected void moveFile(Object requestor, @NotNull VirtualFile vFile, @NotNull VirtualFile newParent) {
        if (vFile == null) {
            LazyAttachVirtualFS.$$$reportNull$$$0(8);
        }
        if (newParent == null) {
            LazyAttachVirtualFS.$$$reportNull$$$0(9);
        }
        throw new IncorrectOperationException();
    }

    protected void renameFile(Object requestor, @NotNull VirtualFile vFile, @NotNull String newName) {
        if (vFile == null) {
            LazyAttachVirtualFS.$$$reportNull$$$0(10);
        }
        if (newName == null) {
            LazyAttachVirtualFS.$$$reportNull$$$0(11);
        }
        throw new IncorrectOperationException();
    }

    @NotNull
    protected VirtualFile createChildFile(Object requestor, @NotNull VirtualFile vDir, @NotNull String fileName2) {
        if (vDir == null) {
            LazyAttachVirtualFS.$$$reportNull$$$0(12);
        }
        if (fileName2 == null) {
            LazyAttachVirtualFS.$$$reportNull$$$0(13);
        }
        throw new IncorrectOperationException();
    }

    @NotNull
    protected VirtualFile createChildDirectory(Object requestor, @NotNull VirtualFile vDir, @NotNull String dirName) {
        if (vDir == null) {
            LazyAttachVirtualFS.$$$reportNull$$$0(14);
        }
        if (dirName == null) {
            LazyAttachVirtualFS.$$$reportNull$$$0(15);
        }
        throw new IncorrectOperationException();
    }

    @NotNull
    protected VirtualFile copyFile(Object requestor, @NotNull VirtualFile virtualFile, @NotNull VirtualFile newParent, @NotNull String copyName) {
        if (virtualFile == null) {
            LazyAttachVirtualFS.$$$reportNull$$$0(16);
        }
        if (newParent == null) {
            LazyAttachVirtualFS.$$$reportNull$$$0(17);
        }
        if (copyName == null) {
            LazyAttachVirtualFS.$$$reportNull$$$0(18);
        }
        throw new IncorrectOperationException();
    }

    public boolean isReadOnly() {
        return true;
    }

    @Nullable
    private static String getFileContent(@NotNull EnvironmentAwareHost host, @NotNull String path) throws IOException {
        InputStream stream;
        if (host == null) {
            LazyAttachVirtualFS.$$$reportNull$$$0(19);
        }
        if (path == null) {
            LazyAttachVirtualFS.$$$reportNull$$$0(20);
        }
        if ((stream = host.getFileContent(path)) == null) {
            return null;
        }
        return new String(FileUtil.loadBytes((InputStream)stream), StandardCharsets.UTF_8);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/attach/fs/LazyAttachVirtualFS";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostInfo";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 7: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vFile";
                break;
            }
            case 9: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParent";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vDir";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirName";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyName";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getProtocol";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/attach/fs/LazyAttachVirtualFS";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findFileByPath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "refreshAndFindFileByPath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addVirtualFileListener";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeVirtualFileListener";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "deleteFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "moveFile";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "renameFile";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createChildFile";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createChildDirectory";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "copyFile";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getFileContent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

