/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.visible.filters;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsLogUserFilter;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.util.VcsUserUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class VcsLogUserFilterImpl
implements VcsLogUserFilter {
    private static final Logger LOG = Logger.getInstance(VcsLogUserFilterImpl.class);
    @NotNull
    public static final String ME = "me";
    @NotNull
    private final Collection<String> myUsers;
    @NotNull
    private final Map<VirtualFile, VcsUser> myData;
    @NotNull
    private final MultiMap<String, VcsUser> myAllUsersByNames;
    @NotNull
    private final MultiMap<String, VcsUser> myAllUsersByEmails;

    VcsLogUserFilterImpl(@NotNull Collection<String> users, @NotNull Map<VirtualFile, VcsUser> meData, @NotNull Set<? extends VcsUser> allUsers) {
        if (users == null) {
            VcsLogUserFilterImpl.$$$reportNull$$$0(0);
        }
        if (meData == null) {
            VcsLogUserFilterImpl.$$$reportNull$$$0(1);
        }
        if (allUsers == null) {
            VcsLogUserFilterImpl.$$$reportNull$$$0(2);
        }
        this.myAllUsersByNames = MultiMap.create();
        this.myAllUsersByEmails = MultiMap.create();
        this.myUsers = users;
        this.myData = meData;
        for (VcsUser vcsUser : allUsers) {
            String email;
            String nameFromEmail;
            String name = vcsUser.getName();
            if (!name.isEmpty()) {
                this.myAllUsersByNames.putValue((Object)VcsUserUtil.getNameInStandardForm(name), (Object)vcsUser);
            }
            if ((nameFromEmail = VcsUserUtil.getNameFromEmail(email = vcsUser.getEmail())) == null) continue;
            this.myAllUsersByEmails.putValue((Object)VcsUserUtil.getNameInStandardForm(nameFromEmail), (Object)vcsUser);
        }
    }

    @NotNull
    public Collection<VcsUser> getUsers(@NotNull VirtualFile root) {
        if (root == null) {
            VcsLogUserFilterImpl.$$$reportNull$$$0(3);
        }
        HashSet result2 = ContainerUtil.newHashSet();
        for (String user : this.myUsers) {
            result2.addAll(this.getUsers(root, user));
        }
        HashSet hashSet = result2;
        if (hashSet == null) {
            VcsLogUserFilterImpl.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    @NotNull
    private Set<VcsUser> getUsers(@NotNull VirtualFile root, @NotNull String name) {
        if (root == null) {
            VcsLogUserFilterImpl.$$$reportNull$$$0(5);
        }
        if (name == null) {
            VcsLogUserFilterImpl.$$$reportNull$$$0(6);
        }
        HashSet users = ContainerUtil.newHashSet();
        if (ME.equals(name)) {
            VcsUser vcsUser = this.myData.get(root);
            if (vcsUser != null) {
                users.addAll(this.getUsers(vcsUser.getName()));
                String emailNamePart = VcsUserUtil.getNameFromEmail(vcsUser.getEmail());
                if (emailNamePart != null) {
                    users.addAll(this.getUsers(emailNamePart));
                }
            } else {
                LOG.warn("Can not resolve user name for root " + root);
            }
        } else {
            users.addAll(this.getUsers(name));
        }
        HashSet hashSet = users;
        if (hashSet == null) {
            VcsLogUserFilterImpl.$$$reportNull$$$0(7);
        }
        return hashSet;
    }

    @NotNull
    public Collection<String> getUserNamesForPresentation() {
        Collection<String> collection = this.myUsers;
        if (collection == null) {
            VcsLogUserFilterImpl.$$$reportNull$$$0(8);
        }
        return collection;
    }

    public boolean matches(@NotNull VcsCommitMetadata commit2) {
        if (commit2 == null) {
            VcsLogUserFilterImpl.$$$reportNull$$$0(9);
        }
        return ContainerUtil.exists(this.myUsers, name -> {
            Set<VcsUser> users = this.getUsers(commit2.getRoot(), (String)name);
            if (!users.isEmpty()) {
                return users.contains(commit2.getAuthor());
            }
            if (!name.equals(ME)) {
                boolean result2;
                String lowerUser = VcsUserUtil.nameToLowerCase(name);
                boolean bl = result2 = VcsUserUtil.nameToLowerCase(commit2.getAuthor().getName()).equals(lowerUser) || VcsUserUtil.emailToLowerCase(commit2.getAuthor().getEmail()).startsWith(lowerUser + "@");
                if (result2) {
                    LOG.warn("Unregistered author " + commit2.getAuthor() + " for commit " + ((Hash)commit2.getId()).asString() + "; search pattern " + name);
                }
                return result2;
            }
            return false;
        });
    }

    private Set<VcsUser> getUsers(@NotNull String name) {
        if (name == null) {
            VcsLogUserFilterImpl.$$$reportNull$$$0(10);
        }
        HashSet result2 = ContainerUtil.newHashSet();
        result2.addAll(this.myAllUsersByNames.get((Object)VcsUserUtil.getNameInStandardForm(name)));
        result2.addAll(this.myAllUsersByEmails.get((Object)VcsUserUtil.getNameInStandardForm(name)));
        return result2;
    }

    @NotNull
    public String getPresentation() {
        String string = StringUtil.join(this.getUserNamesForPresentation(), (String)", ");
        if (string == null) {
            VcsLogUserFilterImpl.$$$reportNull$$$0(11);
        }
        return string;
    }

    public String toString() {
        return "author: " + StringUtil.join(this.myUsers, (String)", ");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "users";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "meData";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allUsers";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/visible/filters/VcsLogUserFilterImpl";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commit";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/visible/filters/VcsLogUserFilterImpl";
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsers";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserNamesForPresentation";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getUsers";
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 11: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

