/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.table;

import com.intellij.ide.IdeTooltip;
import com.intellij.ide.IdeTooltipManager;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.vcs.changes.issueLinks.TableLinkMouseListener;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.data.LoadingDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.EdgePrintElement;
import com.intellij.vcs.log.graph.NodePrintElement;
import com.intellij.vcs.log.graph.PrintElement;
import com.intellij.vcs.log.graph.actions.GraphAction;
import com.intellij.vcs.log.graph.actions.GraphAnswer;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.paint.GraphCellPainter;
import com.intellij.vcs.log.paint.PositionUtil;
import com.intellij.vcs.log.statistics.VcsLogUsageTriggerCollector;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.frame.CommitPresentationUtil;
import com.intellij.vcs.log.ui.render.GraphCommitCellRenderer;
import com.intellij.vcs.log.ui.render.SimpleColoredComponentLinkMouseListener;
import com.intellij.vcs.log.ui.table.Selection;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.table.TableColumn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphTableController {
    @NotNull
    private final VcsLogGraphTable myTable;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final VcsLogUiProperties myProperties;
    @NotNull
    private final VcsLogColorManager myColorManager;
    @NotNull
    private final GraphCellPainter myGraphCellPainter;
    @NotNull
    private final GraphCommitCellRenderer myCommitRenderer;

    public GraphTableController(@NotNull VcsLogData logData, @NotNull VcsLogColorManager colorManager, @NotNull VcsLogUiProperties properties, @NotNull VcsLogGraphTable table, @NotNull GraphCellPainter graphCellPainter, @NotNull GraphCommitCellRenderer commitRenderer) {
        if (logData == null) {
            GraphTableController.$$$reportNull$$$0(0);
        }
        if (colorManager == null) {
            GraphTableController.$$$reportNull$$$0(1);
        }
        if (properties == null) {
            GraphTableController.$$$reportNull$$$0(2);
        }
        if (table == null) {
            GraphTableController.$$$reportNull$$$0(3);
        }
        if (graphCellPainter == null) {
            GraphTableController.$$$reportNull$$$0(4);
        }
        if (commitRenderer == null) {
            GraphTableController.$$$reportNull$$$0(5);
        }
        this.myTable = table;
        this.myLogData = logData;
        this.myProperties = properties;
        this.myColorManager = colorManager;
        this.myGraphCellPainter = graphCellPainter;
        this.myCommitRenderer = commitRenderer;
        MyMouseAdapter mouseAdapter = new MyMouseAdapter();
        table.addMouseMotionListener(mouseAdapter);
        table.addMouseListener(mouseAdapter);
    }

    @Nullable
    PrintElement findPrintElement(@NotNull MouseEvent e) {
        int row2;
        if (e == null) {
            GraphTableController.$$$reportNull$$$0(6);
        }
        if ((row2 = this.myTable.rowAtPoint(e.getPoint())) >= 0 && row2 < this.myTable.getRowCount()) {
            return this.findPrintElement(row2, e);
        }
        return null;
    }

    @Nullable
    private PrintElement findPrintElement(int row2, @NotNull MouseEvent e) {
        if (e == null) {
            GraphTableController.$$$reportNull$$$0(7);
        }
        Point point = this.calcPoint4Graph(e.getPoint());
        Collection printElements = this.myTable.getVisibleGraph().getRowInfo(row2).getPrintElements();
        return this.myGraphCellPainter.getElementUnderCursor(printElements, point.x, point.y);
    }

    private void performGraphAction(@Nullable PrintElement printElement, @NotNull MouseEvent e, @NotNull GraphAction.Type actionType) {
        boolean isClickOnGraphElement;
        if (e == null) {
            GraphTableController.$$$reportNull$$$0(8);
        }
        if (actionType == null) {
            GraphTableController.$$$reportNull$$$0(9);
        }
        boolean bl = isClickOnGraphElement = actionType == GraphAction.Type.MOUSE_CLICK && printElement != null;
        if (isClickOnGraphElement) {
            GraphTableController.triggerElementClick(printElement);
        }
        Selection previousSelection = this.myTable.getSelection();
        GraphAnswer answer = this.myTable.getVisibleGraph().getActionController().performAction((GraphAction)new GraphAction.GraphActionImpl(printElement, actionType));
        this.handleGraphAnswer((GraphAnswer<Integer>)answer, isClickOnGraphElement, previousSelection, e);
    }

    public void handleGraphAnswer(@Nullable GraphAnswer<Integer> answer, boolean dataCouldChange, @Nullable Selection previousSelection, @Nullable MouseEvent e) {
        if (dataCouldChange) {
            this.myTable.getModel().fireTableDataChanged();
            if (previousSelection != null) {
                previousSelection.restore(this.myTable.getVisibleGraph(), answer == null || answer.getCommitToJump() != null && answer.doJump(), false);
            }
        }
        this.myTable.repaint();
        if (answer == null) {
            return;
        }
        if (answer.getCursorToSet() != null) {
            this.myTable.setCursor(answer.getCursorToSet());
        }
        if (answer.getCommitToJump() != null) {
            Integer row2 = this.myTable.getModel().getVisiblePack().getVisibleGraph().getVisibleRowIndex(answer.getCommitToJump());
            if (row2 != null && row2 >= 0 && answer.doJump()) {
                this.myTable.jumpToRow(row2);
                return;
            }
            if (e != null) {
                this.showToolTip(this.getArrowTooltipText((Integer)answer.getCommitToJump(), row2), e);
            }
        }
    }

    @NotNull
    private Point calcPoint4Graph(@NotNull Point clickPoint) {
        TableColumn column;
        if (clickPoint == null) {
            GraphTableController.$$$reportNull$$$0(10);
        }
        int width = 0;
        for (int i = 0; i < this.myTable.getColumnModel().getColumnCount() && (column = this.myTable.getColumnModel().getColumn(i)).getModelIndex() != 1; ++i) {
            width += column.getWidth();
        }
        Point point = new Point(clickPoint.x - width, PositionUtil.getYInsideRow(clickPoint, this.myTable.getRowHeight()));
        if (point == null) {
            GraphTableController.$$$reportNull$$$0(11);
        }
        return point;
    }

    @NotNull
    private String getArrowTooltipText(int commit2, @Nullable Integer row2) {
        Object details = row2 != null && row2 >= 0 ? this.myTable.getModel().getCommitMetadata(row2) : this.myLogData.getMiniDetailsGetter().getCommitData(commit2, Collections.singleton(commit2));
        String balloonText = "";
        if (details instanceof LoadingDetails) {
            CommitId commitId = this.myLogData.getCommitId(commit2);
            if (commitId != null) {
                balloonText = "Jump to commit " + commitId.getHash().toShortString();
                if (this.myColorManager.isMultipleRoots()) {
                    balloonText = balloonText + " in " + commitId.getRoot().getName();
                }
            }
        } else {
            balloonText = "Jump to " + CommitPresentationUtil.getShortSummary(details);
        }
        String string = balloonText;
        if (string == null) {
            GraphTableController.$$$reportNull$$$0(12);
        }
        return string;
    }

    private void showToolTip(@NotNull String text, @NotNull MouseEvent e) {
        if (text == null) {
            GraphTableController.$$$reportNull$$$0(13);
        }
        if (e == null) {
            GraphTableController.$$$reportNull$$$0(14);
        }
        VcsLogUiUtil.showTooltip((JComponent)((Object)this.myTable), new Point(e.getX() + 5, e.getY()), Balloon.Position.atRight, text);
    }

    private void showOrHideCommitTooltip(int row2, int column, @NotNull MouseEvent e) {
        if (e == null) {
            GraphTableController.$$$reportNull$$$0(15);
        }
        if (!this.showTooltip(row2, column, e.getPoint(), false) && IdeTooltipManager.getInstance().hasCurrent()) {
            IdeTooltipManager.getInstance().hideCurrent(e);
        }
    }

    private boolean showTooltip(int row2, int column, @NotNull Point point, boolean now) {
        JComponent tipComponent;
        if (point == null) {
            GraphTableController.$$$reportNull$$$0(16);
        }
        if ((tipComponent = this.myCommitRenderer.getTooltip(this.myTable.getValueAt(row2, this.myTable.convertColumnIndexToView(column)), this.calcPoint4Graph(point), row2)) != null) {
            this.myTable.getExpandableItemsHandler().setEnabled(false);
            IdeTooltip tooltip = new IdeTooltip((Component)((Object)this.myTable), point, (JComponent)new Wrapper(tipComponent), new Object[0]).setPreferredPosition(Balloon.Position.below);
            IdeTooltipManager.getInstance().show(tooltip, now);
            return true;
        }
        return false;
    }

    public void showTooltip(int row2) {
        Point point = new Point(this.getColumnLeftXCoordinate(this.myTable.convertColumnIndexToView(1)) + this.myCommitRenderer.getTooltipXCoordinate(row2), row2 * this.myTable.getRowHeight() + this.myTable.getRowHeight() / 2);
        this.showTooltip(row2, 1, point, true);
    }

    private void performRootColumnAction() {
        if (this.myColorManager.isMultipleRoots() && this.myProperties.exists(CommonUiProperties.SHOW_ROOT_NAMES)) {
            VcsLogUsageTriggerCollector.triggerUsage("RootColumnClick");
            this.myProperties.set(CommonUiProperties.SHOW_ROOT_NAMES, this.myProperties.get(CommonUiProperties.SHOW_ROOT_NAMES) == false);
        }
    }

    private static void triggerElementClick(@NotNull PrintElement printElement) {
        if (printElement == null) {
            GraphTableController.$$$reportNull$$$0(17);
        }
        if (printElement instanceof NodePrintElement) {
            VcsLogUsageTriggerCollector.triggerUsage("GraphNodeClick");
        } else if (printElement instanceof EdgePrintElement && ((EdgePrintElement)printElement).hasArrow()) {
            VcsLogUsageTriggerCollector.triggerUsage("GraphArrowClick");
        }
    }

    protected int getColumnLeftXCoordinate(int viewColumnIndex) {
        int x = 0;
        for (int i = 0; i < viewColumnIndex; ++i) {
            x += this.myTable.getColumnModel().getColumn(i).getWidth();
        }
        return x;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphCellPainter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitRenderer";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clickPoint";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/table/GraphTableController";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/table/GraphTableController";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "calcPoint4Graph";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrowTooltipText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findPrintElement";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "performGraphAction";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "calcPoint4Graph";
                break;
            }
            case 11: 
            case 12: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "showToolTip";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "showOrHideCommitTooltip";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "showTooltip";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "triggerElementClick";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyMouseAdapter
    extends MouseAdapter {
        private static final int BORDER_THICKNESS = 3;
        @NotNull
        private final TableLinkMouseListener myLinkListener = new MyLinkMouseListener();
        @Nullable
        private Cursor myLastCursor = null;

        private MyMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int row2;
            if (this.myLinkListener.onClick(e, e.getClickCount())) {
                return;
            }
            int c = GraphTableController.this.myTable.columnAtPoint(e.getPoint());
            int column = GraphTableController.this.myTable.convertColumnIndexToModel(c);
            if (e.getClickCount() == 2) {
                boolean useLeftBorder;
                int commitColumnIndex = GraphTableController.this.myTable.convertColumnIndexToView(1);
                boolean bl = useLeftBorder = c > commitColumnIndex;
                if ((useLeftBorder ? this.isOnLeftBorder(e, c) : this.isOnRightBorder(e, c)) && (column == 2 || column == 3)) {
                    GraphTableController.this.myTable.resetColumnWidth(column);
                } else {
                    int c2 = GraphTableController.this.myTable.columnAtPoint(new Point(e.getPoint().x + (useLeftBorder ? 1 : -1) * JBUI.scale((int)3), e.getPoint().y));
                    int column2 = GraphTableController.this.myTable.convertColumnIndexToModel(c2);
                    if ((useLeftBorder ? this.isOnLeftBorder(e, c2) : this.isOnRightBorder(e, c2)) && (column2 == 2 || column2 == 3)) {
                        GraphTableController.this.myTable.resetColumnWidth(column2);
                    }
                }
            }
            if ((row2 = GraphTableController.this.myTable.rowAtPoint(e.getPoint())) >= 0 && row2 < GraphTableController.this.myTable.getRowCount() && e.getClickCount() == 1) {
                PrintElement printElement;
                if (column == 0) {
                    GraphTableController.this.performRootColumnAction();
                } else if (column == 1 && (printElement = GraphTableController.this.findPrintElement(row2, e)) != null) {
                    GraphTableController.this.performGraphAction(printElement, e, GraphAction.Type.MOUSE_CLICK);
                }
            }
        }

        public boolean isOnLeftBorder(@NotNull MouseEvent e, int column) {
            if (e == null) {
                MyMouseAdapter.$$$reportNull$$$0(0);
            }
            return Math.abs(GraphTableController.this.getColumnLeftXCoordinate(column) - e.getPoint().x) <= JBUI.scale((int)3);
        }

        public boolean isOnRightBorder(@NotNull MouseEvent e, int column) {
            if (e == null) {
                MyMouseAdapter.$$$reportNull$$$0(1);
            }
            return Math.abs(GraphTableController.this.getColumnLeftXCoordinate(column) + GraphTableController.this.myTable.getColumnModel().getColumn(column).getWidth() - e.getPoint().x) <= JBUI.scale((int)3);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (GraphTableController.this.myTable.isResizingColumns()) {
                return;
            }
            GraphTableController.this.myTable.getExpandableItemsHandler().setEnabled(true);
            if (this.myLinkListener.getTagAt(e) != null) {
                this.swapCursor(12);
                return;
            }
            int row2 = GraphTableController.this.myTable.rowAtPoint(e.getPoint());
            if (row2 >= 0 && row2 < GraphTableController.this.myTable.getRowCount()) {
                int column = GraphTableController.this.myTable.convertColumnIndexToModel(GraphTableController.this.myTable.columnAtPoint(e.getPoint()));
                if (column == 0) {
                    this.swapCursor(12);
                    return;
                }
                if (column == 1) {
                    PrintElement printElement = GraphTableController.this.findPrintElement(row2, e);
                    if (printElement == null) {
                        this.restoreCursor(12);
                    }
                    GraphTableController.this.performGraphAction(printElement, e, GraphAction.Type.MOUSE_OVER);
                    if (printElement == null) {
                        GraphTableController.this.showOrHideCommitTooltip(row2, column, e);
                    }
                    return;
                }
            }
            this.restoreCursor(12);
        }

        private void swapCursor(int newCursorType) {
            if (GraphTableController.this.myTable.getCursor().getType() != newCursorType && this.myLastCursor == null) {
                Cursor newCursor = Cursor.getPredefinedCursor(newCursorType);
                this.myLastCursor = GraphTableController.this.myTable.getCursor();
                GraphTableController.this.myTable.setCursor(newCursor);
            }
        }

        private void restoreCursor(int newCursorType) {
            if (this.myLastCursor != null && GraphTableController.this.myTable.getCursor().getType() == newCursorType) {
                GraphTableController.this.myTable.setCursor(this.myLastCursor);
                this.myLastCursor = null;
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
            GraphTableController.this.myTable.getExpandableItemsHandler().setEnabled(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/vcs/log/ui/table/GraphTableController$MyMouseAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isOnLeftBorder";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isOnRightBorder";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private class MyLinkMouseListener
        extends SimpleColoredComponentLinkMouseListener {
            private MyLinkMouseListener() {
            }

            @Override
            @Nullable
            public Object getTagAt(@NotNull MouseEvent e) {
                if (e == null) {
                    MyLinkMouseListener.$$$reportNull$$$0(0);
                }
                return ObjectUtils.tryCast((Object)super.getTagAt(e), SimpleColoredComponent.BrowserLauncherTag.class);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/vcs/log/ui/table/GraphTableController$MyMouseAdapter$MyLinkMouseListener", "getTagAt"));
            }
        }
    }
}

