/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.render;

import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.ui.CurrentBranchComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.RefGroup;
import com.intellij.vcs.log.VcsLogRefManager;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.ui.render.GraphCommitCellRenderer;
import com.intellij.vcs.log.ui.render.LabelIcon;
import com.intellij.vcs.log.ui.render.LabelIconCache;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LabelPainter {
    private static final JBValue.JBValueGroup JBVG = new JBValue.JBValueGroup();
    public static final JBValue TOP_TEXT_PADDING = JBVG.value(1.0f);
    public static final JBValue BOTTOM_TEXT_PADDING = JBVG.value(2.0f);
    public static final JBValue RIGHT_PADDING = JBVG.value(4.0f);
    public static final JBValue LEFT_PADDING = JBVG.value(4.0f);
    public static final JBValue COMPACT_MIDDLE_PADDING = JBVG.value(2.0f);
    public static final JBValue MIDDLE_PADDING = JBVG.value(12.0f);
    public static final JBValue LABEL_ARC = JBVG.value(6.0f);
    private static final int MAX_LENGTH = 22;
    private static final String THREE_DOTS = "...";
    private static final String TWO_DOTS = "..";
    private static final String SEPARATOR = "/";
    private static final JBColor TEXT_COLOR = CurrentBranchComponent.TEXT_COLOR;
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final JComponent myComponent;
    @NotNull
    private final LabelIconCache myIconCache;
    @NotNull
    private List<Pair<String, LabelIcon>> myLabels;
    private int myHeight;
    private int myWidth;
    @NotNull
    private Color myBackground;
    @Nullable
    private Color myGreyBackground;
    @NotNull
    private Color myForeground;
    private boolean myCompact;
    private boolean myShowTagNames;

    public LabelPainter(@NotNull VcsLogData data, @NotNull JComponent component, @NotNull LabelIconCache iconCache, boolean compact, boolean showTagNames) {
        if (data == null) {
            LabelPainter.$$$reportNull$$$0(0);
        }
        if (component == null) {
            LabelPainter.$$$reportNull$$$0(1);
        }
        if (iconCache == null) {
            LabelPainter.$$$reportNull$$$0(2);
        }
        this.myLabels = ContainerUtil.newArrayList();
        this.myHeight = JBUI.scale((int)22);
        this.myWidth = 0;
        this.myBackground = UIUtil.getTableBackground();
        this.myGreyBackground = null;
        this.myForeground = UIUtil.getTableForeground();
        this.myLogData = data;
        this.myComponent = component;
        this.myIconCache = iconCache;
        this.myCompact = compact;
        this.myShowTagNames = showTagNames;
    }

    @Nullable
    public static VcsLogRefManager getRefManager(@NotNull VcsLogData logData, @NotNull Collection<? extends VcsRef> references) {
        if (logData == null) {
            LabelPainter.$$$reportNull$$$0(3);
        }
        if (references == null) {
            LabelPainter.$$$reportNull$$$0(4);
        }
        if (!references.isEmpty()) {
            VirtualFile root = ((VcsRef)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem(references))).getRoot();
            return logData.getLogProvider(root).getReferenceManager();
        }
        return null;
    }

    public void customizePainter(@NotNull Collection<? extends VcsRef> references, @NotNull Color background, @NotNull Color foreground, boolean isSelected, int availableWidth) {
        if (references == null) {
            LabelPainter.$$$reportNull$$$0(5);
        }
        if (background == null) {
            LabelPainter.$$$reportNull$$$0(6);
        }
        if (foreground == null) {
            LabelPainter.$$$reportNull$$$0(7);
        }
        this.myBackground = background;
        this.myForeground = isSelected ? foreground : TEXT_COLOR;
        FontMetrics metrics = this.myComponent.getFontMetrics(LabelPainter.getReferenceFont());
        this.myHeight = metrics.getHeight() + TOP_TEXT_PADDING.get() + BOTTOM_TEXT_PADDING.get();
        VcsLogRefManager manager = LabelPainter.getRefManager(this.myLogData, references);
        List refGroups = manager == null ? ContainerUtil.emptyList() : manager.groupForTable(references, this.myCompact, this.myShowTagNames);
        this.myGreyBackground = LabelPainter.calculateGreyBackground(refGroups, background, isSelected, this.myCompact);
        Pair<List<Pair<String, LabelIcon>>, Integer> presentation = this.calculatePresentation(refGroups, metrics, this.myGreyBackground != null ? this.myGreyBackground : this.myBackground, availableWidth, this.myCompact);
        this.myLabels = (List)presentation.first;
        this.myWidth = (Integer)presentation.second;
    }

    @NotNull
    private Pair<List<Pair<String, LabelIcon>>, Integer> calculatePresentation(@NotNull List<? extends RefGroup> refGroups, @NotNull FontMetrics fontMetrics, @NotNull Color background, int availableWidth, boolean compact) {
        if (refGroups == null) {
            LabelPainter.$$$reportNull$$$0(8);
        }
        if (fontMetrics == null) {
            LabelPainter.$$$reportNull$$$0(9);
        }
        if (background == null) {
            LabelPainter.$$$reportNull$$$0(10);
        }
        int width = LEFT_PADDING.get() + RIGHT_PADDING.get();
        ArrayList labels = ContainerUtil.newArrayList();
        if (refGroups.isEmpty()) {
            Pair pair = Pair.create((Object)labels, (Object)width);
            if (pair == null) {
                LabelPainter.$$$reportNull$$$0(11);
            }
            return pair;
        }
        if (compact) {
            Pair<List<Pair<String, LabelIcon>>, Integer> pair = this.calculateCompactPresentation(refGroups, fontMetrics, background, availableWidth);
            if (pair == null) {
                LabelPainter.$$$reportNull$$$0(12);
            }
            return pair;
        }
        Pair<List<Pair<String, LabelIcon>>, Integer> pair = this.calculateLongPresentation(refGroups, fontMetrics, background, availableWidth);
        if (pair == null) {
            LabelPainter.$$$reportNull$$$0(13);
        }
        return pair;
    }

    @NotNull
    private Pair<List<Pair<String, LabelIcon>>, Integer> calculateCompactPresentation(@NotNull List<? extends RefGroup> refGroups, @NotNull FontMetrics fontMetrics, @NotNull Color background, int availableWidth) {
        if (refGroups == null) {
            LabelPainter.$$$reportNull$$$0(14);
        }
        if (fontMetrics == null) {
            LabelPainter.$$$reportNull$$$0(15);
        }
        if (background == null) {
            LabelPainter.$$$reportNull$$$0(16);
        }
        int width = LEFT_PADDING.get() + RIGHT_PADDING.get();
        ArrayList labels = ContainerUtil.newArrayList();
        if (refGroups.isEmpty()) {
            Pair pair = Pair.create((Object)labels, (Object)width);
            if (pair == null) {
                LabelPainter.$$$reportNull$$$0(17);
            }
            return pair;
        }
        for (RefGroup refGroup : refGroups) {
            List colors = refGroup.getColors();
            LabelIcon labelIcon = this.getIcon(fontMetrics.getHeight(), background, colors);
            int newWidth = width + labelIcon.getIconWidth() + (refGroup != ContainerUtil.getLastItem(refGroups) ? COMPACT_MIDDLE_PADDING.get() : 0);
            String text = LabelPainter.shortenRefName(refGroup.getName(), fontMetrics, availableWidth - newWidth);
            labels.add(Pair.create((Object)text, (Object)labelIcon));
            width = newWidth += fontMetrics.stringWidth(text);
        }
        Pair pair = Pair.create((Object)labels, (Object)width);
        if (pair == null) {
            LabelPainter.$$$reportNull$$$0(18);
        }
        return pair;
    }

    @NotNull
    private Pair<List<Pair<String, LabelIcon>>, Integer> calculateLongPresentation(@NotNull List<? extends RefGroup> refGroups, @NotNull FontMetrics fontMetrics, @NotNull Color background, int availableWidth) {
        if (refGroups == null) {
            LabelPainter.$$$reportNull$$$0(19);
        }
        if (fontMetrics == null) {
            LabelPainter.$$$reportNull$$$0(20);
        }
        if (background == null) {
            LabelPainter.$$$reportNull$$$0(21);
        }
        int width = LEFT_PADDING.get() + RIGHT_PADDING.get();
        ArrayList labels = ContainerUtil.newArrayList();
        if (refGroups.isEmpty()) {
            Pair pair = Pair.create((Object)labels, (Object)width);
            if (pair == null) {
                LabelPainter.$$$reportNull$$$0(22);
            }
            return pair;
        }
        int height = fontMetrics.getHeight();
        for (int i = 0; i < refGroups.size(); ++i) {
            String text;
            RefGroup group = refGroups.get(i);
            int doNotFitWidth = 0;
            if (i < refGroups.size() - 1) {
                LabelIcon lastIcon = this.getIcon(height, background, LabelPainter.getColors(refGroups.subList(i + 1, refGroups.size())));
                doNotFitWidth = lastIcon.getIconWidth();
            }
            List colors = group.getColors();
            LabelIcon labelIcon = this.getIcon(height, background, colors);
            int newWidth = width + labelIcon.getIconWidth() + (i != refGroups.size() - 1 ? MIDDLE_PADDING.get() : 0);
            if (availableWidth - (newWidth += fontMetrics.stringWidth(text = LabelPainter.getGroupText(group, fontMetrics, availableWidth - newWidth - doNotFitWidth))) - doNotFitWidth < 0) {
                LabelIcon lastIcon = this.getIcon(height, background, LabelPainter.getColors(refGroups.subList(i, refGroups.size())));
                String name = labels.isEmpty() ? text : "";
                labels.add(Pair.create((Object)name, (Object)lastIcon));
                width += fontMetrics.stringWidth(name) + lastIcon.getIconWidth();
                break;
            }
            labels.add(Pair.create((Object)text, (Object)labelIcon));
            width = newWidth;
        }
        Pair pair = Pair.create((Object)labels, (Object)width);
        if (pair == null) {
            LabelPainter.$$$reportNull$$$0(23);
        }
        return pair;
    }

    @NotNull
    private LabelIcon getIcon(int height, @NotNull Color background, @NotNull List<? extends Color> colors) {
        if (background == null) {
            LabelPainter.$$$reportNull$$$0(24);
        }
        if (colors == null) {
            LabelPainter.$$$reportNull$$$0(25);
        }
        LabelIcon labelIcon = this.myIconCache.getIcon(this.myComponent, height, background, colors);
        if (labelIcon == null) {
            LabelPainter.$$$reportNull$$$0(26);
        }
        return labelIcon;
    }

    @NotNull
    private static List<Color> getColors(@NotNull Collection<? extends RefGroup> groups) {
        if (groups == null) {
            LabelPainter.$$$reportNull$$$0(27);
        }
        LinkedHashMap usedColors = ContainerUtil.newLinkedHashMap();
        for (RefGroup refGroup : groups) {
            List colors = refGroup.getColors();
            for (Color color : colors) {
                Integer count = (Integer)usedColors.get(color);
                if (count == null) {
                    count = 0;
                }
                usedColors.put(color, count + 1);
            }
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        for (Map.Entry entry : usedColors.entrySet()) {
            result2.add(entry.getKey());
            if ((Integer)entry.getValue() <= 1) continue;
            result2.add(entry.getKey());
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            LabelPainter.$$$reportNull$$$0(28);
        }
        return arrayList;
    }

    @NotNull
    private static String getGroupText(@NotNull RefGroup group, @NotNull FontMetrics fontMetrics, int availableWidth) {
        if (group == null) {
            LabelPainter.$$$reportNull$$$0(29);
        }
        if (fontMetrics == null) {
            LabelPainter.$$$reportNull$$$0(30);
        }
        if (!group.isExpanded()) {
            String string = LabelPainter.shortenRefName(group.getName(), fontMetrics, availableWidth);
            if (string == null) {
                LabelPainter.$$$reportNull$$$0(31);
            }
            return string;
        }
        StringBuilder text = new StringBuilder();
        String remainder = ", ...";
        String separator = ", ";
        int remainderWidth = fontMetrics.stringWidth(remainder);
        int separatorWidth = fontMetrics.stringWidth(separator);
        for (int i = 0; i < group.getRefs().size(); ++i) {
            String refName;
            int refNameWidth;
            boolean firstRef;
            boolean lastRef = i == group.getRefs().size() - 1;
            int width = availableWidth - (lastRef ? 0 : remainderWidth) - ((firstRef = i == 0) ? 0 : separatorWidth);
            if (width - (refNameWidth = fontMetrics.stringWidth(refName = LabelPainter.shortenRefName(((VcsRef)group.getRefs().get(i)).getName(), fontMetrics, width))) < 0 && !firstRef) {
                text.append(remainder);
                break;
            }
            text.append(firstRef ? "" : separator).append(refName);
            availableWidth -= (firstRef ? 0 : separatorWidth) + refNameWidth;
        }
        String string = text.toString();
        if (string == null) {
            LabelPainter.$$$reportNull$$$0(32);
        }
        return string;
    }

    @Nullable
    private static Color calculateGreyBackground(@NotNull List<? extends RefGroup> refGroups, @NotNull Color background, boolean isSelected, boolean isCompact) {
        if (refGroups == null) {
            LabelPainter.$$$reportNull$$$0(33);
        }
        if (background == null) {
            LabelPainter.$$$reportNull$$$0(34);
        }
        if (isSelected) {
            return null;
        }
        if (!isCompact) {
            return CurrentBranchComponent.getBranchPresentationBackground(background);
        }
        for (RefGroup refGroup : refGroups) {
            boolean paintGreyBackground;
            if (refGroup.isExpanded()) {
                paintGreyBackground = ContainerUtil.find((Iterable)refGroup.getRefs(), ref -> !ref.getName().isEmpty()) != null;
            } else {
                boolean bl = paintGreyBackground = !refGroup.getName().isEmpty();
            }
            if (!paintGreyBackground) continue;
            return CurrentBranchComponent.getBranchPresentationBackground(background);
        }
        return null;
    }

    @NotNull
    private static String shortenRefName(@NotNull String refName, @NotNull FontMetrics fontMetrics, int availableWidth) {
        if (refName == null) {
            LabelPainter.$$$reportNull$$$0(35);
        }
        if (fontMetrics == null) {
            LabelPainter.$$$reportNull$$$0(36);
        }
        if (fontMetrics.stringWidth(refName) > availableWidth && refName.length() > 22) {
            int separatorIndex = refName.indexOf(SEPARATOR);
            if (separatorIndex > TWO_DOTS.length()) {
                refName = TWO_DOTS + refName.substring(separatorIndex);
            }
            if (fontMetrics.stringWidth(refName) <= availableWidth) {
                String string = refName;
                if (string == null) {
                    LabelPainter.$$$reportNull$$$0(37);
                }
                return string;
            }
            if (availableWidth > 0) {
                for (int i = refName.length(); i > 22; --i) {
                    String result2 = StringUtil.shortenTextWithEllipsis((String)refName, (int)i, (int)0, (String)THREE_DOTS);
                    if (fontMetrics.stringWidth(result2) > availableWidth) continue;
                    String string = result2;
                    if (string == null) {
                        LabelPainter.$$$reportNull$$$0(38);
                    }
                    return string;
                }
            }
            String string = StringUtil.shortenTextWithEllipsis((String)refName, (int)22, (int)0, (String)THREE_DOTS);
            if (string == null) {
                LabelPainter.$$$reportNull$$$0(39);
            }
            return string;
        }
        String string = refName;
        if (string == null) {
            LabelPainter.$$$reportNull$$$0(40);
        }
        return string;
    }

    public void paint(@NotNull Graphics2D g2, int x, int y, int height) {
        if (g2 == null) {
            LabelPainter.$$$reportNull$$$0(41);
        }
        if (this.myLabels.isEmpty()) {
            return;
        }
        GraphicsConfig config2 = GraphicsUtil.setupAAPainting((Graphics)g2);
        g2.setFont(LabelPainter.getReferenceFont());
        g2.setStroke(new BasicStroke(1.5f));
        FontMetrics fontMetrics = g2.getFontMetrics();
        int baseLine = SimpleColoredComponent.getTextBaseLine((FontMetrics)fontMetrics, (int)height);
        g2.setColor(this.myBackground);
        g2.fillRect(x, y, this.myWidth, height);
        if (this.myGreyBackground != null && this.myCompact) {
            g2.setColor(this.myGreyBackground);
            g2.fillRect(x, y + baseLine - fontMetrics.getAscent() - TOP_TEXT_PADDING.get(), this.myWidth, fontMetrics.getHeight() + TOP_TEXT_PADDING.get() + BOTTOM_TEXT_PADDING.get());
        }
        x += LEFT_PADDING.get();
        for (Pair<String, LabelIcon> label2 : this.myLabels) {
            LabelIcon icon = (LabelIcon)label2.second;
            String text = (String)label2.first;
            if (this.myGreyBackground != null && !this.myCompact) {
                g2.setColor(this.myGreyBackground);
                g2.fill(new RoundRectangle2D.Double(x - MIDDLE_PADDING.get() / 3, y + baseLine - fontMetrics.getAscent() - TOP_TEXT_PADDING.get(), icon.getIconWidth() + fontMetrics.stringWidth(text) + 2 * MIDDLE_PADDING.get() / 3, fontMetrics.getHeight() + TOP_TEXT_PADDING.get() + BOTTOM_TEXT_PADDING.get(), LABEL_ARC.get(), LABEL_ARC.get()));
            }
            icon.paintIcon(null, g2, x, y + (height - icon.getIconHeight()) / 2);
            g2.setColor(this.myForeground);
            g2.drawString(text, x += icon.getIconWidth(), y + baseLine);
            x += fontMetrics.stringWidth(text) + (this.myCompact ? COMPACT_MIDDLE_PADDING.get() : MIDDLE_PADDING.get());
        }
        config2.restore();
    }

    public Dimension getSize() {
        if (this.myLabels.isEmpty()) {
            return new Dimension();
        }
        return new Dimension(this.myWidth, this.myHeight);
    }

    public boolean isLeftAligned() {
        return Registry.is((String)"vcs.log.labels.left.aligned");
    }

    public static Font getReferenceFont() {
        Font font = GraphCommitCellRenderer.getLabelFont();
        return font.deriveFont((float)font.getSize() - 1.0f);
    }

    public boolean isCompact() {
        return this.myCompact;
    }

    public void setShowTagNames(boolean showTagNames) {
        this.myShowTagNames = showTagNames;
    }

    public void setCompact(boolean compact) {
        this.myCompact = compact;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 26: 
            case 28: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 26: 
            case 28: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconCache";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 6: 
            case 10: 
            case 16: 
            case 21: 
            case 24: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "background";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "foreground";
                break;
            }
            case 8: 
            case 14: 
            case 19: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refGroups";
                break;
            }
            case 9: 
            case 15: 
            case 20: 
            case 30: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fontMetrics";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 26: 
            case 28: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/render/LabelPainter";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colors";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groups";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refName";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/render/LabelPainter";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "calculatePresentation";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateCompactPresentation";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateLongPresentation";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getColors";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupText";
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "shortenRefName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRefManager";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "customizePainter";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "calculatePresentation";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 26: 
            case 28: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "calculateCompactPresentation";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "calculateLongPresentation";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getColors";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getGroupText";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "calculateGreyBackground";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "shortenRefName";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 22: 
            case 23: 
            case 26: 
            case 28: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 39: 
            case 40: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

