/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.statistics;

import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.UsageDescriptorKeyValidator;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogApplicationSettings;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiPropertiesImpl;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class VcsLogFeaturesCollector
extends ProjectUsagesCollector {
    @Override
    @NotNull
    public Set<UsageDescriptor> getUsages(@NotNull Project project) {
        VcsLogUiImpl ui;
        VcsProjectLog projectLog;
        if (project == null) {
            VcsLogFeaturesCollector.$$$reportNull$$$0(0);
        }
        if ((projectLog = VcsProjectLog.getInstance(project)) != null && (ui = projectLog.getMainLogUi()) != null) {
            MainVcsLogUiProperties properties = ui.getProperties();
            VcsLogUiProperties defaultProperties = VcsLogFeaturesCollector.createDefaultPropertiesInstance();
            HashSet usages = ContainerUtil.newHashSet((Object[])new UsageDescriptor[]{new UsageDescriptor("uiInitialized")});
            VcsLogFeaturesCollector.addBooleanUsage(properties, defaultProperties, usages, "details", CommonUiProperties.SHOW_DETAILS);
            VcsLogFeaturesCollector.addBooleanUsage(properties, defaultProperties, usages, "diffPreview", CommonUiProperties.SHOW_DIFF_PREVIEW);
            VcsLogFeaturesCollector.addBooleanUsage(properties, defaultProperties, usages, "parentChanges", MainVcsLogUiProperties.SHOW_CHANGES_FROM_PARENTS);
            VcsLogFeaturesCollector.addBooleanUsage(properties, defaultProperties, usages, "onlyAffectedChanges", MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES);
            VcsLogFeaturesCollector.addBooleanUsage(properties, defaultProperties, usages, "long.edges", MainVcsLogUiProperties.SHOW_LONG_EDGES);
            VcsLogFeaturesCollector.addEnumUsage(properties, defaultProperties, usages, "sort", MainVcsLogUiProperties.BEK_SORT_TYPE);
            if (ui.getColorManager().isMultipleRoots()) {
                VcsLogFeaturesCollector.addBooleanUsage(properties, defaultProperties, usages, "roots", CommonUiProperties.SHOW_ROOT_NAMES);
            }
            VcsLogFeaturesCollector.addBooleanUsage(properties, defaultProperties, usages, "labels.compact", MainVcsLogUiProperties.COMPACT_REFERENCES_VIEW);
            VcsLogFeaturesCollector.addBooleanUsage(properties, defaultProperties, usages, "labels.showTagNames", MainVcsLogUiProperties.SHOW_TAG_NAMES);
            VcsLogFeaturesCollector.addBooleanUsage(properties, defaultProperties, usages, "textFilter.regex", MainVcsLogUiProperties.TEXT_FILTER_REGEX);
            VcsLogFeaturesCollector.addBooleanUsage(properties, defaultProperties, usages, "textFilter.matchCase", MainVcsLogUiProperties.TEXT_FILTER_MATCH_CASE);
            for (VcsLogHighlighterFactory factory : (VcsLogHighlighterFactory[])VcsLogUiImpl.LOG_HIGHLIGHTER_FACTORY_EP.getExtensions((AreaInstance)project)) {
                if (!factory.showMenuItem()) continue;
                VcsLogFeaturesCollector.addBooleanUsage(properties, defaultProperties, usages, "highlighter." + VcsLogFeaturesCollector.getFactoryIdSafe(factory), MainVcsLogUiProperties.VcsLogHighlighterProperty.get(factory.getId()));
            }
            for (VcsLogFilterCollection.FilterKey key : VcsLogFilterCollection.STANDARD_KEYS) {
                if (properties.getFilterValues(key.getName()) == null) continue;
                usages.add(StatisticsUtilKt.getBooleanUsage(key.getName() + "Filter", true));
            }
            List<String> tabs2 = projectLog.getTabsManager().getTabs();
            usages.add(StatisticsUtilKt.getCountingUsage("additionalTabs.count", tabs2.size(), Arrays.asList(0, 1, 2, 3, 4, 8)));
            HashSet hashSet = usages;
            if (hashSet == null) {
                VcsLogFeaturesCollector.$$$reportNull$$$0(1);
            }
            return hashSet;
        }
        Set<UsageDescriptor> set2 = Collections.emptySet();
        if (set2 == null) {
            VcsLogFeaturesCollector.$$$reportNull$$$0(2);
        }
        return set2;
    }

    @NotNull
    private static String getFactoryIdSafe(@NotNull VcsLogHighlighterFactory factory) {
        if (factory == null) {
            VcsLogFeaturesCollector.$$$reportNull$$$0(3);
        }
        if (PluginInfoDetectorKt.getPluginInfo(factory.getClass()).isDevelopedByJetBrains()) {
            String string = UsageDescriptorKeyValidator.ensureProperKey(factory.getId());
            if (string == null) {
                VcsLogFeaturesCollector.$$$reportNull$$$0(4);
            }
            return string;
        }
        if ("THIRD_PARTY" == null) {
            VcsLogFeaturesCollector.$$$reportNull$$$0(5);
        }
        return "THIRD_PARTY";
    }

    private static void addBooleanUsage(@NotNull VcsLogUiProperties properties, @NotNull VcsLogUiProperties defaultProperties, @NotNull Set<? super UsageDescriptor> usages, @NotNull String usageName, @NotNull VcsLogUiProperties.VcsLogUiProperty<Boolean> property) {
        if (properties == null) {
            VcsLogFeaturesCollector.$$$reportNull$$$0(6);
        }
        if (defaultProperties == null) {
            VcsLogFeaturesCollector.$$$reportNull$$$0(7);
        }
        if (usages == null) {
            VcsLogFeaturesCollector.$$$reportNull$$$0(8);
        }
        if (usageName == null) {
            VcsLogFeaturesCollector.$$$reportNull$$$0(9);
        }
        if (property == null) {
            VcsLogFeaturesCollector.$$$reportNull$$$0(10);
        }
        VcsLogFeaturesCollector.addUsageIfNotDefault(properties, defaultProperties, usages, property, value -> StatisticsUtilKt.getBooleanUsage(usageName, value));
    }

    private static void addEnumUsage(@NotNull VcsLogUiProperties properties, @NotNull VcsLogUiProperties defaultProperties, @NotNull Set<? super UsageDescriptor> usages, @NotNull String usageName, @NotNull VcsLogUiProperties.VcsLogUiProperty<? extends Enum> property) {
        if (properties == null) {
            VcsLogFeaturesCollector.$$$reportNull$$$0(11);
        }
        if (defaultProperties == null) {
            VcsLogFeaturesCollector.$$$reportNull$$$0(12);
        }
        if (usages == null) {
            VcsLogFeaturesCollector.$$$reportNull$$$0(13);
        }
        if (usageName == null) {
            VcsLogFeaturesCollector.$$$reportNull$$$0(14);
        }
        if (property == null) {
            VcsLogFeaturesCollector.$$$reportNull$$$0(15);
        }
        VcsLogFeaturesCollector.addUsageIfNotDefault(properties, defaultProperties, usages, property, value -> StatisticsUtilKt.getEnumUsage(usageName, value));
    }

    private static <T> void addUsageIfNotDefault(@NotNull VcsLogUiProperties properties, @NotNull VcsLogUiProperties defaultProperties, @NotNull Set<? super UsageDescriptor> usages, @NotNull VcsLogUiProperties.VcsLogUiProperty<T> property, @NotNull Function<? super T, ? extends UsageDescriptor> createUsage) {
        if (properties == null) {
            VcsLogFeaturesCollector.$$$reportNull$$$0(16);
        }
        if (defaultProperties == null) {
            VcsLogFeaturesCollector.$$$reportNull$$$0(17);
        }
        if (usages == null) {
            VcsLogFeaturesCollector.$$$reportNull$$$0(18);
        }
        if (property == null) {
            VcsLogFeaturesCollector.$$$reportNull$$$0(19);
        }
        if (createUsage == null) {
            VcsLogFeaturesCollector.$$$reportNull$$$0(20);
        }
        if (!properties.exists(property)) {
            return;
        }
        T value = properties.get(property);
        if (!Objects.equals(defaultProperties.get(property), value)) {
            usages.add((UsageDescriptor)createUsage.fun(value));
        }
    }

    @NotNull
    private static VcsLogUiProperties createDefaultPropertiesInstance() {
        VcsLogUiPropertiesImpl vcsLogUiPropertiesImpl = new VcsLogUiPropertiesImpl(new VcsLogApplicationSettings()){
            @NotNull
            private final VcsLogUiPropertiesImpl.State myState = new VcsLogUiPropertiesImpl.State();

            @Override
            @NotNull
            public VcsLogUiPropertiesImpl.State getState() {
                VcsLogUiPropertiesImpl.State state = this.myState;
                if (state == null) {
                    1.$$$reportNull$$$0(0);
                }
                return state;
            }

            @Override
            public void addRecentlyFilteredGroup(@NotNull String filterName, @NotNull Collection<String> values) {
                if (filterName == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (values == null) {
                    1.$$$reportNull$$$0(2);
                }
                throw new UnsupportedOperationException();
            }

            @Override
            @NotNull
            public List<List<String>> getRecentlyFilteredGroups(@NotNull String filterName) {
                if (filterName == null) {
                    1.$$$reportNull$$$0(3);
                }
                throw new UnsupportedOperationException();
            }

            public void loadState(@NotNull Object state) {
                if (state == null) {
                    1.$$$reportNull$$$0(4);
                }
                throw new UnsupportedOperationException();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/vcs/log/statistics/VcsLogFeaturesCollector$1";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "filterName";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "values";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "state";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getState";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/vcs/log/statistics/VcsLogFeaturesCollector$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "addRecentlyFilteredGroup";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getRecentlyFilteredGroups";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "loadState";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (vcsLogUiPropertiesImpl == null) {
            VcsLogFeaturesCollector.$$$reportNull$$$0(21);
        }
        return vcsLogUiPropertiesImpl;
    }

    @Override
    @NotNull
    public String getGroupId() {
        if ("vcs.log.ui" == null) {
            VcsLogFeaturesCollector.$$$reportNull$$$0(22);
        }
        return "vcs.log.ui";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 21: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 21: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/statistics/VcsLogFeaturesCollector";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 6: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 7: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultProperties";
                break;
            }
            case 8: 
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageName";
                break;
            }
            case 10: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createUsage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/statistics/VcsLogFeaturesCollector";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsages";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactoryIdSafe";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultPropertiesInstance";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getUsages";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 21: 
            case 22: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFactoryIdSafe";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addBooleanUsage";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addEnumUsage";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "addUsageIfNotDefault";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 21: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

