/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.history;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsLogBranchFilter;
import com.intellij.vcs.log.VcsLogFileHistoryProvider;
import com.intellij.vcs.log.VcsLogFilter;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogRevisionFilter;
import com.intellij.vcs.log.VcsLogRootFilter;
import com.intellij.vcs.log.VcsLogStructureFilter;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.history.FileHistoryUi;
import com.intellij.vcs.log.history.FileHistoryUiFactory;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogContentUtil;
import com.intellij.vcs.log.impl.VcsLogManager;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.filters.VcsLogFilterObject;
import com.intellij.vcs.log.visible.filters.VcsLogFiltersKt;
import com.intellij.vcsUtil.VcsUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsLogFileHistoryProviderImpl
implements VcsLogFileHistoryProvider {
    @NotNull
    public static final String TAB_NAME = "History";

    public boolean canShowFileHistory(@NotNull Project project, @NotNull FilePath path) {
        if (project == null) {
            VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(0);
        }
        if (path == null) {
            VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(1);
        }
        if (!Registry.is((String)"vcs.new.history")) {
            return false;
        }
        VirtualFile root = VcsLogUtil.getActualRoot(project, path);
        if (root == null) {
            return false;
        }
        VcsLogData dataManager = VcsProjectLog.getInstance(project).getDataManager();
        if (dataManager == null) {
            return false;
        }
        return dataManager.getIndex().isIndexingEnabled(root);
    }

    public void showFileHistory(@NotNull Project project, @NotNull FilePath path, @Nullable String revisionNumber) {
        if (project == null) {
            VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(2);
        }
        if (path == null) {
            VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(3);
        }
        VirtualFile root = (VirtualFile)ObjectUtils.assertNotNull((Object)VcsLogUtil.getActualRoot(project, path));
        FilePath correctedPath = VcsLogFileHistoryProviderImpl.getCorrectedPath(project, path, root, revisionNumber);
        Hash hash = revisionNumber != null ? HashImpl.build(revisionNumber) : null;
        VcsLogManager logManager = (VcsLogManager)ObjectUtils.assertNotNull((Object)VcsProjectLog.getInstance(project).getLogManager());
        BiConsumer<AbstractVcsLogUi, Boolean> historyUiConsumer = (ui, firstTime) -> {
            if (hash != null) {
                ui.jumpToNearestCommit(hash, root);
            } else if (firstTime.booleanValue()) {
                ui.jumpToRow(0);
            }
        };
        if (path.isDirectory() && VcsLogUtil.isFolderHistoryShownInLog()) {
            VcsLogFileHistoryProviderImpl.findOrOpenFolderHistory(project, logManager, root, correctedPath, hash, historyUiConsumer);
        } else {
            VcsLogFileHistoryProviderImpl.findOrOpenHistory(project, logManager, root, correctedPath, hash, historyUiConsumer);
        }
    }

    private static void findOrOpenHistory(@NotNull Project project, @NotNull VcsLogManager logManager, @NotNull VirtualFile root, @NotNull FilePath path, @Nullable Hash hash, @NotNull BiConsumer<AbstractVcsLogUi, Boolean> consumer) {
        FileHistoryUi fileHistoryUi;
        boolean firstTime;
        if (project == null) {
            VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(4);
        }
        if (logManager == null) {
            VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(5);
        }
        if (root == null) {
            VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(6);
        }
        if (path == null) {
            VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(7);
        }
        if (consumer == null) {
            VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(8);
        }
        boolean bl = firstTime = (fileHistoryUi = VcsLogContentUtil.findAndSelect(project, FileHistoryUi.class, ui -> ui.matches(path, hash))) == null;
        if (firstTime) {
            String suffix = hash != null ? " (" + hash.toShortString() + ")" : "";
            fileHistoryUi = VcsLogContentUtil.openLogTab(project, logManager, TAB_NAME, path.getName() + suffix, new FileHistoryUiFactory(path, root, hash), true);
        }
        consumer.accept(fileHistoryUi, firstTime);
    }

    private static void findOrOpenFolderHistory(@NotNull Project project, @NotNull VcsLogManager logManager, @NotNull VirtualFile root, @NotNull FilePath path, @Nullable Hash hash, @NotNull BiConsumer<AbstractVcsLogUi, Boolean> consumer) {
        VcsLogUiImpl ui;
        boolean firstTime;
        if (project == null) {
            VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(9);
        }
        if (logManager == null) {
            VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(10);
        }
        if (root == null) {
            VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(11);
        }
        if (path == null) {
            VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(12);
        }
        if (consumer == null) {
            VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(13);
        }
        boolean bl = firstTime = (ui = VcsLogContentUtil.findAndSelect(project, VcsLogUiImpl.class, logUi -> VcsLogFileHistoryProviderImpl.matches(logUi.getFilterUi().getFilters(), path, hash))) == null;
        if (firstTime) {
            VcsLogFilterCollection filters = VcsLogFileHistoryProviderImpl.createFilters(path, hash, root);
            ui = VcsProjectLog.getInstance(project).getTabsManager().openAnotherLogTab(logManager, filters);
            ui.getProperties().set(MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES, true);
        }
        consumer.accept(ui, firstTime);
    }

    @NotNull
    private static VcsLogFilterCollection createFilters(@NotNull FilePath filePath, @Nullable Hash hash, @NotNull VirtualFile root) {
        if (filePath == null) {
            VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(14);
        }
        if (root == null) {
            VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(15);
        }
        Object pathFilter = Objects.equals(filePath.getVirtualFile(), root) ? VcsLogFilterObject.fromRoot(root) : VcsLogFilterObject.fromPaths(Collections.singleton(filePath));
        if (hash == null) {
            VcsLogFilterCollection vcsLogFilterCollection = VcsLogFilterObject.collection(new VcsLogFilter[]{pathFilter, VcsLogFilterObject.fromBranch("HEAD")});
            if (vcsLogFilterCollection == null) {
                VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(16);
            }
            return vcsLogFilterCollection;
        }
        VcsLogFilterCollection vcsLogFilterCollection = VcsLogFilterObject.collection(new VcsLogFilter[]{pathFilter, VcsLogFilterObject.fromCommit(new CommitId(hash, root))});
        if (vcsLogFilterCollection == null) {
            VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(17);
        }
        return vcsLogFilterCollection;
    }

    private static boolean matches(@NotNull VcsLogFilterCollection filters, @NotNull FilePath filePath, @Nullable Hash hash) {
        VcsLogFilterCollection.FilterKey hashKey;
        if (filters == null) {
            VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(18);
        }
        if (filePath == null) {
            VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(19);
        }
        VcsLogFilterCollection.FilterKey filterKey = hashKey = hash == null ? VcsLogFilterCollection.BRANCH_FILTER : VcsLogFilterCollection.REVISION_FILTER;
        if (!VcsLogFiltersKt.matches(filters, hashKey, VcsLogFilterCollection.STRUCTURE_FILTER) && !VcsLogFiltersKt.matches(filters, hashKey, VcsLogFilterCollection.ROOT_FILTER)) {
            return false;
        }
        if (!Objects.equals(VcsLogFileHistoryProviderImpl.getSingleFilePath(filters), filePath)) {
            return false;
        }
        if (hash != null) {
            return Objects.equals(VcsLogFileHistoryProviderImpl.getSingleHash(filters), hash);
        }
        return VcsLogFileHistoryProviderImpl.isFilteredByHead(filters);
    }

    private static boolean isFilteredByHead(@NotNull VcsLogFilterCollection filters) {
        VcsLogBranchFilter branchFilter;
        if (filters == null) {
            VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(20);
        }
        if ((branchFilter = (VcsLogBranchFilter)filters.get(VcsLogFilterCollection.BRANCH_FILTER)) == null) {
            return false;
        }
        return branchFilter.getTextPresentation().equals(Collections.singletonList("HEAD"));
    }

    @Nullable
    private static Hash getSingleHash(@NotNull VcsLogFilterCollection filters) {
        VcsLogRevisionFilter revisionFilter;
        if (filters == null) {
            VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(21);
        }
        if ((revisionFilter = (VcsLogRevisionFilter)filters.get(VcsLogFilterCollection.REVISION_FILTER)) == null) {
            return null;
        }
        Collection heads = revisionFilter.getHeads();
        if (heads.size() != 1) {
            return null;
        }
        return ((CommitId)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem((Collection)heads))).getHash();
    }

    @Nullable
    private static FilePath getSingleFilePath(@NotNull VcsLogFilterCollection filters) {
        VcsLogStructureFilter structureFilter;
        if (filters == null) {
            VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(22);
        }
        if ((structureFilter = (VcsLogStructureFilter)filters.get(VcsLogFilterCollection.STRUCTURE_FILTER)) == null) {
            VcsLogRootFilter rootFilter = (VcsLogRootFilter)filters.get(VcsLogFilterCollection.ROOT_FILTER);
            if (rootFilter == null) {
                return null;
            }
            Collection roots = rootFilter.getRoots();
            if (roots.size() != 1) {
                return null;
            }
            return VcsUtil.getFilePath((VirtualFile)((VirtualFile)ObjectUtils.assertNotNull((Object)ContainerUtil.getFirstItem((Collection)roots))));
        }
        Collection filePaths = structureFilter.getFiles();
        if (filePaths.size() != 1) {
            return null;
        }
        return (FilePath)ContainerUtil.getFirstItem((Collection)filePaths);
    }

    @NotNull
    private static FilePath getCorrectedPath(@NotNull Project project, @NotNull FilePath path, @NotNull VirtualFile root, @Nullable String revisionNumber) {
        if (project == null) {
            VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(23);
        }
        if (path == null) {
            VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(24);
        }
        if (root == null) {
            VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(25);
        }
        if (!root.equals(VcsUtil.getVcsRootFor((Project)project, (FilePath)path)) && path.isDirectory()) {
            path = VcsUtil.getFilePath((String)path.getPath(), (boolean)false);
        }
        if (revisionNumber == null) {
            FilePath filePath = VcsUtil.getLastCommitPath((Project)project, (FilePath)path);
            if (filePath == null) {
                VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(26);
            }
            return filePath;
        }
        FilePath filePath = path;
        if (filePath == null) {
            VcsLogFileHistoryProviderImpl.$$$reportNull$$$0(27);
        }
        return filePath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 17: 
            case 26: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 17: 
            case 26: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 7: 
            case 12: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logManager";
                break;
            }
            case 6: 
            case 11: 
            case 15: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 16: 
            case 17: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/history/VcsLogFileHistoryProviderImpl";
                break;
            }
            case 18: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/history/VcsLogFileHistoryProviderImpl";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createFilters";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getCorrectedPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canShowFileHistory";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showFileHistory";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findOrOpenHistory";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findOrOpenFolderHistory";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createFilters";
                break;
            }
            case 16: 
            case 17: 
            case 26: 
            case 27: {
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isFilteredByHead";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getSingleHash";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getSingleFilePath";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getCorrectedPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 17: 
            case 26: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

