/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils.impl;

import com.intellij.util.BooleanFunction;
import com.intellij.vcs.log.graph.utils.Flags;
import com.intellij.vcs.log.graph.utils.UpdatableIntToIntMap;
import com.intellij.vcs.log.graph.utils.impl.AbstractIntToIntMap;
import com.intellij.vcs.log.graph.utils.impl.IDIntToIntMap;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class ListIntToIntMap
extends AbstractIntToIntMap
implements UpdatableIntToIntMap {
    public static final int DEFAULT_BLOCK_SIZE = 30;
    @NotNull
    final BooleanFunction<Integer> myThisIsVisible;
    private final int myLongSize;
    private final int myBlockSize;
    private final int[] mySubSumOfBlocks;

    @NotNull
    public static UpdatableIntToIntMap newInstance(@NotNull BooleanFunction<Integer> thisIsVisible, int longSize) {
        if (thisIsVisible == null) {
            ListIntToIntMap.$$$reportNull$$$0(0);
        }
        UpdatableIntToIntMap updatableIntToIntMap = ListIntToIntMap.newInstance(thisIsVisible, longSize, 30);
        if (updatableIntToIntMap == null) {
            ListIntToIntMap.$$$reportNull$$$0(1);
        }
        return updatableIntToIntMap;
    }

    @NotNull
    public static UpdatableIntToIntMap newInstance(Flags visibleNodes) {
        UpdatableIntToIntMap updatableIntToIntMap = ListIntToIntMap.newInstance((BooleanFunction<Integer>)((BooleanFunction)integer -> visibleNodes.get((int)integer)), visibleNodes.size());
        if (updatableIntToIntMap == null) {
            ListIntToIntMap.$$$reportNull$$$0(2);
        }
        return updatableIntToIntMap;
    }

    @NotNull
    public static UpdatableIntToIntMap newInstance(@NotNull BooleanFunction<Integer> thisIsVisible, int longSize, int blockSize) {
        if (thisIsVisible == null) {
            ListIntToIntMap.$$$reportNull$$$0(3);
        }
        if (longSize < 0) {
            throw new NegativeArraySizeException("size < 0: " + longSize);
        }
        if (longSize == 0) {
            UpdatableIntToIntMap updatableIntToIntMap = IDIntToIntMap.EMPTY;
            if (updatableIntToIntMap == null) {
                ListIntToIntMap.$$$reportNull$$$0(4);
            }
            return updatableIntToIntMap;
        }
        int sumSize = (longSize - 1) / blockSize + 1;
        ListIntToIntMap listIntToIntMap = new ListIntToIntMap(thisIsVisible, longSize, blockSize, new int[sumSize]);
        listIntToIntMap.update(0, longSize - 1);
        ListIntToIntMap listIntToIntMap2 = listIntToIntMap;
        if (listIntToIntMap2 == null) {
            ListIntToIntMap.$$$reportNull$$$0(5);
        }
        return listIntToIntMap2;
    }

    private ListIntToIntMap(@NotNull BooleanFunction<Integer> thisIsVisible, int longSize, int blockSize, int[] subSumOfBlocks) {
        if (thisIsVisible == null) {
            ListIntToIntMap.$$$reportNull$$$0(6);
        }
        this.myLongSize = longSize;
        this.myThisIsVisible = thisIsVisible;
        this.myBlockSize = blockSize;
        this.mySubSumOfBlocks = subSumOfBlocks;
    }

    @Override
    public int shortSize() {
        return this.mySubSumOfBlocks[this.mySubSumOfBlocks.length - 1];
    }

    @Override
    public int longSize() {
        return this.myLongSize;
    }

    private int getRelevantSumIndex(int longIndex) {
        return longIndex / this.myBlockSize;
    }

    @Override
    public int getLongIndex(int shortIndex) {
        this.checkShortIndex(shortIndex);
        int i = Arrays.binarySearch(this.mySubSumOfBlocks, shortIndex);
        if (i < 0) {
            i = -i - 1;
        }
        int blockIndex = i;
        int prefVisibleCount = 0;
        if (blockIndex > 0) {
            prefVisibleCount = this.mySubSumOfBlocks[blockIndex - 1];
        }
        for (int longIndex = blockIndex * this.myBlockSize; longIndex < this.myLongSize; ++longIndex) {
            if (this.myThisIsVisible.fun((Object)longIndex)) {
                ++prefVisibleCount;
            }
            if (prefVisibleCount <= shortIndex) continue;
            return longIndex;
        }
        throw new IllegalAccessError("This should never happen!");
    }

    @Override
    public int getShortIndex(int longIndex) {
        this.checkLongIndex(longIndex);
        int blockIndex = this.getRelevantSumIndex(longIndex);
        int countVisible = this.calculateSumForBlock(blockIndex, longIndex);
        if (countVisible > 0) {
            return countVisible - 1;
        }
        return 0;
    }

    private int calculateSumForBlock(int blockIndex, int lastLongIndex) {
        int sum = 0;
        if (blockIndex > 0) {
            sum = this.mySubSumOfBlocks[blockIndex - 1];
        }
        for (int longIndex = blockIndex * this.myBlockSize; longIndex <= lastLongIndex; ++longIndex) {
            if (!this.myThisIsVisible.fun((Object)longIndex)) continue;
            ++sum;
        }
        return sum;
    }

    private void updateSumWithCorrectPrevious(int blockIndex) {
        int endIndex = Math.min(this.myLongSize, (blockIndex + 1) * this.myBlockSize);
        this.mySubSumOfBlocks[blockIndex] = this.calculateSumForBlock(blockIndex, endIndex - 1);
    }

    @Override
    public void update(int startLongIndex, int endLongIndex) {
        this.checkUpdateParameters(startLongIndex, endLongIndex);
        int startSumIndex = this.getRelevantSumIndex(startLongIndex);
        int endSumIndex = this.getRelevantSumIndex(endLongIndex);
        int prevEndSum = this.mySubSumOfBlocks[endSumIndex];
        for (int blockIndex = startSumIndex; blockIndex <= endSumIndex; ++blockIndex) {
            this.updateSumWithCorrectPrevious(blockIndex);
        }
        int sumDelta = this.mySubSumOfBlocks[endSumIndex] - prevEndSum;
        int blockIndex = endSumIndex + 1;
        while (blockIndex < this.mySubSumOfBlocks.length) {
            int n = blockIndex++;
            this.mySubSumOfBlocks[n] = this.mySubSumOfBlocks[n] + sumDelta;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisIsVisible";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/graph/utils/impl/ListIntToIntMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/graph/utils/impl/ListIntToIntMap";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "newInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newInstance";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

