/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils;

import com.intellij.util.containers.IntStack;
import com.intellij.vcs.log.graph.api.LinearGraph;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.utils.DfsUtilKt;
import com.intellij.vcs.log.graph.utils.Flags;
import com.intellij.vcs.log.graph.utils.LinearGraphUtils;
import com.intellij.vcs.log.graph.utils.impl.BitSetFlags;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B#\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00120\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/vcs/log/graph/utils/DfsWalk;", "", "startNodes", "", "", "linearGraph", "Lcom/intellij/vcs/log/graph/api/LinearGraph;", "(Ljava/util/Collection;Lcom/intellij/vcs/log/graph/api/LinearGraph;)V", "graph", "Lcom/intellij/vcs/log/graph/api/LiteLinearGraph;", "visited", "Lcom/intellij/vcs/log/graph/utils/Flags;", "(Ljava/util/Collection;Lcom/intellij/vcs/log/graph/api/LiteLinearGraph;Lcom/intellij/vcs/log/graph/utils/Flags;)V", "stack", "Lcom/intellij/util/containers/IntStack;", "walk", "", "goDown", "", "consumer", "Lkotlin/Function1;", "intellij.platform.vcs.log.graph.impl"})
public final class DfsWalk {
    private final IntStack stack;
    private final Collection<Integer> startNodes;
    private final LiteLinearGraph graph;
    private final Flags visited;

    public final void walk(boolean goDown, @NotNull Function1<? super Integer, Boolean> consumer) {
        Intrinsics.checkParameterIsNotNull(consumer, (String)"consumer");
        Iterator<Integer> iterator = this.startNodes.iterator();
        while (iterator.hasNext()) {
            int start2 = ((Number)iterator.next()).intValue();
            if (start2 < 0 || this.visited.get(start2)) continue;
            this.visited.set(start2, true);
            if (!((Boolean)consumer.invoke((Object)start2)).booleanValue()) {
                return;
            }
            DfsUtilKt.access$walk(start2, this.stack, (Function1)new Function1<Integer, Integer>(this, goDown, consumer){
                final /* synthetic */ DfsWalk this$0;
                final /* synthetic */ boolean $goDown;
                final /* synthetic */ Function1 $consumer;

                public final Integer invoke(int currentNode) {
                    for (Integer downNode : DfsWalk.access$getGraph$p(this.this$0).getNodes(currentNode, this.$goDown ? LiteLinearGraph.NodeFilter.DOWN : LiteLinearGraph.NodeFilter.UP)) {
                        Flags flags = DfsWalk.access$getVisited$p(this.this$0);
                        Integer n = downNode;
                        Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"downNode");
                        if (flags.get(n)) continue;
                        DfsWalk.access$getVisited$p(this.this$0).set(downNode, true);
                        if (!((Boolean)this.$consumer.invoke((Object)downNode)).booleanValue()) {
                            return -10;
                        }
                        return downNode;
                    }
                    return -1;
                }
                {
                    this.this$0 = dfsWalk;
                    this.$goDown = bl;
                    this.$consumer = function1;
                    super(1);
                }
            });
        }
    }

    public DfsWalk(@NotNull Collection<Integer> startNodes, @NotNull LiteLinearGraph graph2, @NotNull Flags visited) {
        Intrinsics.checkParameterIsNotNull(startNodes, (String)"startNodes");
        Intrinsics.checkParameterIsNotNull((Object)graph2, (String)"graph");
        Intrinsics.checkParameterIsNotNull((Object)visited, (String)"visited");
        this.startNodes = startNodes;
        this.graph = graph2;
        this.visited = visited;
        this.stack = new IntStack();
    }

    public DfsWalk(@NotNull Collection<Integer> startNodes, @NotNull LinearGraph linearGraph) {
        Intrinsics.checkParameterIsNotNull(startNodes, (String)"startNodes");
        Intrinsics.checkParameterIsNotNull((Object)linearGraph, (String)"linearGraph");
        LiteLinearGraph liteLinearGraph = LinearGraphUtils.asLiteLinearGraph(linearGraph);
        Intrinsics.checkExpressionValueIsNotNull((Object)liteLinearGraph, (String)"LinearGraphUtils.asLiteLinearGraph(linearGraph)");
        this(startNodes, liteLinearGraph, new BitSetFlags(linearGraph.nodesCount()));
    }

    public static final /* synthetic */ LiteLinearGraph access$getGraph$p(DfsWalk $this) {
        return $this.graph;
    }

    public static final /* synthetic */ Flags access$getVisited$p(DfsWalk $this) {
        return $this.visited;
    }
}

