/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.graph.utils;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.graph.api.LiteLinearGraph;
import com.intellij.vcs.log.graph.utils.Flags;
import java.util.LinkedList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00030\u000fJ\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00030\u00030\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/vcs/log/graph/utils/BfsWalk;", "", "start", "", "graph", "Lcom/intellij/vcs/log/graph/api/LiteLinearGraph;", "visited", "Lcom/intellij/vcs/log/graph/utils/Flags;", "(ILcom/intellij/vcs/log/graph/api/LiteLinearGraph;Lcom/intellij/vcs/log/graph/utils/Flags;)V", "queue", "Ljava/util/LinkedList;", "kotlin.jvm.PlatformType", "getStart", "()I", "currentNodes", "", "isFinished", "", "step", "walk", "", "intellij.platform.vcs.log.graph.impl"})
public final class BfsWalk {
    private final LinkedList<Integer> queue;
    private final int start;
    private final LiteLinearGraph graph;
    private final Flags visited;

    public final boolean isFinished() {
        return this.queue.isEmpty();
    }

    @NotNull
    public final List<Integer> currentNodes() {
        return this.queue;
    }

    @NotNull
    public final List<Integer> step() {
        while (!this.queue.isEmpty()) {
            Integer node;
            Integer n = node = this.queue.poll();
            Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"node");
            if (this.visited.get(n)) continue;
            this.visited.set(node, true);
            List<Integer> list2 = this.graph.getNodes(node, LiteLinearGraph.NodeFilter.DOWN);
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"graph.getNodes(node, Lit\u2026earGraph.NodeFilter.DOWN)");
            List next = CollectionsKt.sorted((Iterable)list2);
            this.queue.addAll(next);
            return next;
        }
        return CollectionsKt.emptyList();
    }

    public final void walk() {
        while (!this.isFinished()) {
            this.step();
        }
    }

    public final int getStart() {
        return this.start;
    }

    public BfsWalk(int start2, @NotNull LiteLinearGraph graph2, @NotNull Flags visited) {
        Intrinsics.checkParameterIsNotNull((Object)graph2, (String)"graph");
        Intrinsics.checkParameterIsNotNull((Object)visited, (String)"visited");
        this.start = start2;
        this.graph = graph2;
        this.visited = visited;
        LinkedList linkedList = ContainerUtil.newLinkedList((Object[])new Integer[]{this.start});
        Intrinsics.checkExpressionValueIsNotNull((Object)linkedList, (String)"ContainerUtil.newLinkedList(start)");
        this.queue = linkedList;
    }
}

