/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.options.newEditor.SettingsDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.Consumer;
import com.intellij.util.NotNullProducer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwingHelper {
    private static final Logger LOG = Logger.getInstance(SwingHelper.class);
    private static final String DIALOG_RESIZED_TO_FIT_TEXT = "INTELLIJ_DIALOG_RESIZED_TO_FIT_TEXT";
    public static final String ELLIPSIS = "...";
    public static final String ERROR_STR = "www";

    @NotNull
    public static JPanel newVerticalPanel(float childAlignmentX, Component ... children2) {
        JPanel jPanel = SwingHelper.newGenericBoxPanel(true, childAlignmentX, children2);
        if (jPanel == null) {
            SwingHelper.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    @NotNull
    public static JPanel newLeftAlignedVerticalPanel(Component ... children2) {
        JPanel jPanel = SwingHelper.newVerticalPanel(0.0f, children2);
        if (jPanel == null) {
            SwingHelper.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    @NotNull
    public static JPanel newLeftAlignedVerticalPanel(@NotNull Collection<Component> children2) {
        if (children2 == null) {
            SwingHelper.$$$reportNull$$$0(2);
        }
        JPanel jPanel = SwingHelper.newVerticalPanel(0.0f, children2);
        if (jPanel == null) {
            SwingHelper.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    @NotNull
    public static JPanel newVerticalPanel(float childAlignmentX, @NotNull Collection<Component> children2) {
        if (children2 == null) {
            SwingHelper.$$$reportNull$$$0(4);
        }
        JPanel jPanel = SwingHelper.newVerticalPanel(childAlignmentX, children2.toArray(new Component[0]));
        if (jPanel == null) {
            SwingHelper.$$$reportNull$$$0(5);
        }
        return jPanel;
    }

    @NotNull
    public static JPanel newHorizontalPanel(float childAlignmentY, Component ... children2) {
        JPanel jPanel = SwingHelper.newGenericBoxPanel(false, childAlignmentY, children2);
        if (jPanel == null) {
            SwingHelper.$$$reportNull$$$0(6);
        }
        return jPanel;
    }

    private static JPanel newGenericBoxPanel(boolean verticalOrientation, float childAlignment, Component ... children2) {
        JPanel panel2 = new JPanel();
        int axis = verticalOrientation ? 1 : 0;
        panel2.setLayout(new BoxLayout(panel2, axis));
        for (Component child2 : children2) {
            panel2.add(child2, Float.valueOf(childAlignment));
            if (!(child2 instanceof JComponent)) continue;
            JComponent jChild = (JComponent)child2;
            if (verticalOrientation) {
                jChild.setAlignmentX(childAlignment);
                continue;
            }
            jChild.setAlignmentY(childAlignment);
        }
        return panel2;
    }

    @NotNull
    public static JPanel wrapWithoutStretch(@NotNull JComponent component) {
        if (component == null) {
            SwingHelper.$$$reportNull$$$0(7);
        }
        JPanel panel2 = new JPanel(new FlowLayout(0, 0, 0));
        panel2.add(component);
        JPanel jPanel = panel2;
        if (jPanel == null) {
            SwingHelper.$$$reportNull$$$0(8);
        }
        return jPanel;
    }

    @NotNull
    public static JPanel wrapWithHorizontalStretch(@NotNull JComponent component) {
        if (component == null) {
            SwingHelper.$$$reportNull$$$0(9);
        }
        JPanel panel2 = new JPanel(new BorderLayout(0, 0));
        panel2.add((Component)component, "North");
        JPanel jPanel = panel2;
        if (jPanel == null) {
            SwingHelper.$$$reportNull$$$0(10);
        }
        return jPanel;
    }

    public static void setPreferredWidthToFitText(@NotNull TextFieldWithHistoryWithBrowseButton component) {
        if (component == null) {
            SwingHelper.$$$reportNull$$$0(11);
        }
        int childWidth = SwingHelper.calcWidthToFitText(((TextFieldWithHistory)component.getChildComponent()).getTextEditor(), JBUI.scale((int)32));
        SwingHelper.setPreferredWidthForComponentWithBrowseButton(component, childWidth);
    }

    public static void setPreferredWidthToFitText(@NotNull TextFieldWithBrowseButton component) {
        if (component == null) {
            SwingHelper.$$$reportNull$$$0(12);
        }
        int childWidth = SwingHelper.calcWidthToFitText((JTextField)component.getChildComponent(), JBUI.scale((int)20));
        SwingHelper.setPreferredWidthForComponentWithBrowseButton(component, childWidth);
    }

    private static <T extends JComponent> void setPreferredWidthForComponentWithBrowseButton(@NotNull ComponentWithBrowseButton<T> component, int childPrefWidth) {
        if (component == null) {
            SwingHelper.$$$reportNull$$$0(13);
        }
        Dimension buttonPrefSize = component.getButton().getPreferredSize();
        SwingHelper.setPreferredWidth(component, childPrefWidth + buttonPrefSize.width);
    }

    public static void setPreferredWidthToFitText(@NotNull JTextField textField2) {
        if (textField2 == null) {
            SwingHelper.$$$reportNull$$$0(14);
        }
        SwingHelper.setPreferredWidthToFitText(textField2, JBUI.scale((int)15));
    }

    public static void setPreferredWidthToFitText(@NotNull JTextField textField2, int additionalWidth) {
        if (textField2 == null) {
            SwingHelper.$$$reportNull$$$0(15);
        }
        SwingHelper.setPreferredSizeToFitText(textField2, StringUtil.notNullize((String)textField2.getText()), additionalWidth);
    }

    public static void setPreferredWidthToFitText(@NotNull JTextField textField2, @NotNull String text) {
        if (textField2 == null) {
            SwingHelper.$$$reportNull$$$0(16);
        }
        if (text == null) {
            SwingHelper.$$$reportNull$$$0(17);
        }
        SwingHelper.setPreferredSizeToFitText(textField2, text, JBUI.scale((int)15));
    }

    private static void setPreferredSizeToFitText(@NotNull JTextField textField2, @NotNull String text, int additionalWidth) {
        if (textField2 == null) {
            SwingHelper.$$$reportNull$$$0(18);
        }
        if (text == null) {
            SwingHelper.$$$reportNull$$$0(19);
        }
        int width = SwingHelper.calcWidthToFitText(textField2, text, additionalWidth);
        SwingHelper.setPreferredWidth(textField2, width);
    }

    private static int calcWidthToFitText(@NotNull JTextField textField2, int additionalWidth) {
        if (textField2 == null) {
            SwingHelper.$$$reportNull$$$0(20);
        }
        return SwingHelper.calcWidthToFitText(textField2, textField2.getText(), additionalWidth);
    }

    private static int calcWidthToFitText(@NotNull JTextField textField2, @NotNull String text, int additionalWidth) {
        if (textField2 == null) {
            SwingHelper.$$$reportNull$$$0(21);
        }
        if (text == null) {
            SwingHelper.$$$reportNull$$$0(22);
        }
        return textField2.getFontMetrics(textField2.getFont()).stringWidth(text) + additionalWidth;
    }

    public static void adjustDialogSizeToFitPreferredSize(@NotNull DialogWrapper dialogWrapper) {
        JRootPane rootPane;
        if (dialogWrapper == null) {
            SwingHelper.$$$reportNull$$$0(23);
        }
        if ((rootPane = dialogWrapper.getRootPane()) == null) {
            return;
        }
        Dimension componentSize = rootPane.getSize();
        Dimension componentPreferredSize = rootPane.getPreferredSize();
        if (componentPreferredSize.width <= componentSize.width && componentPreferredSize.height <= componentSize.height) {
            return;
        }
        int dw = Math.max(0, componentPreferredSize.width - componentSize.width);
        int dh = Math.max(0, componentPreferredSize.height - componentSize.height);
        Dimension oldDialogSize = dialogWrapper.getSize();
        Dimension newDialogSize = new Dimension(oldDialogSize.width + dw, oldDialogSize.height + dh);
        dialogWrapper.setSize(newDialogSize.width, newDialogSize.height);
        rootPane.revalidate();
        rootPane.repaint();
        LOG.debug("DialogWrapper '" + dialogWrapper.getTitle() + "' has been re-sized (added width: " + dw + ", added height: " + dh + ")");
    }

    public static void resizeDialogToFitTextFor(JComponent ... components) {
        if (components == null) {
            SwingHelper.$$$reportNull$$$0(24);
        }
        if (components.length == 0) {
            return;
        }
        SwingHelper.doWithDialogWrapper(components[0], (Consumer<? super DialogWrapper>)((Consumer)dialogWrapper -> {
            if (dialogWrapper instanceof SettingsDialog || dialogWrapper instanceof SingleConfigurableEditor) {
                for (JComponent component : components) {
                    if (component instanceof TextFieldWithHistoryWithBrowseButton) {
                        SwingHelper.setPreferredWidthToFitText((TextFieldWithHistoryWithBrowseButton)component);
                        continue;
                    }
                    if (component instanceof TextFieldWithBrowseButton) {
                        SwingHelper.setPreferredWidthToFitText((TextFieldWithBrowseButton)component);
                        continue;
                    }
                    if (!(component instanceof JTextField)) continue;
                    SwingHelper.setPreferredWidthToFitText((JTextField)component);
                }
                ApplicationManager.getApplication().invokeLater(() -> SwingHelper.adjustDialogSizeToFitPreferredSize(dialogWrapper), ModalityState.any());
            }
        }));
    }

    private static void doWithDialogWrapper(@NotNull JComponent component, @NotNull Consumer<? super DialogWrapper> consumer) {
        if (component == null) {
            SwingHelper.$$$reportNull$$$0(25);
        }
        if (consumer == null) {
            SwingHelper.$$$reportNull$$$0(26);
        }
        UIUtil.invokeLaterIfNeeded(() -> {
            if (component.getClientProperty(DIALOG_RESIZED_TO_FIT_TEXT) != null) {
                return;
            }
            component.putClientProperty(DIALOG_RESIZED_TO_FIT_TEXT, true);
            DialogWrapper dialogWrapper = DialogWrapper.findInstance((Component)component);
            if (dialogWrapper != null) {
                consumer.consume((Object)dialogWrapper);
            } else {
                UiNotifyConnector.doWhenFirstShown((JComponent)component, () -> {
                    DialogWrapper dialogWrapper1 = DialogWrapper.findInstance((Component)component);
                    if (dialogWrapper1 != null) {
                        consumer.consume((Object)dialogWrapper1);
                    }
                });
            }
        });
    }

    public static <T> void updateItems(@NotNull JComboBox<T> comboBox2, @NotNull List<? extends T> newItems, @Nullable T newSelectedItemIfSelectionCannotBePreserved) {
        if (comboBox2 == null) {
            SwingHelper.$$$reportNull$$$0(27);
        }
        if (newItems == null) {
            SwingHelper.$$$reportNull$$$0(28);
        }
        if (!SwingHelper.shouldUpdate(comboBox2, newItems)) {
            return;
        }
        Object itemToSelect = comboBox2.getSelectedItem();
        boolean preserveSelection = true;
        if (!newItems.contains(itemToSelect)) {
            if (newItems.contains(newSelectedItemIfSelectionCannotBePreserved)) {
                itemToSelect = newSelectedItemIfSelectionCannotBePreserved;
            } else {
                itemToSelect = null;
                preserveSelection = false;
            }
        }
        comboBox2.removeAllItems();
        for (T newItem : newItems) {
            comboBox2.addItem(newItem);
        }
        if (preserveSelection) {
            int count = comboBox2.getItemCount();
            for (int i = 0; i < count; ++i) {
                T item = comboBox2.getItemAt(i);
                if (!ComparatorUtil.equalsNullable((Object)itemToSelect, item)) continue;
                comboBox2.setSelectedIndex(i);
                break;
            }
        }
    }

    private static <T> boolean shouldUpdate(@NotNull JComboBox<T> comboBox2, @NotNull List<? extends T> newItems) {
        if (comboBox2 == null) {
            SwingHelper.$$$reportNull$$$0(29);
        }
        if (newItems == null) {
            SwingHelper.$$$reportNull$$$0(30);
        }
        int count = comboBox2.getItemCount();
        if (newItems.size() != count) {
            return true;
        }
        for (int i = 0; i < count; ++i) {
            T newItem;
            T oldItem = comboBox2.getItemAt(i);
            if (ComparatorUtil.equalsNullable(oldItem, newItem = newItems.get(i))) continue;
            return true;
        }
        return false;
    }

    public static void setNoBorderCellRendererFor(@NotNull TableColumn column) {
        if (column == null) {
            SwingHelper.$$$reportNull$$$0(31);
        }
        final TableCellRenderer previous = column.getCellRenderer();
        column.setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row2, int column) {
                Component component = previous != null ? previous.getTableCellRendererComponent(table, value, isSelected, false, row2, column) : super.getTableCellRendererComponent(table, value, isSelected, false, row2, column);
                if (component instanceof JComponent) {
                    ((JComponent)component).setBorder(null);
                }
                return component;
            }
        });
    }

    public static void addHistoryOnExpansion(final @NotNull TextFieldWithHistory textFieldWithHistory, final @NotNull NotNullProducer<? extends List<String>> historyProvider) {
        if (textFieldWithHistory == null) {
            SwingHelper.$$$reportNull$$$0(32);
        }
        if (historyProvider == null) {
            SwingHelper.$$$reportNull$$$0(33);
        }
        textFieldWithHistory.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                List history = (List)historyProvider.produce();
                SwingHelper.setHistory(textFieldWithHistory, ContainerUtil.notNullize((List)history), true);
                textFieldWithHistory.removePopupMenuListener((PopupMenuListener)this);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
    }

    public static void setHistory(@NotNull TextFieldWithHistory textFieldWithHistory, @NotNull List<String> history, boolean mergeWithPrevHistory) {
        if (textFieldWithHistory == null) {
            SwingHelper.$$$reportNull$$$0(34);
        }
        if (history == null) {
            SwingHelper.$$$reportNull$$$0(35);
        }
        HashSet newHistorySet = ContainerUtil.newHashSet(history);
        List prevHistory = textFieldWithHistory.getHistory();
        ArrayList mergedHistory = ContainerUtil.newArrayListWithCapacity((int)history.size());
        if (mergeWithPrevHistory) {
            for (String item : prevHistory) {
                if (newHistorySet.contains(item)) continue;
                mergedHistory.add(item);
            }
        }
        mergedHistory.addAll(history);
        String oldText = StringUtil.notNullize((String)textFieldWithHistory.getText());
        String oldSelectedItem = (String)ObjectUtils.tryCast((Object)textFieldWithHistory.getSelectedItem(), String.class);
        if (!mergedHistory.contains(oldSelectedItem)) {
            oldSelectedItem = null;
        }
        textFieldWithHistory.setHistory((List)mergedHistory);
        SwingHelper.setLongestAsPrototype((JComboBox)textFieldWithHistory, mergedHistory);
        if (oldSelectedItem != null) {
            textFieldWithHistory.setSelectedItem((Object)oldSelectedItem);
        }
        if (!oldText.equals(oldSelectedItem)) {
            textFieldWithHistory.setText(oldText);
        }
    }

    public static void setLongestAsPrototype(@NotNull JComboBox comboBox2, @NotNull List<String> variants) {
        if (comboBox2 == null) {
            SwingHelper.$$$reportNull$$$0(36);
        }
        if (variants == null) {
            SwingHelper.$$$reportNull$$$0(37);
        }
        Object prototypeDisplayValue = comboBox2.getPrototypeDisplayValue();
        String prototypeDisplayValueStr = null;
        if (prototypeDisplayValue instanceof String) {
            prototypeDisplayValueStr = (String)prototypeDisplayValue;
        } else if (prototypeDisplayValue != null) {
            return;
        }
        String longest = StringUtil.notNullize((String)prototypeDisplayValueStr);
        boolean updated = false;
        for (String s : variants) {
            if (longest.length() >= s.length()) continue;
            longest = s;
            updated = true;
        }
        if (updated) {
            comboBox2.setPrototypeDisplayValue(longest);
        }
    }

    public static void installFileCompletionAndBrowseDialog(@Nullable Project project, @NotNull TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String browseDialogTitle, @NotNull FileChooserDescriptor fileChooserDescriptor2) {
        if (textFieldWithHistoryWithBrowseButton == null) {
            SwingHelper.$$$reportNull$$$0(38);
        }
        if (browseDialogTitle == null) {
            SwingHelper.$$$reportNull$$$0(39);
        }
        if (fileChooserDescriptor2 == null) {
            SwingHelper.$$$reportNull$$$0(40);
        }
        SwingHelper.doInstall(project, textFieldWithHistoryWithBrowseButton, ((TextFieldWithHistory)textFieldWithHistoryWithBrowseButton.getChildComponent()).getTextEditor(), browseDialogTitle, fileChooserDescriptor2, TextComponentAccessor.TEXT_FIELD_WITH_HISTORY_WHOLE_TEXT);
    }

    public static void installFileCompletionAndBrowseDialog(@Nullable Project project, @NotNull TextFieldWithBrowseButton textFieldWithBrowseButton, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String browseDialogTitle, @NotNull FileChooserDescriptor fileChooserDescriptor2) {
        if (textFieldWithBrowseButton == null) {
            SwingHelper.$$$reportNull$$$0(41);
        }
        if (browseDialogTitle == null) {
            SwingHelper.$$$reportNull$$$0(42);
        }
        if (fileChooserDescriptor2 == null) {
            SwingHelper.$$$reportNull$$$0(43);
        }
        SwingHelper.doInstall(project, textFieldWithBrowseButton, textFieldWithBrowseButton.getTextField(), browseDialogTitle, fileChooserDescriptor2, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
    }

    private static <T extends JComponent> void doInstall(@Nullable Project project, @NotNull ComponentWithBrowseButton<T> componentWithBrowseButton, @NotNull JTextField textField2, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String browseDialogTitle, @NotNull FileChooserDescriptor fileChooserDescriptor2, @NotNull TextComponentAccessor<T> textComponentAccessor) {
        if (componentWithBrowseButton == null) {
            SwingHelper.$$$reportNull$$$0(44);
        }
        if (textField2 == null) {
            SwingHelper.$$$reportNull$$$0(45);
        }
        if (browseDialogTitle == null) {
            SwingHelper.$$$reportNull$$$0(46);
        }
        if (fileChooserDescriptor2 == null) {
            SwingHelper.$$$reportNull$$$0(47);
        }
        if (textComponentAccessor == null) {
            SwingHelper.$$$reportNull$$$0(48);
        }
        ComponentsKt.installFileCompletionAndBrowseDialog(project, componentWithBrowseButton, textField2, browseDialogTitle, fileChooserDescriptor2.withShowHiddenFiles(SystemInfo.isUnix), textComponentAccessor);
    }

    @NotNull
    public static HyperlinkLabel createWebHyperlink(@NotNull String url) {
        if (url == null) {
            SwingHelper.$$$reportNull$$$0(49);
        }
        HyperlinkLabel hyperlinkLabel = SwingHelper.createWebHyperlink(url, url);
        if (hyperlinkLabel == null) {
            SwingHelper.$$$reportNull$$$0(50);
        }
        return hyperlinkLabel;
    }

    @NotNull
    public static HyperlinkLabel createWebHyperlink(@NotNull String text, @NotNull String url) {
        if (text == null) {
            SwingHelper.$$$reportNull$$$0(51);
        }
        if (url == null) {
            SwingHelper.$$$reportNull$$$0(52);
        }
        HyperlinkLabel hyperlink = new HyperlinkLabel(text);
        hyperlink.setHyperlinkTarget(url);
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)new OpenLinkInBrowser(url));
        actionGroup.add((AnAction)new CopyLinkAction(url));
        hyperlink.setComponentPopupMenu(ActionManager.getInstance().createActionPopupMenu("web hyperlink", (ActionGroup)actionGroup).getComponent());
        HyperlinkLabel hyperlinkLabel = hyperlink;
        if (hyperlinkLabel == null) {
            SwingHelper.$$$reportNull$$$0(53);
        }
        return hyperlinkLabel;
    }

    public static void setPreferredWidth(@NotNull Component component, int width) {
        if (component == null) {
            SwingHelper.$$$reportNull$$$0(54);
        }
        Dimension preferredSize = component.getPreferredSize();
        preferredSize.width = width;
        component.setPreferredSize(preferredSize);
    }

    public static boolean scrollToReference(JEditorPane view, String reference) {
        reference = StringUtil.trimStart((String)reference, (String)"#");
        List<String> toCheck = Arrays.asList("a", "h1", "h2", "h3", "h4");
        Document document = view.getDocument();
        if (document instanceof HTMLDocument) {
            ArrayList list2 = new ArrayList();
            for (Element root : document.getRootElements()) {
                SwingHelper.getAllElements(root, list2, toCheck);
            }
            for (Element element : list2) {
                AttributeSet attributes = element.getAttributes();
                String nm = (String)attributes.getAttribute(HTML.Attribute.NAME);
                if (nm == null) {
                    nm = (String)attributes.getAttribute(HTML.Attribute.ID);
                }
                if (nm == null || !nm.equals(reference)) continue;
                try {
                    int pos = element.getStartOffset();
                    Rectangle r = view.modelToView(pos);
                    if (r == null) continue;
                    Rectangle vis = view.getVisibleRect();
                    r.y -= 5;
                    r.height = vis.height;
                    view.scrollRectToVisible(r);
                    return true;
                }
                catch (BadLocationException badLocationException) {
                }
            }
        }
        return false;
    }

    private static void getAllElements(Element root, List<? super Element> list2, List<String> toCheck) {
        if (toCheck.contains(root.getName().toLowerCase(Locale.US))) {
            list2.add(root);
        }
        for (int i = 0; i < root.getElementCount(); ++i) {
            SwingHelper.getAllElements(root.getElement(i), list2, toCheck);
        }
    }

    @NotNull
    public static JEditorPane createHtmlViewer(boolean lineWrap, @Nullable Font font, @Nullable Color background, @Nullable Color foreground) {
        JEditorPane textPane = lineWrap ? new JEditorPane(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = 0;
                return dimension;
            }
        } : new JEditorPane();
        UISettings.setupComponentAntialiasing((JComponent)textPane);
        textPane.setFont(font != null ? font : UIUtil.getLabelFont());
        textPane.setEditorKit(UIUtil.getHTMLEditorKit());
        textPane.setEditable(false);
        if (background != null) {
            textPane.setBackground(background);
        } else {
            NonOpaquePanel.setTransparent((JComponent)textPane);
        }
        textPane.setForeground(foreground != null ? foreground : UIUtil.getLabelForeground());
        textPane.setFocusable(false);
        JEditorPane jEditorPane = textPane;
        if (jEditorPane == null) {
            SwingHelper.$$$reportNull$$$0(55);
        }
        return jEditorPane;
    }

    public static void setHtml(@NotNull JEditorPane editorPane, @NotNull String bodyInnerHtml, @Nullable Color foregroundColor) {
        if (editorPane == null) {
            SwingHelper.$$$reportNull$$$0(56);
        }
        if (bodyInnerHtml == null) {
            SwingHelper.$$$reportNull$$$0(57);
        }
        editorPane.setText(SwingHelper.buildHtml(UIUtil.getCssFontDeclaration((Font)editorPane.getFont(), (Color)foregroundColor, (Color)JBUI.CurrentTheme.Link.linkColor(), null), bodyInnerHtml));
    }

    @NotNull
    public static String buildHtml(@NotNull String headInnerHtml, @NotNull String bodyInnedHtml) {
        if (headInnerHtml == null) {
            SwingHelper.$$$reportNull$$$0(58);
        }
        if (bodyInnedHtml == null) {
            SwingHelper.$$$reportNull$$$0(59);
        }
        String string = "<html><head>" + headInnerHtml + "</head><body>" + bodyInnedHtml + "</body></html>";
        if (string == null) {
            SwingHelper.$$$reportNull$$$0(60);
        }
        return string;
    }

    @NotNull
    public static TextFieldWithHistoryWithBrowseButton createTextFieldWithHistoryWithBrowseButton(@Nullable Project project, @NotNull String browseDialogTitle, @NotNull FileChooserDescriptor fileChooserDescriptor2, @Nullable NotNullProducer<? extends List<String>> historyProvider) {
        if (browseDialogTitle == null) {
            SwingHelper.$$$reportNull$$$0(61);
        }
        if (fileChooserDescriptor2 == null) {
            SwingHelper.$$$reportNull$$$0(62);
        }
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = ComponentsKt.textFieldWithHistoryWithBrowseButton(project, browseDialogTitle, fileChooserDescriptor2, (Function0<? extends List<String>>)(historyProvider == null ? null : () -> (List)historyProvider.produce()));
        if (textFieldWithHistoryWithBrowseButton == null) {
            SwingHelper.$$$reportNull$$$0(63);
        }
        return textFieldWithHistoryWithBrowseButton;
    }

    @NotNull
    public static <C extends JComponent> ComponentWithBrowseButton<C> wrapWithInfoButton(@NotNull C component, @NotNull String infoButtonTooltip, @NotNull ActionListener listener2) {
        if (component == null) {
            SwingHelper.$$$reportNull$$$0(64);
        }
        if (infoButtonTooltip == null) {
            SwingHelper.$$$reportNull$$$0(65);
        }
        if (listener2 == null) {
            SwingHelper.$$$reportNull$$$0(66);
        }
        ComponentWithBrowseButton comp = new ComponentWithBrowseButton(component, listener2);
        FixedSizeButton uiHelpButton = comp.getButton();
        uiHelpButton.setToolTipText(infoButtonTooltip);
        uiHelpButton.setIcon(UIUtil.getBalloonInformationIcon());
        uiHelpButton.setHorizontalAlignment(0);
        uiHelpButton.setVerticalAlignment(0);
        ComponentWithBrowseButton componentWithBrowseButton = comp;
        if (componentWithBrowseButton == null) {
            SwingHelper.$$$reportNull$$$0(67);
        }
        return componentWithBrowseButton;
    }

    public static String truncateStringWithEllipsis(String text, int maxWidth, final FontMetrics fm) {
        return SwingHelper.truncateStringWithEllipsis(text, maxWidth, new WidthCalculator(){

            @Override
            public int stringWidth(String s) {
                return fm.stringWidth(s);
            }

            @Override
            public int charWidth(char c) {
                return fm.charWidth(c);
            }
        });
    }

    public static String truncateStringWithEllipsis(@NotNull String text, int maxWidth, WidthCalculator fm) {
        if (text == null) {
            SwingHelper.$$$reportNull$$$0(68);
        }
        int error = fm.stringWidth(ERROR_STR);
        int wholeWidth = fm.stringWidth(text) + error;
        if (wholeWidth <= maxWidth || text.isEmpty()) {
            return text;
        }
        int ellipsisWidth = fm.stringWidth(ELLIPSIS) + error;
        if (ellipsisWidth >= maxWidth) {
            return ELLIPSIS;
        }
        int availableWidth = maxWidth - ellipsisWidth;
        int currentLen = (int)Math.floor((double)availableWidth / ((double)wholeWidth / (double)text.length()));
        String currentSubstring = text.substring(0, currentLen);
        int realWidth = fm.stringWidth(currentSubstring);
        if (realWidth >= availableWidth) {
            int delta = 0;
            for (int i = currentLen - 1; i >= 0; --i) {
                if (realWidth - delta < availableWidth) {
                    return text.substring(0, i) + ELLIPSIS;
                }
                delta += fm.charWidth(currentSubstring.charAt(i));
            }
            return text.substring(0, 1) + ELLIPSIS;
        }
        int delta = 0;
        for (int i = currentLen; i < text.length(); ++i) {
            if (realWidth + delta >= availableWidth) {
                return text.substring(0, i) + ELLIPSIS;
            }
            delta += fm.charWidth(text.charAt(i));
        }
        return text.substring(0, currentLen) + ELLIPSIS;
    }

    public static JEditorPane createHtmlLabel(@NotNull String innerHtml, @Nullable String disabledHtml, final @Nullable Consumer<? super String> hyperlinkListener) {
        if (innerHtml == null) {
            SwingHelper.$$$reportNull$$$0(69);
        }
        disabledHtml = disabledHtml == null ? innerHtml : disabledHtml;
        Font font = UIUtil.getLabelFont();
        String html = SwingHelper.buildHtml(UIUtil.getCssFontDeclaration((Font)font, (Color)UIUtil.getActiveTextColor(), null, null), innerHtml);
        String disabled = SwingHelper.buildHtml(UIUtil.getCssFontDeclaration((Font)font, (Color)UIUtil.getInactiveTextColor(), null, null), disabledHtml);
        JEditorPane pane = new HtmlViewerBuilder().setCarryTextOver(false).setFont(UIUtil.getLabelFont()).setDisabledHtml(disabled).create();
        pane.setText(html);
        pane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    if (hyperlinkListener != null) {
                        hyperlinkListener.consume((Object)(e.getURL() == null ? "" : e.getURL().toString()));
                    } else {
                        BrowserUtil.browse((URL)e.getURL());
                    }
                }
            }
        });
        return pane;
    }

    @Nullable
    public static Component getComponentFromRecentMouseEvent() {
        MouseEvent mouseEvent;
        Component component;
        AWTEvent event = IdeEventQueue.getInstance().getTrueCurrentEvent();
        if (event instanceof MouseEvent && (component = (mouseEvent = (MouseEvent)event).getComponent()) != null && (component = SwingUtilities.getDeepestComponentAt(component, mouseEvent.getX(), mouseEvent.getY())) != null) {
            if (component instanceof JTabbedPane) {
                mouseEvent = SwingUtilities.convertMouseEvent(mouseEvent.getComponent(), mouseEvent, component);
                JTabbedPane tabbedPane = (JTabbedPane)component;
                int index = tabbedPane.getUI().tabForCoordinate(tabbedPane, mouseEvent.getX(), mouseEvent.getY());
                if (index != -1) {
                    return tabbedPane.getComponentAt(index);
                }
            }
            return component;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/SwingHelper";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 25: 
            case 54: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 17: 
            case 19: 
            case 22: 
            case 51: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialogWrapper";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 27: 
            case 29: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comboBox";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newItems";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textFieldWithHistory";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "historyProvider";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "history";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variants";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textFieldWithHistoryWithBrowseButton";
                break;
            }
            case 39: 
            case 42: 
            case 46: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browseDialogTitle";
                break;
            }
            case 40: 
            case 43: 
            case 47: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileChooserDescriptor";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textFieldWithBrowseButton";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentWithBrowseButton";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textComponentAccessor";
                break;
            }
            case 49: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorPane";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bodyInnerHtml";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "headInnerHtml";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bodyInnedHtml";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoButtonTooltip";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "innerHtml";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "newVerticalPanel";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "newLeftAlignedVerticalPanel";
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/SwingHelper";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "newHorizontalPanel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithoutStretch";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithHorizontalStretch";
                break;
            }
            case 50: 
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "createWebHyperlink";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "createHtmlViewer";
                break;
            }
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "buildHtml";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "createTextFieldWithHistoryWithBrowseButton";
                break;
            }
            case 67: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapWithInfoButton";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "newLeftAlignedVerticalPanel";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "newVerticalPanel";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithoutStretch";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithHorizontalStretch";
                break;
            }
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setPreferredWidthToFitText";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setPreferredWidthForComponentWithBrowseButton";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "setPreferredSizeToFitText";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "calcWidthToFitText";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "adjustDialogSizeToFitPreferredSize";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "resizeDialogToFitTextFor";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "doWithDialogWrapper";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "updateItems";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "shouldUpdate";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "setNoBorderCellRendererFor";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addHistoryOnExpansion";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "setHistory";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "setLongestAsPrototype";
                break;
            }
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "installFileCompletionAndBrowseDialog";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "doInstall";
                break;
            }
            case 49: 
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "createWebHyperlink";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "setPreferredWidth";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "setHtml";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "buildHtml";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "createTextFieldWithHistoryWithBrowseButton";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "wrapWithInfoButton";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "truncateStringWithEllipsis";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "createHtmlLabel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 68: 
            case 69: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface WidthCalculator {
        public int stringWidth(String var1);

        public int charWidth(char var1);
    }

    private static class OpenLinkInBrowser
    extends AnAction {
        private final String myUrl;

        private OpenLinkInBrowser(@NotNull String url) {
            if (url == null) {
                OpenLinkInBrowser.$$$reportNull$$$0(0);
            }
            super("Open Link in Browser", null, PlatformIcons.WEB_ICON);
            this.myUrl = url;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                OpenLinkInBrowser.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(true);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                OpenLinkInBrowser.$$$reportNull$$$0(2);
            }
            BrowserUtil.browse((String)this.myUrl);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/ui/SwingHelper$OpenLinkInBrowser";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class CopyLinkAction
    extends AnAction {
        private final String myUrl;

        private CopyLinkAction(@NotNull String url) {
            if (url == null) {
                CopyLinkAction.$$$reportNull$$$0(0);
            }
            super("Copy Link Address", null, PlatformIcons.COPY_ICON);
            this.myUrl = url;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                CopyLinkAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(true);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                CopyLinkAction.$$$reportNull$$$0(2);
            }
            StringSelection content = new StringSelection(this.myUrl);
            CopyPasteManager.getInstance().setContents((Transferable)content);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "url";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/ui/SwingHelper$CopyLinkAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class HtmlViewerBuilder {
        private boolean myCarryTextOver;
        private String myDisabledHtml;
        private Font myFont;
        private Color myBackground;
        private Color myForeground;

        public JEditorPane create() {
            JEditorPane textPane = new JEditorPane(){
                private boolean myEnabled = true;
                private String myEnabledHtml;

                @Override
                public Dimension getPreferredSize() {
                    Dimension dimension = super.getPreferredSize();
                    if (myCarryTextOver) {
                        dimension.width = 0;
                    }
                    return dimension;
                }

                @Override
                public void setText(String t) {
                    if (myDisabledHtml != null && this.myEnabled) {
                        this.myEnabledHtml = t;
                    }
                    super.setText(t);
                }

                @Override
                public void setEnabled(boolean enabled) {
                    if (myDisabledHtml != null) {
                        this.myEnabled = enabled;
                        if (this.myEnabled) {
                            this.setText(this.myEnabledHtml);
                        } else {
                            this.setText(myDisabledHtml);
                        }
                        super.setEnabled(true);
                    } else {
                        super.setEnabled(enabled);
                    }
                }
            };
            textPane.setFont(this.myFont != null ? this.myFont : UIUtil.getLabelFont());
            textPane.setContentType("text/html");
            textPane.setEditable(false);
            if (this.myBackground != null) {
                textPane.setBackground(this.myBackground);
            } else {
                textPane.setOpaque(false);
            }
            textPane.setForeground(this.myForeground != null ? this.myForeground : UIUtil.getLabelForeground());
            textPane.setFocusable(false);
            return textPane;
        }

        public HtmlViewerBuilder setCarryTextOver(boolean carryTextOver) {
            this.myCarryTextOver = carryTextOver;
            return this;
        }

        public HtmlViewerBuilder setDisabledHtml(String disabledHtml) {
            this.myDisabledHtml = disabledHtml;
            return this;
        }

        public HtmlViewerBuilder setFont(Font font) {
            this.myFont = font;
            return this;
        }

        public HtmlViewerBuilder setBackground(Color background) {
            this.myBackground = background;
            return this;
        }

        public HtmlViewerBuilder setForeground(Color foreground) {
            this.myForeground = foreground;
            return this;
        }
    }
}

