/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.download.impl;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.download.DownloadableFileDescription;
import com.intellij.util.text.UniqueNameGenerator;
import org.jetbrains.annotations.NotNull;

public class DownloadableFileDescriptionImpl
implements DownloadableFileDescription {
    private final String myFileName;
    private final String myFileExtension;
    private final String myDownloadUrl;

    public DownloadableFileDescriptionImpl(@NotNull String downloadUrl, @NotNull String fileName2, @NotNull String fileExtension) {
        if (downloadUrl == null) {
            DownloadableFileDescriptionImpl.$$$reportNull$$$0(0);
        }
        if (fileName2 == null) {
            DownloadableFileDescriptionImpl.$$$reportNull$$$0(1);
        }
        if (fileExtension == null) {
            DownloadableFileDescriptionImpl.$$$reportNull$$$0(2);
        }
        this.myFileName = fileName2;
        this.myFileExtension = fileExtension.length() > 0 && !fileExtension.startsWith(".") ? "." + fileExtension : fileExtension;
        this.myDownloadUrl = downloadUrl;
    }

    @NotNull
    public String getDownloadUrl() {
        String string = this.myDownloadUrl;
        if (string == null) {
            DownloadableFileDescriptionImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getPresentableFileName() {
        String string = this.myFileName + this.myFileExtension;
        if (string == null) {
            DownloadableFileDescriptionImpl.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getPresentableDownloadUrl() {
        String string = this.myDownloadUrl;
        if (string == null) {
            DownloadableFileDescriptionImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    public String getDefaultFileName() {
        String string = this.generateFileName((Condition<String>)Conditions.alwaysTrue());
        if (string == null) {
            DownloadableFileDescriptionImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String generateFileName(@NotNull Condition<String> validator) {
        if (validator == null) {
            DownloadableFileDescriptionImpl.$$$reportNull$$$0(7);
        }
        String string = UniqueNameGenerator.generateUniqueName((String)"", (String)this.myFileName, (String)this.myFileExtension, (String)"_", (String)"", validator);
        if (string == null) {
            DownloadableFileDescriptionImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DownloadableFileDescriptionImpl that = (DownloadableFileDescriptionImpl)o;
        return this.myDownloadUrl.equals(that.myDownloadUrl);
    }

    public int hashCode() {
        return this.myDownloadUrl.hashCode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "downloadUrl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileExtension";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/download/impl/DownloadableFileDescriptionImpl";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/download/impl/DownloadableFileDescriptionImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDownloadUrl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableFileName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableDownloadUrl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultFileName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "generateFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generateFileName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

