/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.win;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.CommandProcessorEx;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.PathChooserDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.PathChooserDialogHelper;
import com.intellij.ui.UIBundle;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ui.OwnerOptional;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.File;
import java.lang.ref.WeakReference;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WinPathChooserDialog
implements PathChooserDialog,
FileChooserDialog {
    private FileDialog myFileDialog;
    private final FileChooserDescriptor myFileChooserDescriptor;
    private final WeakReference<Component> myParent;
    private final Project myProject;
    private final String myTitle;
    private VirtualFile[] virtualFiles;
    private final PathChooserDialogHelper myHelper;

    public WinPathChooserDialog(FileChooserDescriptor descriptor, Component parent, Project project) {
        this.myHelper = new PathChooserDialogHelper(descriptor);
        this.myFileChooserDescriptor = descriptor;
        this.myParent = new WeakReference<Component>(parent);
        this.myProject = project;
        this.myTitle = WinPathChooserDialog.getChooserTitle(descriptor);
        Consumer dialogConsumer = owner -> {
            this.myFileDialog = new FileDialog((Dialog)owner, this.myTitle, 0);
        };
        Consumer frameConsumer = owner -> {
            this.myFileDialog = new FileDialog((Frame)owner, this.myTitle, 0);
        };
        OwnerOptional.fromComponent(parent).ifDialog((Consumer<? super Dialog>)dialogConsumer).ifFrame((Consumer<? super Frame>)frameConsumer).ifNull((Consumer<? super Frame>)frameConsumer);
    }

    private static String getChooserTitle(FileChooserDescriptor descriptor) {
        String title = descriptor.getTitle();
        return title != null ? title : UIBundle.message((String)"file.chooser.default.title", (Object[])new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void choose(@Nullable VirtualFile toSelect2, @NotNull Consumer<? super List<VirtualFile>> callback2) {
        boolean appStarted;
        if (callback2 == null) {
            WinPathChooserDialog.$$$reportNull$$$0(0);
        }
        if (toSelect2 != null && toSelect2.getParent() != null) {
            String directoryName;
            String fileName2 = null;
            if (toSelect2.isDirectory()) {
                directoryName = toSelect2.getCanonicalPath();
            } else {
                directoryName = toSelect2.getParent().getCanonicalPath();
                fileName2 = toSelect2.getPath();
            }
            this.myFileDialog.setDirectory(directoryName);
            this.myFileDialog.setFile(fileName2);
        }
        this.myFileDialog.setFilenameFilter((dir, name) -> {
            File file2 = new File(dir, name);
            return this.myFileChooserDescriptor.isFileSelectable(this.myHelper.fileToVirtualFile(file2));
        });
        this.myFileDialog.setMultipleMode(this.myFileChooserDescriptor.isChooseMultiple());
        CommandProcessorEx commandProcessor = ApplicationManager.getApplication() != null ? (CommandProcessorEx)CommandProcessor.getInstance() : null;
        boolean bl = appStarted = commandProcessor != null;
        if (appStarted) {
            commandProcessor.enterModal();
            LaterInvocator.enterModal(this.myFileDialog);
        }
        Component parent = (Component)this.myParent.get();
        try {
            this.myFileDialog.setVisible(true);
        }
        finally {
            if (appStarted) {
                commandProcessor.leaveModal();
                LaterInvocator.leaveModal(this.myFileDialog);
                if (parent != null) {
                    parent.requestFocus();
                }
            }
        }
        Object[] files2 = this.myFileDialog.getFiles();
        List<VirtualFile> virtualFileList = this.myHelper.getChosenFiles((File[])files2);
        this.virtualFiles = virtualFileList.toArray(VirtualFile.EMPTY_ARRAY);
        if (!virtualFileList.isEmpty()) {
            try {
                if (virtualFileList.size() == 1) {
                    this.myFileChooserDescriptor.isFileSelectable(virtualFileList.get(0));
                }
                this.myFileChooserDescriptor.validateSelectedFiles(this.virtualFiles);
            }
            catch (Exception e) {
                if (parent == null) {
                    Messages.showErrorDialog((Project)this.myProject, (String)e.getMessage(), (String)this.myTitle);
                } else {
                    Messages.showErrorDialog((Component)parent, (String)e.getMessage(), (String)this.myTitle);
                }
                return;
            }
            if (!ArrayUtil.isEmpty((Object[])files2)) {
                callback2.consume(virtualFileList);
            } else if (callback2 instanceof FileChooser.FileChooserConsumer) {
                ((FileChooser.FileChooserConsumer)callback2).cancelled();
            }
        }
    }

    @NotNull
    private static FileDialog createFileDialogWithoutOwner(String title, int load2) {
        FileDialog fileDialog = new FileDialog((Frame)null, title, load2);
        if (fileDialog == null) {
            WinPathChooserDialog.$$$reportNull$$$0(1);
        }
        return fileDialog;
    }

    @NotNull
    public VirtualFile[] choose(@Nullable VirtualFile toSelect2, @Nullable Project project) {
        this.choose(toSelect2, (Consumer<? super List<VirtualFile>>)((Consumer)files2 -> {}));
        if (this.virtualFiles == null) {
            WinPathChooserDialog.$$$reportNull$$$0(2);
        }
        return this.virtualFiles;
    }

    @NotNull
    public VirtualFile[] choose(@Nullable Project project, VirtualFile ... toSelect2) {
        if (toSelect2 == null) {
            WinPathChooserDialog.$$$reportNull$$$0(3);
        }
        VirtualFile[] virtualFileArray = this.choose(toSelect2.length > 0 ? toSelect2[0] : null, project);
        if (virtualFileArray == null) {
            WinPathChooserDialog.$$$reportNull$$$0(4);
        }
        return virtualFileArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/win/WinPathChooserDialog";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toSelect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/win/WinPathChooserDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileDialogWithoutOwner";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "choose";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "choose";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

