/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.mac.touchbar;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.ui.mac.foundation.ID;
import com.intellij.ui.mac.touchbar.NSAutoreleaseLock;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public class Utils {
    private static final Logger LOG = Logger.getInstance(Utils.class);
    private static final String TB_SERVER_PROCESS = SystemInfo.isMacOSHighSierra ? "TouchBarServer" : "TouchBarAgent";

    public static boolean isTouchBarServerRunning() {
        GeneralCommandLine cmdLine = new GeneralCommandLine(new String[]{"pgrep", TB_SERVER_PROCESS});
        try {
            ProcessOutput out = ExecUtil.execAndGetOutput((GeneralCommandLine)cmdLine);
            return !out.getStdout().isEmpty();
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
            return false;
        }
    }

    public static boolean restartTouchBarServer() {
        try {
            ProcessOutput out = ExecUtil.sudoAndGetOutput((GeneralCommandLine)new GeneralCommandLine(new String[]{"pkill", TB_SERVER_PROCESS}), (String)"");
            return out.getStderr().isEmpty();
        }
        catch (ExecutionException e) {
            LOG.error((Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        return false;
    }

    public static String getAppId() {
        try {
            ApplicationInfoEx appEx = ApplicationInfoImpl.getInstanceEx();
            if (appEx == null) {
                return null;
            }
        }
        catch (Throwable e) {
            LOG.debug(e);
            return null;
        }
        String appId = null;
        try (NSAutoreleaseLock lock = new NSAutoreleaseLock();){
            ID bundle = Foundation.invoke((String)"NSBundle", (String)"mainBundle", (Object[])new Object[0]);
            ID dict = Foundation.invoke((ID)bundle, (String)"infoDictionary", (Object[])new Object[0]);
            ID nsAppID = Foundation.invoke((ID)dict, (String)"objectForKey:", (Object[])new Object[]{Foundation.nsString((String)"CFBundleIdentifier")});
            appId = Foundation.toStringViaUTF8((ID)nsAppID);
        }
        if (appId == null || appId.isEmpty()) {
            LOG.error("can't obtain application id from NSBundle.mainBundle");
        }
        return appId;
    }

    @Nullable
    static ModalityState getCurrentModalityState() {
        return ApplicationManager.getApplication() != null ? LaterInvocator.getCurrentModalityState() : null;
    }
}

