/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.progress.util.PotemkinProgress;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.FieldAccessor;
import com.intellij.util.MethodInvocator;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.peer.ComponentPeer;
import javax.swing.event.MouseInputListener;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import sun.awt.AWTAccessor;

abstract class WindowMouseListener
extends MouseAdapter
implements MouseInputListener {
    protected final Component myContent;
    @JdkConstants.CursorType
    int myCursorType;
    protected static boolean ourIsResizing;
    private Point myLocation;
    private Rectangle myViewBounds;
    private boolean wasDragged;

    WindowMouseListener(Component content) {
        this.myContent = content;
    }

    @JdkConstants.CursorType
    abstract int getCursorType(Component var1, Point var2);

    abstract void updateBounds(Rectangle var1, Component var2, int var3, int var4);

    @Override
    public void mouseMoved(MouseEvent event) {
        this.update(event, false);
    }

    @Override
    public void mousePressed(MouseEvent event) {
        this.update(event, true);
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        this.process(event, false);
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        this.process(event, true);
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        this.process(event, true);
    }

    protected boolean isDisabled(Component view) {
        if (view instanceof Frame) {
            int state = ((Frame)view).getExtendedState();
            if (WindowMouseListener.isStateSet(1, state)) {
                return true;
            }
            if (WindowMouseListener.isStateSet(6, state)) {
                return true;
            }
        }
        return false;
    }

    private void update(MouseEvent event, boolean start2) {
        Component content;
        Component view;
        if (event.isConsumed()) {
            return;
        }
        if (start2) {
            this.wasDragged = false;
        }
        if (this.myLocation == null && (view = this.getView(content = this.getContent(event))) != null) {
            this.setCursorType(this.isDisabled(view) ? -1 : this.getCursorType(view, event.getLocationOnScreen()));
            this.setCursor(content, Cursor.getPredefinedCursor(this.myCursorType == -1 ? 0 : this.myCursorType));
            if (start2 && this.myCursorType != -1) {
                this.myLocation = event.getLocationOnScreen();
                this.myViewBounds = view.getBounds();
                event.consume();
            }
        }
    }

    protected void setCursorType(int cursorType) {
        this.myCursorType = cursorType;
    }

    private void process(MouseEvent event, boolean stop2) {
        if (event.isConsumed()) {
            return;
        }
        if (!stop2) {
            this.wasDragged = true;
        }
        if (this.myLocation != null && this.myViewBounds != null) {
            Component content = this.getContent(event);
            Component view = this.getView(content);
            if (view != null) {
                Rectangle bounds2 = new Rectangle(this.myViewBounds);
                int dx = event.getXOnScreen() - this.myLocation.x;
                int dy = event.getYOnScreen() - this.myLocation.y;
                if (this.myCursorType == 0 && view instanceof Frame) {
                    int state = ((Frame)view).getExtendedState();
                    if (WindowMouseListener.isStateSet(2, state)) {
                        dx = 0;
                    }
                    if (WindowMouseListener.isStateSet(4, state)) {
                        dy = 0;
                    }
                }
                this.updateBounds(bounds2, view, dx, dy);
                if (!bounds2.equals(view.getBounds())) {
                    this.setBounds(view, bounds2);
                }
            }
            if (stop2) {
                this.setCursor(content, Cursor.getPredefinedCursor(0));
                this.myLocation = null;
                if (this.wasDragged) {
                    this.myViewBounds = null;
                }
            }
            event.consume();
        } else if (stop2 && this.myViewBounds != null) {
            this.myViewBounds = null;
            event.consume();
        }
    }

    protected void setBounds(Component comp, Rectangle bounds2) {
        Rectangle compBounds = comp.getBounds();
        boolean moved = bounds2.x != compBounds.x || bounds2.y != compBounds.y;
        boolean resized = bounds2.width != compBounds.width || bounds2.height != compBounds.height;
        comp.setBounds(bounds2);
        comp.invalidate();
        comp.validate();
        comp.repaint();
        if (moved) {
            this.notifyMoved();
        }
        if (resized) {
            this.notifyResized();
        }
    }

    protected Component getContent(MouseEvent event) {
        return this.myContent != null ? this.myContent : event.getComponent();
    }

    protected Component getView(Component component) {
        return UIUtil.getWindow((Component)component);
    }

    protected void setCursor(Component content, Cursor cursor) {
        UIUtil.setCursor((Component)content, (Cursor)cursor);
    }

    public boolean isBusy() {
        return this.myLocation != null;
    }

    static boolean isStateSet(int mask, int state) {
        return mask == (mask & state);
    }

    protected void notifyMoved() {
    }

    protected void notifyResized() {
    }

    @ApiStatus.Experimental
    public static class ToolkitListenerHelper {
        private final WindowMouseListener myListener;
        private Class classWComponentPeer;
        private MethodInvocator reshapeInvocator;
        private FieldAccessor<Component, Integer> xAccessor;
        private FieldAccessor<Component, Integer> yAccessor;
        private FieldAccessor<Component, Integer> widthAccessor;
        private FieldAccessor<Component, Integer> heightAccessor;
        private MethodInvocator addMouseListenerMethod;
        private MethodInvocator addMouseMotionListenerMethod;
        private MethodInvocator removeMouseListenerMethod;
        private MethodInvocator removeMouseMotionListenerMethod;
        private ComponentAdapter pendingListener;

        public ToolkitListenerHelper(WindowMouseListener l) {
            this.myListener = l;
            if (SystemInfo.isWindows) {
                try {
                    this.classWComponentPeer = Class.forName("sun.awt.windows.WComponentPeer");
                    this.reshapeInvocator = new MethodInvocator(this.classWComponentPeer, "reshapeNoCheck", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE});
                    this.xAccessor = new FieldAccessor(Component.class, "x");
                    this.yAccessor = new FieldAccessor(Component.class, "y");
                    this.widthAccessor = new FieldAccessor(Component.class, "width");
                    this.heightAccessor = new FieldAccessor(Component.class, "height");
                    this.addMouseListenerMethod = new MethodInvocator(Class.forName("sun.awt.windows.WWindowPeer"), "addMouseListener", new Class[]{MouseListener.class});
                    this.addMouseMotionListenerMethod = new MethodInvocator(Class.forName("sun.awt.windows.WWindowPeer"), "addMouseMotionListener", new Class[]{MouseMotionListener.class});
                    this.removeMouseListenerMethod = new MethodInvocator(Class.forName("sun.awt.windows.WWindowPeer"), "removeMouseListener", new Class[]{MouseListener.class});
                    this.removeMouseMotionListenerMethod = new MethodInvocator(Class.forName("sun.awt.windows.WWindowPeer"), "removeMouseMotionListener", new Class[]{MouseMotionListener.class});
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
        }

        public void setCursor(Component content, Cursor cursor, Runnable defaultAction) {
            PotemkinProgress.invokeLaterNotBlocking(content, defaultAction);
        }

        public void setBounds(Component comp, Rectangle bounds2, Runnable defaultAction) {
            if (this.classWComponentPeer != null && this.classWComponentPeer.isInstance(ToolkitListenerHelper.getPeer(comp))) {
                this.reshapeInvocator.invoke((Object)ToolkitListenerHelper.getPeer(comp), new Object[]{bounds2.x, bounds2.y, bounds2.width, bounds2.height});
                this.xAccessor.set((Object)comp, (Object)bounds2.x);
                this.yAccessor.set((Object)comp, (Object)bounds2.y);
                this.widthAccessor.set((Object)comp, (Object)bounds2.width);
                this.heightAccessor.set((Object)comp, (Object)bounds2.height);
            } else {
                PotemkinProgress.invokeLaterNotBlocking(comp, defaultAction);
            }
        }

        public void addTo(Component comp) {
            boolean wasShown;
            if (this.methodsNotAvailable()) {
                return;
            }
            final Window window = UIUtil.getWindow((Component)comp);
            if (window == null) {
                return;
            }
            boolean bl = wasShown = ToolkitListenerHelper.getPeer(window) != null;
            if (wasShown) {
                this.addToImpl(window);
            }
            window.removeComponentListener(this.pendingListener);
            this.pendingListener = new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent event) {
                    if (!wasShown) {
                        this.addToImpl(window);
                    }
                }

                @Override
                public void componentHidden(ComponentEvent e) {
                    window.removeComponentListener(this);
                    this.removeFrom(window);
                }
            };
            window.addComponentListener(this.pendingListener);
        }

        public void removeFrom(Component comp) {
            if (this.methodsNotAvailable()) {
                return;
            }
            if (ToolkitListenerHelper.getPeer(comp = UIUtil.getWindow((Component)comp)) != null) {
                this.removeMouseListenerMethod.invoke((Object)ToolkitListenerHelper.getPeer(comp), new Object[]{this.myListener});
                this.removeMouseMotionListenerMethod.invoke((Object)ToolkitListenerHelper.getPeer(comp), new Object[]{this.myListener});
            }
            if (comp != null) {
                comp.removeComponentListener(this.pendingListener);
            }
        }

        private void addToImpl(Component comp) {
            if (this.methodsNotAvailable()) {
                return;
            }
            this.addMouseListenerMethod.invoke((Object)ToolkitListenerHelper.getPeer(comp), new Object[]{this.myListener});
            this.addMouseMotionListenerMethod.invoke((Object)ToolkitListenerHelper.getPeer(comp), new Object[]{this.myListener});
        }

        private boolean methodsNotAvailable() {
            return this.removeMouseListenerMethod == null || this.removeMouseMotionListenerMethod == null;
        }

        @Nullable
        public static ComponentPeer getPeer(@Nullable Component comp) {
            if (comp == null) {
                return null;
            }
            return AWTAccessor.getComponentAccessor().getPeer(comp);
        }
    }
}

