/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.impl;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.impl.TaskManagerImpl;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

@State(name="TaskProjectConfiguration")
public class TaskProjectConfiguration
implements PersistentStateComponent<TaskProjectConfiguration> {
    @Property(surroundWithTag=false)
    @XCollection(elementName="server")
    public List<SharedServer> servers = new ArrayList<SharedServer>();
    private final TaskManagerImpl myManager;

    public TaskProjectConfiguration() {
        this.myManager = null;
    }

    public TaskProjectConfiguration(TaskManagerImpl manager) {
        this.myManager = manager;
    }

    public TaskProjectConfiguration getState() {
        LinkedHashSet<SharedServer> set2 = new LinkedHashSet<SharedServer>(this.servers);
        for (TaskRepository repository : this.myManager.getAllRepositories()) {
            if (!repository.isShared()) continue;
            SharedServer server = new SharedServer();
            server.type = repository.getRepositoryType().getName();
            server.url = repository.getUrl();
            set2.add(server);
        }
        this.servers.clear();
        this.servers.addAll(set2);
        return this;
    }

    public void loadState(@NotNull TaskProjectConfiguration state) {
        if (state == null) {
            TaskProjectConfiguration.$$$reportNull$$$0(0);
        }
        this.servers.clear();
        for (SharedServer server : state.servers) {
            if (server.url == null || server.type == null) continue;
            this.servers.add(server);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/tasks/impl/TaskProjectConfiguration", "loadState"));
    }

    @Tag(value="server")
    public static class SharedServer {
        @Attribute(value="type")
        public String type;
        @Attribute(value="url")
        public String url;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SharedServer server = (SharedServer)o;
            if (this.type != null ? !this.type.equals(server.type) : server.type != null) {
                return false;
            }
            return !(this.url != null ? !this.url.equals(server.url) : server.url != null);
        }

        public int hashCode() {
            int result2 = this.type != null ? this.type.hashCode() : 0;
            result2 = 31 * result2 + (this.url != null ? this.url.hashCode() : 0);
            return result2;
        }
    }
}

