/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.remote.RemoteProcess;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.io.BaseOutputReader;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseRemoteProcessHandler<T extends RemoteProcess>
extends BaseProcessHandler<T> {
    private static final Logger LOG = Logger.getInstance(BaseRemoteProcessHandler.class);

    public BaseRemoteProcessHandler(@NotNull T process2, String commandLine, @Nullable Charset charset) {
        if (process2 == null) {
            BaseRemoteProcessHandler.$$$reportNull$$$0(0);
        }
        super(process2, commandLine, charset);
    }

    protected void destroyProcessImpl() {
        if (!((RemoteProcess)this.myProcess).killProcessTree()) {
            super.destroyProcessImpl();
        }
    }

    public void startNotify() {
        this.notifyTextAvailable(this.myCommandLine + '\n', ProcessOutputTypes.SYSTEM);
        this.addProcessListener((ProcessListener)new ProcessAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void startNotified(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    RemoteOutputReader stdoutReader = new RemoteOutputReader(((RemoteProcess)BaseRemoteProcessHandler.this.myProcess).getInputStream(), BaseRemoteProcessHandler.this.getCharset(), (RemoteProcess)BaseRemoteProcessHandler.this.myProcess, BaseRemoteProcessHandler.this.myCommandLine){

                        protected void onTextAvailable(@NotNull String text) {
                            if (text == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            BaseRemoteProcessHandler.this.notifyTextAvailable(text, ProcessOutputTypes.STDOUT);
                        }

                        @NotNull
                        protected Future<?> executeOnPooledThread(@NotNull Runnable runnable2) {
                            if (runnable2 == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            Future<?> future2 = BaseRemoteProcessHandler.this.executeTask(runnable2);
                            if (future2 == null) {
                                1.$$$reportNull$$$0(2);
                            }
                            return future2;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            RuntimeException runtimeException;
                            Object[] objectArray;
                            Object[] objectArray2;
                            int n2;
                            String string;
                            switch (n) {
                                default: {
                                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                    break;
                                }
                                case 2: {
                                    string = "@NotNull method %s.%s must not return null";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    n2 = 3;
                                    break;
                                }
                                case 2: {
                                    n2 = 2;
                                    break;
                                }
                            }
                            Object[] objectArray3 = new Object[n2];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "text";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "runnable";
                                    break;
                                }
                                case 2: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "com/intellij/remote/BaseRemoteProcessHandler$1$1";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "com/intellij/remote/BaseRemoteProcessHandler$1$1";
                                    break;
                                }
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "executeOnPooledThread";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray;
                                    objectArray[2] = "onTextAvailable";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray;
                                    objectArray[2] = "executeOnPooledThread";
                                    break;
                                }
                                case 2: {
                                    break;
                                }
                            }
                            String string2 = String.format(string, objectArray);
                            switch (n) {
                                default: {
                                    runtimeException = new IllegalArgumentException(string2);
                                    break;
                                }
                                case 2: {
                                    runtimeException = new IllegalStateException(string2);
                                    break;
                                }
                            }
                            throw runtimeException;
                        }
                    };
                    RemoteOutputReader stderrReader = new RemoteOutputReader(((RemoteProcess)BaseRemoteProcessHandler.this.myProcess).getErrorStream(), BaseRemoteProcessHandler.this.getCharset(), (RemoteProcess)BaseRemoteProcessHandler.this.myProcess, BaseRemoteProcessHandler.this.myCommandLine){

                        protected void onTextAvailable(@NotNull String text) {
                            if (text == null) {
                                2.$$$reportNull$$$0(0);
                            }
                            BaseRemoteProcessHandler.this.notifyTextAvailable(text, ProcessOutputTypes.STDERR);
                        }

                        @NotNull
                        protected Future<?> executeOnPooledThread(@NotNull Runnable runnable2) {
                            if (runnable2 == null) {
                                2.$$$reportNull$$$0(1);
                            }
                            Future<?> future2 = BaseRemoteProcessHandler.this.executeTask(runnable2);
                            if (future2 == null) {
                                2.$$$reportNull$$$0(2);
                            }
                            return future2;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            RuntimeException runtimeException;
                            Object[] objectArray;
                            Object[] objectArray2;
                            int n2;
                            String string;
                            switch (n) {
                                default: {
                                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                                    break;
                                }
                                case 2: {
                                    string = "@NotNull method %s.%s must not return null";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    n2 = 3;
                                    break;
                                }
                                case 2: {
                                    n2 = 2;
                                    break;
                                }
                            }
                            Object[] objectArray3 = new Object[n2];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "text";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "runnable";
                                    break;
                                }
                                case 2: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "com/intellij/remote/BaseRemoteProcessHandler$1$2";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "com/intellij/remote/BaseRemoteProcessHandler$1$2";
                                    break;
                                }
                                case 2: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "executeOnPooledThread";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray;
                                    objectArray[2] = "onTextAvailable";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray;
                                    objectArray[2] = "executeOnPooledThread";
                                    break;
                                }
                                case 2: {
                                    break;
                                }
                            }
                            String string2 = String.format(string, objectArray);
                            switch (n) {
                                default: {
                                    runtimeException = new IllegalArgumentException(string2);
                                    break;
                                }
                                case 2: {
                                    runtimeException = new IllegalStateException(string2);
                                    break;
                                }
                            }
                            throw runtimeException;
                        }
                    };
                    BaseRemoteProcessHandler.this.myWaitFor.setTerminationCallback(exitCode -> {
                        try {
                            try {
                                stderrReader.waitFor();
                                stdoutReader.waitFor();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        finally {
                            BaseRemoteProcessHandler.this.onOSProcessTerminated(exitCode);
                        }
                    });
                }
                finally {
                    BaseRemoteProcessHandler.this.removeProcessListener((ProcessListener)this);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/remote/BaseRemoteProcessHandler$1", "startNotified"));
            }
        });
        super.startNotify();
    }

    @NotNull
    public Future<?> executeTask(@NotNull Runnable task2) {
        if (task2 == null) {
            BaseRemoteProcessHandler.$$$reportNull$$$0(1);
        }
        Future<?> future2 = AppExecutorUtil.getAppExecutorService().submit(task2);
        if (future2 == null) {
            BaseRemoteProcessHandler.$$$reportNull$$$0(2);
        }
        return future2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/remote/BaseRemoteProcessHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/remote/BaseRemoteProcessHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "executeTask";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "executeTask";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class RemoteOutputReader
    extends BaseOutputReader {
        @NotNull
        private final RemoteProcess myRemoteProcess;
        private boolean myClosed;

        RemoteOutputReader(@NotNull InputStream inputStream, Charset charset, @NotNull RemoteProcess remoteProcess, @NotNull String commandLine) {
            if (inputStream == null) {
                RemoteOutputReader.$$$reportNull$$$0(0);
            }
            if (remoteProcess == null) {
                RemoteOutputReader.$$$reportNull$$$0(1);
            }
            if (commandLine == null) {
                RemoteOutputReader.$$$reportNull$$$0(2);
            }
            super(inputStream, charset);
            this.myRemoteProcess = remoteProcess;
            this.start(CommandLineUtil.extractPresentableName((String)commandLine));
        }

        protected void doRun() {
            try {
                this.setClosed(false);
                while (true) {
                    boolean read2 = this.readAvailable();
                    if (this.myRemoteProcess.isDisconnected()) {
                        this.myReader.close();
                        break;
                    }
                    if (this.isStopped) {
                        break;
                    }
                    Thread.sleep(this.mySleepingPolicy.getTimeToSleep(read2));
                }
            }
            catch (InterruptedException read2) {
            }
            catch (Exception e) {
                LOG.warn((Throwable)e);
            }
            finally {
                this.setClosed(true);
            }
        }

        protected synchronized void setClosed(boolean closed) {
            this.myClosed = closed;
        }

        public void waitFor() throws InterruptedException {
            while (!this.isClosed()) {
                Thread.sleep(100L);
            }
        }

        private synchronized boolean isClosed() {
            return this.myClosed;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "inputStream";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "remoteProcess";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "commandLine";
                    break;
                }
            }
            objectArray[1] = "com/intellij/remote/BaseRemoteProcessHandler$RemoteOutputReader";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

