/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl;

import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiMultiReference
implements PsiPolyVariantReference {
    public static final Comparator<PsiReference> COMPARATOR = (ref1, ref2) -> {
        TextRange range2;
        boolean soft2;
        boolean soft1 = ref1.isSoft();
        if (soft1 != (soft2 = ref2.isSoft())) {
            return soft1 ? 1 : -1;
        }
        boolean resolves1 = PsiMultiReference.resolves(ref1);
        boolean resolves2 = PsiMultiReference.resolves(ref2);
        if (resolves1 && !resolves2) {
            return -1;
        }
        if (!resolves1 && resolves2) {
            return 1;
        }
        TextRange range1 = ref1.getRangeInElement();
        if (TextRange.areSegmentsEqual((Segment)range1, (Segment)(range2 = ref2.getRangeInElement()))) {
            return 0;
        }
        if (range1.getStartOffset() >= range2.getStartOffset() && range1.getEndOffset() <= range2.getEndOffset()) {
            return -1;
        }
        if (range2.getStartOffset() >= range1.getStartOffset() && range2.getEndOffset() <= range1.getEndOffset()) {
            return 1;
        }
        return 0;
    };
    private final PsiReference[] myReferences;
    private final PsiElement myElement;
    private boolean mySorted;

    private static boolean resolves(PsiReference ref1) {
        return ref1 instanceof PsiPolyVariantReference && ((PsiPolyVariantReference)ref1).multiResolve(false).length > 0 || ref1.resolve() != null;
    }

    public PsiMultiReference(@NotNull PsiReference[] references, PsiElement element) {
        if (references == null) {
            PsiMultiReference.$$$reportNull$$$0(0);
        }
        assert (references.length > 0);
        this.myReferences = references;
        this.myElement = element;
    }

    @NotNull
    public PsiReference[] getReferences() {
        if (this.myReferences == null) {
            PsiMultiReference.$$$reportNull$$$0(1);
        }
        return this.myReferences;
    }

    private synchronized PsiReference chooseReference() {
        if (!this.mySorted) {
            Arrays.sort(this.myReferences, COMPARATOR);
            this.mySorted = true;
        }
        return this.myReferences[0];
    }

    @NotNull
    public PsiElement getElement() {
        PsiElement psiElement = this.myElement;
        if (psiElement == null) {
            PsiMultiReference.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    @NotNull
    public TextRange getRangeInElement() {
        TextRange range2 = this.getRangeInElementIfSameForAll();
        if (range2 != null) {
            TextRange textRange = range2;
            if (textRange == null) {
                PsiMultiReference.$$$reportNull$$$0(3);
            }
            return textRange;
        }
        PsiReference chosenRef = this.chooseReference();
        TextRange textRange = PsiMultiReference.getReferenceRange(chosenRef, this.myElement);
        if (textRange == null) {
            PsiMultiReference.$$$reportNull$$$0(4);
        }
        return textRange;
    }

    @Nullable
    private TextRange getRangeInElementIfSameForAll() {
        TextRange range2 = null;
        for (PsiReference reference : this.getReferences()) {
            TextRange refRange = PsiMultiReference.getReferenceRange(reference, this.myElement);
            if (range2 == null) {
                range2 = refRange;
                continue;
            }
            if (range2.equals((Object)refRange)) continue;
            return null;
        }
        return range2;
    }

    @NotNull
    public static TextRange getReferenceRange(@NotNull PsiReference reference, @NotNull PsiElement inElement) {
        PsiElement refElement;
        if (reference == null) {
            PsiMultiReference.$$$reportNull$$$0(5);
        }
        if (inElement == null) {
            PsiMultiReference.$$$reportNull$$$0(6);
        }
        TextRange rangeInElement = reference.getRangeInElement();
        PsiElement element = refElement = reference.getElement();
        while (element != inElement) {
            int start2 = element.getStartOffsetInParent();
            if (start2 + rangeInElement.getStartOffset() < 0) {
                throw new IllegalArgumentException("Inconsistent reference range in #" + inElement.getLanguage().getID() + ":ref of " + reference.getClass() + " on " + PsiMultiReference.classAndRange(refElement) + " with range " + reference.getRangeInElement() + ", requested range in PSI of " + PsiMultiReference.classAndRange(inElement));
            }
            rangeInElement = rangeInElement.shiftRight(start2);
            if (!((element = element.getParent()) instanceof PsiFile)) continue;
            break;
        }
        TextRange textRange = rangeInElement;
        if (textRange == null) {
            PsiMultiReference.$$$reportNull$$$0(7);
        }
        return textRange;
    }

    private static String classAndRange(PsiElement psi) {
        return psi.getClass() + " " + psi.getTextRange();
    }

    public PsiElement resolve() {
        PsiReference reference = this.chooseReference();
        if (this.cannotChoose()) {
            ResolveResult[] results = this.multiResolve(false);
            return results.length == 1 ? results[0].getElement() : null;
        }
        return reference.resolve();
    }

    private boolean cannotChoose() {
        return this.myReferences.length > 1 && COMPARATOR.compare(this.myReferences[0], this.myReferences[1]) == 0;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.chooseReference().getCanonicalText();
        if (string == null) {
            PsiMultiReference.$$$reportNull$$$0(8);
        }
        return string;
    }

    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (newElementName == null) {
            PsiMultiReference.$$$reportNull$$$0(9);
        }
        return this.chooseReference().handleElementRename(newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            PsiMultiReference.$$$reportNull$$$0(10);
        }
        return this.chooseReference().bindToElement(element);
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (element == null) {
            PsiMultiReference.$$$reportNull$$$0(11);
        }
        for (PsiReference reference : this.myReferences) {
            if (!reference.isReferenceTo(element)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Object[] getVariants() {
        HashSet variants = new HashSet();
        for (PsiReference ref : this.myReferences) {
            Object[] refVariants = ref.getVariants();
            ContainerUtil.addAll(variants, (Object[])refVariants);
        }
        Object[] objectArray = variants.toArray();
        if (objectArray == null) {
            PsiMultiReference.$$$reportNull$$$0(12);
        }
        return objectArray;
    }

    public boolean isSoft() {
        for (PsiReference reference : this.getReferences()) {
            if (reference.isSoft()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        PsiReference[] refs = this.getReferences();
        LinkedHashSet<PsiElementResolveResult> result2 = new LinkedHashSet<PsiElementResolveResult>(refs.length);
        PsiElementResolveResult selfReference = null;
        for (PsiReference reference : refs) {
            if (reference instanceof PsiPolyVariantReference) {
                ContainerUtil.addAll(result2, (Object[])((PsiPolyVariantReference)reference).multiResolve(incompleteCode));
                continue;
            }
            PsiElement resolved = reference.resolve();
            if (resolved == null) continue;
            PsiElementResolveResult rresult = new PsiElementResolveResult(resolved);
            if (this.getElement() == resolved) {
                selfReference = rresult;
                continue;
            }
            result2.add(rresult);
        }
        if (result2.isEmpty() && selfReference != null) {
            result2.add(selfReference);
        }
        ResolveResult[] resolveResultArray = result2.toArray(ResolveResult.EMPTY_ARRAY);
        if (resolveResultArray == null) {
            PsiMultiReference.$$$reportNull$$$0(13);
        }
        return resolveResultArray;
    }

    public String toString() {
        return "PsiMultiReference{" + StringUtil.join((Object[])this.myReferences, r -> r.getClass().getName(), (String)",") + '}';
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/PsiMultiReference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inElement";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/PsiMultiReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferences";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRangeInElement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceRange";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 13: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceRange";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "handleElementRename";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

