/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter.common;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.BlockEx;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.DependantSpacingImpl;
import com.intellij.formatting.DependentSpacingRule;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InjectedLanguageBlockWrapper
implements BlockEx {
    private final Block myOriginal;
    private final int myOffset;
    private final TextRange myRange;
    @Nullable
    private final Indent myIndent;
    @Nullable
    private final Language myLanguage;
    private List<Block> myBlocks;

    public InjectedLanguageBlockWrapper(@NotNull Block original, int offset, @Nullable TextRange range2, @Nullable Indent indent) {
        if (original == null) {
            InjectedLanguageBlockWrapper.$$$reportNull$$$0(0);
        }
        this(original, offset, range2, indent, null);
    }

    public InjectedLanguageBlockWrapper(@NotNull Block original, int offset, @Nullable TextRange range2, @Nullable Indent indent, @Nullable Language language) {
        if (original == null) {
            InjectedLanguageBlockWrapper.$$$reportNull$$$0(1);
        }
        this.myOriginal = original;
        this.myOffset = offset;
        this.myRange = range2;
        this.myIndent = indent;
        this.myLanguage = language;
    }

    public Indent getIndent() {
        return this.myIndent != null ? this.myIndent : this.myOriginal.getIndent();
    }

    @Nullable
    public Alignment getAlignment() {
        return this.myOriginal.getAlignment();
    }

    @NotNull
    public TextRange getTextRange() {
        TextRange range2 = this.myOriginal.getTextRange();
        if (this.myRange != null) {
            range2 = range2.intersection(this.myRange);
        }
        int start2 = this.myOffset + range2.getStartOffset() - (this.myRange != null ? this.myRange.getStartOffset() : 0);
        TextRange textRange = TextRange.from((int)start2, (int)range2.getLength());
        if (textRange == null) {
            InjectedLanguageBlockWrapper.$$$reportNull$$$0(2);
        }
        return textRange;
    }

    @Override
    @Nullable
    public Language getLanguage() {
        return this.myLanguage;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        if (this.myBlocks == null) {
            this.myBlocks = this.buildBlocks();
        }
        List<Block> list2 = this.myBlocks;
        if (list2 == null) {
            InjectedLanguageBlockWrapper.$$$reportNull$$$0(3);
        }
        return list2;
    }

    private List<Block> buildBlocks() {
        List list2 = this.myOriginal.getSubBlocks();
        if (list2.isEmpty()) {
            return AbstractBlock.EMPTY;
        }
        if (this.myOffset == 0 && this.myRange == null) {
            return list2;
        }
        ArrayList<Block> result2 = new ArrayList<Block>(list2.size());
        if (this.myRange == null) {
            for (Block block : list2) {
                result2.add(new InjectedLanguageBlockWrapper(block, this.myOffset, null, null, this.myLanguage));
            }
        } else {
            this.collectBlocksIntersectingRange(list2, result2, this.myRange);
        }
        return result2;
    }

    private void collectBlocksIntersectingRange(List<Block> list2, List<Block> result2, @NotNull TextRange range2) {
        if (range2 == null) {
            InjectedLanguageBlockWrapper.$$$reportNull$$$0(4);
        }
        for (Block block : list2) {
            TextRange textRange = block.getTextRange();
            if (block instanceof InjectedLanguageBlockWrapper && block.getTextRange().equals((Object)range2)) continue;
            if (range2.contains(textRange)) {
                result2.add(new InjectedLanguageBlockWrapper(block, this.myOffset, range2, null, this.myLanguage));
                continue;
            }
            if (!textRange.intersectsStrict(range2)) continue;
            this.collectBlocksIntersectingRange(block.getSubBlocks(), result2, range2);
        }
    }

    @Nullable
    public Wrap getWrap() {
        return this.myOriginal.getWrap();
    }

    @Nullable
    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        Spacing spacing;
        if (child2 == null) {
            InjectedLanguageBlockWrapper.$$$reportNull$$$0(5);
        }
        int shift = 0;
        Block child1ToUse = child1;
        Block child2ToUse = child2;
        if (child1 instanceof InjectedLanguageBlockWrapper) {
            child1ToUse = ((InjectedLanguageBlockWrapper)child1).myOriginal;
            shift = child1.getTextRange().getStartOffset() - child1ToUse.getTextRange().getStartOffset();
        }
        if (child2 instanceof InjectedLanguageBlockWrapper) {
            child2ToUse = ((InjectedLanguageBlockWrapper)child2).myOriginal;
        }
        if ((spacing = this.myOriginal.getSpacing(child1ToUse, child2ToUse)) instanceof DependantSpacingImpl && shift != 0) {
            DependantSpacingImpl hostSpacing = (DependantSpacingImpl)spacing;
            int finalShift = shift;
            List shiftedRanges = ContainerUtil.map(hostSpacing.getDependentRegionRanges(), range2 -> range2.shiftRight(finalShift));
            return new DependantSpacingImpl(hostSpacing.getMinSpaces(), hostSpacing.getMaxSpaces(), shiftedRanges, hostSpacing.shouldKeepLineFeeds(), hostSpacing.getKeepBlankLines(), DependentSpacingRule.DEFAULT);
        }
        return spacing;
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        ChildAttributes childAttributes = this.myOriginal.getChildAttributes(newChildIndex);
        if (childAttributes == null) {
            InjectedLanguageBlockWrapper.$$$reportNull$$$0(6);
        }
        return childAttributes;
    }

    public boolean isIncomplete() {
        return this.myOriginal.isIncomplete();
    }

    public boolean isLeaf() {
        return this.myOriginal.isLeaf();
    }

    public String toString() {
        return this.myOriginal.toString();
    }

    public Block getOriginal() {
        return this.myOriginal;
    }

    @Nullable
    public String getDebugName() {
        if (this.myOriginal != null) {
            String originalDebugName = this.myOriginal.getDebugName();
            if (originalDebugName == null) {
                originalDebugName = this.myOriginal.getClass().getSimpleName();
            }
            return "wrapped " + originalDebugName;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/formatter/common/InjectedLanguageBlockWrapper";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/formatter/common/InjectedLanguageBlockWrapper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubBlocks";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "collectBlocksIntersectingRange";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

