/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile.codeInspection.ui.header;

import com.intellij.application.options.schemes.SchemesModel;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionProfileModifiableModel;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.ui.SingleInspectionProfilePanel;
import com.intellij.profile.codeInspection.ui.header.InspectionProfileSchemesPanel;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;

public abstract class InspectionProfileSchemesModel
implements SchemesModel<InspectionProfileModifiableModel> {
    private final List<SingleInspectionProfilePanel> myProfilePanels;
    private final List<InspectionProfileImpl> myDeletedProfiles;
    private final InspectionProfileManager myApplicationProfileManager;
    private final InspectionProfileManager myProjectProfileManager;

    InspectionProfileSchemesModel(@NotNull InspectionProfileManager appProfileManager, @NotNull InspectionProfileManager projectProfileManager) {
        if (appProfileManager == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(0);
        }
        if (projectProfileManager == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(1);
        }
        this.myProfilePanels = new ArrayList<SingleInspectionProfilePanel>();
        this.myDeletedProfiles = new SmartList();
        this.myApplicationProfileManager = appProfileManager;
        this.myProjectProfileManager = projectProfileManager;
    }

    @Override
    public boolean canDuplicateScheme(@NotNull InspectionProfileModifiableModel profile2) {
        if (profile2 == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(2);
        }
        return true;
    }

    @Override
    public boolean canResetScheme(@NotNull InspectionProfileModifiableModel profile2) {
        if (profile2 == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(3);
        }
        return true;
    }

    @Override
    public boolean canDeleteScheme(@NotNull InspectionProfileModifiableModel candidateToDelete) {
        boolean isProjectProfile;
        SingleInspectionProfilePanel profilePanel;
        InspectionProfileModifiableModel profile2;
        if (candidateToDelete == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(4);
        }
        boolean projectProfileFound = false;
        boolean ideProfileFound = false;
        Iterator<SingleInspectionProfilePanel> iterator = this.myProfilePanels.iterator();
        while (!(!iterator.hasNext() || candidateToDelete != (profile2 = (profilePanel = iterator.next()).getProfile()) && (ideProfileFound |= !(isProjectProfile = profile2.getProfileManager() == this.myProjectProfileManager)) && (projectProfileFound |= isProjectProfile))) {
        }
        return candidateToDelete.getProfileManager() == this.myProjectProfileManager ? projectProfileFound : ideProfileFound;
    }

    @Override
    public boolean isProjectScheme(@NotNull InspectionProfileModifiableModel profile2) {
        if (profile2 == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(5);
        }
        return profile2.isProjectLevel();
    }

    @Override
    public boolean canRenameScheme(@NotNull InspectionProfileModifiableModel profile2) {
        if (profile2 == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(6);
        }
        return true;
    }

    @Override
    public boolean containsScheme(@NotNull String name, boolean isProjectProfile) {
        if (name == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(7);
        }
        return this.hasName(name, isProjectProfile);
    }

    @Override
    public boolean differsFromDefault(@NotNull InspectionProfileModifiableModel profile2) {
        if (profile2 == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(8);
        }
        return this.getProfilePanel(profile2).differsFromDefault();
    }

    @Override
    public void removeScheme(@NotNull InspectionProfileModifiableModel profile2) {
        if (profile2 == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(9);
        }
        SingleInspectionProfilePanel panel2 = this.getProfilePanel(profile2);
        this.removeProfile(profile2);
        this.myDeletedProfiles.add(profile2);
        this.onProfileRemoved(panel2);
    }

    protected abstract void onProfileRemoved(@NotNull SingleInspectionProfilePanel var1);

    void addProfile(@NotNull InspectionProfileModifiableModel profile2) {
        if (profile2 == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(10);
        }
        this.myProfilePanels.add(this.createPanel(profile2));
    }

    private void removeProfile(@NotNull InspectionProfileImpl profile2) {
        if (profile2 == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(11);
        }
        for (SingleInspectionProfilePanel panel2 : this.myProfilePanels) {
            if (!panel2.getProfile().equals(profile2)) continue;
            this.myProfilePanels.remove(panel2);
            break;
        }
    }

    void updatePanel(@NotNull InspectionProfileSchemesPanel panel2) {
        if (panel2 == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(12);
        }
        List allProfiles = ContainerUtil.map(this.myProfilePanels, p -> p.getProfile());
        panel2.resetSchemes(allProfiles);
    }

    void apply(InspectionProfileModifiableModel selected, Consumer<? super InspectionProfileImpl> applyRootProfileAction) {
        for (InspectionProfileImpl profile2 : this.myDeletedProfiles) {
            profile2.getProfileManager().deleteProfile(profile2);
        }
        this.myDeletedProfiles.clear();
        SingleInspectionProfilePanel selectedPanel = this.getProfilePanel(selected);
        for (SingleInspectionProfilePanel panel2 : this.getProfilePanels()) {
            panel2.apply();
            if (panel2 != selectedPanel) continue;
            applyRootProfileAction.consume((Object)panel2.getProfile());
        }
    }

    void reset() {
        this.disposeUI();
        this.myDeletedProfiles.clear();
        InspectionProfileSchemesModel.getSortedProfiles(this.myApplicationProfileManager, this.myProjectProfileManager).stream().map(source -> {
            try {
                return new InspectionProfileModifiableModel((InspectionProfileImpl)source);
            }
            catch (Exception e) {
                if (e instanceof JDOMException) {
                    return null;
                }
                throw new RuntimeException(e);
            }
        }).forEach(this::addProfile);
    }

    void disposeUI() {
        for (SingleInspectionProfilePanel panel2 : this.myProfilePanels) {
            panel2.disposeUI();
        }
        this.myProfilePanels.clear();
    }

    SingleInspectionProfilePanel getProfilePanel(InspectionProfileImpl profile2) {
        return this.myProfilePanels.stream().filter(panel2 -> panel2.getProfile().equals(profile2)).findFirst().orElse(null);
    }

    @NotNull
    protected abstract SingleInspectionProfilePanel createPanel(@NotNull InspectionProfileModifiableModel var1);

    private boolean hasName(@NotNull String name, boolean shared) {
        boolean hasName;
        if (name == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(13);
        }
        if (hasName = this.myProfilePanels.stream().map(SingleInspectionProfilePanel::getProfile).anyMatch(p -> name.equals(p.getName()) && p.isProjectLevel() == shared)) {
            return true;
        }
        return this.myProfilePanels.stream().anyMatch(p -> {
            InspectionProfileModifiableModel profile2 = p.getProfile();
            return name.equals(profile2.getName()) && profile2.isProjectLevel() == shared;
        });
    }

    @NotNull
    List<SingleInspectionProfilePanel> getProfilePanels() {
        List<SingleInspectionProfilePanel> list2 = this.myProfilePanels;
        if (list2 == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(14);
        }
        return list2;
    }

    int getSize() {
        return this.myProfilePanels.size();
    }

    boolean hasDeletedProfiles() {
        return !this.myDeletedProfiles.isEmpty();
    }

    @NotNull
    InspectionProfileModifiableModel getModifiableModelFor(@NotNull InspectionProfileImpl profile2) {
        if (profile2 == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(15);
        }
        if (profile2 instanceof InspectionProfileModifiableModel) {
            InspectionProfileModifiableModel inspectionProfileModifiableModel = (InspectionProfileModifiableModel)profile2;
            if (inspectionProfileModifiableModel == null) {
                InspectionProfileSchemesModel.$$$reportNull$$$0(16);
            }
            return inspectionProfileModifiableModel;
        }
        for (SingleInspectionProfilePanel panel2 : this.myProfilePanels) {
            InspectionProfileModifiableModel modifiableModel = panel2.getProfile();
            if (!modifiableModel.getSource().equals(profile2)) continue;
            InspectionProfileModifiableModel inspectionProfileModifiableModel = modifiableModel;
            if (inspectionProfileModifiableModel == null) {
                InspectionProfileSchemesModel.$$$reportNull$$$0(17);
            }
            return inspectionProfileModifiableModel;
        }
        throw new AssertionError((Object)("profile " + profile2.getName() + " is not present among profile panels" + Arrays.toString(this.myProfilePanels.stream().map(p -> p.getProfile().getName()).toArray(String[]::new))));
    }

    @NotNull
    public static List<InspectionProfileImpl> getSortedProfiles(@NotNull InspectionProfileManager appManager, @NotNull InspectionProfileManager projectManager) {
        if (appManager == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(18);
        }
        if (projectManager == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(19);
        }
        List list2 = ContainerUtil.concat((List)ContainerUtil.sorted(appManager.getProfiles()), (List)ContainerUtil.sorted(projectManager.getProfiles()));
        if (list2 == null) {
            InspectionProfileSchemesModel.$$$reportNull$$$0(20);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appProfileManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectProfileManager";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateToDelete";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/profile/codeInspection/ui/header/InspectionProfileSchemesModel";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appManager";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/profile/codeInspection/ui/header/InspectionProfileSchemesModel";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getProfilePanels";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableModelFor";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedProfiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canDuplicateScheme";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canResetScheme";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "canDeleteScheme";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isProjectScheme";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "canRenameScheme";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "containsScheme";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "differsFromDefault";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeScheme";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addProfile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeProfile";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updatePanel";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "hasName";
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 20: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getModifiableModelFor";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getSortedProfiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 16: 
            case 17: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

