/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.templates;

import com.intellij.application.options.CodeStyle;
import com.intellij.execution.RunManager;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.util.projectWizard.ExistingModuleLoader;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectTemplateParameterFactory;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.util.projectWizard.WizardInputField;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.platform.templates.ArchivedProjectTemplate;
import com.intellij.platform.templates.LocalArchivedTemplate;
import com.intellij.platform.templates.SaveProjectAsTemplateAction;
import com.intellij.platform.templates.TemplateProjectDirectoryGenerator;
import com.intellij.platform.templates.github.ZipUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.zip.ZipInputStream;
import javax.swing.Icon;
import org.apache.velocity.exception.VelocityException;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateModuleBuilder
extends ModuleBuilder {
    private static final Logger LOG = Logger.getInstance(TemplateModuleBuilder.class);
    private final ModuleType myType;
    private final List<WizardInputField> myAdditionalFields;
    private final ArchivedProjectTemplate myTemplate;
    private boolean myProjectMode;

    public TemplateModuleBuilder(ArchivedProjectTemplate template, ModuleType moduleType, @NotNull List<WizardInputField> additionalFields) {
        if (additionalFields == null) {
            TemplateModuleBuilder.$$$reportNull$$$0(0);
        }
        this.myTemplate = template;
        this.myType = moduleType;
        this.myAdditionalFields = additionalFields;
    }

    public ModuleWizardStep[] createWizardSteps(@NotNull WizardContext wizardContext, @NotNull ModulesProvider modulesProvider) {
        if (wizardContext == null) {
            TemplateModuleBuilder.$$$reportNull$$$0(1);
        }
        if (modulesProvider == null) {
            TemplateModuleBuilder.$$$reportNull$$$0(2);
        }
        ModuleBuilder builder2 = this.myType.createModuleBuilder();
        return builder2.createWizardSteps(wizardContext, modulesProvider);
    }

    public ModuleWizardStep[] createFinishingSteps(@NotNull WizardContext wizardContext, @NotNull ModulesProvider modulesProvider) {
        if (wizardContext == null) {
            TemplateModuleBuilder.$$$reportNull$$$0(3);
        }
        if (modulesProvider == null) {
            TemplateModuleBuilder.$$$reportNull$$$0(4);
        }
        ModuleBuilder builder2 = this.myType.createModuleBuilder();
        return builder2.createFinishingSteps(wizardContext, modulesProvider);
    }

    @NotNull
    protected List<WizardInputField> getAdditionalFields() {
        List<WizardInputField> list2 = this.myAdditionalFields;
        if (list2 == null) {
            TemplateModuleBuilder.$$$reportNull$$$0(5);
        }
        return list2;
    }

    public Module commitModule(@NotNull Project project, ModifiableModuleModel model) {
        if (project == null) {
            TemplateModuleBuilder.$$$reportNull$$$0(6);
        }
        if (this.myProjectMode) {
            Module[] modules = ModuleManager.getInstance((Project)project).getModules();
            if (modules.length > 0) {
                Module module = modules[0];
                ApplicationManager.getApplication().runWriteAction(() -> {
                    try {
                        this.setupModule(module);
                    }
                    catch (ConfigurationException e) {
                        LOG.error((Throwable)e);
                    }
                });
                StartupManager.getInstance((Project)project).registerPostStartupActivity(() -> ApplicationManager.getApplication().runWriteAction(() -> {
                    try {
                        ModifiableModuleModel modifiableModuleModel = ModuleManager.getInstance((Project)project).getModifiableModel();
                        modifiableModuleModel.renameModule(module, module.getProject().getName());
                        modifiableModuleModel.commit();
                        this.fixModuleName(module);
                    }
                    catch (ModuleWithNameAlreadyExists moduleWithNameAlreadyExists) {
                        // empty catch block
                    }
                }));
                return module;
            }
            return null;
        }
        return super.commitModule(project, model);
    }

    @Nullable
    public String getBuilderId() {
        return this.myTemplate.getName();
    }

    public ModuleType getModuleType() {
        return this.myType;
    }

    public Icon getNodeIcon() {
        return this.myTemplate.getIcon();
    }

    public boolean isTemplateBased() {
        return true;
    }

    @NotNull
    public Module createModule(@NotNull ModifiableModuleModel moduleModel) throws InvalidDataException, IOException, ModuleWithNameAlreadyExists, JDOMException, ConfigurationException {
        if (moduleModel == null) {
            TemplateModuleBuilder.$$$reportNull$$$0(7);
        }
        String path = this.getContentEntryPath();
        ExistingModuleLoader loader = ExistingModuleLoader.setUpLoader(this.getModuleFilePath());
        this.unzip(loader.getName(), path, true, null, true);
        Module module = loader.createModule(moduleModel);
        if (this.myProjectMode) {
            moduleModel.renameModule(module, module.getProject().getName());
        }
        this.fixModuleName(module);
        Module module2 = module;
        if (module2 == null) {
            TemplateModuleBuilder.$$$reportNull$$$0(8);
        }
        return module2;
    }

    private void fixModuleName(@NotNull Module module) {
        if (module == null) {
            TemplateModuleBuilder.$$$reportNull$$$0(9);
        }
        for (RunConfiguration configuration : RunManager.getInstance((Project)module.getProject()).getAllConfigurationsList()) {
            if (!(configuration instanceof ModuleBasedConfiguration)) continue;
            ((ModuleBasedConfiguration)configuration).getConfigurationModule().setModule(module);
        }
        ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
        for (WizardInputField field : this.myAdditionalFields) {
            ProjectTemplateParameterFactory factory = WizardInputField.getFactoryById((String)field.getId());
            if (factory == null) continue;
            factory.applyResult(field.getValue(), model);
        }
        TemplateModuleBuilder.applyProjectDefaults(module.getProject());
        for (ProjectTemplateParameterFactory factory : ProjectTemplateParameterFactory.EP_NAME.getExtensionList()) {
            String value = factory.getImmediateValue();
            if (value == null) continue;
            factory.applyResult(value, model);
        }
        model.commit();
    }

    private static void applyProjectDefaults(@NotNull Project project) {
        if (project == null) {
            TemplateModuleBuilder.$$$reportNull$$$0(10);
        }
        Project defaultProject = ProjectManager.getInstance().getDefaultProject();
        String charset = EncodingProjectManager.getInstance((Project)defaultProject).getDefaultCharsetName();
        EncodingProjectManager.getInstance((Project)project).setDefaultCharsetName(charset);
        RunManagerImpl.getInstanceImpl(defaultProject).copyTemplatesToProjectFromTemplate(project);
    }

    @Nullable
    private WizardInputField getBasePackageField() {
        for (WizardInputField field : this.getAdditionalFields()) {
            if (!"IJ_BASE_PACKAGE".equals(field.getId())) continue;
            return field;
        }
        return null;
    }

    private void unzip(final @Nullable String projectName, String path, final boolean isModuleMode, final @Nullable ProgressIndicator pI, final boolean reportFailuresWithDialog) {
        final WizardInputField basePackage = this.getBasePackageField();
        try {
            File to;
            File from;
            final File dir = new File(path);
            class ExceptionConsumer
            implements Consumer<VelocityException> {
                private String myPath;
                private String myText;
                private final SmartList<Trinity<String, String, VelocityException>> myFailures = new SmartList();

                ExceptionConsumer() {
                }

                public void consume(VelocityException e) {
                    this.myFailures.add((Object)Trinity.create((Object)this.myPath, (Object)this.myText, (Object)((Object)e)));
                }

                private void setCurrentFile(String path, String text) {
                    this.myPath = path;
                    this.myText = text;
                }

                private void reportFailures() {
                    if (this.myFailures.isEmpty()) {
                        return;
                    }
                    if (reportFailuresWithDialog) {
                        String dialogMessage;
                        if (this.myFailures.size() == 1) {
                            dialogMessage = "Failed to decode file '" + (String)((Trinity)this.myFailures.get(0)).getFirst() + "'";
                        } else {
                            StringBuilder dialogMessageBuilder = new StringBuilder();
                            dialogMessageBuilder.append("Failed to decode files: \n");
                            for (Trinity failure : this.myFailures) {
                                dialogMessageBuilder.append((String)failure.getFirst()).append("\n");
                            }
                            dialogMessage = dialogMessageBuilder.toString();
                        }
                        Messages.showErrorDialog((String)dialogMessage, (String)"Decoding Template");
                    }
                    StringBuilder reportBuilder = new StringBuilder();
                    for (Trinity failure : this.myFailures) {
                        reportBuilder.append("File: ").append((String)failure.getFirst()).append("\n");
                        reportBuilder.append("Exception:\n").append(ExceptionUtil.getThrowableText((Throwable)((Throwable)failure.getThird()))).append("\n");
                        reportBuilder.append("File content:\n'").append((String)failure.getSecond()).append("'\n");
                        reportBuilder.append("\n===========================================\n");
                    }
                    LOG.error("Cannot decode files in template", (Throwable)null, new Attachment[]{new Attachment("Files in template", reportBuilder.toString())});
                }
            }
            final ExceptionConsumer consumer = new ExceptionConsumer();
            final ArrayList filesToRefresh = new ArrayList();
            this.myTemplate.processStream(new ArchivedProjectTemplate.StreamProcessor<Void>(){
                {
                }

                @Override
                public Void consume(@NotNull ZipInputStream stream) throws IOException {
                    if (stream == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ZipUtil.unzip(ProgressManager.getInstance().getProgressIndicator(), dir, stream, (NullableFunction<? super String, String>)((NullableFunction)path1 -> {
                        if (isModuleMode && path1.contains(".idea")) {
                            return null;
                        }
                        if (basePackage != null) {
                            return path1.replace(TemplateModuleBuilder.getPathFragment(basePackage.getDefaultValue()), TemplateModuleBuilder.getPathFragment(basePackage.getValue()));
                        }
                        return path1;
                    }), new ZipUtil.ContentProcessor(){

                        @Override
                        public byte[] processContent(byte[] content, File file2) throws IOException {
                            if (pI != null) {
                                pI.checkCanceled();
                            }
                            FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(file2.getName());
                            String text = new String(content, CharsetToolkit.UTF8_CHARSET);
                            consumer.setCurrentFile(file2.getName(), text);
                            return fileType.isBinary() ? content : TemplateModuleBuilder.this.processTemplates(projectName, text, file2, (Consumer<? super VelocityException>)consumer);
                        }
                    }, true);
                    TemplateModuleBuilder.this.myTemplate.handleUnzippedDirectories(dir, filesToRefresh);
                    return null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stream", "com/intellij/platform/templates/TemplateModuleBuilder$1", "consume"));
                }
            });
            if (pI != null) {
                pI.setText("Refreshing...");
            }
            String iml = (String)ContainerUtil.find((Object[])((Object[])ObjectUtils.chooseNotNull((Object)dir.list(), (Object)ArrayUtilRt.EMPTY_STRING_ARRAY)), s -> s.endsWith(".iml"));
            if (isModuleMode && !(from = new File(path, Objects.requireNonNull(iml))).renameTo(to = new File(this.getModuleFilePath()))) {
                throw new IOException("Can't rename " + from + " to " + to);
            }
            RefreshQueue refreshQueue = RefreshQueue.getInstance();
            LOG.assertTrue(!filesToRefresh.isEmpty());
            for (File file2 : filesToRefresh) {
                VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file2);
                if (virtualFile == null) {
                    throw new IOException("Can't find " + file2);
                }
                refreshQueue.refresh(false, true, null, new VirtualFile[]{virtualFile});
            }
            consumer.reportFailures();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    private static String getPathFragment(@NotNull String value) {
        if (value == null) {
            TemplateModuleBuilder.$$$reportNull$$$0(11);
        }
        String string = "/" + value.replace('.', '/') + "/";
        if (string == null) {
            TemplateModuleBuilder.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Nullable
    private byte[] processTemplates(@Nullable String projectName, String content, File file2, Consumer<? super VelocityException> exceptionConsumer) throws IOException {
        String patchedContent = content;
        if (!(this.myTemplate instanceof LocalArchivedTemplate) || ((LocalArchivedTemplate)this.myTemplate).isEscaped()) {
            for (WizardInputField wizardInputField : this.myAdditionalFields) {
                if (wizardInputField.acceptFile(file2)) continue;
                return null;
            }
            Properties properties = FileTemplateManager.getDefaultInstance().getDefaultProperties();
            for (WizardInputField field : this.myAdditionalFields) {
                properties.putAll((Map<?, ?>)field.getValues());
            }
            if (projectName != null) {
                properties.put("IJ_PROJECT_NAME", projectName);
            }
            String string = FileTemplateUtil.mergeTemplate(properties, content, true, exceptionConsumer);
            patchedContent = string.replace("\\$", "$").replace("\\#", "#");
        } else {
            int i = content.indexOf("<IntelliJ_File_Header>");
            if (i != -1) {
                FileTemplate fileTemplate = FileTemplateManager.getDefaultInstance().getDefaultTemplate(SaveProjectAsTemplateAction.getFileHeaderTemplateName());
                Properties properties = FileTemplateManager.getDefaultInstance().getDefaultProperties();
                String templateText = fileTemplate.getText(properties);
                patchedContent = patchedContent.substring(0, i) + templateText + patchedContent.substring(i + "<IntelliJ_File_Header>".length());
            }
        }
        return StringUtilRt.convertLineSeparators((String)patchedContent, (String)CodeStyle.getDefaultSettings().getLineSeparator()).getBytes(CharsetToolkit.UTF8_CHARSET);
    }

    @Nullable
    public Project createProject(final String name, final String path) {
        File location = new File(FileUtil.toSystemDependentName((String)path));
        LOG.assertTrue(location.exists());
        final VirtualFile baseDir = (VirtualFile)WriteAction.compute(() -> LocalFileSystem.getInstance().refreshAndFindFileByIoFile(location));
        if (baseDir == null) {
            LOG.error("Couldn't find path '" + path + "' in VFS");
            return null;
        }
        VirtualFile[] children2 = baseDir.getChildren();
        final boolean isSomehowOverwriting = children2.length > 1 || children2.length == 1 && !".idea".equals(children2[0].getName());
        Task.WithResult<Project, RuntimeException> task2 = new Task.WithResult<Project, RuntimeException>(null, "Applying Template", true){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Project compute(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                try {
                    TemplateModuleBuilder.this.myProjectMode = true;
                    TemplateModuleBuilder.this.unzip(name, path, false, indicator, false);
                    Project project = ProjectManagerEx.getInstanceEx().convertAndLoadProject(path);
                    return project;
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                    Project project = null;
                    return project;
                }
                finally {
                    TemplateModuleBuilder.this.cleanup();
                    if (indicator.isCanceled() && !isSomehowOverwriting) {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            try {
                                WriteAction.run(() -> baseDir.delete(TemplateProjectDirectoryGenerator.class));
                            }
                            catch (IOException e) {
                                LOG.error((Throwable)e);
                            }
                        });
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/platform/templates/TemplateModuleBuilder$2", "compute"));
            }
        };
        return (Project)ProgressManager.getInstance().run((Task.WithResult)task2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 12: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 12: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalFields";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "wizardContext";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modulesProvider";
                break;
            }
            case 5: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/platform/templates/TemplateModuleBuilder";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleModel";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/platform/templates/TemplateModuleBuilder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalFields";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createModule";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathFragment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createWizardSteps";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createFinishingSteps";
                break;
            }
            case 5: 
            case 8: 
            case 12: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "commitModule";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createModule";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fixModuleName";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "applyProjectDefaults";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPathFragment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 12: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

