/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusEvent;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class Windows {
    private static final String HEAVYWEIGHT_WINDOW_CLASS_NAME = "HeavyWeightWindow";

    private static boolean isHeavyWeightPopup(AWTEvent event) {
        Object source = event.getSource();
        if (source != null) {
            if (event.getSource().getClass().getName().contains(HEAVYWEIGHT_WINDOW_CLASS_NAME)) {
                return true;
            }
            Window ancestor = SwingUtilities.getWindowAncestor((Component)source);
            if (ancestor != null && ancestor.getClass().getName().contains(HEAVYWEIGHT_WINDOW_CLASS_NAME)) {
                return true;
            }
        }
        return false;
    }

    static ToolWindowFilter toolWindows() {
        return ToolWindowFilter.INSTANCE;
    }

    static class ToolWindowFilter {
        static ToolWindowFilter INSTANCE = new ToolWindowFilter();

        private ToolWindowFilter() {
        }

        static ToolWindowProvider filterBySignal(Signal signal) {
            return new ToolWindowProvider(signal);
        }
    }

    static class Signal {
        private final Predicate<? super AWTEvent> isAppropriatePredicate;

        Signal(Predicate<? super AWTEvent> isAppropriatePredicate) {
            this.isAppropriatePredicate = isAppropriatePredicate;
        }

        public boolean appropriate(AWTEvent event) {
            return this.isAppropriatePredicate.test(event);
        }
    }

    static class ToolWindowProvider {
        private final Signal mySignal;
        private Consumer<String> dockedWindowHandler;
        private Consumer<String> pinnedWindowFocusLostHandler;
        private Consumer<String> floatingWindowHandler;
        private Consumer<String> windowedWindowHandler;
        private Consumer<String> deactivationShortcutHandler;
        private ActionManager myActionManager;

        private ToolWindowProvider(Signal signal) {
            this.mySignal = signal;
        }

        public ToolWindowProvider handleDocked(Consumer<String> dockedWindowHandler) {
            this.dockedWindowHandler = dockedWindowHandler;
            return this;
        }

        public ToolWindowProvider handleFocusLostOnPinned(Consumer<String> pinnedWindowHandler) {
            this.pinnedWindowFocusLostHandler = pinnedWindowHandler;
            return this;
        }

        public ToolWindowProvider handleFloating(Consumer<String> floatingWindowHandler) {
            this.floatingWindowHandler = floatingWindowHandler;
            return this;
        }

        public ToolWindowProvider handleWindowed(Consumer<String> windowedWindowHandler) {
            this.windowedWindowHandler = windowedWindowHandler;
            return this;
        }

        public ToolWindowProvider withEscAction(ActionManager actionManager) {
            this.myActionManager = actionManager;
            return this;
        }

        public static boolean isInActiveToolWindow(Object component) {
            JComponent source = component instanceof JComponent ? (JComponent)component : null;
            ToolWindow activeToolWindow = ToolWindowManager.getActiveToolWindow();
            if (activeToolWindow != null) {
                JComponent activeToolWindowComponent = activeToolWindow.getComponent();
                if (activeToolWindowComponent != null) {
                    while (source != null && source != activeToolWindowComponent) {
                        source = source.getParent() != null && source.getParent() instanceof JComponent ? (JComponent)source.getParent() : null;
                    }
                }
                return source != null;
            }
            return false;
        }

        public static boolean isInToolWindow(Component component) {
            for (Container c = component.getParent(); c != null; c = c.getParent()) {
                if (!(c instanceof ToolWindow)) continue;
                return true;
            }
            return false;
        }

        public Shortcut[] findShortcuts(String actionId) {
            return KeymapManager.getInstance().getActiveKeymap().getShortcuts(actionId);
        }

        public void bind(Project project) {
            final AWTEventListener listener2 = new AWTEventListener(){

                @Override
                public void eventDispatched(AWTEvent event) {
                    if (mySignal.isAppropriatePredicate.test(event)) {
                        FocusEvent focusEvent;
                        String id = ToolWindowManager.getActiveId();
                        if (event.getID() == 1005 && ToolWindowProvider.isInActiveToolWindow((focusEvent = (FocusEvent)event).getSource()) && !ToolWindowProvider.isInActiveToolWindow(focusEvent.getOppositeComponent()) && focusEvent.getOppositeComponent() != null) {
                            ToolWindow activeToolWindow = ToolWindowManager.getActiveToolWindow();
                            if (!focusEvent.isTemporary() && activeToolWindow != null && (activeToolWindow.isAutoHide() || activeToolWindow.getType() == ToolWindowType.SLIDING)) {
                                pinnedWindowFocusLostHandler.accept(id);
                            }
                        }
                    }
                }
            };
            Toolkit.getDefaultToolkit().addAWTEventListener(listener2, 28L);
            Disposable listenerDisposer = new Disposable(){

                public void dispose() {
                    Toolkit.getDefaultToolkit().removeAWTEventListener(listener2);
                }
            };
            Disposer.register((Disposable)project, (Disposable)listenerDisposer);
        }
    }
}

