/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.ui.AbstractPainter;
import com.intellij.openapi.ui.impl.ShadowPainter;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

final class WindowShadowPainter
extends AbstractPainter {
    private static final ShadowPainter PAINTER = new ShadowPainter(AllIcons.Ide.Shadow.Top, AllIcons.Ide.Shadow.TopRight, AllIcons.Ide.Shadow.Right, AllIcons.Ide.Shadow.BottomRight, AllIcons.Ide.Shadow.Bottom, AllIcons.Ide.Shadow.BottomLeft, AllIcons.Ide.Shadow.Left, AllIcons.Ide.Shadow.TopLeft);
    private static final long MASK = 262209L;
    private static final AtomicReference<AWTEventListener> WINDOW_LISTENER = new AtomicReference<1>(new AWTEventListener(){

        @Override
        public void eventDispatched(AWTEvent event) {
            Object source;
            Object object = source = event == null ? null : event.getSource();
            if (source instanceof Window) {
                Container c = (Window)source;
                while (c instanceof Window && c instanceof RootPaneContainer) {
                    WindowShadowPainter painter;
                    Component pane;
                    JRootPane root = ((RootPaneContainer)((Object)c)).getRootPane();
                    if (root != null && (pane = root.getGlassPane()) instanceof IdeGlassPaneImpl && (painter = ((IdeGlassPaneImpl)pane).myWindowShadowPainter) != null && pane == painter.myComponent) {
                        List shadows = painter.myShadows;
                        painter.myShadows = WindowShadowPainter.getShadows(pane, c);
                        if (!Objects.equals(painter.myShadows, shadows)) {
                            pane.repaint();
                        }
                    }
                    c = c.getParent();
                }
            }
        }
    });
    private List<Rectangle> myShadows;
    private Component myComponent;

    WindowShadowPainter() {
        AWTEventListener listener2 = WINDOW_LISTENER.getAndSet(null);
        if (listener2 != null) {
            Toolkit.getDefaultToolkit().addAWTEventListener(listener2, 262209L);
        }
    }

    public boolean needsRepaint() {
        return true;
    }

    public void executePaint(Component component, Graphics2D g) {
        Window window = UIUtil.getWindow((Component)component);
        if (window != null) {
            List<Rectangle> shadows;
            if (this.myComponent != component) {
                this.myComponent = component;
                this.myShadows = WindowShadowPainter.getShadows(component, window);
            }
            if ((shadows = this.myShadows) != null) {
                for (Rectangle bounds2 : shadows) {
                    PAINTER.paintShadow(component, g, bounds2.x, bounds2.y, bounds2.width, bounds2.height);
                }
            }
        }
    }

    private static List<Rectangle> getShadows(Component component, Window window) {
        Point point = new Point();
        SwingUtilities.convertPointToScreen(point, component);
        return WindowShadowPainter.getShadows(null, point, window.getOwnedWindows());
    }

    private static List<Rectangle> getShadows(List<Rectangle> list2, Point point, Window ... windows) {
        if (windows != null) {
            for (Window window : windows) {
                Rectangle bounds2 = WindowShadowPainter.getShadowBounds(point, window);
                if (bounds2 != null) {
                    if (list2 == null) {
                        list2 = ContainerUtil.newArrayList();
                    }
                    list2.add(bounds2);
                }
                list2 = WindowShadowPainter.getShadows(list2, point, window.getOwnedWindows());
            }
        }
        return list2;
    }

    private static Rectangle getShadowBounds(Point point, Window window) {
        Object property;
        RootPaneContainer container;
        JRootPane root;
        Dialog dialog2;
        Frame frame;
        if (!window.isShowing()) {
            return null;
        }
        if (!window.isDisplayable()) {
            return null;
        }
        if (window instanceof Frame && !(frame = (Frame)window).isUndecorated()) {
            return null;
        }
        if (window instanceof Dialog && !(dialog2 = (Dialog)window).isUndecorated()) {
            return null;
        }
        if (window instanceof RootPaneContainer && (root = (container = (RootPaneContainer)((Object)window)).getRootPane()) != null && (property = root.getClientProperty("Window.shadow")) instanceof Boolean && !((Boolean)property).booleanValue()) {
            return null;
        }
        Rectangle bounds2 = window.getBounds();
        if (bounds2.isEmpty()) {
            return null;
        }
        bounds2.x -= AllIcons.Ide.Shadow.Left.getIconWidth() + point.x;
        bounds2.y -= AllIcons.Ide.Shadow.Top.getIconHeight() + point.y;
        bounds2.width += AllIcons.Ide.Shadow.Left.getIconWidth() + AllIcons.Ide.Shadow.Right.getIconWidth();
        bounds2.height += AllIcons.Ide.Shadow.Top.getIconHeight() + AllIcons.Ide.Shadow.Bottom.getIconHeight();
        return bounds2;
    }
}

