/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.impl.ToolWindowImpl;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.openapi.wm.impl.content.ToolWindowContentUi;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.UIBundle;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.util.ui.JBSwingUtilities;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.accessibility.AccessibleContextUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.function.Supplier;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.PanelUI;
import org.jetbrains.annotations.NotNull;

public abstract class ToolWindowHeader
extends JPanel
implements Disposable,
UISettingsListener {
    @NotNull
    private final Supplier<? extends ActionGroup> myGearProducer;
    private ToolWindow myToolWindow;
    private BufferedImage myImage;
    private BufferedImage myActiveImage;
    private ToolWindowType myImageType;
    private final DefaultActionGroup myActionGroup;
    private final DefaultActionGroup myActionGroupWest;
    private final ActionToolbar myToolbar;
    private ActionToolbar myToolbarWest;
    private final JPanel myWestPanel;

    ToolWindowHeader(final ToolWindowImpl toolWindow, @NotNull Supplier<? extends ActionGroup> gearProducer) {
        if (gearProducer == null) {
            ToolWindowHeader.$$$reportNull$$$0(0);
        }
        this.myActionGroup = new DefaultActionGroup();
        this.myActionGroupWest = new DefaultActionGroup();
        this.myGearProducer = gearProducer;
        this.setLayout(new BorderLayout());
        AccessibleContextUtil.setName((Component)this, (String)"Tool Window Header");
        this.myToolWindow = toolWindow;
        this.myWestPanel = new NonOpaquePanel(){

            public void doLayout() {
                if (this.getComponentCount() == 1) {
                    Rectangle r = this.getBounds();
                    Insets insets = this.getInsets();
                    Component c = this.getComponent(0);
                    Dimension size = c.getPreferredSize();
                    if (size.width < r.width - insets.left - insets.right) {
                        c.setBounds(insets.left, insets.top, size.width, r.height - insets.top - insets.bottom);
                    } else {
                        c.setBounds(insets.left, insets.top, r.width - insets.left - insets.right, r.height - insets.top - insets.bottom);
                    }
                } else if (this.getComponentCount() > 1) {
                    int width2;
                    Rectangle r = this.getBounds();
                    Component c = this.getComponent(0);
                    Dimension min = c.getMinimumSize();
                    Dimension size = c.getPreferredSize();
                    int n = width2 = this.getComponentCount() > 1 ? this.getComponent((int)1).getMinimumSize().width : 0;
                    if (min.width > r.width - width2) {
                        c.setBounds(0, 0, min.width, r.height);
                    } else if (size.width < r.width - width2) {
                        c.setBounds(0, 0, size.width, r.height);
                    } else {
                        c.setBounds(0, 0, r.width - width2, r.height);
                    }
                    if (this.getComponentCount() > 1) {
                        this.getComponent(1).setBounds(c.getWidth(), 0, this.getComponent((int)1).getMinimumSize().width, r.height);
                    }
                }
            }

            public Dimension getMinimumSize() {
                Dimension size = super.getMinimumSize();
                if (this.getComponentCount() > 0) {
                    size.width = Math.max(size.width, this.getComponent((int)0).getMinimumSize().width + (this.getComponentCount() > 1 ? this.getComponent((int)1).getMinimumSize().width : 0));
                }
                return size;
            }
        };
        this.add((Component)this.myWestPanel, "Center");
        this.myWestPanel.add(toolWindow.getContentUI().getTabComponent());
        ToolWindowContentUi.initMouseListeners(this.myWestPanel, toolWindow.getContentUI(), true);
        this.myToolbar = ActionManager.getInstance().createActionToolbar("ToolwindowTitle", (ActionGroup)new DefaultActionGroup(new AnAction[]{this.myActionGroup, new ShowOptionsAction(), new HideAction()}), true);
        this.myToolbar.setTargetComponent((JComponent)this);
        this.myToolbar.setLayoutPolicy(0);
        this.myToolbar.setReservePlaceAutoPopupIcon(false);
        JComponent component = this.myToolbar.getComponent();
        int padding = JBUI.CurrentTheme.ToolWindow.tabVerticalPadding();
        component.setBorder(BorderFactory.createEmptyBorder(padding, 0, padding, 0));
        component.setOpaque(false);
        this.add((Component)component, "East");
        this.myWestPanel.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                toolWindow.getContentUI().showContextMenu(comp, x, y, toolWindow.getPopupGroup(), toolWindow.getContentManager().getSelectedContent());
            }
        });
        this.myWestPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                toolWindow.fireActivated();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!e.isPopupTrigger()) {
                    if (UIUtil.isCloseClick((MouseEvent)e, (int)502)) {
                        if (e.isAltDown()) {
                            toolWindow.fireHidden();
                        } else {
                            toolWindow.fireHiddenSide();
                        }
                    } else {
                        toolWindow.fireActivated();
                    }
                }
            }
        });
        this.setOpaque(true);
        this.setBorder(JBUI.CurrentTheme.ToolWindow.tabBorder());
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent event) {
                ToolWindowManagerImpl mgr = toolWindow.getToolWindowManager();
                mgr.setMaximized(ToolWindowHeader.this.myToolWindow, !mgr.isMaximized(ToolWindowHeader.this.myToolWindow));
                return true;
            }
        }.installOn((Component)this.myWestPanel);
        this.myWestPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                Runnable runnable2 = () -> ToolWindowHeader.this.dispatchEvent(SwingUtilities.convertMouseEvent(e.getComponent(), e, ToolWindowHeader.this));
                SwingUtilities.invokeLater(runnable2);
            }
        });
    }

    private void initWestToolBar(JPanel westPanel) {
        this.myToolbarWest = ActionManager.getInstance().createActionToolbar("ToolwindowTitle", (ActionGroup)new DefaultActionGroup(new AnAction[]{this.myActionGroupWest}), true);
        this.myToolbarWest.setTargetComponent((JComponent)this);
        this.myToolbarWest.setLayoutPolicy(0);
        this.myToolbarWest.setReservePlaceAutoPopupIcon(false);
        JComponent component = this.myToolbarWest.getComponent();
        int padding = JBUI.CurrentTheme.ToolWindow.tabVerticalPadding();
        component.setBorder(BorderFactory.createEmptyBorder(padding, 0, padding, 0));
        component.setOpaque(false);
        westPanel.add(component);
    }

    public void uiSettingsChanged(UISettings uiSettings) {
        this.clearCaches();
    }

    public void dispose() {
        this.removeAll();
        this.myToolWindow = null;
    }

    void setTabActions(@NotNull AnAction[] actions) {
        if (actions == null) {
            ToolWindowHeader.$$$reportNull$$$0(1);
        }
        if (this.myToolbarWest == null) {
            this.initWestToolBar(this.myWestPanel);
        }
        this.myActionGroupWest.removeAll();
        this.myActionGroupWest.addSeparator();
        this.myActionGroupWest.addAll(actions);
        if (this.myToolbarWest != null) {
            this.myToolbarWest.updateActionsImmediately();
        }
    }

    void setAdditionalTitleActions(@NotNull AnAction[] actions) {
        if (actions == null) {
            ToolWindowHeader.$$$reportNull$$$0(2);
        }
        this.myActionGroup.removeAll();
        this.myActionGroup.addAll(actions);
        if (actions.length > 0) {
            this.myActionGroup.addSeparator();
        }
        if (this.myToolbar != null) {
            this.myToolbar.updateActionsImmediately();
        }
    }

    @Override
    protected Graphics getComponentGraphics(Graphics g) {
        return JBSwingUtilities.runGlobalCGTransform((JComponent)this, (Graphics)super.getComponentGraphics(g));
    }

    @Override
    protected void paintComponent(Graphics g) {
        BufferedImage image;
        Rectangle r = this.getBounds();
        Graphics2D g2d = (Graphics2D)g;
        Shape clip = g2d.getClip();
        ToolWindowType type = this.myToolWindow.getType();
        if (this.isActive()) {
            if (this.myActiveImage == null || type != this.myImageType) {
                this.myActiveImage = ToolWindowHeader.drawToBuffer(g2d, true, r.height, this.myToolWindow.getType() == ToolWindowType.FLOATING);
            }
            image = this.myActiveImage;
        } else {
            if (this.myImage == null || type != this.myImageType) {
                this.myImage = ToolWindowHeader.drawToBuffer(g2d, false, r.height, this.myToolWindow.getType() == ToolWindowType.FLOATING);
            }
            image = this.myImage;
        }
        this.myImageType = this.myToolWindow.getType();
        Rectangle clipBounds = clip.getBounds();
        for (int x = clipBounds.x; x < clipBounds.x + clipBounds.width; x += 150) {
            UIUtil.drawImage((Graphics)g, (Image)image, (int)x, (int)0, null);
        }
    }

    private static BufferedImage drawToBuffer(Graphics2D g2d, boolean active, int height, boolean floating) {
        int width = 150;
        BufferedImage image = UIUtil.createImage((Graphics)g2d, (int)150, (int)height, (int)1);
        Graphics2D g = image.createGraphics();
        UIUtil.drawHeader((Graphics)g, (int)0, (int)150, (int)height, (boolean)active, (boolean)true, (!floating ? 1 : 0) != 0, (boolean)true);
        g.dispose();
        return image;
    }

    @Override
    public void setUI(PanelUI ui) {
        this.clearCaches();
        super.setUI(ui);
    }

    public void clearCaches() {
        this.myImage = null;
        this.myActiveImage = null;
    }

    @Override
    protected void paintChildren(Graphics g) {
        Graphics2D graphics = (Graphics2D)g.create();
        UISettings.setupAntialiasing((Graphics)graphics);
        super.paintChildren(graphics);
        Rectangle r = this.getBounds();
        if (!this.isActive() && !UIUtil.isUnderDarcula()) {
            graphics.setColor(new Color(255, 255, 255, 30));
            graphics.fill(r);
        }
        graphics.dispose();
    }

    protected abstract boolean isActive();

    protected abstract void hideToolWindow();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gearProducer";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/wm/impl/ToolWindowHeader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setTabActions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setAdditionalTitleActions";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class HideAction
    extends DumbAwareAction {
        HideAction() {
            this.copyFrom(ActionManager.getInstance().getAction("HideActiveWindow"));
            this.getTemplatePresentation().setIcon(AllIcons.General.HideToolWindow);
            this.getTemplatePresentation().setText(UIBundle.message((String)"tool.window.hide.action.name", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                HideAction.$$$reportNull$$$0(0);
            }
            ToolWindowHeader.this.hideToolWindow();
        }

        public final void update(@NotNull AnActionEvent event) {
            if (event == null) {
                HideAction.$$$reportNull$$$0(1);
            }
            event.getPresentation().setEnabled(ToolWindowHeader.this.myToolWindow != null && ToolWindowHeader.this.myToolWindow.isVisible());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/wm/impl/ToolWindowHeader$HideAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class ShowOptionsAction
    extends DumbAwareAction {
        ShowOptionsAction() {
            this.copyFrom((AnAction)ToolWindowHeader.this.myGearProducer.get());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ShowOptionsAction.$$$reportNull$$$0(0);
            }
            InputEvent inputEvent = e.getInputEvent();
            ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("ToolwindowPopup", (ActionGroup)ToolWindowHeader.this.myGearProducer.get());
            int x = 0;
            int y = 0;
            if (inputEvent instanceof MouseEvent) {
                x = ((MouseEvent)inputEvent).getX();
                y = ((MouseEvent)inputEvent).getY();
            }
            popupMenu.getComponent().show(inputEvent.getComponent(), x, y);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/wm/impl/ToolWindowHeader$ShowOptionsAction", "actionPerformed"));
        }
    }
}

