/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.impl;

import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalChangesUnderRoots {
    private final ChangeListManager myChangeManager;
    private final ProjectLevelVcsManager myVcsManager;
    private VcsRoot[] myRoots;

    public LocalChangesUnderRoots(@NotNull ChangeListManager changeListManager, @NotNull ProjectLevelVcsManager projectLevelVcsManager) {
        if (changeListManager == null) {
            LocalChangesUnderRoots.$$$reportNull$$$0(0);
        }
        if (projectLevelVcsManager == null) {
            LocalChangesUnderRoots.$$$reportNull$$$0(1);
        }
        this.myChangeManager = changeListManager;
        this.myVcsManager = projectLevelVcsManager;
    }

    public Map<String, Map<VirtualFile, Collection<Change>>> getChangesByLists(@NotNull Collection<VirtualFile> rootsToSave) {
        if (rootsToSave == null) {
            LocalChangesUnderRoots.$$$reportNull$$$0(2);
        }
        HashMap<String, Map<VirtualFile, Collection<Change>>> result2 = new HashMap<String, Map<VirtualFile, Collection<Change>>>();
        this.myRoots = this.myVcsManager.getAllVcsRoots();
        List changeLists = this.myChangeManager.getChangeListsCopy();
        for (LocalChangeList list2 : changeLists) {
            HashMap<VirtualFile, Collection<Change>> subMap = new HashMap<VirtualFile, Collection<Change>>();
            this.addChangesToMap(rootsToSave, subMap, list2.getChanges());
            result2.put(list2.getName(), subMap);
        }
        return result2;
    }

    @NotNull
    public Map<VirtualFile, Collection<Change>> getChangesUnderRoots(@NotNull Collection<VirtualFile> rootsToSave) {
        if (rootsToSave == null) {
            LocalChangesUnderRoots.$$$reportNull$$$0(3);
        }
        HashMap<VirtualFile, Collection<Change>> result2 = new HashMap<VirtualFile, Collection<Change>>();
        Collection allChanges = this.myChangeManager.getAllChanges();
        this.myRoots = this.myVcsManager.getAllVcsRoots();
        this.addChangesToMap(rootsToSave, result2, allChanges);
        HashMap<VirtualFile, Collection<Change>> hashMap = result2;
        if (hashMap == null) {
            LocalChangesUnderRoots.$$$reportNull$$$0(4);
        }
        return hashMap;
    }

    private void addChangesToMap(Collection<VirtualFile> rootsToSave, Map<VirtualFile, Collection<Change>> result2, Collection<? extends Change> allChanges) {
        for (Change change : allChanges) {
            if (change.getBeforeRevision() != null) {
                this.addChangeToMap(result2, change, change.getBeforeRevision(), rootsToSave);
            }
            if (change.getAfterRevision() == null) continue;
            this.addChangeToMap(result2, change, change.getAfterRevision(), rootsToSave);
        }
    }

    private void addChangeToMap(@NotNull Map<VirtualFile, Collection<Change>> result2, @NotNull Change change, @NotNull ContentRevision revision, @NotNull Collection<VirtualFile> rootsToSave) {
        if (result2 == null) {
            LocalChangesUnderRoots.$$$reportNull$$$0(5);
        }
        if (change == null) {
            LocalChangesUnderRoots.$$$reportNull$$$0(6);
        }
        if (revision == null) {
            LocalChangesUnderRoots.$$$reportNull$$$0(7);
        }
        if (rootsToSave == null) {
            LocalChangesUnderRoots.$$$reportNull$$$0(8);
        }
        VirtualFile root = this.getRootForPath(revision.getFile(), rootsToSave);
        LocalChangesUnderRoots.addChangeToMap(result2, root, change);
    }

    @Nullable
    private VirtualFile getRootForPath(@NotNull FilePath file2, @NotNull Collection<VirtualFile> rootsToSave) {
        VirtualFile vf;
        if (file2 == null) {
            LocalChangesUnderRoots.$$$reportNull$$$0(9);
        }
        if (rootsToSave == null) {
            LocalChangesUnderRoots.$$$reportNull$$$0(10);
        }
        if ((vf = ChangesUtil.findValidParentUnderReadAction((FilePath)file2)) == null) {
            return null;
        }
        VirtualFile rootCandidate = null;
        for (VcsRoot root : this.myRoots) {
            if (!VfsUtilCore.isAncestor((VirtualFile)root.getPath(), (VirtualFile)vf, (boolean)false) || rootCandidate != null && !VfsUtil.isAncestor((VirtualFile)rootCandidate, (VirtualFile)root.getPath(), (boolean)true)) continue;
            rootCandidate = root.getPath();
        }
        if (!rootsToSave.contains(rootCandidate)) {
            return null;
        }
        return rootCandidate;
    }

    private static void addChangeToMap(@NotNull Map<VirtualFile, Collection<Change>> result2, @Nullable VirtualFile root, @NotNull Change change) {
        if (result2 == null) {
            LocalChangesUnderRoots.$$$reportNull$$$0(11);
        }
        if (change == null) {
            LocalChangesUnderRoots.$$$reportNull$$$0(12);
        }
        if (root == null) {
            return;
        }
        Collection<Change> changes2 = result2.get(root);
        if (changes2 == null) {
            changes2 = new HashSet<Change>();
            result2.put(root, changes2);
        }
        changes2.add(change);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectLevelVcsManager";
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootsToSave";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/impl/LocalChangesUnderRoots";
                break;
            }
            case 5: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/impl/LocalChangesUnderRoots";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesUnderRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getChangesByLists";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getChangesUnderRoots";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addChangeToMap";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getRootForPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

