/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.ide.DataManager;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.VcsInternalDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.history.FileHistoryPanelImpl;
import com.intellij.openapi.vcs.history.FileHistoryRefresherI;
import com.intellij.openapi.vcs.history.LimitHistoryCheck;
import com.intellij.openapi.vcs.history.VcsAbstractHistorySession;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsHistorySession;
import com.intellij.openapi.vcs.history.VcsHistorySessionConsumer;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.components.JBPanel;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.BufferedListConsumer;
import com.intellij.util.Consumer;
import com.intellij.util.ContentUtilEx;
import com.intellij.vcsUtil.VcsUtil;
import java.awt.BorderLayout;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileHistorySessionPartner
implements VcsHistorySessionConsumer,
Disposable {
    @NotNull
    private final AbstractVcs myVcs;
    @NotNull
    private final VcsHistoryProvider myVcsHistoryProvider;
    @NotNull
    private final FilePath myPath;
    @Nullable
    private final VcsRevisionNumber myStartingRevisionNumber;
    @NotNull
    private final FileHistoryRefresherI myRefresher;
    @NotNull
    private final LimitHistoryCheck myLimitHistoryCheck;
    @NotNull
    private final BufferedListConsumer<VcsFileRevision> myBuffer;
    @NotNull
    private final FileHistoryContentPanel myContentPanel;
    private volatile VcsAbstractHistorySession mySession;

    public FileHistorySessionPartner(@NotNull VcsHistoryProvider vcsHistoryProvider, @NotNull FilePath path, @Nullable VcsRevisionNumber startingRevisionNumber, @NotNull AbstractVcs vcs, @NotNull FileHistoryRefresherI refresher) {
        if (vcsHistoryProvider == null) {
            FileHistorySessionPartner.$$$reportNull$$$0(0);
        }
        if (path == null) {
            FileHistorySessionPartner.$$$reportNull$$$0(1);
        }
        if (vcs == null) {
            FileHistorySessionPartner.$$$reportNull$$$0(2);
        }
        if (refresher == null) {
            FileHistorySessionPartner.$$$reportNull$$$0(3);
        }
        this.mySession = null;
        this.myVcsHistoryProvider = vcsHistoryProvider;
        this.myPath = path;
        this.myStartingRevisionNumber = startingRevisionNumber;
        this.myRefresher = refresher;
        this.myLimitHistoryCheck = new LimitHistoryCheck(vcs.getProject(), path.getPath());
        this.myVcs = vcs;
        this.myContentPanel = new FileHistoryContentPanel();
        Consumer sessionRefresher = vcsFileRevisions -> {
            this.mySession.getRevisionList().addAll(vcsFileRevisions);
            VcsHistorySession copy = this.mySession.copyWithCachedRevision();
            ApplicationManager.getApplication().invokeLater(() -> this.myContentPanel.setHistorySession(copy));
        };
        this.myBuffer = new BufferedListConsumer<VcsFileRevision>(5, sessionRefresher, 1000){

            @Override
            protected void invokeConsumer(@NotNull Runnable consumerRunnable) {
                if (consumerRunnable == null) {
                    1.$$$reportNull$$$0(0);
                }
                consumerRunnable.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumerRunnable", "com/intellij/openapi/vcs/history/FileHistorySessionPartner$1", "invokeConsumer"));
            }
        };
    }

    @Nullable
    static FileHistoryRefresherI findExistingHistoryRefresher(@NotNull Project project, @NotNull FilePath path, @Nullable VcsRevisionNumber startingRevisionNumber) {
        JComponent component;
        if (project == null) {
            FileHistorySessionPartner.$$$reportNull$$$0(4);
        }
        if (path == null) {
            FileHistorySessionPartner.$$$reportNull$$$0(5);
        }
        if ((component = ContentUtilEx.findContentComponent(FileHistorySessionPartner.getToolWindow(project).getContentManager(), (Condition<? super JComponent>)((Condition)comp -> comp instanceof FileHistoryContentPanel && FileHistoryPanelImpl.sameHistories(((FileHistoryContentPanel)((Object)((Object)comp))).getPath(), ((FileHistoryContentPanel)((Object)((Object)comp))).getRevision(), path, startingRevisionNumber)))) == null) {
            return null;
        }
        DataProvider dataProvider = DataManagerImpl.getDataProviderEx(component);
        if (dataProvider == null) {
            return null;
        }
        return (FileHistoryRefresherI)VcsInternalDataKeys.FILE_HISTORY_REFRESHER.getData(dataProvider);
    }

    public boolean shouldBeRefreshed() {
        return this.mySession.shouldBeRefreshed();
    }

    public void acceptRevision(VcsFileRevision revision) {
        this.myLimitHistoryCheck.checkNumber();
        this.myBuffer.consumeOne(revision);
    }

    public void reportCreatedEmptySession(VcsAbstractHistorySession session2) {
        if (this.mySession != null && session2 != null && this.mySession.getRevisionList().equals(session2.getRevisionList())) {
            return;
        }
        this.mySession = session2;
        if (this.mySession != null) {
            this.mySession.shouldBeRefreshed();
            List revisionList = this.mySession.getRevisionList();
            while (this.myLimitHistoryCheck.isOver(revisionList.size())) {
                revisionList.remove(revisionList.size() - 1);
            }
        }
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (this.mySession != null) {
                this.myContentPanel.setHistorySession(this.mySession.copyWithCachedRevision());
            }
        });
    }

    @NotNull
    private static ToolWindow getToolWindow(@NotNull Project project) {
        if (project == null) {
            FileHistorySessionPartner.$$$reportNull$$$0(6);
        }
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)project).getToolWindow(ToolWindowId.VCS);
        assert (toolWindow != null) : "Version Control ToolWindow should be available at this point.";
        ToolWindow toolWindow2 = toolWindow;
        if (toolWindow2 == null) {
            FileHistorySessionPartner.$$$reportNull$$$0(7);
        }
        return toolWindow2;
    }

    public void reportException(VcsException exception) {
        VcsBalloonProblemNotifier.showOverVersionControlView(this.myVcs.getProject(), VcsBundle.message((String)"message.title.could.not.load.file.history", (Object[])new Object[0]) + ": " + exception.getMessage(), MessageType.ERROR);
    }

    public void beforeRefresh() {
        this.myLimitHistoryCheck.reset();
    }

    public void createOrSelectContent() {
        ToolWindow toolWindow = FileHistorySessionPartner.getToolWindow(this.myVcs.getProject());
        ContentManager manager = toolWindow.getContentManager();
        boolean selectedExistingContent = ContentUtilEx.selectContent(manager, (JComponent)((Object)this.myContentPanel), true);
        if (!selectedExistingContent) {
            String tabName = this.myPath.getName();
            if (this.myStartingRevisionNumber != null) {
                tabName = tabName + " (" + VcsUtil.getShortRevisionString((VcsRevisionNumber)this.myStartingRevisionNumber) + ")";
            }
            ContentUtilEx.addTabbedContent(manager, (JComponent)((Object)this.myContentPanel), "History", tabName, true, this);
        }
        toolWindow.activate(null);
    }

    public void finished() {
        this.myBuffer.flush();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (this.mySession == null) {
                return;
            }
            this.myContentPanel.finishRefresh();
        });
    }

    public void dispose() {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsHistoryProvider";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refresher";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/history/FileHistorySessionPartner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/history/FileHistorySessionPartner";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolWindow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findExistingHistoryRefresher";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getToolWindow";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class FileHistoryContentPanel
    extends JBPanel {
        @Nullable
        private FileHistoryPanelImpl myFileHistoryPanel;

        private FileHistoryContentPanel() {
            super((LayoutManager)new BorderLayout());
        }

        public void setHistorySession(@NotNull VcsHistorySession session2) {
            if (session2 == null) {
                FileHistoryContentPanel.$$$reportNull$$$0(0);
            }
            if (this.myFileHistoryPanel == null) {
                this.myFileHistoryPanel = new FileHistoryPanelImpl(FileHistorySessionPartner.this.myVcs, FileHistorySessionPartner.this.myPath, FileHistorySessionPartner.this.myStartingRevisionNumber, session2, FileHistorySessionPartner.this.myVcsHistoryProvider, FileHistorySessionPartner.this.myRefresher, false);
                this.add(this.myFileHistoryPanel, "Center");
                DataManager.registerDataProvider((JComponent)((Object)this), (DataProvider)this.myFileHistoryPanel);
                Disposer.register((Disposable)FileHistorySessionPartner.this, (Disposable)this.myFileHistoryPanel);
            } else if (!session2.getRevisionList().isEmpty()) {
                this.myFileHistoryPanel.setHistorySession(session2);
            }
        }

        public void finishRefresh() {
            if (this.myFileHistoryPanel != null) {
                this.myFileHistoryPanel.finishRefresh();
            }
        }

        @NotNull
        public FilePath getPath() {
            FilePath filePath = FileHistorySessionPartner.this.myPath;
            if (filePath == null) {
                FileHistoryContentPanel.$$$reportNull$$$0(1);
            }
            return filePath;
        }

        @Nullable
        public VcsRevisionNumber getRevision() {
            return FileHistorySessionPartner.this.myStartingRevisionNumber;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "session";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/history/FileHistorySessionPartner$FileHistoryContentPanel";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/history/FileHistorySessionPartner$FileHistoryContentPanel";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "setHistorySession";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

