/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.history;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.history.CurrentRevision;
import com.intellij.openapi.vcs.history.DiffFromHistoryHandler;
import com.intellij.openapi.vcs.history.VcsDiffUtil;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsHistoryUtil;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseDiffFromHistoryHandler<T extends VcsFileRevision>
implements DiffFromHistoryHandler {
    private static final Logger LOG = Logger.getInstance(BaseDiffFromHistoryHandler.class);
    @NotNull
    protected final Project myProject;

    protected BaseDiffFromHistoryHandler(@NotNull Project project) {
        if (project == null) {
            BaseDiffFromHistoryHandler.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public void showDiffForOne(@NotNull AnActionEvent e, @NotNull Project project, @NotNull FilePath filePath, @NotNull VcsFileRevision previousRevision, @NotNull VcsFileRevision revision) {
        if (e == null) {
            BaseDiffFromHistoryHandler.$$$reportNull$$$0(1);
        }
        if (project == null) {
            BaseDiffFromHistoryHandler.$$$reportNull$$$0(2);
        }
        if (filePath == null) {
            BaseDiffFromHistoryHandler.$$$reportNull$$$0(3);
        }
        if (previousRevision == null) {
            BaseDiffFromHistoryHandler.$$$reportNull$$$0(4);
        }
        if (revision == null) {
            BaseDiffFromHistoryHandler.$$$reportNull$$$0(5);
        }
        this.doShowDiff(filePath, previousRevision, revision);
    }

    public void showDiffForTwo(@NotNull Project project, @NotNull FilePath filePath, @NotNull VcsFileRevision older, @NotNull VcsFileRevision newer) {
        if (project == null) {
            BaseDiffFromHistoryHandler.$$$reportNull$$$0(6);
        }
        if (filePath == null) {
            BaseDiffFromHistoryHandler.$$$reportNull$$$0(7);
        }
        if (older == null) {
            BaseDiffFromHistoryHandler.$$$reportNull$$$0(8);
        }
        if (newer == null) {
            BaseDiffFromHistoryHandler.$$$reportNull$$$0(9);
        }
        this.doShowDiff(filePath, older, newer);
    }

    protected void doShowDiff(@NotNull FilePath filePath, @NotNull VcsFileRevision older, @NotNull VcsFileRevision newer) {
        if (filePath == null) {
            BaseDiffFromHistoryHandler.$$$reportNull$$$0(10);
        }
        if (older == null) {
            BaseDiffFromHistoryHandler.$$$reportNull$$$0(11);
        }
        if (newer == null) {
            BaseDiffFromHistoryHandler.$$$reportNull$$$0(12);
        }
        if (!filePath.isDirectory()) {
            VcsHistoryUtil.showDifferencesInBackground(this.myProject, filePath, older, newer);
        } else if (older.equals(VcsFileRevision.NULL)) {
            VcsFileRevision right = newer;
            this.showAffectedChanges(filePath, right);
        } else if (newer instanceof CurrentRevision) {
            VcsFileRevision left = older;
            this.showChangesBetweenRevisions(filePath, left, null);
        } else {
            VcsFileRevision left = older;
            VcsFileRevision right = newer;
            this.showChangesBetweenRevisions(filePath, left, right);
        }
    }

    protected void showChangesBetweenRevisions(final @NotNull FilePath path, @NotNull T older, @Nullable T newer) {
        if (path == null) {
            BaseDiffFromHistoryHandler.$$$reportNull$$$0(13);
        }
        if (older == null) {
            BaseDiffFromHistoryHandler.$$$reportNull$$$0(14);
        }
        new CollectChangesTask("Comparing revisions...", (VcsFileRevision)older, (VcsFileRevision)newer){
            final /* synthetic */ VcsFileRevision val$older;
            final /* synthetic */ VcsFileRevision val$newer;
            {
                this.val$older = vcsFileRevision;
                this.val$newer = vcsFileRevision2;
                super(title);
            }

            @Override
            @NotNull
            public List<Change> getChanges() throws VcsException {
                List<Change> list2 = BaseDiffFromHistoryHandler.this.getChangesBetweenRevisions(path, this.val$older, this.val$newer);
                if (list2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                return list2;
            }

            @Override
            @NotNull
            public String getDialogTitle() {
                String string = BaseDiffFromHistoryHandler.this.getChangesBetweenRevisionsDialogTitle(path, this.val$older, this.val$newer);
                if (string == null) {
                    1.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/openapi/vcs/history/BaseDiffFromHistoryHandler$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getChanges";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDialogTitle";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }.queue();
    }

    protected void showAffectedChanges(final @NotNull FilePath path, @NotNull T rev) {
        if (path == null) {
            BaseDiffFromHistoryHandler.$$$reportNull$$$0(15);
        }
        if (rev == null) {
            BaseDiffFromHistoryHandler.$$$reportNull$$$0(16);
        }
        new CollectChangesTask("Collecting affected changes...", (VcsFileRevision)rev){
            final /* synthetic */ VcsFileRevision val$rev;
            {
                this.val$rev = vcsFileRevision;
                super(title);
            }

            @Override
            @NotNull
            public List<Change> getChanges() throws VcsException {
                List<Change> list2 = BaseDiffFromHistoryHandler.this.getAffectedChanges(path, this.val$rev);
                if (list2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return list2;
            }

            @Override
            @NotNull
            public String getDialogTitle() {
                String string = BaseDiffFromHistoryHandler.this.getAffectedChangesDialogTitle(path, this.val$rev);
                if (string == null) {
                    2.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/openapi/vcs/history/BaseDiffFromHistoryHandler$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getChanges";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDialogTitle";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        }.queue();
    }

    @NotNull
    protected abstract List<Change> getChangesBetweenRevisions(@NotNull FilePath var1, @NotNull T var2, @Nullable T var3) throws VcsException;

    @NotNull
    protected abstract List<Change> getAffectedChanges(@NotNull FilePath var1, @NotNull T var2) throws VcsException;

    @NotNull
    protected abstract String getPresentableName(@NotNull T var1);

    protected void showChangesDialog(@NotNull String title, @NotNull List<? extends Change> changes2) {
        if (title == null) {
            BaseDiffFromHistoryHandler.$$$reportNull$$$0(17);
        }
        if (changes2 == null) {
            BaseDiffFromHistoryHandler.$$$reportNull$$$0(18);
        }
        VcsDiffUtil.showChangesDialog(this.myProject, title, changes2);
    }

    protected void showError(@NotNull VcsException e, @NotNull String logMessage) {
        if (e == null) {
            BaseDiffFromHistoryHandler.$$$reportNull$$$0(19);
        }
        if (logMessage == null) {
            BaseDiffFromHistoryHandler.$$$reportNull$$$0(20);
        }
        LOG.info(logMessage, (Throwable)e);
        VcsBalloonProblemNotifier.showOverVersionControlView(this.myProject, e.getMessage(), MessageType.ERROR);
    }

    @NotNull
    protected String getChangesBetweenRevisionsDialogTitle(@NotNull FilePath path, @NotNull T rev1, @Nullable T rev2) {
        if (path == null) {
            BaseDiffFromHistoryHandler.$$$reportNull$$$0(21);
        }
        if (rev1 == null) {
            BaseDiffFromHistoryHandler.$$$reportNull$$$0(22);
        }
        String rev1Title = this.getPresentableName(rev1);
        String string = rev2 != null ? String.format("Difference between %s and %s in %s", rev1Title, this.getPresentableName(rev2), path.getName()) : String.format("Difference between %s and local version in %s", rev1Title, path.getName());
        if (string == null) {
            BaseDiffFromHistoryHandler.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    protected String getAffectedChangesDialogTitle(@NotNull FilePath path, @NotNull T rev) {
        if (path == null) {
            BaseDiffFromHistoryHandler.$$$reportNull$$$0(24);
        }
        if (rev == null) {
            BaseDiffFromHistoryHandler.$$$reportNull$$$0(25);
        }
        String string = String.format("Initial commit %s in %s", this.getPresentableName(rev), path.getName());
        if (string == null) {
            BaseDiffFromHistoryHandler.$$$reportNull$$$0(26);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 23: 
            case 26: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 23: 
            case 26: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previousRevision";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revision";
                break;
            }
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "older";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newer";
                break;
            }
            case 13: 
            case 15: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 16: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rev";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logMessage";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rev1";
                break;
            }
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/history/BaseDiffFromHistoryHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/history/BaseDiffFromHistoryHandler";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesBetweenRevisionsDialogTitle";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getAffectedChangesDialogTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "showDiffForOne";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showDiffForTwo";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doShowDiff";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "showChangesBetweenRevisions";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "showAffectedChanges";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "showChangesDialog";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "showError";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getChangesBetweenRevisionsDialogTitle";
                break;
            }
            case 23: 
            case 26: {
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getAffectedChangesDialogTitle";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 23: 
            case 26: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected abstract class CollectChangesTask
    extends Task.Backgroundable {
        private List<Change> myChanges;

        public CollectChangesTask(String title) {
            if (title == null) {
                CollectChangesTask.$$$reportNull$$$0(0);
            }
            super(BaseDiffFromHistoryHandler.this.myProject, title);
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                CollectChangesTask.$$$reportNull$$$0(1);
            }
            try {
                this.myChanges = this.getChanges();
            }
            catch (VcsException e) {
                BaseDiffFromHistoryHandler.this.showError(e, "Error during task: " + this.getDialogTitle());
            }
        }

        @NotNull
        public abstract List<Change> getChanges() throws VcsException;

        @NotNull
        public abstract String getDialogTitle();

        public void onSuccess() {
            BaseDiffFromHistoryHandler.this.showChangesDialog(this.getDialogTitle(), ContainerUtil.notNullize(this.myChanges));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/history/BaseDiffFromHistoryHandler$CollectChangesTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

