/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.configurable;

import com.google.common.collect.Maps;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.configurable.VcsDirectoryConfigurationPanel;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vcs.impl.VcsDescriptor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.UtilKt;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class VcsMappingConfigurationDialog
extends DialogWrapper {
    @NotNull
    private final Project myProject;
    private ComboBox<VcsDescriptor> myVCSComboBox;
    private TextFieldWithBrowseButton myDirectoryTextField;
    private JPanel myPanel;
    private JPanel myVcsConfigurablePlaceholder;
    private JRadioButton myProjectRadioButton;
    private JRadioButton myDirectoryRadioButton;
    private JBLabel myProjectButtonComment;
    private UnnamedConfigurable myVcsConfigurable;
    private VcsDirectoryMapping myMappingCopy;
    private JComponent myVcsConfigurableComponent;
    private final ProjectLevelVcsManager myVcsManager;
    @NotNull
    private final Map<String, VcsDescriptor> myVcses;

    public VcsMappingConfigurationDialog(@NotNull Project project, String title) {
        if (project == null) {
            VcsMappingConfigurationDialog.$$$reportNull$$$0(0);
        }
        super(project, false);
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        this.myVcses = Maps.uniqueIndex((Iterable)ContainerUtil.list((Object[])this.myVcsManager.getAllVcss()), VcsDescriptor::getName);
        this.myVCSComboBox.setModel(VcsDirectoryConfigurationPanel.buildVcsWrappersModel(project));
        this.myDirectoryTextField.addActionListener((ActionListener)((Object)new MyBrowseFolderListener("Select Directory", "Select directory to map to a VCS", this.myDirectoryTextField, project, FileChooserDescriptorFactory.createSingleFolderDescriptor())));
        this.myMappingCopy = new VcsDirectoryMapping("", "");
        this.setTitle(title);
        this.init();
        this.myVCSComboBox.addActionListener(e -> this.updateVcsConfigurable());
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    public void setMapping(@NotNull VcsDirectoryMapping mapping) {
        if (mapping == null) {
            VcsMappingConfigurationDialog.$$$reportNull$$$0(1);
        }
        this.myMappingCopy = new VcsDirectoryMapping(mapping.getDirectory(), mapping.getVcs(), mapping.getRootSettings());
        this.myProjectRadioButton.setSelected(this.myMappingCopy.isDefaultMapping());
        this.myDirectoryRadioButton.setSelected(!this.myProjectRadioButton.isSelected());
        this.myDirectoryTextField.setText(this.myMappingCopy.isDefaultMapping() ? "" : FileUtil.toSystemDependentName((String)mapping.getDirectory()));
        this.myVCSComboBox.setSelectedItem((Object)this.myVcses.get(mapping.getVcs()));
        this.updateVcsConfigurable();
        this.myDirectoryTextField.setEnabled(this.myDirectoryRadioButton.isSelected());
        this.initProjectMessage();
    }

    @NotNull
    public VcsDirectoryMapping getMapping() {
        VcsDescriptor wrapper2 = (VcsDescriptor)this.myVCSComboBox.getSelectedItem();
        String vcs = wrapper2 == null || wrapper2.isNone() ? "" : wrapper2.getName();
        String directory = this.myProjectRadioButton.isSelected() ? "" : FileUtil.toSystemIndependentName((String)this.myDirectoryTextField.getText());
        VcsDirectoryMapping vcsDirectoryMapping = new VcsDirectoryMapping(directory, vcs, this.myMappingCopy.getRootSettings());
        if (vcsDirectoryMapping == null) {
            VcsMappingConfigurationDialog.$$$reportNull$$$0(2);
        }
        return vcsDirectoryMapping;
    }

    private void updateVcsConfigurable() {
        UnnamedConfigurable configurable;
        AbstractVcs vcs;
        VcsDescriptor wrapper2;
        if (this.myVcsConfigurable != null) {
            this.myVcsConfigurablePlaceholder.remove(this.myVcsConfigurableComponent);
            this.myVcsConfigurable.disposeUIResources();
            this.myVcsConfigurable = null;
        }
        if ((wrapper2 = (VcsDescriptor)this.myVCSComboBox.getSelectedItem()) != null && !wrapper2.isNone() && (vcs = this.myVcsManager.findVcsByName(wrapper2.getName())) != null && (configurable = vcs.getRootConfigurable(this.myMappingCopy)) != null) {
            this.myVcsConfigurable = configurable;
            this.myVcsConfigurableComponent = (JComponent)ObjectUtils.notNull((Object)this.myVcsConfigurable.createComponent());
            this.myVcsConfigurablePlaceholder.add((Component)this.myVcsConfigurableComponent, "Center");
        }
        this.pack();
    }

    protected void doOKAction() {
        if (this.myVcsConfigurable != null) {
            try {
                this.myVcsConfigurable.apply();
            }
            catch (ConfigurationException ex) {
                Messages.showErrorDialog((Component)this.myPanel, (String)("Invalid VCS options: " + ex.getMessage()));
            }
        }
        super.doOKAction();
    }

    private void createUIComponents() {
        ButtonGroup bg = new ButtonGroup();
        this.myProjectRadioButton = new JRadioButton();
        this.myDirectoryRadioButton = new JRadioButton();
        bg.add(this.myProjectRadioButton);
        bg.add(this.myDirectoryRadioButton);
        ActionListener listener2 = e -> this.myDirectoryTextField.setEnabled(this.myDirectoryRadioButton.isSelected());
        this.myProjectRadioButton.addActionListener(listener2);
        this.myDirectoryRadioButton.addActionListener(listener2);
        this.myDirectoryRadioButton.setSelected(true);
    }

    public void initProjectMessage() {
        this.myProjectButtonComment.setText(XmlStringUtil.wrapInHtml((CharSequence)DefaultVcsRootPolicy.getInstance(this.myProject).getProjectConfigurationMessage(this.myProject)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/configurable/VcsMappingConfigurationDialog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/configurable/VcsMappingConfigurationDialog";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMapping";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setMapping";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JPanel jPanel;
        ComboBox comboBox2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(6, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(5, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("VCS:");
        jPanel2.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDirectoryTextField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, new Dimension(300, -1), null));
        this.myVCSComboBox = comboBox2 = new ComboBox();
        jPanel2.add((Component)comboBox2, new GridConstraints(3, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myVcsConfigurablePlaceholder = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(4, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JRadioButton jRadioButton = this.myProjectRadioButton;
        jRadioButton.setText("Project");
        jPanel2.add((Component)jRadioButton, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 0, null, null, null));
        JRadioButton jRadioButton2 = this.myDirectoryRadioButton;
        jRadioButton2.setText("Directory:");
        jPanel2.add((Component)jRadioButton2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myProjectButtonComment = jBLabel = new JBLabel();
        jBLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel.setText("test");
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null, 3));
        jLabel.setLabelFor((Component)comboBox2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private class MyBrowseFolderListener
    extends ComponentWithBrowseButton.BrowseFolderActionListener<JTextField> {
        MyBrowseFolderListener(String title, String description, TextFieldWithBrowseButton textField2, Project project, FileChooserDescriptor fileChooserDescriptor2) {
            super(title, description, (ComponentWithBrowseButton)textField2, project, fileChooserDescriptor2, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        }

        protected VirtualFile getInitialFile() {
            VirtualFile file2;
            String text = this.getComponentText();
            if (text.isEmpty() && (file2 = VcsMappingConfigurationDialog.this.myProject.getBaseDir()) != null) {
                return file2;
            }
            return super.getInitialFile();
        }

        protected void onFileChosen(final @NotNull VirtualFile chosenFile) {
            if (chosenFile == null) {
                MyBrowseFolderListener.$$$reportNull$$$0(0);
            }
            String oldText = VcsMappingConfigurationDialog.this.myDirectoryTextField.getText();
            super.onFileChosen(chosenFile);
            VcsDescriptor wrapper2 = (VcsDescriptor)VcsMappingConfigurationDialog.this.myVCSComboBox.getSelectedItem();
            if (oldText.isEmpty() && (wrapper2 == null || wrapper2.isNone())) {
                new Task.Backgroundable(VcsMappingConfigurationDialog.this.myProject, "Looking for VCS Administrative Area", false){
                    private VcsDescriptor probableVcs;
                    {
                        super(arg0, arg1, arg2);
                        this.probableVcs = null;
                    }

                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        this.probableVcs = (VcsDescriptor)UtilKt.getIfSingle(VcsMappingConfigurationDialog.this.myVcses.values().stream().filter(descriptor -> descriptor.probablyUnderVcs(chosenFile)));
                    }

                    public void onSuccess() {
                        if (this.probableVcs != null) {
                            VcsMappingConfigurationDialog.this.myVCSComboBox.setSelectedItem((Object)this.probableVcs);
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/configurable/VcsMappingConfigurationDialog$MyBrowseFolderListener$1", "run"));
                    }
                }.queue();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chosenFile", "com/intellij/openapi/vcs/configurable/VcsMappingConfigurationDialog$MyBrowseFolderListener", "onFileChosen"));
        }
    }
}

