/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.IgnoreSettingsType;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vcs.changes.ui.IgnoreUnversionedDialog;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ListUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.Function;
import java.util.HashSet;
import java.util.Set;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IgnoredSettingsPanel
implements SearchableConfigurable,
Configurable.NoScroll {
    private final JBList<IgnoredFileBean> myList;
    private JPanel myPanel;
    private final Project myProject;
    private DefaultListModel<IgnoredFileBean> myModel = new DefaultListModel();
    private final ChangeListManagerImpl myChangeListManager;
    private final Set<String> myDirectoriesManuallyRemovedFromIgnored = new HashSet<String>();

    public IgnoredSettingsPanel(Project project) {
        this.myList = new JBList();
        this.myList.setCellRenderer((ListCellRenderer)((Object)new MyCellRenderer()));
        this.myList.getEmptyText().setText(VcsBundle.message((String)"no.ignored.files", (Object[])new Object[0]));
        new ListSpeedSearch<IgnoredFileBean>((JList<IgnoredFileBean>)this.myList, (Function<IgnoredFileBean, String>)((Function)bean -> IgnoredSettingsPanel.getBeanTextPresentation(bean)));
        this.myProject = project;
        this.myChangeListManager = ChangeListManagerImpl.getInstanceImpl(this.myProject);
    }

    private void setItems(IgnoredFileBean[] filesToIgnore) {
        this.myModel = new DefaultListModel();
        for (IgnoredFileBean bean : filesToIgnore) {
            this.myModel.addElement(bean);
        }
        this.myList.setModel(this.myModel);
    }

    private IgnoredFileBean[] getItems() {
        int count = this.myModel.getSize();
        IgnoredFileBean[] result2 = new IgnoredFileBean[count];
        for (int i = 0; i < count; ++i) {
            result2[i] = this.myModel.getElementAt(i);
        }
        return result2;
    }

    private void addItem() {
        IgnoreUnversionedDialog dlg = new IgnoreUnversionedDialog(this.myProject);
        if (dlg.showAndGet()) {
            IgnoredFileBean[] ignoredFiles;
            for (IgnoredFileBean bean : ignoredFiles = dlg.getSelectedIgnoredFiles()) {
                this.myModel.addElement(bean);
            }
        }
    }

    private void editItem() {
        IgnoredFileBean bean = (IgnoredFileBean)this.myList.getSelectedValue();
        if (bean == null) {
            return;
        }
        IgnoreUnversionedDialog dlg = new IgnoreUnversionedDialog(this.myProject);
        dlg.setIgnoredFile(bean);
        if (dlg.showAndGet()) {
            IgnoredFileBean[] beans = dlg.getSelectedIgnoredFiles();
            assert (beans.length == 1);
            int selectedIndex = this.myList.getSelectedIndex();
            this.myModel.setElementAt(beans[0], selectedIndex);
        }
    }

    private void deleteItems() {
        for (IgnoredFileBean bean : this.myList.getSelectedValuesList()) {
            if (bean.getType() != IgnoreSettingsType.UNDER_DIR) continue;
            this.myDirectoriesManuallyRemovedFromIgnored.add(bean.getPath());
        }
        ListUtil.removeSelectedItems(this.myList);
    }

    public void reset() {
        this.setItems(this.myChangeListManager.getFilesToIgnore());
        this.myDirectoriesManuallyRemovedFromIgnored.clear();
        this.myDirectoriesManuallyRemovedFromIgnored.addAll(this.myChangeListManager.getIgnoredFilesComponent().getDirectoriesManuallyRemovedFromIgnored());
    }

    public void apply() {
        IgnoredFileBean[] toIgnore = this.getItems();
        this.myChangeListManager.setFilesToIgnore(toIgnore);
        for (IgnoredFileBean bean : toIgnore) {
            if (bean.getType() != IgnoreSettingsType.UNDER_DIR) continue;
            this.myDirectoriesManuallyRemovedFromIgnored.remove(bean.getPath());
        }
        this.myChangeListManager.getIgnoredFilesComponent().setDirectoriesManuallyRemovedFromIgnored(this.myDirectoriesManuallyRemovedFromIgnored);
    }

    public boolean isModified() {
        return !Comparing.equal((Object[])this.myChangeListManager.getFilesToIgnore(), (Object[])this.getItems());
    }

    public JComponent createComponent() {
        if (this.myPanel == null) {
            this.myPanel = ToolbarDecorator.createDecorator(this.myList).setAddAction(new AnActionButtonRunnable(){

                public void run(AnActionButton button2) {
                    IgnoredSettingsPanel.this.addItem();
                }
            }).setEditAction(new AnActionButtonRunnable(){

                public void run(AnActionButton button2) {
                    IgnoredSettingsPanel.this.editItem();
                }
            }).setRemoveAction(new AnActionButtonRunnable(){

                public void run(AnActionButton button2) {
                    IgnoredSettingsPanel.this.deleteItems();
                }
            }).disableUpDownActions().createPanel();
        }
        return this.myPanel;
    }

    @Nls
    public String getDisplayName() {
        return "Ignored Files";
    }

    @NotNull
    public String getHelpTopic() {
        if ("project.propVCSSupport.Ignored.Files" == null) {
            IgnoredSettingsPanel.$$$reportNull$$$0(0);
        }
        return "project.propVCSSupport.Ignored.Files";
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            IgnoredSettingsPanel.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    private static String getBeanTextPresentation(IgnoredFileBean bean) {
        IgnoreSettingsType type = bean.getType();
        String path = bean.getPath();
        String mask = bean.getMask();
        if (type == IgnoreSettingsType.UNDER_DIR && path != null) {
            return VcsBundle.message((String)"ignored.configure.item.directory", (Object[])new Object[]{path});
        }
        if (type == IgnoreSettingsType.FILE && path != null) {
            return VcsBundle.message((String)"ignored.configure.item.file", (Object[])new Object[]{path});
        }
        if (type == IgnoreSettingsType.MASK && mask != null) {
            return VcsBundle.message((String)"ignored.configure.item.mask", (Object[])new Object[]{mask});
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/openapi/vcs/changes/ui/IgnoredSettingsPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpTopic";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class MyCellRenderer
    extends ColoredListCellRenderer<IgnoredFileBean> {
        private MyCellRenderer() {
        }

        protected void customizeCellRenderer(@NotNull JList list2, IgnoredFileBean bean, int index, boolean selected, boolean hasFocus) {
            String text;
            if (list2 == null) {
                MyCellRenderer.$$$reportNull$$$0(0);
            }
            if ((text = IgnoredSettingsPanel.getBeanTextPresentation(bean)) != null) {
                this.append(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
            SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)list2, (SimpleColoredComponent)this, (boolean)true, (boolean)selected);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/vcs/changes/ui/IgnoredSettingsPanel$MyCellRenderer", "customizeCellRenderer"));
        }
    }
}

