/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.CommonBundle;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.IdeaTextPatchBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.changes.CommitSession;
import com.intellij.openapi.vcs.changes.CommitSessionContextAware;
import com.intellij.openapi.vcs.changes.LocalCommitExecutor;
import com.intellij.openapi.vcs.changes.patch.CreatePatchConfigurationPanel;
import com.intellij.openapi.vcs.changes.patch.PatchWriter;
import com.intellij.openapi.vcs.changes.shelf.ShelveChangesManager;
import com.intellij.util.WaitForProgressToShow;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreatePatchCommitExecutor
extends LocalCommitExecutor
implements ProjectComponent {
    private static final Logger LOG = Logger.getInstance(CreatePatchCommitExecutor.class);
    private static final String VCS_PATCH_PATH_KEY = "vcs.patch.path";
    private static final String VCS_PATCH_TO_CLIPBOARD = "vcs.patch.to.clipboard";
    private final Project myProject;
    private final ChangeListManager myChangeListManager;

    public static CreatePatchCommitExecutor getInstance(Project project) {
        return (CreatePatchCommitExecutor)((Object)project.getComponent(CreatePatchCommitExecutor.class));
    }

    public CreatePatchCommitExecutor(Project project, ChangeListManager changeListManager) {
        this.myProject = project;
        this.myChangeListManager = changeListManager;
    }

    @Nls
    public String getActionText() {
        return "Create Patch...";
    }

    public String getHelpId() {
        return "reference.dialogs.vcs.patch.create";
    }

    public boolean supportsPartialCommit() {
        return true;
    }

    @NotNull
    public CommitSession createCommitSession() {
        CreatePatchCommitSession createPatchCommitSession = new CreatePatchCommitSession();
        if (createPatchCommitSession == null) {
            CreatePatchCommitExecutor.$$$reportNull$$$0(0);
        }
        return createPatchCommitSession;
    }

    public void projectOpened() {
        this.myChangeListManager.registerCommitExecutor((CommitExecutor)this);
    }

    private boolean checkIsFileValid(@NotNull File file2) {
        if (file2 == null) {
            CreatePatchCommitExecutor.$$$reportNull$$$0(1);
        }
        if (file2.exists()) {
            int[] result2 = new int[1];
            WaitForProgressToShow.runOrInvokeAndWaitAboveProgress(() -> {
                result2[0] = Messages.showYesNoDialog((Project)this.myProject, (String)("File " + file2.getName() + " (" + file2.getParent() + ") already exists.\nDo you want to overwrite it?"), (String)CommonBundle.getWarningTitle(), (String)"Overwrite", (String)"Cancel", (Icon)Messages.getWarningIcon());
            });
            if (1 == result2[0]) {
                return false;
            }
        }
        if (file2.getParentFile() == null) {
            WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> Messages.showErrorDialog((Project)this.myProject, (String)VcsBundle.message((String)"create.patch.error.title", (Object[])new Object[]{"Can not write patch to specified file: " + file2.getPath()}), (String)CommonBundle.getErrorTitle()), (ModalityState)ModalityState.NON_MODAL, (Project)this.myProject);
            return false;
        }
        return true;
    }

    @NotNull
    private String getDefaultPatchPath() {
        String baseDir = this.myProject.getBasePath();
        String string = baseDir == null ? FileUtil.toSystemIndependentName((String)PathManager.getHomePath()) : baseDir;
        if (string == null) {
            CreatePatchCommitExecutor.$$$reportNull$$$0(2);
        }
        return string;
    }

    private Boolean showDialog(File file2) {
        String message = VcsBundle.message((String)"create.patch.success.confirmation", (Object[])new Object[]{file2.getPath()});
        String title = VcsBundle.message((String)"create.patch.commit.action.title", (Object[])new Object[0]);
        final Boolean[] ref = new Boolean[1];
        DialogWrapper.DoNotAskOption option2 = new DialogWrapper.DoNotAskOption(){

            public boolean isToBeShown() {
                return true;
            }

            public void setToBeShown(boolean value, int exitCode) {
                if (!value) {
                    ref[0] = exitCode == 0;
                }
            }

            public boolean canBeHidden() {
                return true;
            }

            public boolean shouldSaveOptionsOnCancel() {
                return true;
            }

            @NotNull
            public String getDoNotShowMessage() {
                String string = CommonBundle.message((String)"dialog.options.do.not.ask", (Object[])new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/patch/CreatePatchCommitExecutor$1", "getDoNotShowMessage"));
            }
        };
        ShowFilePathAction.showDialog(this.myProject, message, title, file2, option2);
        return ref[0];
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/CreatePatchCommitExecutor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommitSession";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/CreatePatchCommitExecutor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPatchPath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "checkIsFileValid";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class CreatePatchCommitSession
    implements CommitSession,
    CommitSessionContextAware {
        private final CreatePatchConfigurationPanel myPanel;
        private CommitContext myCommitContext;

        CreatePatchCommitSession() {
            this.myPanel = new CreatePatchConfigurationPanel(CreatePatchCommitExecutor.this.myProject);
        }

        public void setContext(CommitContext context) {
            this.myCommitContext = context;
        }

        @Nullable
        public JComponent getAdditionalConfigurationUI() {
            return this.myPanel.getPanel();
        }

        public JComponent getAdditionalConfigurationUI(Collection<Change> changes2, String commitMessage2) {
            String patchPath = StringUtil.nullize((String)PropertiesComponent.getInstance((Project)CreatePatchCommitExecutor.this.myProject).getValue(CreatePatchCommitExecutor.VCS_PATCH_PATH_KEY));
            if (patchPath == null && (patchPath = VcsApplicationSettings.getInstance().PATCH_STORAGE_LOCATION) == null) {
                patchPath = CreatePatchCommitExecutor.this.getDefaultPatchPath();
            }
            this.myPanel.setFileName(ShelveChangesManager.suggestPatchName(CreatePatchCommitExecutor.this.myProject, commitMessage2, new File(patchPath), null));
            this.myPanel.setToClipboard(PropertiesComponent.getInstance((Project)CreatePatchCommitExecutor.this.myProject).getBoolean(CreatePatchCommitExecutor.VCS_PATCH_TO_CLIPBOARD, false));
            File commonAncestor = ChangesUtil.findCommonAncestor(changes2);
            this.myPanel.setCommonParentPath(commonAncestor);
            this.myPanel.selectBasePath(PatchWriter.calculateBaseForWritingPatch(CreatePatchCommitExecutor.this.myProject, changes2));
            this.myPanel.setReversePatch(false);
            JComponent panel2 = this.myPanel.getPanel();
            panel2.putClientProperty("Vcs.SessionDialog.title", "Patch File Settings");
            return panel2;
        }

        public boolean canExecute(Collection<Change> changes2, String commitMessage2) {
            return this.myPanel.isOkToExecute();
        }

        public void execute(@NotNull Collection<Change> changes2, @Nullable String commitMessage2) {
            if (changes2 == null) {
                CreatePatchCommitSession.$$$reportNull$$$0(0);
            }
            PropertiesComponent.getInstance((Project)CreatePatchCommitExecutor.this.myProject).setValue(CreatePatchCommitExecutor.VCS_PATCH_TO_CLIPBOARD, this.myPanel.isToClipboard());
            try {
                if (this.myPanel.isToClipboard()) {
                    String base = this.myPanel.getBaseDirName();
                    List<FilePatch> patches2 = IdeaTextPatchBuilder.buildPatch(CreatePatchCommitExecutor.this.myProject, changes2, base, this.myPanel.isReversePatch(), true);
                    PatchWriter.writeAsPatchToClipboard(CreatePatchCommitExecutor.this.myProject, patches2, base, this.myCommitContext);
                    VcsNotifier.getInstance(CreatePatchCommitExecutor.this.myProject).notifySuccess("Patch copied to clipboard");
                } else {
                    this.validateAndWritePatchToFile(changes2);
                }
            }
            catch (VcsException | IOException ex) {
                LOG.info(ex);
                WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> this.lambda$execute$0((Exception)ex), null, (Project)CreatePatchCommitExecutor.this.myProject);
            }
        }

        private void validateAndWritePatchToFile(@NotNull Collection<? extends Change> changes2) throws VcsException, IOException {
            String fileName2;
            File file2;
            if (changes2 == null) {
                CreatePatchCommitSession.$$$reportNull$$$0(1);
            }
            if (!CreatePatchCommitExecutor.this.checkIsFileValid(file2 = new File(fileName2 = this.myPanel.getFileName()).getAbsoluteFile())) {
                return;
            }
            file2.getParentFile().mkdirs();
            VcsConfiguration.getInstance((Project)CreatePatchCommitExecutor.this.myProject).acceptLastCreatedPatchName(file2.getName());
            String patchPath = FileUtil.toSystemIndependentName((String)StringUtil.notNullize((String)file2.getParent()));
            String valueToStore = StringUtil.isEmpty((String)patchPath) || patchPath.equals(CreatePatchCommitExecutor.this.getDefaultPatchPath()) ? null : patchPath;
            PropertiesComponent.getInstance((Project)CreatePatchCommitExecutor.this.myProject).setValue(CreatePatchCommitExecutor.VCS_PATCH_PATH_KEY, valueToStore);
            VcsApplicationSettings.getInstance().PATCH_STORAGE_LOCATION = valueToStore;
            boolean reversePatch = this.myPanel.isReversePatch();
            String baseDirName = this.myPanel.getBaseDirName();
            List<FilePatch> patches2 = IdeaTextPatchBuilder.buildPatch(CreatePatchCommitExecutor.this.myProject, changes2, baseDirName, reversePatch, true);
            PatchWriter.writePatches(CreatePatchCommitExecutor.this.myProject, fileName2, baseDirName, patches2, this.myCommitContext, this.myPanel.getEncoding(), true);
            WaitForProgressToShow.runOrInvokeLaterAboveProgress(() -> {
                VcsConfiguration configuration = VcsConfiguration.getInstance((Project)CreatePatchCommitExecutor.this.myProject);
                if (Boolean.TRUE.equals(configuration.SHOW_PATCH_IN_EXPLORER)) {
                    ShowFilePathAction.openFile(file2);
                } else if (configuration.SHOW_PATCH_IN_EXPLORER == null) {
                    configuration.SHOW_PATCH_IN_EXPLORER = CreatePatchCommitExecutor.this.showDialog(file2);
                }
            }, null, (Project)CreatePatchCommitExecutor.this.myProject);
        }

        @Nullable
        public ValidationInfo validateFields() {
            return this.myPanel.validateFields();
        }

        private /* synthetic */ void lambda$execute$0(Exception ex) {
            Messages.showErrorDialog((Project)CreatePatchCommitExecutor.this.myProject, (String)VcsBundle.message((String)"create.patch.error.title", (Object[])new Object[]{ex.getMessage()}), (String)CommonBundle.getErrorTitle());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "changes";
            objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/CreatePatchCommitExecutor$CreatePatchCommitSession";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "execute";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "validateAndWritePatchToFile";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

