/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.committed;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.CachingCommittedChangesProvider;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesAdapter;
import com.intellij.openapi.vcs.changes.committed.CommittedChangesCache;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.text.DateFormatUtil;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OutdatedVersionNotifier {
    private static final Logger LOG = Logger.getInstance(OutdatedVersionNotifier.class);
    private final FileEditorManager myFileEditorManager;
    private final CommittedChangesCache myCache;
    private final Project myProject;
    private static final Key<OutdatedRevisionPanel> PANEL_KEY = new Key("OutdatedRevisionPanel");
    private volatile boolean myIncomingChangesRequested;

    public OutdatedVersionNotifier(FileEditorManager fileEditorManager, CommittedChangesCache cache, MessageBus messageBus, Project project) {
        this.myFileEditorManager = fileEditorManager;
        this.myCache = cache;
        this.myProject = project;
        MessageBusConnection busConnection = messageBus.connect();
        busConnection.subscribe(CommittedChangesCache.COMMITTED_TOPIC, (Object)new CommittedChangesAdapter(){

            @Override
            public void incomingChangesUpdated(@Nullable List<CommittedChangeList> receivedChanges) {
                if (OutdatedVersionNotifier.this.myCache.getCachedIncomingChanges() == null) {
                    OutdatedVersionNotifier.this.requestLoadIncomingChanges();
                } else {
                    OutdatedVersionNotifier.this.updateAllEditorsLater();
                }
            }

            @Override
            public void changesCleared() {
                OutdatedVersionNotifier.this.updateAllEditorsLater();
            }
        });
        busConnection.subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                if (source == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (file2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (OutdatedVersionNotifier.this.myCache.getCachedIncomingChanges() == null) {
                    OutdatedVersionNotifier.this.requestLoadIncomingChanges();
                } else {
                    Pair<CommittedChangeList, Change> pair = OutdatedVersionNotifier.this.myCache.getIncomingChangeList(file2);
                    if (pair != null) {
                        FileEditor[] fileEditors;
                        for (FileEditor editor : fileEditors = source.getEditors(file2)) {
                            OutdatedVersionNotifier.this.initPanel((CommittedChangeList)pair.first, (Change)pair.second, editor);
                        }
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "source";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "file";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/openapi/vcs/changes/committed/OutdatedVersionNotifier$2";
                objectArray[2] = "fileOpened";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private void requestLoadIncomingChanges() {
        OutdatedVersionNotifier.debug("Requesting load of incoming changes");
        if (!this.myIncomingChangesRequested) {
            this.myIncomingChangesRequested = true;
            this.myCache.loadIncomingChangesAsync((Consumer<? super List<CommittedChangeList>>)((Consumer)committedChangeLists -> {
                this.myIncomingChangesRequested = false;
                this.updateAllEditorsLater();
            }), true);
        }
    }

    private static void debug(@NonNls String message) {
        LOG.debug(message);
    }

    private void updateAllEditorsLater() {
        OutdatedVersionNotifier.debug("Queueing update of editors");
        ApplicationManager.getApplication().invokeLater(() -> this.updateAllEditors(), this.myProject.getDisposed());
    }

    private void updateAllEditors() {
        VirtualFile[] files2;
        if (this.myCache.getCachedIncomingChanges() == null) {
            this.requestLoadIncomingChanges();
            return;
        }
        OutdatedVersionNotifier.debug("Updating editors");
        for (VirtualFile file2 : files2 = this.myFileEditorManager.getOpenFiles()) {
            FileEditor[] fileEditors;
            Pair<CommittedChangeList, Change> pair = this.myCache.getIncomingChangeList(file2);
            for (FileEditor editor : fileEditors = this.myFileEditorManager.getEditors(file2)) {
                OutdatedRevisionPanel oldPanel = (OutdatedRevisionPanel)((Object)editor.getUserData(PANEL_KEY));
                if (pair != null) {
                    if (oldPanel != null) {
                        oldPanel.setChangeList((CommittedChangeList)pair.first, (Change)pair.second);
                        continue;
                    }
                    this.initPanel((CommittedChangeList)pair.first, (Change)pair.second, editor);
                    continue;
                }
                if (oldPanel == null) continue;
                this.myFileEditorManager.removeTopComponent(editor, (JComponent)((Object)oldPanel));
                editor.putUserData(PANEL_KEY, null);
            }
        }
    }

    private void initPanel(CommittedChangeList list2, Change c, FileEditor editor) {
        if (!OutdatedVersionNotifier.isIncomingChangesSupported(list2)) {
            return;
        }
        OutdatedRevisionPanel component = new OutdatedRevisionPanel(list2, c);
        editor.putUserData(PANEL_KEY, (Object)component);
        this.myFileEditorManager.addTopComponent(editor, (JComponent)((Object)component));
    }

    private static boolean isIncomingChangesSupported(@NotNull CommittedChangeList list2) {
        CachingCommittedChangesProvider provider;
        if (list2 == null) {
            OutdatedVersionNotifier.$$$reportNull$$$0(0);
        }
        return (provider = list2.getVcs().getCachingCommittedChangesProvider()) != null && provider.supportsIncomingChanges();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/vcs/changes/committed/OutdatedVersionNotifier", "isIncomingChangesSupported"));
    }

    private static class OutdatedRevisionPanel
    extends EditorNotificationPanel {
        private CommittedChangeList myChangeList;

        OutdatedRevisionPanel(CommittedChangeList changeList, Change c) {
            this.createActionLabel(VcsBundle.message((String)"outdated.version.show.diff.action", (Object[])new Object[0]), "Compare.LastVersion");
            this.createActionLabel(VcsBundle.message((String)"outdated.version.update.project.action", (Object[])new Object[0]), "Vcs.UpdateProject");
            this.myChangeList = changeList;
            this.updateLabelText(c);
        }

        private void updateLabelText(Change c) {
            String formattedDate;
            boolean dateIsPretty;
            String comment = this.myChangeList.getComment();
            int pos = comment.indexOf("\n");
            if (pos >= 0) {
                comment = comment.substring(0, pos).trim() + "...";
            }
            boolean bl = dateIsPretty = !(formattedDate = DateFormatUtil.formatPrettyDateTime((Date)this.myChangeList.getCommitDate())).contains("/");
            String key = c.getType() == Change.Type.DELETED ? "outdated.version.text.deleted" : (dateIsPretty ? "outdated.version.pretty.date.text" : "outdated.version.text");
            this.myLabel.setText(VcsBundle.message((String)key, (Object[])new Object[]{this.myChangeList.getCommitterName(), formattedDate, comment}));
        }

        public void setChangeList(CommittedChangeList changeList, Change c) {
            this.myChangeList = changeList;
            this.updateLabelText(c);
        }
    }
}

