/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions.diff;

import com.intellij.diff.DiffDialogHints;
import com.intellij.diff.DiffManager;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionExtensionProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListChange;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ChangesViewManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.FakeRevision;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.changes.actions.diff.UnversionedDiffRequestProducer;
import com.intellij.openapi.vcs.changes.ui.ChangeDiffRequestChain;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowDiffFromLocalChangesActionProvider
implements AnActionExtensionProvider {
    @Override
    public boolean isActive(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(0);
        }
        return e.getData(ChangesListView.DATA_KEY) != null;
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(1);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        ChangesListView view = (ChangesListView)((Object)e.getRequiredData(ChangesListView.DATA_KEY));
        Stream<Change> changes2 = view.getSelectedChanges();
        Stream<VirtualFile> unversionedFiles = view.getSelectedUnversionedFiles();
        if ("MainMenu".equals(e.getPlace())) {
            e.getPresentation().setEnabled(project != null && (changes2.findAny().isPresent() || unversionedFiles.findAny().isPresent()));
        } else {
            e.getPresentation().setEnabled(project != null && ShowDiffFromLocalChangesActionProvider.canShowDiff(project, changes2, unversionedFiles));
        }
    }

    private static boolean canShowDiff(@Nullable Project project, @NotNull Stream<Change> changes2, @NotNull Stream<VirtualFile> files2) {
        if (changes2 == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(2);
        }
        if (files2 == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(3);
        }
        return files2.findAny().isPresent() || changes2.anyMatch(it -> ChangeDiffRequestProducer.canCreate(project, it));
    }

    @Override
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(4);
        }
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        ChangesListView view = (ChangesListView)((Object)e.getRequiredData(ChangesListView.DATA_KEY));
        if (ChangeListManager.getInstance((Project)project).isFreezedWithNotification(null)) {
            return;
        }
        List<Change> changes2 = view.getSelectedChanges().collect(Collectors.toList());
        List<VirtualFile> unversioned = view.getSelectedUnversionedFiles().collect(Collectors.toList());
        boolean needsConversion = ShowDiffFromLocalChangesActionProvider.checkIfThereAreFakeRevisions(project, changes2);
        if (needsConversion) {
            ChangeListManager.getInstance((Project)project).invokeAfterUpdate(() -> {
                ((ChangesViewManager)ChangesViewManager.getInstance(project)).refreshImmediately();
                List<Change> actualChanges = ShowDiffFromLocalChangesActionProvider.loadFakeRevisions(project, changes2);
                ShowDiffFromLocalChangesActionProvider.showDiff(project, actualChanges, unversioned, view);
            }, InvokeAfterUpdateMode.BACKGROUND_CANCELLABLE, ActionsBundle.actionText((String)"Diff.ShowDiff"), ModalityState.current());
        } else {
            ShowDiffFromLocalChangesActionProvider.showDiff(project, changes2, unversioned, view);
        }
    }

    private static boolean checkIfThereAreFakeRevisions(@NotNull Project project, @NotNull List<Change> changes2) {
        if (project == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(5);
        }
        if (changes2 == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(6);
        }
        boolean needsConversion = false;
        for (Change change : changes2) {
            ContentRevision beforeRevision = change.getBeforeRevision();
            ContentRevision afterRevision = change.getAfterRevision();
            if (beforeRevision instanceof FakeRevision) {
                VcsDirtyScopeManager.getInstance((Project)project).fileDirty(beforeRevision.getFile());
                needsConversion = true;
            }
            if (!(afterRevision instanceof FakeRevision)) continue;
            VcsDirtyScopeManager.getInstance((Project)project).fileDirty(afterRevision.getFile());
            needsConversion = true;
        }
        return needsConversion;
    }

    @NotNull
    private static List<Change> loadFakeRevisions(@NotNull Project project, @NotNull List<Change> changes2) {
        if (project == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(7);
        }
        if (changes2 == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(8);
        }
        ArrayList<Change> actualChanges = new ArrayList<Change>();
        for (Change change : changes2) {
            actualChanges.addAll(ChangeListManager.getInstance((Project)project).getChangesIn(ChangesUtil.getFilePath((Change)change)));
        }
        ArrayList<Change> arrayList = actualChanges;
        if (arrayList == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    private static void showDiff(@NotNull Project project, @NotNull List<Change> changes2, @NotNull List<VirtualFile> unversioned, @NotNull ChangesListView changesView) {
        Change selectedChange;
        List<Change> changelistChanges;
        if (project == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(10);
        }
        if (changes2 == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(11);
        }
        if (unversioned == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(12);
        }
        if (changesView == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(13);
        }
        if (changes2.size() == 1 && unversioned.isEmpty() && (changelistChanges = changesView.getAllChangesFromSameChangelist(selectedChange = changes2.get(0))) != null) {
            int selectedIndex = ContainerUtil.indexOf(changelistChanges, it -> ChangeListChange.HASHING_STRATEGY.equals((Object)selectedChange, it));
            if (selectedIndex != -1) {
                ShowDiffFromLocalChangesActionProvider.showChangesDiff(project, (ListSelection<Change>)ListSelection.createAt(changelistChanges, (int)selectedIndex));
            } else {
                ShowDiffFromLocalChangesActionProvider.showChangesDiff(project, (ListSelection<Change>)ListSelection.create(changelistChanges, (Object)selectedChange));
            }
            return;
        }
        if (unversioned.size() == 1 && changes2.isEmpty()) {
            VirtualFile selectedFile = unversioned.get(0);
            List allUnversioned = changesView.getUnversionedFiles().collect(Collectors.toList());
            ShowDiffFromLocalChangesActionProvider.showUnversionedDiff(project, (ListSelection<VirtualFile>)ListSelection.create(allUnversioned, (Object)selectedFile));
            return;
        }
        ShowDiffFromLocalChangesActionProvider.showSelectionDiff(project, changes2, unversioned);
    }

    private static void showChangesDiff(@Nullable Project project, @NotNull ListSelection<Change> selection) {
        if (selection == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(14);
        }
        ListSelection producers = selection.map(change -> ChangeDiffRequestProducer.create(project, change));
        ShowDiffFromLocalChangesActionProvider.showDiff(project, producers.getList(), producers.getSelectedIndex());
    }

    private static void showUnversionedDiff(@Nullable Project project, @NotNull ListSelection<VirtualFile> selection) {
        if (selection == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(15);
        }
        ListSelection producers = selection.map(change -> UnversionedDiffRequestProducer.create(project, change));
        ShowDiffFromLocalChangesActionProvider.showDiff(project, producers.getList(), producers.getSelectedIndex());
    }

    private static void showSelectionDiff(@Nullable Project project, @NotNull List<Change> changes2, @NotNull List<VirtualFile> unversioned) {
        if (changes2 == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(16);
        }
        if (unversioned == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(17);
        }
        List changeRequests = ContainerUtil.mapNotNull(changes2, change -> ChangeDiffRequestProducer.create(project, change));
        List unversionedRequests = ContainerUtil.mapNotNull(unversioned, file2 -> UnversionedDiffRequestProducer.create(project, file2));
        ShowDiffFromLocalChangesActionProvider.showDiff(project, ContainerUtil.concat((List)changeRequests, (List)unversionedRequests), 0);
    }

    private static void showDiff(@Nullable Project project, @NotNull List<ChangeDiffRequestChain.Producer> producers, int selected) {
        if (producers == null) {
            ShowDiffFromLocalChangesActionProvider.$$$reportNull$$$0(18);
        }
        if (producers.isEmpty()) {
            return;
        }
        ChangeDiffRequestChain chain = new ChangeDiffRequestChain(producers, selected);
        chain.putUserData(DiffUserDataKeysEx.LAST_REVISION_WITH_LOCAL, true);
        DiffManager.getInstance().showDiff(project, (DiffRequestChain)chain, DiffDialogHints.DEFAULT);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 5: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/actions/diff/ShowDiffFromLocalChangesActionProvider";
                break;
            }
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unversioned";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changesView";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/actions/diff/ShowDiffFromLocalChangesActionProvider";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "loadFakeRevisions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isActive";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canShowDiff";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkIfThereAreFakeRevisions";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "loadFakeRevisions";
                break;
            }
            case 9: {
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "showDiff";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "showChangesDiff";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "showUnversionedDiff";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "showSelectionDiff";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

