/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.util.messages.Topic;
import org.jetbrains.annotations.NotNull;

public class VcsFreezingProcess {
    private static final Logger LOG = Logger.getInstance(VcsFreezingProcess.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myOperationTitle;
    @NotNull
    private final Runnable myRunnable;
    @NotNull
    private final ChangeListManagerEx myChangeListManager;
    @NotNull
    private final ProjectManagerEx myProjectManager;
    @NotNull
    private final SaveAndSyncHandler mySaveAndSyncHandler;

    public VcsFreezingProcess(@NotNull Project project, @NotNull String operationTitle, @NotNull Runnable runnable2) {
        if (project == null) {
            VcsFreezingProcess.$$$reportNull$$$0(0);
        }
        if (operationTitle == null) {
            VcsFreezingProcess.$$$reportNull$$$0(1);
        }
        if (runnable2 == null) {
            VcsFreezingProcess.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myOperationTitle = operationTitle;
        this.myRunnable = runnable2;
        this.myChangeListManager = (ChangeListManagerEx)ChangeListManager.getInstance((Project)project);
        this.myProjectManager = ProjectManagerEx.getInstanceEx();
        this.mySaveAndSyncHandler = SaveAndSyncHandler.getInstance();
    }

    public void execute() {
        LOG.debug("starting");
        try {
            LOG.debug("saving documents, blocking project autosync");
            this.saveAndBlockInAwt();
            try {
                LOG.debug("freezing the ChangeListManager");
                this.freeze();
                LOG.debug("running the operation");
                this.myRunnable.run();
                LOG.debug("operation completed.");
            }
            finally {
                LOG.debug("unfreezing the ChangeListManager");
                this.unfreeze();
            }
        }
        finally {
            LOG.debug("unblocking project autosync");
            this.unblockInAwt();
        }
        LOG.debug("finished.");
    }

    private void saveAndBlockInAwt() {
        ApplicationManager.getApplication().invokeAndWait(() -> {
            this.myProjectManager.blockReloadingProjectOnExternalChanges();
            FileDocumentManager.getInstance().saveAllDocuments();
            this.mySaveAndSyncHandler.blockSaveOnFrameDeactivation();
            this.mySaveAndSyncHandler.blockSyncOnFrameActivation();
        });
    }

    private void unblockInAwt() {
        ApplicationManager.getApplication().invokeAndWait(() -> {
            this.myProjectManager.unblockReloadingProjectOnExternalChanges();
            this.mySaveAndSyncHandler.unblockSaveOnFrameDeactivation();
            this.mySaveAndSyncHandler.unblockSyncOnFrameActivation();
        });
    }

    private void freeze() {
        BackgroundTaskUtil.syncPublisher(this.myProject, Listener.TOPIC).onFreeze();
        this.myChangeListManager.freeze("Local changes are not available until " + this.myOperationTitle + " is finished.");
    }

    private void unfreeze() {
        BackgroundTaskUtil.syncPublisher(this.myProject, Listener.TOPIC).onUnfreeze();
        this.myChangeListManager.unfreeze();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "operationTitle";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "runnable";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/vcs/changes/VcsFreezingProcess";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface Listener {
        public static final Topic<Listener> TOPIC = Topic.create((String)"Change List Manager Freeze", Listener.class);

        default public void onFreeze() {
        }

        default public void onUnfreeze() {
        }
    }
}

