/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RemoteDifferenceStrategy;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ControlledCycle;
import com.intellij.openapi.vcs.changes.RemoteRevisionsNumbersCache;
import com.intellij.openapi.vcs.changes.RemoteRevisionsStateCache;
import com.intellij.openapi.vcs.changes.ui.RemoteStatusChangeNodeDecorator;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vcs.update.UpdateFilesHelper;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.util.Consumer;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class RemoteRevisionsCache
implements VcsListener {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.RemoteRevisionsCache");
    public static final Topic<Runnable> REMOTE_VERSION_CHANGED = new Topic("REMOTE_VERSION_CHANGED", Runnable.class);
    public static final int DEFAULT_REFRESH_INTERVAL = 180000;
    private final RemoteRevisionsNumbersCache myRemoteRevisionsNumbersCache;
    private final RemoteRevisionsStateCache myRemoteRevisionsStateCache;
    private final ProjectLevelVcsManager myVcsManager;
    private final RemoteStatusChangeNodeDecorator myChangeDecorator;
    private final Project myProject;
    private final Object myLock;
    private final Map<String, RemoteDifferenceStrategy> myKinds;
    private final ControlledCycle myControlledCycle;

    public static RemoteRevisionsCache getInstance(Project project) {
        return (RemoteRevisionsCache)ServiceManager.getService((Project)project, RemoteRevisionsCache.class);
    }

    private RemoteRevisionsCache(Project project) {
        this.myProject = project;
        this.myLock = new Object();
        this.myRemoteRevisionsNumbersCache = new RemoteRevisionsNumbersCache(this.myProject);
        this.myRemoteRevisionsStateCache = new RemoteRevisionsStateCache(this.myProject);
        this.myChangeDecorator = new RemoteStatusChangeNodeDecorator(this);
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        MessageBusConnection connection = this.myProject.getMessageBus().connect();
        connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)this);
        connection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED_IN_PLUGIN, (Object)this);
        this.myKinds = new HashMap<String, RemoteDifferenceStrategy>();
        VcsConfiguration vcsConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
        this.myControlledCycle = new ControlledCycle(project, (Getter<Boolean>)((Getter)() -> {
            boolean shouldBeDone;
            boolean bl = shouldBeDone = vcsConfiguration.isChangedOnServerEnabled() && this.myVcsManager.hasActiveVcss();
            if (shouldBeDone) {
                boolean somethingChanged = this.myRemoteRevisionsNumbersCache.updateStep();
                if (somethingChanged |= this.myRemoteRevisionsStateCache.updateStep()) {
                    BackgroundTaskUtil.syncPublisher(this.myProject, REMOTE_VERSION_CHANGED).run();
                }
            }
            return shouldBeDone;
        }), "Finishing \"changed on server\" update", 180000);
        this.updateRoots();
        if (!this.myProject.isDefault() && vcsConfiguration.isChangedOnServerEnabled()) {
            ((ProjectLevelVcsManagerImpl)this.myVcsManager).addInitializationRequest(VcsInitObject.REMOTE_REVISIONS_CACHE, () -> {
                if (!this.myVcsManager.hasActiveVcss() || !vcsConfiguration.isChangedOnServerEnabled()) {
                    return;
                }
                this.myControlledCycle.startIfNotStarted();
            });
        }
    }

    public void updateAutomaticRefreshAlarmState(boolean remoteCacheStateChanged) {
        this.manageAlarm();
    }

    private void manageAlarm() {
        VcsConfiguration vcsConfiguration = VcsConfiguration.getInstance((Project)this.myProject);
        if (!this.myProject.isDefault() && this.myVcsManager.hasActiveVcss() && vcsConfiguration.isChangedOnServerEnabled()) {
            this.myControlledCycle.startIfNotStarted();
        } else {
            this.myControlledCycle.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRoots() {
        VcsRoot[] roots = this.myVcsManager.getAllVcsRoots();
        Object object = this.myLock;
        synchronized (object) {
            for (VcsRoot root : roots) {
                AbstractVcs vcs = root.getVcs();
                if (this.myKinds.containsKey(vcs.getName())) continue;
                this.myKinds.put(vcs.getName(), vcs.getRemoteDifferenceStrategy());
            }
        }
    }

    public void directoryMappingChanged() {
        if (!VcsConfiguration.getInstance((Project)this.myProject).isChangedOnServerEnabled()) {
            this.manageAlarm();
        } else {
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    this.updateRoots();
                    this.myRemoteRevisionsNumbersCache.directoryMappingChanged();
                    this.myRemoteRevisionsStateCache.directoryMappingChanged();
                    this.manageAlarm();
                }
                catch (ProcessCanceledException processCanceledException) {
                    // empty catch block
                }
            });
        }
    }

    public void changeUpdated(@NotNull String path, @NotNull AbstractVcs vcs) {
        if (path == null) {
            RemoteRevisionsCache.$$$reportNull$$$0(0);
        }
        if (vcs == null) {
            RemoteRevisionsCache.$$$reportNull$$$0(1);
        }
        if (RemoteDifferenceStrategy.ASK_TREE_PROVIDER.equals((Object)vcs.getRemoteDifferenceStrategy())) {
            this.myRemoteRevisionsStateCache.changeUpdated(path, vcs);
        } else {
            this.myRemoteRevisionsNumbersCache.changeUpdated(path, vcs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(UpdatedFiles updatedFiles) {
        HashMap<String, RemoteDifferenceStrategy> strategyMap;
        Object object = this.myLock;
        synchronized (object) {
            strategyMap = new HashMap<String, RemoteDifferenceStrategy>(this.myKinds);
        }
        LinkedList<String> newForTree = new LinkedList<String>();
        LinkedList<String> newForUsual = new LinkedList<String>();
        UpdateFilesHelper.iterateAffectedFiles(updatedFiles, (Consumer<? super Couple<String>>)((Consumer)pair -> {
            String vcsName = (String)pair.getSecond();
            RemoteDifferenceStrategy strategy = (RemoteDifferenceStrategy)strategyMap.get(vcsName);
            if (strategy == null) {
                AbstractVcs vcs = this.myVcsManager.findVcsByName(vcsName);
                if (vcs == null) {
                    return;
                }
                strategy = vcs.getRemoteDifferenceStrategy();
            }
            if (RemoteDifferenceStrategy.ASK_TREE_PROVIDER.equals((Object)strategy)) {
                newForTree.add((String)pair.getFirst());
            } else {
                newForUsual.add((String)pair.getFirst());
            }
        }));
        this.myRemoteRevisionsStateCache.invalidate(newForTree);
        this.myRemoteRevisionsNumbersCache.invalidate(newForUsual);
    }

    public void changeRemoved(@NotNull String path, @NotNull AbstractVcs vcs) {
        if (path == null) {
            RemoteRevisionsCache.$$$reportNull$$$0(2);
        }
        if (vcs == null) {
            RemoteRevisionsCache.$$$reportNull$$$0(3);
        }
        if (RemoteDifferenceStrategy.ASK_TREE_PROVIDER.equals((Object)vcs.getRemoteDifferenceStrategy())) {
            this.myRemoteRevisionsStateCache.changeRemoved(path, vcs);
        } else {
            this.myRemoteRevisionsNumbersCache.changeRemoved(path, vcs);
        }
    }

    public boolean isUpToDate(@NotNull Change change) {
        AbstractVcs vcs;
        if (change == null) {
            RemoteRevisionsCache.$$$reportNull$$$0(4);
        }
        if ((vcs = ChangesUtil.getVcsForChange((Change)change, (Project)this.myProject)) == null) {
            return true;
        }
        RemoteDifferenceStrategy strategy = vcs.getRemoteDifferenceStrategy();
        if (RemoteDifferenceStrategy.ASK_TREE_PROVIDER.equals((Object)strategy)) {
            return this.myRemoteRevisionsStateCache.isUpToDate(change, vcs);
        }
        return this.myRemoteRevisionsNumbersCache.isUpToDate(change, vcs);
    }

    public RemoteStatusChangeNodeDecorator getChangesNodeDecorator() {
        return this.myChangeDecorator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/RemoteRevisionsCache";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "changeUpdated";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "changeRemoved";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isUpToDate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

