/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.IgnoredBeanFactory;
import com.intellij.openapi.vcs.changes.IgnoredFileBean;
import com.intellij.openapi.vcs.changes.IgnoredFileDescriptor;
import com.intellij.openapi.vcs.changes.IgnoredFileProvider;
import com.intellij.openapi.vcs.changes.ui.ChangesComparator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/openapi/vcs/changes/ProjectExcludesIgnoredFileProvider;", "Lcom/intellij/openapi/vcs/changes/IgnoredFileProvider;", "()V", "getIgnoredFiles", "", "Lcom/intellij/openapi/vcs/changes/IgnoredFileDescriptor;", "project", "Lcom/intellij/openapi/project/Project;", "getIgnoredGroupDescription", "", "getProjectExcludePathsRelativeTo", "isIgnoredFile", "", "filePath", "Lcom/intellij/openapi/vcs/FilePath;", "intellij.platform.vcs.impl"})
public final class ProjectExcludesIgnoredFileProvider
implements IgnoredFileProvider {
    public boolean isIgnoredFile(@NotNull Project project, @NotNull FilePath filePath) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        ChangeListManagerImpl changeListManagerImpl = ChangeListManagerImpl.getInstanceImpl(project);
        Intrinsics.checkExpressionValueIsNotNull((Object)changeListManagerImpl, (String)"ChangeListManagerImpl.getInstanceImpl(project)");
        return changeListManagerImpl.getIgnoredFilesComponent().isIgnoredFile(filePath);
    }

    @NotNull
    public Set<IgnoredFileDescriptor> getIgnoredFiles(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return this.getProjectExcludePathsRelativeTo(project);
    }

    @NotNull
    public String getIgnoredGroupDescription() {
        return "Project exclude paths";
    }

    /*
     * WARNING - void declaration
     */
    private final Set<IgnoredFileDescriptor> getProjectExcludePathsRelativeTo(Project project) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        int n;
        Comparator<VirtualFile> comparator2 = ChangesComparator.getVirtualFileComparator(false);
        Intrinsics.checkExpressionValueIsNotNull(comparator2, (String)"ChangesComparator.getVirtualFileComparator(false)");
        TreeSet excludes = SetsKt.sortedSetOf(comparator2, (Object[])new VirtualFile[0]);
        ProjectFileIndex fileIndex = ProjectFileIndex.SERVICE.getInstance((Project)project);
        DirectoryIndexExcludePolicy[] directoryIndexExcludePolicyArray = (DirectoryIndexExcludePolicy[])DirectoryIndexExcludePolicy.EP_NAME.getExtensions((AreaInstance)project);
        int n2 = directoryIndexExcludePolicyArray.length;
        for (n = 0; n < n2; ++n) {
            DirectoryIndexExcludePolicy policy;
            DirectoryIndexExcludePolicy directoryIndexExcludePolicy = policy = directoryIndexExcludePolicyArray[n];
            Intrinsics.checkExpressionValueIsNotNull((Object)directoryIndexExcludePolicy, (String)"policy");
            for (String string : directoryIndexExcludePolicy.getExcludeUrlsForProject()) {
                VirtualFile file2 = VirtualFileManager.getInstance().findFileByUrl(string);
                if (file2 == null) continue;
                excludes.add(file2);
            }
        }
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        directoryIndexExcludePolicyArray = moduleManager.getModules();
        n2 = directoryIndexExcludePolicyArray.length;
        for (n = 0; n < n2; ++n) {
            DirectoryIndexExcludePolicy module;
            DirectoryIndexExcludePolicy directoryIndexExcludePolicy = module = directoryIndexExcludePolicyArray[n];
            Intrinsics.checkExpressionValueIsNotNull((Object)directoryIndexExcludePolicy, (String)"module");
            if (directoryIndexExcludePolicy.isDisposed()) continue;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
            for (String string : moduleRootManager.getExcludeRoots()) {
                if (!fileIndex.isExcluded((VirtualFile)string)) continue;
                excludes.add(string);
            }
        }
        Iterable iterable = $receiver$iv = (Iterable)excludes;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object t : $receiver$iv$iv) {
            void file3;
            VirtualFile virtualFile = (VirtualFile)t;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IgnoredFileBean ignoredFileBean = IgnoredBeanFactory.ignoreFile((VirtualFile)file3, (Project)project);
            collection.add(ignoredFileBean);
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }
}

