/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.changes.IgnoredFileContentProvider;
import com.intellij.openapi.vcs.changes.IgnoredFileGenerator;
import com.intellij.openapi.vcs.changes.IgnoredFileProvider;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingProjectManager;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IgnoredFileGeneratorImpl
implements IgnoredFileGenerator {
    private static final Logger LOG = Logger.getInstance(IgnoredFileGeneratorImpl.class);
    private final Project myProject;
    private final Object myWriteLock;

    protected IgnoredFileGeneratorImpl(@NotNull Project project) {
        if (project == null) {
            IgnoredFileGeneratorImpl.$$$reportNull$$$0(0);
        }
        this.myWriteLock = new Object();
        this.myProject = project;
    }

    public boolean generateFile(@NotNull VirtualFile ignoreFileRoot, @NotNull AbstractVcs vcs) throws IOException {
        if (ignoreFileRoot == null) {
            IgnoredFileGeneratorImpl.$$$reportNull$$$0(1);
        }
        if (vcs == null) {
            IgnoredFileGeneratorImpl.$$$reportNull$$$0(2);
        }
        return this.doGenerateOrAppend(ignoreFileRoot, vcs, false);
    }

    public boolean appendFile(@NotNull VirtualFile ignoreFileRoot, @NotNull AbstractVcs vcs) throws IOException {
        if (ignoreFileRoot == null) {
            IgnoredFileGeneratorImpl.$$$reportNull$$$0(3);
        }
        if (vcs == null) {
            IgnoredFileGeneratorImpl.$$$reportNull$$$0(4);
        }
        return this.doGenerateOrAppend(ignoreFileRoot, vcs, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doGenerateOrAppend(@NotNull VirtualFile ignoreFileRoot, @NotNull AbstractVcs vcs, boolean append) throws IOException {
        IgnoredFileContentProvider ignoredFileContentProvider;
        if (ignoreFileRoot == null) {
            IgnoredFileGeneratorImpl.$$$reportNull$$$0(5);
        }
        if (vcs == null) {
            IgnoredFileGeneratorImpl.$$$reportNull$$$0(6);
        }
        if ((ignoredFileContentProvider = this.findIgnoredFileContentProvider(vcs)) == null) {
            LOG.debug("Cannot find content provider for vcs " + vcs.getName());
            return false;
        }
        String ignoreFileName = ignoredFileContentProvider.getFileName();
        if (!IgnoredFileGeneratorImpl.needGenerateIgnoreFile(this.myProject, ignoreFileRoot)) {
            LOG.debug("Skip VCS ignore file generation");
            return false;
        }
        Object object = this.myWriteLock;
        synchronized (object) {
            String ignoreFileContent = ignoredFileContentProvider.buildIgnoreFileContent(ignoreFileRoot, (IgnoredFileProvider[])IgnoredFileProvider.IGNORE_FILE.getExtensions());
            if (StringUtil.isEmptyOrSpaces((String)ignoreFileContent)) {
                return false;
            }
            File ignoreFile = IgnoredFileGeneratorImpl.getIgnoreFile(ignoreFileRoot, ignoreFileName);
            if (ignoreFile.exists() && !append) {
                return false;
            }
            String projectCharsetName = EncodingProjectManager.getInstance((Project)this.myProject).getDefaultCharsetName();
            FileUtil.writeToFile((File)ignoreFile, (byte[])ignoreFileContent.getBytes(projectCharsetName), (boolean)append);
            IgnoredFileRootStore.getInstance(this.myProject).addRoot(ignoreFile.getParent());
            LocalFileSystem.getInstance().refreshIoFiles(Collections.singleton(ignoreFile));
            return true;
        }
    }

    @Nullable
    private IgnoredFileContentProvider findIgnoredFileContentProvider(@NotNull AbstractVcs vcs) {
        if (vcs == null) {
            IgnoredFileGeneratorImpl.$$$reportNull$$$0(7);
        }
        IgnoredFileContentProvider[] contentProviders = (IgnoredFileContentProvider[])IgnoredFileContentProvider.IGNORE_FILE_CONTENT_PROVIDER.getExtensions((AreaInstance)this.myProject);
        return Arrays.stream(contentProviders).filter(provider -> provider.getSupportedVcs().equals((Object)vcs.getKeyInstanceMethod())).findFirst().orElse(null);
    }

    @NotNull
    private static File getIgnoreFile(@NotNull VirtualFile ignoreFileRoot, @NotNull String ignoreFileName) {
        if (ignoreFileRoot == null) {
            IgnoredFileGeneratorImpl.$$$reportNull$$$0(8);
        }
        if (ignoreFileName == null) {
            IgnoredFileGeneratorImpl.$$$reportNull$$$0(9);
        }
        File vcsRootFile = VfsUtilCore.virtualToIoFile((VirtualFile)ignoreFileRoot);
        File file2 = new File(vcsRootFile.getPath(), ignoreFileName);
        if (file2 == null) {
            IgnoredFileGeneratorImpl.$$$reportNull$$$0(10);
        }
        return file2;
    }

    private static boolean needGenerateIgnoreFile(@NotNull Project project, @NotNull VirtualFile ignoreFileRoot) {
        boolean wasGeneratedPreviously;
        if (project == null) {
            IgnoredFileGeneratorImpl.$$$reportNull$$$0(11);
        }
        if (ignoreFileRoot == null) {
            IgnoredFileGeneratorImpl.$$$reportNull$$$0(12);
        }
        if (wasGeneratedPreviously = IgnoredFileRootStore.getInstance(project).containsRoot(ignoreFileRoot.getPath())) {
            LOG.debug("Ignore file generated previously for root " + ignoreFileRoot.getPath());
        }
        boolean needGenerateRegistryFlag = Registry.is((String)"vcs.ignorefile.generation", (boolean)true);
        return !wasGeneratedPreviously && needGenerateRegistryFlag;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoreFileRoot";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoreFileName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/IgnoredFileGeneratorImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/IgnoredFileGeneratorImpl";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoreFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "generateFile";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "appendFile";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doGenerateOrAppend";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findIgnoredFileContentProvider";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getIgnoreFile";
                break;
            }
            case 10: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "needGenerateIgnoreFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @com.intellij.openapi.components.State(name="IgnoredFileRootStore", storages={@Storage(value="$WORKSPACE_FILE$")})
    static class IgnoredFileRootStore
    implements PersistentStateComponent<State> {
        State myState = new State();

        IgnoredFileRootStore() {
        }

        static IgnoredFileRootStore getInstance(Project project) {
            return (IgnoredFileRootStore)ServiceManager.getService((Project)project, IgnoredFileRootStore.class);
        }

        boolean containsRoot(@NotNull String root) {
            if (root == null) {
                IgnoredFileRootStore.$$$reportNull$$$0(0);
            }
            return this.myState.generatedRoots.contains(root);
        }

        void addRoot(@NotNull String root) {
            if (root == null) {
                IgnoredFileRootStore.$$$reportNull$$$0(1);
            }
            this.myState.generatedRoots.add(root);
        }

        @Nullable
        public State getState() {
            return this.myState;
        }

        public void loadState(@NotNull State state) {
            if (state == null) {
                IgnoredFileRootStore.$$$reportNull$$$0(2);
            }
            this.myState = state;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/IgnoredFileGeneratorImpl$IgnoredFileRootStore";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "containsRoot";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addRoot";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "loadState";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        static class State {
            public Set<String> generatedRoots = ContainerUtil.newHashSet();

            State() {
            }
        }
    }
}

