/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vcs.FilesProcessor;
import com.intellij.openapi.vcs.FilesProcessorWithNotificationImpl;
import com.intellij.openapi.vcs.ProjectConfigurationFilesProcessorImplKt;
import com.intellij.openapi.vcs.ProjectConfigurationFilesStoreState;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.changes.ChangeListListener;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.vcsUtil.VcsImplUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B7\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0018\u0010\n\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f\u0012\u0004\u0012\u00020\u000e0\u000b\u00a2\u0006\u0002\u0010\u000fJ\b\u0010$\u001a\u00020\u000eH\u0016J\u0016\u0010%\u001a\u00020\u000e2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u001c\u0010'\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u001a\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\r2\u0006\u0010+\u001a\u00020\rH\u0002J\b\u0010,\u001a\u00020\tH\u0016J\b\u0010-\u001a\u00020\tH\u0016J\b\u0010.\u001a\u00020\u000eH\u0016R \u0010\n\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f\u0012\u0004\u0012\u00020\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0016\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0012R\u0014\u0010\u001c\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0012R\u0014\u0010\u001e\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0012R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\"\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0012R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/intellij/openapi/vcs/ProjectConfigurationFilesProcessorImpl;", "Lcom/intellij/openapi/vcs/FilesProcessorWithNotificationImpl;", "Lcom/intellij/openapi/vcs/FilesProcessor;", "Lcom/intellij/openapi/vcs/changes/ChangeListListener;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "vcsName", "", "addChosenFiles", "Lkotlin/Function1;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "askedBeforeProperty", "getAskedBeforeProperty", "()Ljava/lang/String;", "changeListManager", "Lcom/intellij/openapi/vcs/changes/ChangeListManagerEx;", "doForCurrentProjectProperty", "getDoForCurrentProjectProperty", "fileSystem", "Lcom/intellij/openapi/vfs/LocalFileSystem;", "kotlin.jvm.PlatformType", "forAllProjectsActionText", "getForAllProjectsActionText", "forCurrentProjectActionText", "getForCurrentProjectActionText", "muteActionText", "getMuteActionText", "projectConfigurationFilesStore", "Lcom/intellij/openapi/vcs/ProjectConfigurationFilesStoreState;", "showActionText", "getShowActionText", "changeListUpdateDone", "doActionOnChosenFiles", "files", "doFilterFiles", "isProjectConfigurationFile", "", "storeDir", "file", "notificationMessage", "notificationTitle", "rememberForAllProjects", "intellij.platform.vcs.impl"})
public final class ProjectConfigurationFilesProcessorImpl
extends FilesProcessorWithNotificationImpl
implements FilesProcessor,
ChangeListListener {
    private final LocalFileSystem fileSystem;
    private final ProjectConfigurationFilesStoreState projectConfigurationFilesStore;
    private final ChangeListManagerEx changeListManager;
    @NotNull
    private final String askedBeforeProperty = "ASKED_SHARE_PROJECT_CONFIGURATION_FILES";
    @NotNull
    private final String doForCurrentProjectProperty = "SHARE_PROJECT_CONFIGURATION_FILES";
    @NotNull
    private final String showActionText;
    @NotNull
    private final String forCurrentProjectActionText;
    @Nullable
    private final String forAllProjectsActionText;
    @NotNull
    private final String muteActionText;
    private final String vcsName;
    private final Function1<Collection<? extends VirtualFile>, Unit> addChosenFiles;

    public void changeListUpdateDone() {
        if (!this.getProjectProperties().getBoolean("SHARE_PROJECT_CONFIGURATION_FILES", false) && VcsImplUtil.isProjectSharedInVcs(this.getProject())) {
            this.getProjectProperties().setValue("SHARE_PROJECT_CONFIGURATION_FILES", true);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Collection<VirtualFile> doFilterFiles(@NotNull Collection<? extends VirtualFile> files2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull(files2, (String)"files");
        String string = this.getProject().getBasePath();
        if (string == null) {
            return files2;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.basePath ?: return files");
        String projectBasePath = string;
        VirtualFile virtualFile = this.fileSystem.findFileByPath(projectBasePath);
        if (virtualFile == null) {
            return files2;
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"fileSystem.findFileByPat\u2026BasePath) ?: return files");
        VirtualFile projectBaseDir = virtualFile;
        VirtualFile storeDir = ProjectKt.getProjectStoreDirectory(projectBaseDir);
        if (ProjectKt.isDirectoryBased(this.getProject()) && storeDir == null) {
            ProjectConfigurationFilesProcessorImplKt.access$getLOG$p().warn("Cannot find store directory for project in directory " + projectBaseDir.getPath());
            return files2;
        }
        Iterable iterable = $receiver$iv = (Iterable)files2;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl = false;
            if (!(ProjectConfigurationFilesProcessorImplKt.access$getConfigurationFilesExtensionsOutsideStoreDirectory$p().contains(it.getExtension()) || this.isProjectConfigurationFile(storeDir, it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List filteredFiles = (List)destination$iv$iv;
        List<VirtualFile> previouslyStoredFiles = this.projectConfigurationFilesStore.cleanupAndGetValidFiles();
        this.projectConfigurationFilesStore.addAll(filteredFiles);
        return CollectionsKt.plus((Collection)filteredFiles, (Iterable)previouslyStoredFiles);
    }

    @Override
    public void doActionOnChosenFiles(@NotNull Collection<? extends VirtualFile> files2) {
        Intrinsics.checkParameterIsNotNull(files2, (String)"files");
        this.addChosenFiles.invoke(files2);
        this.projectConfigurationFilesStore.removeAll(files2);
    }

    @Override
    @NotNull
    public String getAskedBeforeProperty() {
        return this.askedBeforeProperty;
    }

    @Override
    @NotNull
    public String getDoForCurrentProjectProperty() {
        return this.doForCurrentProjectProperty;
    }

    @Override
    @NotNull
    public String notificationTitle() {
        return "";
    }

    @Override
    @NotNull
    public String notificationMessage() {
        String string = VcsBundle.message((String)"project.configuration.files.add.notification.message", (Object[])new Object[]{this.vcsName});
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"VcsBundle.message(\"proje\u2026cation.message\", vcsName)");
        return string;
    }

    @Override
    @NotNull
    public String getShowActionText() {
        return this.showActionText;
    }

    @Override
    @NotNull
    public String getForCurrentProjectActionText() {
        return this.forCurrentProjectActionText;
    }

    @Override
    @Nullable
    public String getForAllProjectsActionText() {
        return this.forAllProjectsActionText;
    }

    @Override
    @NotNull
    public String getMuteActionText() {
        return this.muteActionText;
    }

    @Override
    public void rememberForAllProjects() {
    }

    private final boolean isProjectConfigurationFile(VirtualFile storeDir, VirtualFile file2) {
        return storeDir != null && VfsUtilCore.isAncestor((VirtualFile)storeDir, (VirtualFile)file2, (boolean)true);
    }

    public ProjectConfigurationFilesProcessorImpl(@NotNull Project project, @NotNull Disposable parentDisposable, @NotNull String vcsName, @NotNull Function1<? super Collection<? extends VirtualFile>, Unit> addChosenFiles) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkParameterIsNotNull((Object)vcsName, (String)"vcsName");
        Intrinsics.checkParameterIsNotNull(addChosenFiles, (String)"addChosenFiles");
        super(project, parentDisposable);
        this.vcsName = vcsName;
        this.addChosenFiles = addChosenFiles;
        this.fileSystem = LocalFileSystem.getInstance();
        this.projectConfigurationFilesStore = ProjectConfigurationFilesProcessorImplKt.getProjectConfigurationFilesStore(project);
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        if (changeListManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.vcs.changes.ChangeListManagerEx");
        }
        this.changeListManager = (ChangeListManagerEx)changeListManager;
        boolean $i$f$runReadAction = false;
        ApplicationManager.getApplication().runReadAction(new Computable<T>(this, project, parentDisposable){
            final /* synthetic */ ProjectConfigurationFilesProcessorImpl this$0;
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ Disposable $parentDisposable$inlined;
            {
                this.this$0 = projectConfigurationFilesProcessorImpl;
                this.$project$inlined = project;
                this.$parentDisposable$inlined = disposable;
            }

            public final T compute() {
                boolean bl = false;
                if (!this.$project$inlined.isDisposed()) {
                    ProjectConfigurationFilesProcessorImpl.access$getChangeListManager$p(this.this$0).addChangeListListener(this.this$0, this.$parentDisposable$inlined);
                }
                return (T)Unit.INSTANCE;
            }
        });
        this.askedBeforeProperty = "ASKED_SHARE_PROJECT_CONFIGURATION_FILES";
        this.doForCurrentProjectProperty = "SHARE_PROJECT_CONFIGURATION_FILES";
        String string = VcsBundle.getString((String)"project.configuration.files.add.notification.action.view");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"VcsBundle.getString(\"pro\u2026otification.action.view\")");
        this.showActionText = string;
        String string2 = VcsBundle.getString((String)"project.configuration.files.add.notification.action.add");
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"VcsBundle.getString(\"pro\u2026notification.action.add\")");
        this.forCurrentProjectActionText = string2;
        String string3 = VcsBundle.getString((String)"project.configuration.files.add.notification.action.mute");
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"VcsBundle.getString(\"pro\u2026otification.action.mute\")");
        this.muteActionText = string3;
    }

    public static final /* synthetic */ ChangeListManagerEx access$getChangeListManager$p(ProjectConfigurationFilesProcessorImpl $this) {
        return $this.changeListManager;
    }
}

