/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.updateSettings.UpdateStrategyCustomization;
import com.intellij.openapi.updateSettings.impl.ChannelStatus;
import com.intellij.openapi.updateSettings.impl.ExternalUpdateManager;
import com.intellij.openapi.updateSettings.impl.UpdateOptions;
import com.intellij.openapi.updateSettings.impl.UpdateSettingsProviderHelper;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.net.NetUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="UpdatesConfigurable", storages={@Storage(value="updates.xml", roamingType=RoamingType.DISABLED, exportable=true)})
public class UpdateSettings
implements PersistentStateComponent<UpdateOptions> {
    private UpdateOptions myState = new UpdateOptions();

    public static UpdateSettings getInstance() {
        return (UpdateSettings)ServiceManager.getService(UpdateSettings.class);
    }

    public boolean isPlatformUpdateEnabled() {
        return ExternalUpdateManager.ACTUAL == null;
    }

    @NotNull
    public UpdateOptions getState() {
        UpdateOptions updateOptions = this.myState;
        if (updateOptions == null) {
            UpdateSettings.$$$reportNull$$$0(0);
        }
        return updateOptions;
    }

    public void loadState(@NotNull UpdateOptions state) {
        if (state == null) {
            UpdateSettings.$$$reportNull$$$0(1);
        }
        this.myState = state;
    }

    @Nullable
    public String getLastBuildChecked() {
        return this.myState.getLastBuildChecked();
    }

    @NotNull
    public List<String> getStoredPluginHosts() {
        List<String> list2 = this.myState.getPluginHosts();
        if (list2 == null) {
            UpdateSettings.$$$reportNull$$$0(2);
        }
        return list2;
    }

    public boolean isCheckNeeded() {
        return this.myState.isCheckNeeded();
    }

    public void setCheckNeeded(boolean value) {
        this.myState.setCheckNeeded(value);
    }

    public List<String> getEnabledExternalUpdateSources() {
        return this.myState.getEnabledExternalComponentSources();
    }

    public List<String> getKnownExternalUpdateSources() {
        return this.myState.getKnownExternalComponentSources();
    }

    public Map<String, String> getExternalUpdateChannels() {
        return this.myState.getExternalUpdateChannels();
    }

    public boolean isSecureConnection() {
        return this.myState.isUseSecureConnection();
    }

    public void setSecureConnection(boolean value) {
        this.myState.setUseSecureConnection(value);
    }

    public long getLastTimeChecked() {
        return this.myState.getLastTimeChecked();
    }

    @NotNull
    public List<String> getIgnoredBuildNumbers() {
        List<String> list2 = this.myState.getIgnoredBuildNumbers();
        if (list2 == null) {
            UpdateSettings.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @NotNull
    public ChannelStatus getSelectedChannelStatus() {
        ChannelStatus channelStatus = ChannelStatus.fromCode(this.myState.getUpdateChannelType());
        if (channelStatus == null) {
            UpdateSettings.$$$reportNull$$$0(4);
        }
        return channelStatus;
    }

    public void setSelectedChannelStatus(@NotNull ChannelStatus channel) {
        if (channel == null) {
            UpdateSettings.$$$reportNull$$$0(5);
        }
        this.myState.setUpdateChannelType(channel.getCode());
    }

    @NotNull
    public List<ChannelStatus> getActiveChannels() {
        UpdateStrategyCustomization tweaker = UpdateStrategyCustomization.getInstance();
        List<ChannelStatus> list2 = Stream.of(ChannelStatus.values()).filter(ch -> ch == ChannelStatus.EAP || ch == ChannelStatus.RELEASE || tweaker.isChannelActive((ChannelStatus)((Object)ch))).collect(Collectors.toList());
        if (list2 == null) {
            UpdateSettings.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @NotNull
    public ChannelStatus getSelectedActiveChannel() {
        ChannelStatus current;
        UpdateStrategyCustomization tweaker = UpdateStrategyCustomization.getInstance();
        ChannelStatus channelStatus = tweaker.isChannelActive(current = this.getSelectedChannelStatus()) ? current : this.getActiveChannels().stream().filter(ch -> ch.compareTo(current) > 0).findFirst().orElse(ChannelStatus.RELEASE);
        if (channelStatus == null) {
            UpdateSettings.$$$reportNull$$$0(7);
        }
        return channelStatus;
    }

    @NotNull
    public List<String> getPluginHosts() {
        ArrayList<String> hosts = new ArrayList<String>(this.myState.getPluginHosts());
        String pluginHosts = System.getProperty("idea.plugin.hosts");
        if (pluginHosts != null) {
            ContainerUtil.addAll(hosts, (Object[])pluginHosts.split(";"));
        }
        UpdateSettingsProviderHelper.addPluginRepositories(hosts);
        ArrayList<String> arrayList = hosts;
        if (arrayList == null) {
            UpdateSettings.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    public void forceCheckForUpdateAfterRestart() {
        this.myState.setLastTimeChecked(0L);
    }

    public void saveLastCheckedInfo() {
        this.myState.setLastTimeChecked(System.currentTimeMillis());
        this.myState.setLastBuildChecked(ApplicationInfo.getInstance().getBuild().asString());
    }

    public boolean canUseSecureConnection() {
        return this.myState.isUseSecureConnection() && NetUtils.isSniEnabled();
    }

    public boolean isThirdPartyPluginsAllowed() {
        return this.myState.isThirdPartyPluginsAllowed();
    }

    public void setThirdPartyPluginsAllowed(boolean value) {
        this.myState.setThirdPartyPluginsAllowed(value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/updateSettings/impl/UpdateSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "channel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 1: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/updateSettings/impl/UpdateSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStoredPluginHosts";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredBuildNumbers";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedChannelStatus";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveChannels";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedActiveChannel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginHosts";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setSelectedChannelStatus";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

