/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ContentFolder;
import com.intellij.openapi.roots.ExcludeFolder;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.DirectoryIndexExcludePolicy;
import com.intellij.openapi.roots.ui.configuration.ContentRootPanel;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class ContentEntryEditor
implements ContentRootPanel.ActionCallback {
    private boolean myIsSelected;
    private ContentRootPanel myContentRootPanel;
    private JPanel myMainPanel;
    protected EventDispatcher<ContentEntryEditorListener> myEventDispatcher;
    private final String myContentEntryUrl;
    private final List<ModuleSourceRootEditHandler<?>> myEditHandlers;

    public ContentEntryEditor(String url, List<ModuleSourceRootEditHandler<?>> editHandlers) {
        this.myContentEntryUrl = url;
        this.myEditHandlers = editHandlers;
    }

    protected final List<ModuleSourceRootEditHandler<?>> getEditHandlers() {
        return this.myEditHandlers;
    }

    public String getContentEntryUrl() {
        return this.myContentEntryUrl;
    }

    public void initUI() {
        this.myMainPanel = new JPanel(new BorderLayout());
        this.myMainPanel.setOpaque(false);
        this.myMainPanel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ((ContentEntryEditorListener)ContentEntryEditor.this.myEventDispatcher.getMulticaster()).editingStarted(ContentEntryEditor.this);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (!ContentEntryEditor.this.myIsSelected) {
                    ContentEntryEditor.this.highlight(true);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (!ContentEntryEditor.this.myIsSelected) {
                    ContentEntryEditor.this.highlight(false);
                }
            }
        });
        this.myEventDispatcher = EventDispatcher.create(ContentEntryEditorListener.class);
        this.setSelected(false);
        this.update();
    }

    @Nullable
    protected ContentEntry getContentEntry() {
        ModifiableRootModel model = this.getModel();
        if (model != null) {
            ContentEntry[] entries2;
            for (ContentEntry entry : entries2 = model.getContentEntries()) {
                if (!entry.getUrl().equals(this.myContentEntryUrl)) continue;
                return entry;
            }
        }
        return null;
    }

    protected abstract ModifiableRootModel getModel();

    @Override
    public void deleteContentEntry() {
        String path = FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)this.myContentEntryUrl));
        int answer = Messages.showYesNoDialog((String)ProjectBundle.message((String)"module.paths.remove.content.prompt", (Object[])new Object[]{path}), (String)ProjectBundle.message((String)"module.paths.remove.content.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
        if (answer != 0) {
            return;
        }
        ((ContentEntryEditorListener)this.myEventDispatcher.getMulticaster()).beforeEntryDeleted(this);
        ContentEntry entry = this.getContentEntry();
        if (entry != null) {
            this.getModel().removeContentEntry(entry);
        }
    }

    @Override
    public void deleteContentFolder(ContentEntry contentEntry, ContentFolder folder) {
        if (folder instanceof SourceFolder) {
            this.removeSourceFolder((SourceFolder)folder);
            this.update();
        } else if (folder instanceof ExcludeFolder) {
            this.removeExcludeFolder(folder.getUrl());
            this.update();
        }
    }

    @Override
    public void navigateFolder(ContentEntry contentEntry, ContentFolder contentFolder) {
        VirtualFile file2 = contentFolder.getFile();
        if (file2 != null) {
            ((ContentEntryEditorListener)this.myEventDispatcher.getMulticaster()).navigationRequested(this, file2);
        }
    }

    @Override
    public void onSourceRootPropertiesChanged(@NotNull SourceFolder folder) {
        if (folder == null) {
            ContentEntryEditor.$$$reportNull$$$0(0);
        }
        this.update();
        ((ContentEntryEditorListener)this.myEventDispatcher.getMulticaster()).sourceRootPropertiesChanged(this, folder);
    }

    public void addContentEntryEditorListener(ContentEntryEditorListener listener2) {
        this.myEventDispatcher.addListener((EventListener)listener2);
    }

    public void removeContentEntryEditorListener(ContentEntryEditorListener listener2) {
        this.myEventDispatcher.removeListener((EventListener)listener2);
    }

    public void setSelected(boolean isSelected) {
        if (this.myIsSelected != isSelected) {
            this.highlight(isSelected);
            this.myIsSelected = isSelected;
        }
    }

    private void highlight(boolean selected) {
        if (this.myContentRootPanel != null) {
            this.myContentRootPanel.setSelected(selected);
        }
    }

    public JComponent getComponent() {
        return this.myMainPanel;
    }

    public void update() {
        if (this.myContentRootPanel != null) {
            this.myMainPanel.remove(this.myContentRootPanel);
        }
        this.myContentRootPanel = this.createContentRootPane();
        this.myContentRootPanel.initUI();
        this.myContentRootPanel.setSelected(this.myIsSelected);
        this.myMainPanel.add((Component)this.myContentRootPanel, "Center");
        this.myMainPanel.revalidate();
    }

    protected ContentRootPanel createContentRootPane() {
        return new ContentRootPanel(this, this.myEditHandlers){

            @Override
            protected ContentEntry getContentEntry() {
                return ContentEntryEditor.this.getContentEntry();
            }
        };
    }

    @Nullable
    public SourceFolder addSourceFolder(@NotNull VirtualFile file2, boolean isTestSource, String packagePrefix) {
        if (file2 == null) {
            ContentEntryEditor.$$$reportNull$$$0(1);
        }
        return this.addSourceFolder(file2, (JpsModuleSourceRootType)(isTestSource ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE), (JpsElement)JpsJavaExtensionService.getInstance().createSourceRootProperties(packagePrefix));
    }

    @Nullable
    public <P extends JpsElement> SourceFolder addSourceFolder(@NotNull VirtualFile file2, JpsModuleSourceRootType<P> rootType, P properties) {
        ContentEntry contentEntry;
        if (file2 == null) {
            ContentEntryEditor.$$$reportNull$$$0(2);
        }
        if ((contentEntry = this.getContentEntry()) != null) {
            SourceFolder sourceFolder = contentEntry.addSourceFolder(file2, rootType, properties);
            ((ContentEntryEditorListener)this.myEventDispatcher.getMulticaster()).sourceFolderAdded(this, sourceFolder);
            this.update();
            return sourceFolder;
        }
        return null;
    }

    @Nullable
    protected SourceFolder doAddSourceFolder(@NotNull VirtualFile file2, boolean isTestSource) {
        ContentEntry contentEntry;
        if (file2 == null) {
            ContentEntryEditor.$$$reportNull$$$0(3);
        }
        return (contentEntry = this.getContentEntry()) != null ? contentEntry.addSourceFolder(file2, isTestSource) : null;
    }

    public void removeSourceFolder(@NotNull SourceFolder sourceFolder) {
        if (sourceFolder == null) {
            ContentEntryEditor.$$$reportNull$$$0(4);
        }
        try {
            this.doRemoveSourceFolder(sourceFolder);
        }
        finally {
            ((ContentEntryEditorListener)this.myEventDispatcher.getMulticaster()).sourceFolderRemoved(this, sourceFolder.getFile());
            this.update();
        }
    }

    protected void doRemoveSourceFolder(@NotNull SourceFolder sourceFolder) {
        ContentEntry contentEntry;
        if (sourceFolder == null) {
            ContentEntryEditor.$$$reportNull$$$0(5);
        }
        if ((contentEntry = this.getContentEntry()) != null) {
            contentEntry.removeSourceFolder(sourceFolder);
        }
    }

    @Nullable
    public ExcludeFolder addExcludeFolder(@NotNull VirtualFile file2) {
        if (file2 == null) {
            ContentEntryEditor.$$$reportNull$$$0(6);
        }
        try {
            ExcludeFolder excludeFolder = this.doAddExcludeFolder(file2);
            return excludeFolder;
        }
        finally {
            ((ContentEntryEditorListener)this.myEventDispatcher.getMulticaster()).folderExcluded(this, file2);
            this.update();
        }
    }

    @Nullable
    protected ExcludeFolder doAddExcludeFolder(@NotNull VirtualFile file2) {
        ContentEntry contentEntry;
        if (file2 == null) {
            ContentEntryEditor.$$$reportNull$$$0(7);
        }
        return (contentEntry = this.getContentEntry()) != null ? contentEntry.addExcludeFolder(file2) : null;
    }

    public void removeExcludeFolder(@NotNull String excludeRootUrl) {
        if (excludeRootUrl == null) {
            ContentEntryEditor.$$$reportNull$$$0(8);
        }
        try {
            this.doRemoveExcludeFolder(excludeRootUrl);
        }
        finally {
            ((ContentEntryEditorListener)this.myEventDispatcher.getMulticaster()).folderIncluded(this, excludeRootUrl);
            this.update();
        }
    }

    protected void doRemoveExcludeFolder(@NotNull String excludeRootUrl) {
        ContentEntry contentEntry;
        if (excludeRootUrl == null) {
            ContentEntryEditor.$$$reportNull$$$0(9);
        }
        if ((contentEntry = this.getContentEntry()) != null) {
            contentEntry.removeExcludeFolder(excludeRootUrl);
        }
    }

    @Nullable
    public JpsModuleSourceRootType<?> getRootType(@NotNull VirtualFile file2) {
        SourceFolder folder;
        if (file2 == null) {
            ContentEntryEditor.$$$reportNull$$$0(10);
        }
        return (folder = this.getSourceFolder(file2)) != null ? folder.getRootType() : null;
    }

    public boolean isExcludedOrUnderExcludedDirectory(@NotNull VirtualFile file2) {
        ModifiableRootModel model;
        if (file2 == null) {
            ContentEntryEditor.$$$reportNull$$$0(11);
        }
        if ((model = this.getModel()) == null) {
            throw new AssertionError((Object)(this.getClass() + ".getModel() returned null unexpectedly"));
        }
        Project project = model.getProject();
        ContentEntry contentEntry = this.getContentEntry();
        if (contentEntry == null) {
            return false;
        }
        return ContentEntryEditor.isExcludedOrUnderExcludedDirectory(project, contentEntry, file2);
    }

    public static boolean isExcludedOrUnderExcludedDirectory(@Nullable Project project, @NotNull ContentEntry entry, @NotNull VirtualFile file2) {
        if (entry == null) {
            ContentEntryEditor.$$$reportNull$$$0(12);
        }
        if (file2 == null) {
            ContentEntryEditor.$$$reportNull$$$0(13);
        }
        HashSet excludedUrls = ContainerUtil.newHashSet((Iterable)entry.getExcludeFolderUrls());
        if (project != null) {
            for (DirectoryIndexExcludePolicy policy : DirectoryIndexExcludePolicy.getExtensions((AreaInstance)project)) {
                ContainerUtil.addAll((Collection)excludedUrls, (Object[])policy.getExcludeUrlsForProject());
            }
        }
        Set sourceRoots = ContainerUtil.set((Object[])entry.getSourceFolderFiles());
        for (VirtualFile parent = file2; parent != null; parent = parent.getParent()) {
            if (excludedUrls.contains(parent.getUrl())) {
                return true;
            }
            if (!sourceRoots.contains(parent)) continue;
            return false;
        }
        return false;
    }

    @Nullable
    public SourceFolder getSourceFolder(@NotNull VirtualFile file2) {
        ContentEntry contentEntry;
        if (file2 == null) {
            ContentEntryEditor.$$$reportNull$$$0(14);
        }
        if ((contentEntry = this.getContentEntry()) == null) {
            return null;
        }
        for (SourceFolder sourceFolder : contentEntry.getSourceFolders()) {
            VirtualFile f = sourceFolder.getFile();
            if (f == null || !f.equals(file2)) continue;
            return sourceFolder;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFolder";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludeRootUrl";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/ContentEntryEditor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "onSourceRootPropertiesChanged";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "addSourceFolder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doAddSourceFolder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "removeSourceFolder";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "doRemoveSourceFolder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addExcludeFolder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "doAddExcludeFolder";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "removeExcludeFolder";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "doRemoveExcludeFolder";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getRootType";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "isExcludedOrUnderExcludedDirectory";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "getSourceFolder";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface ContentEntryEditorListener
    extends EventListener {
        public void editingStarted(@NotNull ContentEntryEditor var1);

        public void beforeEntryDeleted(@NotNull ContentEntryEditor var1);

        public void sourceFolderAdded(@NotNull ContentEntryEditor var1, SourceFolder var2);

        public void sourceFolderRemoved(@NotNull ContentEntryEditor var1, VirtualFile var2);

        public void folderExcluded(@NotNull ContentEntryEditor var1, VirtualFile var2);

        public void folderIncluded(@NotNull ContentEntryEditor var1, String var2);

        public void navigationRequested(@NotNull ContentEntryEditor var1, VirtualFile var2);

        public void sourceRootPropertiesChanged(@NotNull ContentEntryEditor var1, @NotNull SourceFolder var2);
    }
}

