/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl.libraries;

import com.intellij.configurationStore.ComponentSerializationUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtilCore;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.PersistentOrderRootType;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.roots.RootProvider;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryTableBase;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TraceableDisposable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryImpl
extends TraceableDisposable
implements LibraryEx.ModifiableModelEx,
LibraryEx,
RootProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.roots.impl.impl.LibraryImpl");
    @NonNls
    public static final String LIBRARY_NAME_ATTR = "name";
    @NonNls
    private static final String LIBRARY_TYPE_ATTR = "type";
    @NonNls
    private static final String ROOT_PATH_ELEMENT = "root";
    @NonNls
    public static final String ELEMENT = "library";
    @NonNls
    private static final String PROPERTIES_ELEMENT = "properties";
    private static final SkipDefaultValuesSerializationFilters SERIALIZATION_FILTERS = new SkipDefaultValuesSerializationFilters();
    private static final String EXCLUDED_ROOTS_TAG = "excluded";
    private String myName;
    private final LibraryTable myLibraryTable;
    private final Map<OrderRootType, VirtualFilePointerContainer> myRoots;
    @Nullable
    private VirtualFilePointerContainer myExcludedRoots;
    private final LibraryImpl mySource;
    private PersistentLibraryKind<?> myKind;
    private LibraryProperties myProperties;
    @Nullable
    private final ModifiableRootModel myRootModel;
    private boolean myDisposed;
    private final Disposable myPointersDisposable;
    private final ProjectModelExternalSource myExternalSource;
    private final EventDispatcher<RootProvider.RootSetChangedListener> myDispatcher;
    @NonNls
    private static final String ROOT_TYPE_ATTR = "type";
    private static final OrderRootType DEFAULT_JAR_DIRECTORY_TYPE = OrderRootType.CLASSES;

    LibraryImpl(LibraryTable table, @NotNull Element element, ModifiableRootModel rootModel) throws InvalidDataException {
        if (element == null) {
            LibraryImpl.$$$reportNull$$$0(0);
        }
        this(table, rootModel, null, null, LibraryImpl.findPersistentLibraryKind(element), LibraryImpl.findExternalSource(element));
        this.readExternal(element);
    }

    LibraryImpl(String name, @Nullable PersistentLibraryKind<?> kind, LibraryTable table, ModifiableRootModel rootModel, ProjectModelExternalSource externalSource) {
        this(table, rootModel, null, name, kind, externalSource);
        if (kind != null) {
            this.myProperties = kind.createDefaultProperties();
        }
    }

    private LibraryImpl(@NotNull LibraryImpl from, LibraryImpl newSource, ModifiableRootModel rootModel) {
        if (from == null) {
            LibraryImpl.$$$reportNull$$$0(1);
        }
        this(from.myLibraryTable, rootModel, newSource, from.myName, from.myKind, from.myExternalSource);
        from.checkDisposed();
        if (from.myKind != null && from.myProperties != null) {
            this.myProperties = this.myKind.createDefaultProperties();
            this.myProperties.loadState(from.myProperties.getState());
        }
        for (OrderRootType rootType : this.getAllRootTypes()) {
            VirtualFilePointerContainer thatContainer = from.myRoots.get(rootType);
            if (thatContainer == null) continue;
            this.getOrCreateContainer(rootType).addAll(thatContainer);
        }
        if (from.myExcludedRoots != null) {
            this.myExcludedRoots = from.myExcludedRoots.clone(this.myPointersDisposable);
        }
    }

    private LibraryImpl(LibraryTable table, @Nullable ModifiableRootModel rootModel, LibraryImpl newSource, String name, @Nullable PersistentLibraryKind<?> kind, @Nullable ProjectModelExternalSource externalSource) {
        super(true);
        this.myRoots = new HashMap<OrderRootType, VirtualFilePointerContainer>(2);
        this.myPointersDisposable = Disposer.newDisposable();
        this.myDispatcher = EventDispatcher.create(RootProvider.RootSetChangedListener.class);
        this.myLibraryTable = table;
        this.myRootModel = rootModel;
        this.mySource = newSource;
        this.myKind = kind;
        this.myName = name;
        this.myExternalSource = externalSource;
        Disposer.register((Disposable)this, (Disposable)this.myPointersDisposable);
    }

    @Nullable
    private static ProjectModelExternalSource findExternalSource(@NotNull Element element) {
        String externalSourceId;
        if (element == null) {
            LibraryImpl.$$$reportNull$$$0(2);
        }
        return (externalSourceId = element.getAttributeValue("__external-system-id")) != null ? ExternalProjectSystemRegistry.getInstance().getSourceById(externalSourceId) : null;
    }

    @Nullable
    private static PersistentLibraryKind<?> findPersistentLibraryKind(@NotNull Element element) {
        String typeString;
        LibraryKind kind;
        if (element == null) {
            LibraryImpl.$$$reportNull$$$0(3);
        }
        if ((kind = LibraryKind.findById((String)(typeString = element.getAttributeValue("type")))) != null && !(kind instanceof PersistentLibraryKind)) {
            LOG.error("Cannot load non-persistable library kind: " + typeString);
            return null;
        }
        return (PersistentLibraryKind)kind;
    }

    @NotNull
    private Set<OrderRootType> getAllRootTypes() {
        HashSet<OrderRootType> rootTypes = new HashSet<OrderRootType>(Arrays.asList(OrderRootType.getAllTypes()));
        if (this.myKind != null) {
            rootTypes.addAll(Arrays.asList(this.myKind.getAdditionalRootTypes()));
        }
        HashSet<OrderRootType> hashSet = rootTypes;
        if (hashSet == null) {
            LibraryImpl.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    public void dispose() {
        this.checkDisposed();
        this.myDisposed = true;
        this.kill(null);
    }

    private void checkDisposed() {
        if (this.isDisposed()) {
            this.throwDisposalError("'" + this.myName + "' already disposed: " + this.getStackTrace());
        }
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public String getName() {
        return this.myName;
    }

    @NotNull
    public String[] getUrls(@NotNull OrderRootType rootType) {
        if (rootType == null) {
            LibraryImpl.$$$reportNull$$$0(5);
        }
        this.checkDisposed();
        VirtualFilePointerContainer result2 = this.myRoots.get(rootType);
        String[] stringArray = result2 == null ? ArrayUtilRt.EMPTY_STRING_ARRAY : result2.getUrls();
        if (stringArray == null) {
            LibraryImpl.$$$reportNull$$$0(6);
        }
        return stringArray;
    }

    @NotNull
    public VirtualFile[] getFiles(@NotNull OrderRootType rootType) {
        if (rootType == null) {
            LibraryImpl.$$$reportNull$$$0(7);
        }
        this.checkDisposed();
        VirtualFilePointerContainer container = this.myRoots.get(rootType);
        VirtualFile[] virtualFileArray = container == null ? VirtualFile.EMPTY_ARRAY : container.getFiles();
        if (virtualFileArray == null) {
            LibraryImpl.$$$reportNull$$$0(8);
        }
        return virtualFileArray;
    }

    public void setName(String name) {
        LOG.assertTrue(this.isWritable());
        this.myName = name;
    }

    @NotNull
    public LibraryEx.ModifiableModelEx getModifiableModel() {
        this.checkDisposed();
        LibraryImpl libraryImpl = new LibraryImpl(this, this, this.myRootModel);
        if (libraryImpl == null) {
            LibraryImpl.$$$reportNull$$$0(9);
        }
        return libraryImpl;
    }

    @NotNull
    public Library cloneLibrary(@NotNull RootModelImpl rootModel) {
        if (rootModel == null) {
            LibraryImpl.$$$reportNull$$$0(10);
        }
        LOG.assertTrue(this.myLibraryTable == null);
        LibraryImpl libraryImpl = new LibraryImpl(this, null, (ModifiableRootModel)rootModel);
        if (libraryImpl == null) {
            LibraryImpl.$$$reportNull$$$0(11);
        }
        return libraryImpl;
    }

    @NotNull
    public List<String> getInvalidRootUrls(@NotNull OrderRootType type) {
        if (type == null) {
            LibraryImpl.$$$reportNull$$$0(12);
        }
        if (this.myDisposed) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                LibraryImpl.$$$reportNull$$$0(13);
            }
            return list2;
        }
        VirtualFilePointerContainer container = this.myRoots.get(type);
        List pointers = container == null ? Collections.emptyList() : container.getList();
        SmartList invalidPaths = null;
        for (VirtualFilePointer pointer : pointers) {
            if (pointer.isValid()) continue;
            if (invalidPaths == null) {
                invalidPaths = new SmartList();
            }
            invalidPaths.add(pointer.getUrl());
        }
        List list3 = ContainerUtil.notNullize(invalidPaths);
        if (list3 == null) {
            LibraryImpl.$$$reportNull$$$0(14);
        }
        return list3;
    }

    public void setProperties(LibraryProperties properties) {
        LOG.assertTrue(this.isWritable());
        this.myProperties = properties;
    }

    @NotNull
    public RootProvider getRootProvider() {
        LibraryImpl libraryImpl = this;
        if (libraryImpl == null) {
            LibraryImpl.$$$reportNull$$$0(15);
        }
        return libraryImpl;
    }

    @NotNull
    private Map<OrderRootType, VirtualFilePointerContainer> initRoots() {
        Disposer.register((Disposable)this, (Disposable)this.myPointersDisposable);
        HashMap<OrderRootType, VirtualFilePointerContainer> result2 = new HashMap<OrderRootType, VirtualFilePointerContainer>(4);
        VirtualFilePointerListener listener2 = this.getListener();
        for (OrderRootType rootType : this.getAllRootTypes()) {
            VirtualFilePointerContainer container = VirtualFilePointerManager.getInstance().createContainer(this.myPointersDisposable, listener2);
            result2.put(rootType, container);
        }
        HashMap<OrderRootType, VirtualFilePointerContainer> hashMap = result2;
        if (hashMap == null) {
            LibraryImpl.$$$reportNull$$$0(16);
        }
        return hashMap;
    }

    @NotNull
    private VirtualFilePointerListener getListener() {
        Project project;
        Project project2 = project = this.myLibraryTable instanceof ProjectLibraryTable ? ((ProjectLibraryTable)this.myLibraryTable).getProject() : null;
        VirtualFilePointerListener virtualFilePointerListener = this.myRootModel != null ? ((RootModelImpl)this.myRootModel).getRootsChangedListener() : (project != null ? ProjectRootManagerImpl.getInstanceImpl(project).getRootsValidityChangedListener() : ProjectJdkImpl.getGlobalVirtualFilePointerListener());
        if (virtualFilePointerListener == null) {
            LibraryImpl.$$$reportNull$$$0(17);
        }
        return virtualFilePointerListener;
    }

    @Nullable
    public ProjectModelExternalSource getExternalSource() {
        return this.myExternalSource;
    }

    public void readExternal(Element element) throws InvalidDataException {
        this.readName(element);
        this.readProperties(element);
        this.readRoots(element);
        this.readJarDirectories(element);
    }

    @NotNull
    private VirtualFilePointerContainer getOrCreateContainer(@NotNull OrderRootType rootType) {
        VirtualFilePointerContainer roots;
        if (rootType == null) {
            LibraryImpl.$$$reportNull$$$0(18);
        }
        if ((roots = this.myRoots.get(rootType)) == null) {
            roots = VirtualFilePointerManager.getInstance().createContainer(this.myPointersDisposable, this.getListener());
            this.myRoots.put(rootType, roots);
        }
        VirtualFilePointerContainer virtualFilePointerContainer = roots;
        if (virtualFilePointerContainer == null) {
            LibraryImpl.$$$reportNull$$$0(19);
        }
        return virtualFilePointerContainer;
    }

    @Deprecated
    private void readJarDirectories(@NotNull Element element) {
        if (element == null) {
            LibraryImpl.$$$reportNull$$$0(20);
        }
        List jarDirs = element.getChildren("jarDirectory");
        for (Element jarDir : jarDirs) {
            String url = jarDir.getAttributeValue("url");
            if (url == null) continue;
            String recursive = jarDir.getAttributeValue("recursive");
            OrderRootType rootType = LibraryImpl.getJarDirectoryRootType(jarDir.getAttributeValue("type"));
            VirtualFilePointerContainer roots = this.getOrCreateContainer(rootType);
            boolean recursively = Boolean.parseBoolean(recursive);
            roots.addJarDirectory(url, recursively);
        }
    }

    @NotNull
    private static OrderRootType getJarDirectoryRootType(@Nullable String type) {
        for (PersistentOrderRootType rootType : OrderRootType.getAllPersistentTypes()) {
            if (!rootType.name().equals(type)) continue;
            PersistentOrderRootType persistentOrderRootType = rootType;
            if (persistentOrderRootType == null) {
                LibraryImpl.$$$reportNull$$$0(21);
            }
            return persistentOrderRootType;
        }
        OrderRootType orderRootType = DEFAULT_JAR_DIRECTORY_TYPE;
        if (orderRootType == null) {
            LibraryImpl.$$$reportNull$$$0(22);
        }
        return orderRootType;
    }

    private void readProperties(@NotNull Element element) {
        String typeId;
        if (element == null) {
            LibraryImpl.$$$reportNull$$$0(23);
        }
        if ((typeId = element.getAttributeValue("type")) == null) {
            return;
        }
        this.myKind = (PersistentLibraryKind)LibraryKind.findById((String)typeId);
        if (this.myKind == null) {
            return;
        }
        this.myProperties = this.myKind.createDefaultProperties();
        Element propertiesElement = element.getChild(PROPERTIES_ELEMENT);
        if (propertiesElement != null) {
            ComponentSerializationUtil.loadComponentState((PersistentStateComponent)this.myProperties, (Element)propertiesElement);
        }
    }

    private void readName(@NotNull Element element) {
        if (element == null) {
            LibraryImpl.$$$reportNull$$$0(24);
        }
        this.myName = element.getAttributeValue(LIBRARY_NAME_ATTR);
    }

    private void readRoots(@NotNull Element element) throws InvalidDataException {
        if (element == null) {
            LibraryImpl.$$$reportNull$$$0(25);
        }
        for (OrderRootType rootType : this.getAllRootTypes()) {
            Element rootChild = element.getChild(rootType.name());
            if (rootChild == null || rootChild.getChildren(ROOT_PATH_ELEMENT).isEmpty()) continue;
            VirtualFilePointerContainer roots = this.getOrCreateContainer(rootType);
            roots.readExternal(rootChild, ROOT_PATH_ELEMENT, false);
        }
        Element excludedRoot = element.getChild(EXCLUDED_ROOTS_TAG);
        if (excludedRoot != null && !excludedRoot.getChildren(ROOT_PATH_ELEMENT).isEmpty()) {
            this.getOrCreateExcludedRoots().readExternal(excludedRoot, ROOT_PATH_ELEMENT, false);
        }
    }

    @NotNull
    private VirtualFilePointerContainer getOrCreateExcludedRoots() {
        if (this.myExcludedRoots == null) {
            this.myExcludedRoots = VirtualFilePointerManager.getInstance().createContainer(this.myPointersDisposable);
        }
        VirtualFilePointerContainer virtualFilePointerContainer = this.myExcludedRoots;
        if (virtualFilePointerContainer == null) {
            LibraryImpl.$$$reportNull$$$0(26);
        }
        return virtualFilePointerContainer;
    }

    @NotNull
    private static List<OrderRootType> sortRootTypes(@NotNull Collection<OrderRootType> rootTypes) {
        if (rootTypes == null) {
            LibraryImpl.$$$reportNull$$$0(27);
        }
        ArrayList<OrderRootType> allTypes = new ArrayList<OrderRootType>(rootTypes);
        Collections.sort(allTypes, (o1, o2) -> o1.name().compareToIgnoreCase(o2.name()));
        ArrayList<OrderRootType> arrayList = allTypes;
        if (arrayList == null) {
            LibraryImpl.$$$reportNull$$$0(28);
        }
        return arrayList;
    }

    public void writeExternal(Element rootElement) {
        Module module;
        Object project;
        this.checkDisposed();
        Element element = new Element(ELEMENT);
        if (this.myName != null) {
            element.setAttribute(LIBRARY_NAME_ATTR, this.myName);
        }
        if (this.myKind != null) {
            Element propertiesElement;
            element.setAttribute("type", this.myKind.getKindId());
            LOG.assertTrue(this.myProperties != null, (Object)("Properties is 'null' in library with kind " + this.myKind));
            Object state = this.myProperties.getState();
            if (state != null && !JDOMUtil.isEmpty((Element)(propertiesElement = XmlSerializer.serializeIfNotDefault((Object)state, (SerializationFilter)SERIALIZATION_FILTERS)))) {
                element.addContent(propertiesElement.setName(PROPERTIES_ELEMENT));
            }
        }
        if (this.myExternalSource != null && ProjectUtilCore.isExternalStorageEnabled((Project)(project = (module = this.getModule()) == null ? (this.myLibraryTable instanceof ProjectLibraryTable ? ((ProjectLibraryTable)this.myLibraryTable).getProject() : null) : module.getProject()))) {
            element.setAttribute("__external-system-id", this.myExternalSource.getId());
        }
        ArrayList<OrderRootType> storableRootTypes = new ArrayList<OrderRootType>(Arrays.asList(OrderRootType.getAllTypes()));
        if (this.myKind != null) {
            storableRootTypes.addAll(Arrays.asList(this.myKind.getAdditionalRootTypes()));
        }
        for (OrderRootType rootType : LibraryImpl.sortRootTypes(storableRootTypes)) {
            VirtualFilePointerContainer roots = this.myRoots.get(rootType);
            if ((roots == null || roots.size() == 0) && rootType.skipWriteIfEmpty()) continue;
            Element rootTypeElement = new Element(rootType.name());
            if (roots != null) {
                roots.writeExternal(rootTypeElement, ROOT_PATH_ELEMENT, false);
            }
            element.addContent(rootTypeElement);
        }
        if (this.myExcludedRoots != null && this.myExcludedRoots.size() > 0) {
            Element excluded = new Element(EXCLUDED_ROOTS_TAG);
            this.myExcludedRoots.writeExternal(excluded, ROOT_PATH_ELEMENT, false);
            element.addContent(excluded);
        }
        this.writeJarDirectories(element);
        rootElement.addContent(element);
    }

    @Deprecated
    private void writeJarDirectories(@NotNull Element element) {
        if (element == null) {
            LibraryImpl.$$$reportNull$$$0(29);
        }
        List<OrderRootType> rootTypes = LibraryImpl.sortRootTypes(this.myRoots.keySet());
        for (OrderRootType rootType : rootTypes) {
            VirtualFilePointerContainer container = this.myRoots.get(rootType);
            ArrayList jarDirectories = new ArrayList(container.getJarDirectories());
            Collections.sort(jarDirectories, Comparator.comparing(p -> (String)p.getFirst(), String.CASE_INSENSITIVE_ORDER));
            for (Pair pair : jarDirectories) {
                String url = (String)pair.getFirst();
                boolean isRecursive = (Boolean)pair.getSecond();
                Element jarDirElement = new Element("jarDirectory");
                jarDirElement.setAttribute("url", url);
                jarDirElement.setAttribute("recursive", Boolean.toString(isRecursive));
                if (!rootType.equals((Object)DEFAULT_JAR_DIRECTORY_TYPE)) {
                    jarDirElement.setAttribute("type", rootType.name());
                }
                element.addContent(jarDirElement);
            }
        }
    }

    private boolean isWritable() {
        return this.mySource != null;
    }

    @Nullable
    public PersistentLibraryKind<?> getKind() {
        return this.myKind;
    }

    public void addExcludedRoot(@NotNull String url) {
        VirtualFilePointerContainer roots;
        if (url == null) {
            LibraryImpl.$$$reportNull$$$0(30);
        }
        if ((roots = this.getOrCreateExcludedRoots()).findByUrl(url) == null) {
            roots.add(url);
        }
    }

    public boolean removeExcludedRoot(@NotNull String url) {
        VirtualFilePointer pointer;
        if (url == null) {
            LibraryImpl.$$$reportNull$$$0(31);
        }
        if (this.myExcludedRoots != null && (pointer = this.myExcludedRoots.findByUrl(url)) != null) {
            this.myExcludedRoots.remove(pointer);
            return true;
        }
        return false;
    }

    @NotNull
    public String[] getExcludedRootUrls() {
        String[] stringArray = this.myExcludedRoots != null ? this.myExcludedRoots.getUrls() : ArrayUtil.EMPTY_STRING_ARRAY;
        if (stringArray == null) {
            LibraryImpl.$$$reportNull$$$0(32);
        }
        return stringArray;
    }

    @NotNull
    public VirtualFile[] getExcludedRoots() {
        VirtualFile[] virtualFileArray = this.myExcludedRoots != null ? this.myExcludedRoots.getFiles() : VirtualFile.EMPTY_ARRAY;
        if (virtualFileArray == null) {
            LibraryImpl.$$$reportNull$$$0(33);
        }
        return virtualFileArray;
    }

    public LibraryProperties getProperties() {
        return this.myProperties;
    }

    public void setKind(@NotNull PersistentLibraryKind<?> kind) {
        if (kind == null) {
            LibraryImpl.$$$reportNull$$$0(34);
        }
        LOG.assertTrue(this.isWritable());
        LOG.assertTrue(this.myKind == null || this.myKind == kind, (Object)("Library kind cannot be changed from " + this.myKind + " to " + kind));
        this.myKind = kind;
        this.myProperties = kind.createDefaultProperties();
    }

    public void addRoot(@NotNull String url, @NotNull OrderRootType rootType) {
        if (url == null) {
            LibraryImpl.$$$reportNull$$$0(35);
        }
        if (rootType == null) {
            LibraryImpl.$$$reportNull$$$0(36);
        }
        this.checkDisposed();
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container = this.getOrCreateContainer(rootType);
        container.add(url);
    }

    public void addRoot(@NotNull VirtualFile file2, @NotNull OrderRootType rootType) {
        if (file2 == null) {
            LibraryImpl.$$$reportNull$$$0(37);
        }
        if (rootType == null) {
            LibraryImpl.$$$reportNull$$$0(38);
        }
        this.checkDisposed();
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container = this.getOrCreateContainer(rootType);
        container.add(file2);
    }

    public void addJarDirectory(@NotNull String url, boolean recursive) {
        if (url == null) {
            LibraryImpl.$$$reportNull$$$0(39);
        }
        this.addJarDirectory(url, recursive, OrderRootType.CLASSES);
    }

    public void addJarDirectory(@NotNull VirtualFile file2, boolean recursive) {
        if (file2 == null) {
            LibraryImpl.$$$reportNull$$$0(40);
        }
        this.addJarDirectory(file2, recursive, OrderRootType.CLASSES);
    }

    public void addJarDirectory(@NotNull String url, boolean recursive, @NotNull OrderRootType rootType) {
        if (url == null) {
            LibraryImpl.$$$reportNull$$$0(41);
        }
        if (rootType == null) {
            LibraryImpl.$$$reportNull$$$0(42);
        }
        this.checkDisposed();
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container = this.getOrCreateContainer(rootType);
        container.addJarDirectory(url, recursive);
    }

    public void addJarDirectory(@NotNull VirtualFile file2, boolean recursive, @NotNull OrderRootType rootType) {
        if (file2 == null) {
            LibraryImpl.$$$reportNull$$$0(43);
        }
        if (rootType == null) {
            LibraryImpl.$$$reportNull$$$0(44);
        }
        this.checkDisposed();
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container = this.getOrCreateContainer(rootType);
        container.addJarDirectory(file2.getUrl(), recursive);
    }

    public boolean isJarDirectory(@NotNull String url) {
        if (url == null) {
            LibraryImpl.$$$reportNull$$$0(45);
        }
        return this.isJarDirectory(url, OrderRootType.CLASSES);
    }

    public boolean isJarDirectory(@NotNull String url, @NotNull OrderRootType rootType) {
        VirtualFilePointerContainer container;
        if (url == null) {
            LibraryImpl.$$$reportNull$$$0(46);
        }
        if (rootType == null) {
            LibraryImpl.$$$reportNull$$$0(47);
        }
        if ((container = this.myRoots.get(rootType)) == null) {
            return false;
        }
        List jarDirectories = container.getJarDirectories();
        return jarDirectories.contains(Pair.create((Object)url, (Object)false)) || jarDirectories.contains(Pair.create((Object)url, (Object)true));
    }

    public boolean isValid(@NotNull String url, @NotNull OrderRootType rootType) {
        VirtualFilePointerContainer container;
        if (url == null) {
            LibraryImpl.$$$reportNull$$$0(48);
        }
        if (rootType == null) {
            LibraryImpl.$$$reportNull$$$0(49);
        }
        VirtualFilePointer fp = (container = this.myRoots.get(rootType)) == null ? null : container.findByUrl(url);
        return fp != null && fp.isValid();
    }

    public boolean removeRoot(@NotNull String url, @NotNull OrderRootType rootType) {
        VirtualFilePointer byUrl;
        if (url == null) {
            LibraryImpl.$$$reportNull$$$0(50);
        }
        if (rootType == null) {
            LibraryImpl.$$$reportNull$$$0(51);
        }
        this.checkDisposed();
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container = this.myRoots.get(rootType);
        VirtualFilePointer virtualFilePointer = byUrl = container == null ? null : container.findByUrl(url);
        if (byUrl != null) {
            container.remove(byUrl);
            if (this.myExcludedRoots != null) {
                for (String excludedRoot : this.myExcludedRoots.getUrls()) {
                    VirtualFilePointer pointer;
                    if (this.isUnderRoots(excludedRoot) || (pointer = this.myExcludedRoots.findByUrl(excludedRoot)) == null) continue;
                    this.myExcludedRoots.remove(pointer);
                }
            }
            container.removeJarDirectory(url);
            return true;
        }
        return false;
    }

    private boolean isUnderRoots(@NotNull String url) {
        if (url == null) {
            LibraryImpl.$$$reportNull$$$0(52);
        }
        for (VirtualFilePointerContainer container : this.myRoots.values()) {
            if (!VfsUtilCore.isUnder((String)url, Arrays.asList(container.getUrls()))) continue;
            return true;
        }
        return false;
    }

    public void moveRootUp(@NotNull String url, @NotNull OrderRootType rootType) {
        if (url == null) {
            LibraryImpl.$$$reportNull$$$0(53);
        }
        if (rootType == null) {
            LibraryImpl.$$$reportNull$$$0(54);
        }
        this.checkDisposed();
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container = this.myRoots.get(rootType);
        if (container != null) {
            container.moveUp(url);
        }
    }

    public void moveRootDown(@NotNull String url, @NotNull OrderRootType rootType) {
        if (url == null) {
            LibraryImpl.$$$reportNull$$$0(55);
        }
        if (rootType == null) {
            LibraryImpl.$$$reportNull$$$0(56);
        }
        this.checkDisposed();
        LOG.assertTrue(this.isWritable());
        VirtualFilePointerContainer container = this.myRoots.get(rootType);
        if (container != null) {
            container.moveDown(url);
        }
    }

    public boolean isChanged() {
        return !this.mySource.equals((Object)this);
    }

    private boolean areRootsChanged(@NotNull LibraryImpl that) {
        if (that == null) {
            LibraryImpl.$$$reportNull$$$0(57);
        }
        return !that.equals((Object)this);
    }

    public Library getSource() {
        return this.mySource;
    }

    public void commit() {
        this.checkDisposed();
        if (this.isChanged()) {
            this.mySource.commit(this);
        }
        Disposer.dispose((Disposable)this);
    }

    private void commit(@NotNull LibraryImpl fromModel) {
        if (fromModel == null) {
            LibraryImpl.$$$reportNull$$$0(58);
        }
        if (this.myLibraryTable != null) {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
        }
        if (!Comparing.equal((String)fromModel.myName, (String)this.myName)) {
            this.myName = fromModel.myName;
            if (this.myLibraryTable instanceof LibraryTableBase) {
                ((LibraryTableBase)this.myLibraryTable).fireLibraryRenamed(this);
            }
        }
        this.myKind = fromModel.getKind();
        this.myProperties = fromModel.myProperties;
        if (this.areRootsChanged(fromModel)) {
            this.disposeMyPointers();
            this.copyRootsFrom(fromModel);
            this.fireRootSetChanged();
        }
    }

    private void copyRootsFrom(@NotNull LibraryImpl fromModel) {
        if (fromModel == null) {
            LibraryImpl.$$$reportNull$$$0(59);
        }
        HashMap clonedRoots = ContainerUtil.newHashMap();
        for (Map.Entry<OrderRootType, VirtualFilePointerContainer> entry : fromModel.myRoots.entrySet()) {
            OrderRootType rootType = entry.getKey();
            VirtualFilePointerContainer container = entry.getValue();
            VirtualFilePointerContainer clone = container.clone(this.myPointersDisposable, this.getListener());
            clonedRoots.put(rootType, clone);
        }
        this.myRoots.clear();
        this.myRoots.putAll(clonedRoots);
        VirtualFilePointerContainer excludedRoots = fromModel.myExcludedRoots;
        this.myExcludedRoots = excludedRoots != null ? excludedRoots.clone(this.myPointersDisposable) : null;
    }

    private void disposeMyPointers() {
        for (VirtualFilePointerContainer container : new THashSet(this.myRoots.values())) {
            container.killAll();
        }
        if (this.myExcludedRoots != null) {
            this.myExcludedRoots.killAll();
        }
        Disposer.dispose((Disposable)this.myPointersDisposable);
        Disposer.register((Disposable)this, (Disposable)this.myPointersDisposable);
    }

    public LibraryTable getTable() {
        return this.myLibraryTable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LibraryImpl library = (LibraryImpl)((Object)o);
        if (this.myName != null ? !this.myName.equals(library.myName) : library.myName != null) {
            return false;
        }
        if (!this.myRoots.equals(library.myRoots)) {
            return false;
        }
        if (this.myKind != null ? !this.myKind.equals(library.myKind) : library.myKind != null) {
            return false;
        }
        if (this.myProperties != null ? !this.myProperties.equals((Object)library.myProperties) : library.myProperties != null) {
            return false;
        }
        return Comparing.equal((Object)this.myExcludedRoots, (Object)library.myExcludedRoots);
    }

    public int hashCode() {
        int result2 = this.myName != null ? this.myName.hashCode() : 0;
        result2 = 31 * result2 + this.myRoots.hashCode();
        return result2;
    }

    @NonNls
    public String toString() {
        return "Library: name:" + this.myName + "; roots:" + this.myRoots.values();
    }

    @Nullable(value="will return non-null value only for module level libraries")
    public Module getModule() {
        return this.myRootModel == null ? null : this.myRootModel.getModule();
    }

    public void addRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener2) {
        if (listener2 == null) {
            LibraryImpl.$$$reportNull$$$0(60);
        }
        this.myDispatcher.addListener((EventListener)listener2);
    }

    public void removeRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener2) {
        if (listener2 == null) {
            LibraryImpl.$$$reportNull$$$0(61);
        }
        this.myDispatcher.removeListener((EventListener)listener2);
    }

    public void addRootSetChangedListener(@NotNull RootProvider.RootSetChangedListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            LibraryImpl.$$$reportNull$$$0(62);
        }
        if (parentDisposable == null) {
            LibraryImpl.$$$reportNull$$$0(63);
        }
        this.myDispatcher.addListener((EventListener)listener2, parentDisposable);
    }

    private void fireRootSetChanged() {
        ((RootProvider.RootSetChangedListener)this.myDispatcher.getMulticaster()).rootSetChanged((RootProvider)this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 26: 
            case 28: 
            case 32: 
            case 33: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 26: 
            case 28: 
            case 32: 
            case 33: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 26: 
            case 28: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/impl/libraries/LibraryImpl";
                break;
            }
            case 5: 
            case 7: 
            case 18: 
            case 36: 
            case 38: 
            case 42: 
            case 44: 
            case 47: 
            case 49: 
            case 51: 
            case 54: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootModel";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootTypes";
                break;
            }
            case 30: 
            case 31: 
            case 35: 
            case 39: 
            case 41: 
            case 45: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 53: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 37: 
            case 40: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "that";
                break;
            }
            case 58: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromModel";
                break;
            }
            case 60: 
            case 61: 
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/impl/libraries/LibraryImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllRootTypes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiableModel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneLibrary";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getInvalidRootUrls";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootProvider";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "initRoots";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getListener";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateContainer";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getJarDirectoryRootType";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateExcludedRoots";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "sortRootTypes";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedRootUrls";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getExcludedRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findExternalSource";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findPersistentLibraryKind";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 26: 
            case 28: 
            case 32: 
            case 33: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getUrls";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFiles";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "cloneLibrary";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getInvalidRootUrls";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateContainer";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "readJarDirectories";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "readProperties";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "readName";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "readRoots";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "sortRootTypes";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "writeJarDirectories";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addExcludedRoot";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "removeExcludedRoot";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "setKind";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "addRoot";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "addJarDirectory";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isJarDirectory";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "isValid";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "removeRoot";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "isUnderRoots";
                break;
            }
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "moveRootUp";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "moveRootDown";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "areRootsChanged";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "commit";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "copyRootsFrom";
                break;
            }
            case 60: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "addRootSetChangedListener";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "removeRootSetChangedListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 21: 
            case 22: 
            case 26: 
            case 28: 
            case 32: 
            case 33: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

