/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileNameMatcher;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ui.UIUtil;
import java.util.Iterator;
import java.util.Map;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;

public class ApproveRemovedMappingsActivity
implements StartupActivity {
    public void runActivity(@NotNull Project project) {
        if (project == null) {
            ApproveRemovedMappingsActivity.$$$reportNull$$$0(0);
        }
        if (ApplicationManager.getApplication().isUnitTestMode() || !Registry.is((String)"ide.restore.removed.mappings")) {
            return;
        }
        final Map<FileNameMatcher, Pair<FileType, Boolean>> map2 = ((FileTypeManagerImpl)FileTypeManager.getInstance()).getRemovedMappings();
        if (!map2.isEmpty()) {
            UIUtil.invokeAndWaitIfNeeded(() -> {
                Iterator iterator = map2.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (((Boolean)((Pair)entry.getValue()).getSecond()).booleanValue()) continue;
                    final FileNameMatcher matcher = (FileNameMatcher)entry.getKey();
                    final FileType fileType = (FileType)((Pair)entry.getValue()).getFirst();
                    Notification notification = new Notification("File type recognized", "File type recognized", "File extension " + matcher.getPresentableString() + " was reassigned to " + fileType.getName() + " <a href='revert'>Revert</a>", NotificationType.WARNING, (NotificationListener)new NotificationListener.Adapter(){

                        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                            if (notification == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (e == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            ApplicationManager.getApplication().runWriteAction(() -> {
                                FileTypeManager.getInstance().associate((FileType)PlainTextFileType.INSTANCE, matcher);
                                map2.put(matcher, Pair.create((Object)fileType, (Object)true));
                            });
                            notification.expire();
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "notification";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "e";
                                    break;
                                }
                            }
                            objectArray[1] = "com/intellij/openapi/fileTypes/impl/ApproveRemovedMappingsActivity$1";
                            objectArray[2] = "hyperlinkActivated";
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    });
                    Notifications.Bus.notify((Notification)notification, (Project)project);
                    ApplicationManager.getApplication().runWriteAction(() -> FileTypeManager.getInstance().associate(fileType, matcher));
                    iterator.remove();
                }
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileTypes/impl/ApproveRemovedMappingsActivity", "runActivity"));
    }
}

